/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.util.Random;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Utils;

public class TestLIRSMemoryConsumption
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() {
        TestLIRSMemoryConsumption.testMemoryConsumption();
        System.out.println("-----------------------");
        TestLIRSMemoryConsumption.testMemoryConsumption();
        System.out.println("-----------------------");
        TestLIRSMemoryConsumption.testMemoryConsumption();
    }

    private static void testMemoryConsumption() {
        int size = 1000000;
        Random rng = new Random();
        CacheLongKeyLIRS.Config config = new CacheLongKeyLIRS.Config();
        int mb = 1;
        while (mb <= 16) {
            config.maxMemory = mb * 1024 * 1024;
            CacheLongKeyLIRS<Object> cache = new CacheLongKeyLIRS<Object>(config);
            long memoryUsedInitial = Utils.getMemoryUsed();
            int i = 0;
            while (i < size) {
                cache.put(i, TestLIRSMemoryConsumption.createValue(i), TestLIRSMemoryConsumption.getValueSize(i));
                ++i;
            }
            i = 0;
            while (i < size) {
                int key;
                int mode = rng.nextInt(4);
                switch (mode) {
                    default: {
                        key = rng.nextInt(10);
                        break;
                    }
                    case 1: {
                        key = rng.nextInt(100);
                        break;
                    }
                    case 2: {
                        key = rng.nextInt(10000);
                        break;
                    }
                    case 3: {
                        key = rng.nextInt(1000000);
                    }
                }
                Object val = cache.get(key);
                if (val == null) {
                    cache.put(key, TestLIRSMemoryConsumption.createValue(key), TestLIRSMemoryConsumption.getValueSize(key));
                }
                ++i;
            }
            Utils.collectGarbage();
            cache.trimNonResidentQueue();
            long memoryUsed = Utils.getMemoryUsed();
            int sizeHot = cache.sizeHot();
            int sizeResident = cache.size();
            int sizeNonResident = cache.sizeNonResident();
            long hits = cache.getHits();
            long misses = cache.getMisses();
            System.out.println(mb + " | " + (memoryUsed - memoryUsedInitial + 512L) / 1024L + " | " + (sizeResident + sizeNonResident) + " | " + sizeHot + " | " + (sizeResident - sizeHot) + " | " + sizeNonResident + " | " + hits * 100L / (hits + misses));
            mb *= 2;
        }
    }

    private static Object createValue(long key) {
        return new byte[2540];
    }

    private static int getValueSize(long key) {
        return 2560;
    }
}

