/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestLargeBlob
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return this.config.big && !this.config.memory && !this.config.networked;
    }

    @Override
    public void test() throws Exception {
        int len;
        this.deleteDb("largeBlob");
        String url = this.getURL("largeBlob;TRACE_LEVEL_FILE=0", true);
        Connection conn = this.getConnection(url);
        long testLength = 2147483757L;
        Statement stat = conn.createStatement();
        stat.execute("create table test(x blob)");
        PreparedStatement prep = conn.prepareStatement("insert into test values(?)");
        prep.setBinaryStream(1, new InputStream(){
            long remaining = 2147483757L;
            int p;
            byte[] oneByte = new byte[1];

            @Override
            public void close() {
            }

            @Override
            public int read(byte[] buff, int off, int len) {
                len = (int)Math.min(this.remaining, (long)len);
                this.remaining -= (long)len;
                if (this.p++ % 5000 == 0) {
                    TestLargeBlob.this.println("" + this.remaining);
                }
                return len == 0 ? -1 : len;
            }

            @Override
            public int read() {
                return this.read(this.oneByte, 0, 1) < 0 ? -1 : this.oneByte[0];
            }
        }, -1);
        prep.executeUpdate();
        ResultSet rs = stat.executeQuery("select length(x) from test");
        rs.next();
        this.assertEquals(2147483757L, rs.getLong(1));
        rs = stat.executeQuery("select x from test");
        rs.next();
        InputStream in = rs.getBinaryStream(1);
        byte[] buff = new byte[4096];
        long length = 0L;
        while ((len = in.read(buff)) >= 0) {
            length += (long)len;
        }
        this.assertEquals(2147483757L, length);
        conn.close();
    }
}

