/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.h2.Driver;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestLinkedTable
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.testLinkedServerMode();
        this.testDefaultValues();
        this.testHiddenSQL();
        this.testNestedQueriesToSameTable();
        this.testSharedConnection();
        this.testMultipleSchemas();
        this.testReadOnlyLinkedTable();
        TestLinkedTable.testLinkOtherSchema();
        TestLinkedTable.testLinkDrop();
        this.testLinkSchema();
        this.testLinkEmitUpdates();
        this.testLinkTable();
        this.testLinkTwoTables();
        this.testCachingResults();
        this.testLinkedTableInReadOnlyDb();
        this.testGeometry();
        this.testFetchSize();
        this.testFetchSizeWithAutoCommit();
        this.testQuotedIdentifiers();
        this.deleteDb("linkedTable");
    }

    private void testLinkedServerMode() throws SQLException {
        if (this.config.memory) {
            return;
        }
        if (this.config.networked) {
            return;
        }
        this.deleteDb("linkedTable1");
        this.deleteDb("linkedTable2");
        String url2 = this.getURL("linkedTable2", true);
        String user = this.getUser();
        String password = this.getPassword();
        Connection conn = this.getConnection("linkedTable2");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int)");
        conn.close();
        conn = this.getConnection("linkedTable1");
        stat = conn.createStatement();
        stat.execute("create linked table link(null, '" + url2 + "', '" + user + "', '" + password + "', 'TEST')");
        conn.close();
        conn = this.getConnection("linkedTable1");
        conn.close();
    }

    private void testDefaultValues() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("linkedTable");
        Connection connMain = DriverManager.getConnection("jdbc:h2:mem:linkedTable");
        Statement statMain = connMain.createStatement();
        statMain.execute("create table test(id identity, name varchar default 'test')");
        Connection conn = this.getConnection("linkedTable");
        Statement stat = conn.createStatement();
        stat.execute("create linked table test1('', 'jdbc:h2:mem:linkedTable', '', '', 'TEST') emit updates");
        stat.execute("create linked table test2('', 'jdbc:h2:mem:linkedTable', '', '', 'TEST')");
        stat.execute("insert into test1 values(default, default)");
        stat.execute("insert into test2 values(default, default)");
        stat.execute("merge into test2 values(3, default)");
        stat.execute("update test1 set name=default where id=1");
        stat.execute("update test2 set name=default where id=2");
        ResultSet rs = statMain.executeQuery("select * from test order by id");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("test", rs.getString(2));
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("test", rs.getString(2));
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        this.assertEquals("test", rs.getString(2));
        this.assertFalse(rs.next());
        stat.execute("delete from test1 where id=1");
        stat.execute("delete from test2 where id=2");
        stat.execute("delete from test2 where id=3");
        conn.close();
        rs = statMain.executeQuery("select * from test order by id");
        this.assertFalse(rs.next());
        connMain.close();
    }

    private void testHiddenSQL() throws SQLException {
        if (this.config.memory) {
            return;
        }
        Driver.load();
        this.deleteDb("linkedTable");
        Connection conn = this.getConnection("linkedTable;SHARE_LINKED_CONNECTIONS=TRUE");
        try {
            conn.createStatement().execute("create linked table test(null, 'jdbc:h2:mem:', 'sa', 'pwd', 'DUAL2')");
            this.fail();
        }
        catch (SQLException e) {
            this.assertContains(e.toString(), "pwd");
        }
        try {
            conn.createStatement().execute("create linked table test(null, 'jdbc:h2:mem:', 'sa', 'pwd', 'DUAL2') --hide--");
            this.fail();
        }
        catch (SQLException e) {
            this.assertTrue(e.toString().indexOf("pwd") < 0);
        }
        conn.close();
    }

    private void testNestedQueriesToSameTable() throws SQLException {
        if (this.config.memory) {
            return;
        }
        Driver.load();
        this.deleteDb("linkedTable");
        String url = this.getURL("linkedTable;SHARE_LINKED_CONNECTIONS=TRUE", true);
        String user = this.getUser();
        String password = this.getPassword();
        Connection ca = this.getConnection(url, user, password);
        Statement sa = ca.createStatement();
        sa.execute("CREATE TABLE TEST(ID INT) AS SELECT 1");
        ca.close();
        Connection cb = DriverManager.getConnection("jdbc:h2:mem:two", "sa", "sa");
        Statement sb = cb.createStatement();
        sb.execute("CREATE LINKED TABLE T1(NULL, '" + url + "', '" + user + "', '" + password + "', 'TEST')");
        sb.executeQuery("SELECT * FROM DUAL A LEFT OUTER JOIN T1 A ON A.ID=1 LEFT OUTER JOIN T1 B ON B.ID=1");
        sb.execute("DROP ALL OBJECTS");
        cb.close();
    }

    private void testSharedConnection() throws SQLException {
        if (this.config.memory) {
            return;
        }
        Driver.load();
        this.deleteDb("linkedTable");
        String url = this.getURL("linkedTable;SHARE_LINKED_CONNECTIONS=TRUE", true);
        String user = this.getUser();
        String password = this.getPassword();
        Connection ca = this.getConnection(url, user, password);
        Statement sa = ca.createStatement();
        sa.execute("CREATE TABLE TEST(ID INT)");
        ca.close();
        Connection cb = DriverManager.getConnection("jdbc:h2:mem:two", "sa", "sa");
        Statement sb = cb.createStatement();
        sb.execute("CREATE LINKED TABLE T1(NULL, '" + url + ";OPEN_NEW=TRUE', '" + user + "', '" + password + "', 'TEST')");
        sb.execute("CREATE LINKED TABLE T2(NULL, '" + url + ";OPEN_NEW=TRUE', '" + user + "', '" + password + "', 'TEST')");
        sb.execute("DROP ALL OBJECTS");
        cb.close();
    }

    private void testMultipleSchemas() throws SQLException {
        Driver.load();
        Connection ca = DriverManager.getConnection("jdbc:h2:mem:one", "sa", "sa");
        Connection cb = DriverManager.getConnection("jdbc:h2:mem:two", "sa", "sa");
        Statement sa = ca.createStatement();
        Statement sb = cb.createStatement();
        sa.execute("CREATE TABLE TEST(ID INT)");
        sa.execute("CREATE SCHEMA P");
        sa.execute("CREATE TABLE P.TEST(X INT)");
        sa.execute("INSERT INTO TEST VALUES(1)");
        sa.execute("INSERT INTO P.TEST VALUES(2)");
        this.assertThrows(90080, sb).execute("CREATE LINKED TABLE T(NULL, 'jdbc:h2:mem:one', 'sa', 'sa', 'TEST')");
        sb.execute("CREATE LINKED TABLE T(NULL, 'jdbc:h2:mem:one', 'sa', 'sa', 'PUBLIC', 'TEST')");
        sb.execute("CREATE LINKED TABLE T2(NULL, 'jdbc:h2:mem:one', 'sa', 'sa', 'P', 'TEST')");
        this.assertSingleValue(sb, "SELECT * FROM T", 1);
        this.assertSingleValue(sb, "SELECT * FROM T2", 2);
        sa.execute("DROP ALL OBJECTS");
        sb.execute("DROP ALL OBJECTS");
        this.assertThrows(42104, sa).execute("SELECT * FROM TEST");
        ca.close();
        cb.close();
    }

    private void testReadOnlyLinkedTable() throws SQLException {
        Driver.load();
        Connection ca = DriverManager.getConnection("jdbc:h2:mem:one", "sa", "sa");
        Connection cb = DriverManager.getConnection("jdbc:h2:mem:two", "sa", "sa");
        Statement sa = ca.createStatement();
        Statement sb = cb.createStatement();
        sa.execute("CREATE TABLE TEST(ID INT)");
        sa.execute("INSERT INTO TEST VALUES(1)");
        String[] suffix = new String[]{"", "READONLY", "EMIT UPDATES"};
        int i = 0;
        while (i < suffix.length) {
            String[] update;
            String sql = "CREATE LINKED TABLE T(NULL, 'jdbc:h2:mem:one', 'sa', 'sa', 'TEST')" + suffix[i];
            sb.execute(sql);
            sb.executeQuery("SELECT * FROM T");
            String[] stringArray = update = new String[]{"DELETE FROM T", "INSERT INTO T VALUES(2)", "UPDATE T SET ID = 3"};
            int n = update.length;
            int n2 = 0;
            while (n2 < n) {
                String u = stringArray[n2];
                try {
                    sb.execute(u);
                    if (i == 1) {
                        this.fail();
                    }
                }
                catch (SQLException e) {
                    if (i == 1) {
                        this.assertKnownException(e);
                    }
                    throw e;
                }
                ++n2;
            }
            sb.execute("DROP TABLE T");
            ++i;
        }
        ca.close();
        cb.close();
    }

    private static void testLinkOtherSchema() throws SQLException {
        Driver.load();
        Connection ca = DriverManager.getConnection("jdbc:h2:mem:one", "sa", "sa");
        Connection cb = DriverManager.getConnection("jdbc:h2:mem:two", "sa", "sa");
        Statement sa = ca.createStatement();
        Statement sb = cb.createStatement();
        sa.execute("CREATE TABLE GOOD (X NUMBER)");
        sa.execute("CREATE SCHEMA S");
        sa.execute("CREATE TABLE S.BAD (X NUMBER)");
        sb.execute("SELECT * FROM LINK_SCHEMA('G', '', 'jdbc:h2:mem:one', 'sa', 'sa', 'PUBLIC'); ");
        sb.execute("SELECT * FROM LINK_SCHEMA('B', '', 'jdbc:h2:mem:one', 'sa', 'sa', 'S'); ");
        sb.executeQuery("SELECT * FROM G.GOOD");
        sb.executeQuery("SELECT * FROM B.BAD");
        ca.close();
        cb.close();
    }

    private void testLinkTwoTables() throws SQLException {
        Driver.load();
        Connection conn = DriverManager.getConnection("jdbc:h2:mem:one", "sa", "sa");
        Statement stat = conn.createStatement();
        stat.execute("CREATE SCHEMA Y");
        stat.execute("CREATE TABLE A( C INT)");
        stat.execute("INSERT INTO A VALUES(1)");
        stat.execute("CREATE TABLE Y.A (C INT)");
        stat.execute("INSERT INTO Y.A VALUES(2)");
        Connection conn2 = DriverManager.getConnection("jdbc:h2:mem:two");
        Statement stat2 = conn2.createStatement();
        stat2.execute("CREATE LINKED TABLE one('org.h2.Driver', 'jdbc:h2:mem:one', 'sa', 'sa', 'Y.A');");
        stat2.execute("CREATE LINKED TABLE two('org.h2.Driver', 'jdbc:h2:mem:one', 'sa', 'sa', 'PUBLIC.A');");
        ResultSet rs = stat2.executeQuery("SELECT * FROM one");
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        rs = stat2.executeQuery("SELECT * FROM two");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        conn.close();
        conn2.close();
    }

    private static void testLinkDrop() throws SQLException {
        Driver.load();
        Connection connA = DriverManager.getConnection("jdbc:h2:mem:a");
        Statement statA = connA.createStatement();
        statA.execute("CREATE TABLE TEST(ID INT)");
        Connection connB = DriverManager.getConnection("jdbc:h2:mem:b");
        Statement statB = connB.createStatement();
        statB.execute("CREATE LINKED TABLE TEST_LINK('', 'jdbc:h2:mem:a', '', '', 'TEST')");
        connA.close();
        statB.execute("DROP TABLE TEST_LINK");
        connA = DriverManager.getConnection("jdbc:h2:mem:a");
        statA = connA.createStatement();
        statA.execute("CREATE TABLE TEST(ID INT)");
        connA.close();
        connB.close();
    }

    private void testLinkEmitUpdates() throws SQLException {
        if (this.config.memory || this.config.networked) {
            return;
        }
        this.deleteDb("linked1");
        this.deleteDb("linked2");
        Driver.load();
        String url1 = this.getURL("linked1", true);
        String url2 = this.getURL("linked2", true);
        Connection conn = DriverManager.getConnection(url1, "sa1", "abc abc");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        Connection conn2 = DriverManager.getConnection(url2, "sa2", "def def");
        Statement stat2 = conn2.createStatement();
        String link = "CREATE LINKED TABLE TEST_LINK_U('', '" + url1 + "', 'sa1', 'abc abc', 'TEST') EMIT UPDATES";
        stat2.execute(link);
        link = "CREATE LINKED TABLE TEST_LINK_DI('', '" + url1 + "', 'sa1', 'abc abc', 'TEST')";
        stat2.execute(link);
        stat2.executeUpdate("INSERT INTO TEST_LINK_U VALUES(1, 'Hello')");
        stat2.executeUpdate("INSERT INTO TEST_LINK_DI VALUES(2, 'World')");
        this.assertThrows(90111, stat2).executeUpdate("UPDATE TEST_LINK_U SET ID=ID+1");
        stat2.executeUpdate("UPDATE TEST_LINK_DI SET ID=ID+1");
        stat2.executeUpdate("UPDATE TEST_LINK_U SET NAME=NAME || ID");
        ResultSet rs = stat2.executeQuery("SELECT * FROM TEST_LINK_DI ORDER BY ID");
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("Hello2", rs.getString(2));
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        this.assertEquals("World3", rs.getString(2));
        this.assertFalse(rs.next());
        rs = stat2.executeQuery("SELECT * FROM TEST_LINK_U ORDER BY ID");
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("Hello2", rs.getString(2));
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        this.assertEquals("World3", rs.getString(2));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("Hello2", rs.getString(2));
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        this.assertEquals("World3", rs.getString(2));
        this.assertFalse(rs.next());
        conn.close();
        conn2.close();
    }

    private void testLinkSchema() throws SQLException {
        if (this.config.memory || this.config.networked) {
            return;
        }
        this.deleteDb("linked1");
        this.deleteDb("linked2");
        Driver.load();
        String url1 = this.getURL("linked1", true);
        String url2 = this.getURL("linked2", true);
        Connection conn = DriverManager.getConnection(url1, "sa1", "abc abc");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST1(ID INT PRIMARY KEY)");
        Connection conn2 = DriverManager.getConnection(url2, "sa2", "def def");
        Statement stat2 = conn2.createStatement();
        String link = "SELECT * FROM LINK_SCHEMA('LINKED', '', '" + url1 + "', 'sa1', 'abc abc', 'PUBLIC')";
        stat2.execute(link);
        stat2.executeQuery("SELECT * FROM LINKED.TEST1");
        stat.execute("CREATE TABLE TEST2(ID INT PRIMARY KEY)");
        stat2.execute(link);
        stat2.executeQuery("SELECT * FROM LINKED.TEST1");
        stat2.executeQuery("SELECT * FROM LINKED.TEST2");
        conn.close();
        conn2.close();
    }

    private void testLinkTable() throws SQLException {
        if (this.config.memory || this.config.networked || this.config.reopen) {
            return;
        }
        this.deleteDb("linked1");
        this.deleteDb("linked2");
        Driver.load();
        String url1 = this.getURL("linked1", true);
        String url2 = this.getURL("linked2", true);
        Connection conn = DriverManager.getConnection(url1, "sa1", "abc abc");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TEMP TABLE TEST_TEMP(ID INT PRIMARY KEY)");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(200), XT TINYINT, XD DECIMAL(10,2), XTS TIMESTAMP, XBY VARBINARY(255), XBO BIT, XSM SMALLINT, XBI BIGINT, XBL BLOB, XDA DATE, XTI TIME, XCL CLOB, XDO DOUBLE)");
        stat.execute("CREATE INDEX IDXNAME ON TEST(NAME)");
        stat.execute("INSERT INTO TEST VALUES(0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello', -1, 10.30, '2001-02-03 11:22:33.4455', X'FF0102', TRUE, 3000, 1234567890123456789, X'1122AA', DATE '0002-01-01', TIME '00:00:00', 'J\u00fcrg', 2.25)");
        this.testRow(stat, "TEST");
        stat.execute("INSERT INTO TEST VALUES(2, 'World', 30, 100.05, '2005-12-31 12:34:56.789', X'FFEECC33', FALSE, 1, -1234567890123456789, X'4455FF', DATE '9999-12-31', TIME '23:59:59', 'George', -2.5)");
        this.testRow(stat, "TEST");
        stat.execute("SELECT * FROM TEST_TEMP");
        conn.close();
        conn = DriverManager.getConnection(url1, "sa1", "abc abc");
        stat = conn.createStatement();
        this.testRow(stat, "TEST");
        this.assertThrows(42102, stat).execute("SELECT * FROM TEST_TEMP");
        conn.close();
        conn = DriverManager.getConnection(url2, "sa2", "def def");
        stat = conn.createStatement();
        stat.execute("CREATE LINKED TABLE IF NOT EXISTS LINK_TEST('org.h2.Driver', '" + url1 + "', 'sa1', 'abc abc', 'TEST')");
        stat.execute("CREATE LINKED TABLE IF NOT EXISTS LINK_TEST('org.h2.Driver', '" + url1 + "', 'sa1', 'abc abc', 'TEST')");
        this.testRow(stat, "LINK_TEST");
        ResultSet rs = stat.executeQuery("SELECT * FROM LINK_TEST");
        ResultSetMetaData meta = rs.getMetaData();
        this.assertEquals(32, meta.getPrecision(1));
        this.assertEquals(200, meta.getPrecision(2));
        conn.close();
        conn = DriverManager.getConnection(url2, "sa2", "def def");
        stat = conn.createStatement();
        stat.execute("INSERT INTO LINK_TEST VALUES(3, 'Link Test', 30, 100.05, '2005-12-31 12:34:56.789', X'FFEECC33', FALSE, 1, -1234567890123456789, X'4455FF', DATE '9999-12-31', TIME '23:59:59', 'George', -2.5)");
        rs = stat.executeQuery("SELECT COUNT(*) FROM LINK_TEST");
        rs.next();
        this.assertEquals(4, rs.getInt(1));
        rs = stat.executeQuery("SELECT COUNT(*) FROM LINK_TEST WHERE NAME='Link Test'");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        int uc = stat.executeUpdate("DELETE FROM LINK_TEST WHERE ID=3");
        this.assertEquals(1, uc);
        rs = stat.executeQuery("SELECT COUNT(*) FROM LINK_TEST");
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='LINK_TEST'");
        rs.next();
        this.assertEquals("TABLE LINK", rs.getString("STORAGE_TYPE"));
        rs.next();
        rs = stat.executeQuery("SELECT * FROM LINK_TEST WHERE ID=0");
        rs.next();
        this.assertTrue(rs.getString("NAME") == null && rs.wasNull());
        this.assertTrue(rs.getString("XT") == null && rs.wasNull());
        this.assertTrue(rs.getInt("ID") == 0 && !rs.wasNull());
        this.assertTrue(rs.getBigDecimal("XD") == null && rs.wasNull());
        this.assertTrue(rs.getTimestamp("XTS") == null && rs.wasNull());
        this.assertTrue(rs.getBytes("XBY") == null && rs.wasNull());
        this.assertTrue(!rs.getBoolean("XBO") && rs.wasNull());
        this.assertTrue(rs.getShort("XSM") == 0 && rs.wasNull());
        this.assertTrue(rs.getLong("XBI") == 0L && rs.wasNull());
        this.assertTrue(rs.getString("XBL") == null && rs.wasNull());
        this.assertTrue(rs.getString("XDA") == null && rs.wasNull());
        this.assertTrue(rs.getString("XTI") == null && rs.wasNull());
        this.assertTrue(rs.getString("XCL") == null && rs.wasNull());
        this.assertTrue(rs.getString("XDO") == null && rs.wasNull());
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE LINK_TEST");
        stat.execute("CREATE LINKED TABLE LINK_TEST('org.h2.Driver', '" + url1 + "', 'sa1', 'abc abc', '(SELECT COUNT(*) FROM TEST)')");
        rs = stat.executeQuery("SELECT * FROM LINK_TEST");
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        this.assertFalse(rs.next());
        conn.close();
        this.deleteDb("linked1");
        this.deleteDb("linked2");
    }

    private void testRow(Statement stat, String name) throws SQLException {
        ResultSet rs = stat.executeQuery("SELECT * FROM " + name + " WHERE ID=1");
        rs.next();
        this.assertEquals("Hello", rs.getString("NAME"));
        this.assertEquals(-1, rs.getByte("XT"));
        BigDecimal bd = rs.getBigDecimal("XD");
        this.assertTrue(bd.equals(new BigDecimal("10.30")));
        Timestamp ts = rs.getTimestamp("XTS");
        String s = ts.toString();
        this.assertEquals("2001-02-03 11:22:33.4455", s);
        this.assertTrue(ts.equals(Timestamp.valueOf("2001-02-03 11:22:33.4455")));
        this.assertEquals(new byte[]{-1, 1, 2}, rs.getBytes("XBY"));
        this.assertTrue(rs.getBoolean("XBO"));
        this.assertEquals(3000, rs.getShort("XSM"));
        this.assertEquals(1234567890123456789L, rs.getLong("XBI"));
        this.assertEquals(new byte[]{17, 34, -86}, rs.getBytes("XBL"));
        this.assertEquals("0002-01-01", rs.getString("XDA"));
        this.assertEquals("00:00:00", rs.getString("XTI"));
        this.assertEquals("J\u00fcrg", rs.getString("XCL"));
        this.assertEquals("2.25", rs.getString("XDO"));
    }

    private void testCachingResults() throws SQLException {
        Driver.load();
        Connection ca = DriverManager.getConnection("jdbc:h2:mem:one", "sa", "sa");
        Connection cb = DriverManager.getConnection("jdbc:h2:mem:two", "sa", "sa");
        Statement sa = ca.createStatement();
        Statement sb = cb.createStatement();
        sa.execute("CREATE TABLE TEST(ID VARCHAR)");
        sa.execute("INSERT INTO TEST (ID) VALUES('abc')");
        sb.execute("CREATE LOCAL TEMPORARY LINKED TABLE T(NULL, 'jdbc:h2:mem:one', 'sa', 'sa', 'TEST')");
        PreparedStatement paData = ca.prepareStatement("select id from TEST where id = ?");
        PreparedStatement pbData = cb.prepareStatement("select id from T where id = ?");
        PreparedStatement paCount = ca.prepareStatement("select count(*) from TEST");
        PreparedStatement pbCount = cb.prepareStatement("select count(*) from T");
        this.testCachingResultsCheckResult(paData, 1, "abc");
        this.testCachingResultsCheckResult(paCount, 1);
        this.testCachingResultsCheckResult(pbData, 1, "abc");
        this.testCachingResultsCheckResult(pbCount, 1);
        sa.execute("INSERT INTO TEST (ID) VALUES('abc')");
        this.testCachingResultsCheckResult(paData, 2, "abc");
        this.testCachingResultsCheckResult(paCount, 2);
        this.testCachingResultsCheckResult(pbData, 2, "abc");
        this.testCachingResultsCheckResult(pbCount, 2);
        ca.close();
        cb.close();
    }

    private void testCachingResultsCheckResult(PreparedStatement ps, int expected) throws SQLException {
        ResultSet rs = ps.executeQuery();
        rs.next();
        this.assertEquals(expected, rs.getInt(1));
    }

    private void testCachingResultsCheckResult(PreparedStatement ps, int expected, String value) throws SQLException {
        ps.setString(1, value);
        ResultSet rs = ps.executeQuery();
        int counter = 0;
        while (rs.next()) {
            ++counter;
            String result = rs.getString(1);
            this.assertEquals(result, value);
        }
        this.assertEquals(expected, counter);
    }

    private void testLinkedTableInReadOnlyDb() throws SQLException {
        if (this.config.memory || this.config.networked || this.config.googleAppEngine) {
            return;
        }
        this.deleteDb("testLinkedTableInReadOnlyDb");
        Driver.load();
        Connection memConn = DriverManager.getConnection("jdbc:h2:mem:one", "sa", "sa");
        Statement memStat = memConn.createStatement();
        memStat.execute("CREATE TABLE TEST(ID VARCHAR)");
        String url1 = this.getURL("testLinkedTableInReadOnlyDb", true);
        Connection conn = DriverManager.getConnection(url1, "sa1", "abc abc");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY)");
        conn.close();
        for (String file : FileUtils.newDirectoryStream(this.getBaseDir())) {
            boolean isReadOnly;
            String name = FileUtils.getName(file);
            if (!name.startsWith("testLinkedTableInReadOnlyDb") || name.endsWith(".trace.db")) continue;
            FileUtils.setReadOnly(file);
            boolean bl = isReadOnly = !FileUtils.canWrite(file);
            if (isReadOnly) continue;
            this.fail("File " + file + " is not read only. Can't test it.");
        }
        conn = DriverManager.getConnection(url1, "sa1", "abc abc");
        stat = conn.createStatement();
        stat.execute("CREATE LOCAL TEMPORARY LINKED TABLE T(NULL, 'jdbc:h2:mem:one', 'sa', 'sa', 'TEST')");
        stat.execute("INSERT INTO T VALUES('abc')");
        conn.close();
        memConn.close();
        this.deleteDb("testLinkedTableInReadOnlyDb");
    }

    private void testGeometry() throws SQLException {
        if (this.config.memory) {
            return;
        }
        Driver.load();
        Connection ca = DriverManager.getConnection("jdbc:h2:mem:one", "sa", "sa");
        Connection cb = DriverManager.getConnection("jdbc:h2:mem:two", "sa", "sa");
        Statement sa = ca.createStatement();
        Statement sb = cb.createStatement();
        sa.execute("CREATE TABLE TEST(ID BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, THE_GEOM GEOMETRY, THE_GEOM_2 GEOMETRY(POINT, 4326))");
        sa.execute("INSERT INTO TEST(THE_GEOM, THE_GEOM_2) VALUES (GEOMETRY 'POINT (1 1)', GEOMETRY 'SRID=4326;POINT(2 2)')");
        String sql = "CREATE LINKED TABLE T(NULL, 'jdbc:h2:mem:one', 'sa', 'sa', 'TEST') READONLY";
        sb.execute(sql);
        Throwable throwable = null;
        Object var7_8 = null;
        try (ResultSet rs = sb.executeQuery("SELECT * FROM T");){
            this.assertTrue(rs.next());
            this.assertEquals("POINT (1 1)", rs.getString("THE_GEOM"));
            this.assertEquals("SRID=4326;POINT (2 2)", rs.getString("THE_GEOM_2"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        sb.execute("DROP TABLE T");
        ca.close();
        cb.close();
    }

    private void testFetchSize() throws SQLException {
        if (this.config.memory) {
            return;
        }
        Driver.load();
        Connection ca = DriverManager.getConnection("jdbc:h2:mem:one", "sa", "sa");
        Connection cb = DriverManager.getConnection("jdbc:h2:mem:two", "sa", "sa");
        Statement sa = ca.createStatement();
        Statement sb = cb.createStatement();
        sa.execute("DROP TABLE IF EXISTS TEST; CREATE TABLE TEST as select * from SYSTEM_RANGE(1,1000) as n;");
        String sql = "CREATE LINKED TABLE T(NULL, 'jdbc:h2:mem:one', 'sa', 'sa', 'TEST') FETCH_SIZE 10";
        sb.execute(sql);
        Throwable throwable = null;
        Object var7_8 = null;
        try (ResultSet rs = sb.executeQuery("SELECT count(*) FROM T");){
            this.assertTrue(rs.next());
            this.assertEquals(1000, rs.getInt(1));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ResultSet res = sb.executeQuery("CALL DB_OBJECT_SQL('TABLE', 'PUBLIC', 'T')");
        res.next();
        this.assertEquals("CREATE FORCE LINKED TABLE \"PUBLIC\".\"T\"(NULL, 'jdbc:h2:mem:one', 'sa', 'sa', 'TEST') FETCH_SIZE 10 /*--hide--*/", res.getString(1));
        sb.execute("DROP TABLE T");
        ca.close();
        cb.close();
    }

    private void testFetchSizeWithAutoCommit() throws SQLException {
        if (this.config.memory) {
            return;
        }
        Driver.load();
        Connection ca = DriverManager.getConnection("jdbc:h2:mem:one", "sa", "sa");
        Connection cb = DriverManager.getConnection("jdbc:h2:mem:two", "sa", "sa");
        Statement sa = ca.createStatement();
        Statement sb = cb.createStatement();
        sa.execute("DROP TABLE IF EXISTS TEST; CREATE TABLE TEST as select * from SYSTEM_RANGE(1,1000) as n;");
        String sql = "CREATE LINKED TABLE T(NULL, 'jdbc:h2:mem:one', 'sa', 'sa', 'TEST') FETCH_SIZE 10 AUTOCOMMIT OFF";
        sb.execute(sql);
        Throwable throwable = null;
        Object var7_8 = null;
        try (ResultSet rs = sb.executeQuery("SELECT count(*) FROM T");){
            this.assertTrue(rs.next());
            this.assertEquals(1000, rs.getInt(1));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ResultSet res = sb.executeQuery("CALL DB_OBJECT_SQL('TABLE', 'PUBLIC', 'T')");
        res.next();
        this.assertEquals("CREATE FORCE LINKED TABLE \"PUBLIC\".\"T\"(NULL, 'jdbc:h2:mem:one', 'sa', 'sa', 'TEST') FETCH_SIZE 10 AUTOCOMMIT OFF /*--hide--*/", res.getString(1));
        sb.execute("DROP TABLE T");
        ca.close();
        cb.close();
    }

    private void testQuotedIdentifiers() throws SQLException {
        ResultSet rs;
        if (this.config.memory) {
            return;
        }
        Driver.load();
        Connection ca = DriverManager.getConnection("jdbc:h2:mem:one", "sa", "sa");
        Connection cb = DriverManager.getConnection("jdbc:h2:mem:two", "sa", "sa");
        Statement sa = ca.createStatement();
        Statement sb = cb.createStatement();
        sa.execute("CREATE TABLE \"Test\" AS SELECT X \"Num\", X \"Column \"\"1\"\"\" FROM SYSTEM_RANGE(1, 100)");
        sb.execute("CREATE LINKED TABLE T(NULL, 'jdbc:h2:mem:one', 'sa', 'sa', '\"Test\"')");
        Throwable throwable = null;
        Object var6_8 = null;
        try {
            rs = sb.executeQuery("SELECT SUM(\"Num\") FROM T WHERE \"Num\" > 1");
            try {
                this.assertTrue(rs.next());
                this.assertEquals(5049, rs.getInt(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var6_8 = null;
        try {
            rs = sb.executeQuery("SELECT SUM(\"Column \"\"1\"\"\") FROM T WHERE \"Column \"\"1\"\"\" > 1");
            try {
                this.assertTrue(rs.next());
                this.assertEquals(5049, rs.getInt(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        ca.close();
        cb.close();
    }
}

