/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.store.FileLister;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestAll;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.db.TestLobObject;
import org.h2.tools.Recover;
import org.h2.tools.SimpleResultSet;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;
import org.h2.util.Task;
import org.h2.value.ValueBlob;
import org.h2.value.ValueClob;
import org.h2.value.ValueLob;

public class TestLob
extends TestDb {
    private static final String MORE_THAN_128_CHARS = "123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";

    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        TestAll config = test.config;
        test.println(config.toString());
        int i = 0;
        while (i < 10) {
            test.testFromMain();
            test.println("Done pass #" + i);
            ++i;
        }
    }

    @Override
    public void test() throws Exception {
        this.testConcurrentSelectAndUpdate();
        this.testReclamationOnInDoubtRollback();
        this.testRemoveAfterDeleteAndClose();
        this.testRemovedAfterTimeout();
        this.testConcurrentRemoveRead();
        this.testCloseLobTwice();
        this.testClobWithRandomUnicodeChars();
        this.testCommitOnExclusiveConnection();
        this.testReadManyLobs();
        this.testLobSkip();
        this.testLobSkipPastEnd();
        this.testCreateIndexOnLob();
        this.testBlobInputStreamSeek(true);
        this.testBlobInputStreamSeek(false);
        this.testDeadlock();
        this.testCopyManyLobs();
        this.testCopyLob();
        this.testConcurrentCreate();
        this.testLobInLargeResult();
        this.testUniqueIndex();
        this.testConvert();
        this.testCreateAsSelect();
        this.testLobServerMemory();
        this.testUpdatingLobRow();
        this.testBufferedInputStreamBug();
        if (this.config.memory) {
            return;
        }
        this.testLargeClob();
        this.testLobUpdateMany();
        this.testLobVariable();
        this.testLobDrop();
        this.testLobNoClose();
        this.testLobTransactions(10);
        this.testLobTransactions(10000);
        this.testLobRollbackStop();
        this.testLobCopy();
        this.testLobHibernate();
        this.testLobCopy2();
        this.testManyLobs();
        this.testClob();
        this.testUpdateLob();
        this.testLobReconnect();
        this.testLob(false);
        this.testLob(true);
        this.testJavaObject();
        this.testLobInValueResultSet();
        this.deleteDb("lob");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testReclamationOnInDoubtRollback() throws Exception {
        Statement st32;
        Throwable throwable;
        Throwable throwable2;
        Connection conn;
        Object var2_5;
        Throwable throwable3;
        block67: {
            if (this.config.memory) return;
            if (this.config.cipher != null) {
                return;
            }
            this.deleteDb("lob");
            throwable3 = null;
            var2_5 = null;
            try {
                conn = this.getConnection("lob");
                try {
                    throwable2 = null;
                    throwable = null;
                    try {
                        st32 = conn.createStatement();
                        try {
                            st32.executeUpdate("CREATE TABLE IF NOT EXISTS dataTable(dataStamp BIGINT PRIMARY KEY, data BLOB)");
                        }
                        finally {
                            if (st32 != null) {
                                st32.close();
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        }
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                        throw throwable2;
                    }
                    conn.setAutoCommit(false);
                    Random rnd = new Random(0L);
                    throwable = null;
                    st32 = null;
                    try (PreparedStatement pstmt = conn.prepareStatement("INSERT INTO dataTable VALUES(?, ?)");){
                        int i = 0;
                        while (i < 100) {
                            int numBytes = 0x100000;
                            byte[] data = new byte[numBytes];
                            rnd.nextBytes(data);
                            pstmt.setLong(1, i);
                            pstmt.setBytes(2, data);
                            pstmt.executeUpdate();
                            ++i;
                        }
                    }
                    catch (Throwable st32) {
                        if (throwable == null) {
                            throwable = st32;
                            throw throwable;
                        }
                        if (throwable == st32) throw throwable;
                        throwable.addSuppressed(st32);
                        throw throwable;
                    }
                    throwable = null;
                    st32 = null;
                    try (Statement st = conn.createStatement();){
                        st.executeUpdate("PREPARE COMMIT lobtx");
                        st.execute("SHUTDOWN IMMEDIATELY");
                    }
                    catch (Throwable st32) {
                        if (throwable == null) {
                            throwable = st32;
                            throw throwable;
                        }
                        if (throwable == st32) throw throwable;
                        throwable.addSuppressed(st32);
                        throw throwable;
                    }
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable3 == null) {
                    throwable3 = throwable5;
                    throw throwable3;
                }
                if (throwable3 == throwable5) throw throwable3;
                throwable3.addSuppressed(throwable5);
                throw throwable3;
            }
            throwable3 = null;
            var2_5 = null;
            try {
                conn = this.getConnection("lob");
                try {
                    throwable2 = null;
                    throwable = null;
                    try {
                        st32 = conn.createStatement();
                        try {
                            try (ResultSet rs = st32.executeQuery("SELECT * FROM INFORMATION_SCHEMA.IN_DOUBT");){
                                this.assertTrue("No in-doubt tx", rs.first());
                                this.assertEquals("LOBTX", rs.getString("TRANSACTION_NAME"));
                                this.assertFalse("more than one in-doubt tx", rs.next());
                                st32.executeUpdate("ROLLBACK TRANSACTION lobtx; CHECKPOINT SYNC");
                            }
                            if (st32 == null) break block67;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            if (st32 == null) throw throwable2;
                            st32.close();
                            throw throwable2;
                        }
                        st32.close();
                    }
                    catch (Throwable throwable7) {
                        if (throwable2 == null) {
                            throwable2 = throwable7;
                            throw throwable2;
                        }
                        if (throwable2 == throwable7) throw throwable2;
                        throwable2.addSuppressed(throwable7);
                        throw throwable2;
                    }
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
            catch (Throwable throwable8) {
                if (throwable3 == null) {
                    throwable3 = throwable8;
                    throw throwable3;
                }
                if (throwable3 == throwable8) throw throwable3;
                throwable3.addSuppressed(throwable8);
                throw throwable3;
            }
        }
        throwable3 = null;
        var2_5 = null;
        try {
            conn = this.getConnection("lob");
            try {
                throwable2 = null;
                throwable = null;
                try {
                    st32 = conn.createStatement();
                    try {
                        st32.execute("SHUTDOWN COMPACT");
                    }
                    finally {
                        if (st32 != null) {
                            st32.close();
                        }
                    }
                }
                catch (Throwable throwable9) {
                    if (throwable2 == null) {
                        throwable2 = throwable9;
                        throw throwable2;
                    }
                    if (throwable2 == throwable9) throw throwable2;
                    throwable2.addSuppressed(throwable9);
                    throw throwable2;
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable10) {
            if (throwable3 == null) {
                throwable3 = throwable10;
                throw throwable3;
            }
            if (throwable3 == throwable10) throw throwable3;
            throwable3.addSuppressed(throwable10);
            throw throwable3;
        }
        ArrayList<String> dbFiles = FileLister.getDatabaseFiles(this.getBaseDir(), "lob", false);
        this.assertEquals(1, dbFiles.size());
        File file = new File(dbFiles.get(0));
        this.assertTrue(file.exists());
        long fileSize = file.length();
        this.assertTrue("File size=" + fileSize, fileSize < 13000L);
    }

    private void testRemoveAfterDeleteAndClose() throws Exception {
        if (this.config.memory || this.config.cipher != null) {
            return;
        }
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, data clob)");
        int i = 0;
        while (i < 10) {
            stat.execute("insert into test values(1, space(100000))");
            if (i > 5) {
                ResultSet rs = stat.executeQuery("select * from test");
                rs.next();
                Clob c = rs.getClob(2);
                stat.execute("delete from test where id = 1");
                c.getSubString(1L, 10);
            } else {
                stat.execute("delete from test where id = 1");
            }
            ++i;
        }
        conn.close();
        Recover.execute(this.getBaseDir(), "lob");
        long size = FileUtils.size(this.getBaseDir() + "/lob.h2.sql");
        this.assertTrue("size: " + size, size > 1000L && size < 10000L);
    }

    private void testLargeClob() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        conn.createStatement().execute("CREATE TABLE TEST(ID IDENTITY, C CLOB)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(C) VALUES(?)");
        int len = SysProperties.LOB_CLIENT_MAX_SIZE_MEMORY + 1;
        prep.setCharacterStream(1, TestLob.getRandomReader(len, 2), -1);
        prep.execute();
        conn = this.reconnect(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        this.assertEqualReaders(TestLob.getRandomReader(len, 2), rs.getCharacterStream("C"), -1);
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testRemovedAfterTimeout() throws Exception {
        if (this.config.lazy) {
            return;
        }
        this.deleteDb("lob");
        String url = this.getURL("lob;lob_timeout=200", true);
        Connection conn = this.getConnection(url);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, data clob)");
        PreparedStatement prep = conn.prepareStatement("insert into test values(?, ?)");
        prep.setInt(1, 1);
        prep.setString(2, "aaa" + new String(new char[16384]).replace('\u0000', 'x'));
        prep.execute();
        prep.setInt(1, 2);
        prep.setString(2, "bbb" + new String(new char[16384]).replace('\u0000', 'x'));
        prep.execute();
        ResultSet rs = stat.executeQuery("select * from test order by id");
        rs.next();
        Clob c1 = rs.getClob(2);
        this.assertEquals("aaa", c1.getSubString(1L, 3));
        rs.next();
        this.assertEquals("aaa", c1.getSubString(1L, 3));
        rs.close();
        this.assertEquals("aaa", c1.getSubString(1L, 3));
        stat.execute("delete from test");
        c1.getSubString(1L, 3);
        Thread.sleep(250L);
        stat.execute("delete from test");
        c1.getSubString(1L, 3);
        conn.close();
        this.assertThrows(SQLException.class, c1).getSubString(1L, 3);
    }

    private void testConcurrentRemoveRead() throws Exception {
        if (this.config.lazy) {
            return;
        }
        this.deleteDb("lob");
        String url = this.getURL("lob", true);
        Connection conn = this.getConnection(url);
        Statement stat = conn.createStatement();
        stat.execute("set max_length_inplace_lob 5");
        stat.execute("create table lob(data clob)");
        stat.execute("insert into lob values(space(100))");
        Connection conn2 = this.getConnection(url);
        Statement stat2 = conn2.createStatement();
        ResultSet rs = stat2.executeQuery("select data from lob");
        rs.next();
        stat.execute("delete lob");
        InputStream in = rs.getBinaryStream(1);
        in.read();
        conn2.close();
        conn.close();
    }

    private void testCloseLobTwice() throws SQLException {
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        PreparedStatement prep = conn.prepareStatement("set @c = ?");
        prep.setCharacterStream(1, (Reader)new StringReader(new String(new char[10000])), 10000);
        prep.execute();
        prep.setCharacterStream(1, (Reader)new StringReader(new String(new char[10001])), 10001);
        prep.execute();
        conn.setAutoCommit(true);
        conn.close();
    }

    private void testReadManyLobs() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id identity, data clob)");
        PreparedStatement prep = conn.prepareStatement("insert into test(data) values ?");
        byte[] data = new byte[256];
        Random r = new Random(1L);
        int i = 0;
        while (i < 1000) {
            r.nextBytes(data);
            prep.setBinaryStream(1, (InputStream)new ByteArrayInputStream(data), -1);
            prep.execute();
            ++i;
        }
        ResultSet rs = stat.executeQuery("select * from test");
        while (rs.next()) {
            rs.getString(2);
        }
        conn.close();
    }

    private void testLobSkip() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.executeUpdate("create table test(x blob) as select secure_rand(1000)");
        ResultSet rs = stat.executeQuery("select * from test");
        rs.next();
        Blob b = rs.getBlob(1);
        byte[] test = b.getBytes(6L, 995);
        this.assertEquals(995, test.length);
        stat.execute("drop table test");
        conn.close();
    }

    private void testLobSkipPastEnd() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int, data blob)");
        byte[] data = new byte[150000];
        new Random(0L).nextBytes(data);
        PreparedStatement prep = conn.prepareStatement("insert into test values(1, ?)");
        prep.setBytes(1, data);
        prep.execute();
        ResultSet rs = stat.executeQuery("select data from test");
        rs.next();
        int blockSize = 1;
        while (blockSize < 100000) {
            int i = 0;
            while (i < data.length) {
                InputStream in = rs.getBinaryStream(1);
                in.skip(i);
                byte[] d2 = new byte[data.length];
                int l = Math.min(blockSize, d2.length - i);
                l = in.read(d2, i, l);
                if (i >= data.length) {
                    this.assertEquals(-1, l);
                } else if (i + blockSize >= data.length) {
                    this.assertEquals(data.length - i, l);
                }
                int j = i;
                while (j < blockSize && j < d2.length) {
                    this.assertEquals(data[j], d2[j]);
                    ++j;
                }
                i += 1000;
            }
            blockSize *= 10;
        }
        stat.execute("drop table test");
        conn.close();
    }

    private void testCreateIndexOnLob() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int, name clob)");
        this.assertThrows(50100, stat).execute("create index idx_n on test(name)");
        stat.execute("drop table test");
        conn.close();
    }

    private void testBlobInputStreamSeek(boolean upgraded) throws Exception {
        PreparedStatement prep;
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, data blob)");
        Random random = new Random();
        byte[] buff = new byte[500000];
        int i = 0;
        while (i < 10) {
            prep = conn.prepareStatement("insert into test values(?, ?)");
            prep.setInt(1, i);
            random.setSeed(i);
            random.nextBytes(buff);
            prep.setBinaryStream(2, (InputStream)new ByteArrayInputStream(buff), -1);
            prep.execute();
            ++i;
        }
        prep = conn.prepareStatement("select * from test where id = ?");
        i = 0;
        while (i < 1) {
            random.setSeed(i);
            random.nextBytes(buff);
            int j = 0;
            while (j < buff.length) {
                prep.setInt(1, i);
                ResultSet rs = prep.executeQuery();
                rs.next();
                InputStream in = rs.getBinaryStream(2);
                in.skip(j);
                int t = in.read();
                this.assertEquals(t, buff[j] & 0xFF);
                j += 10000;
            }
            ++i;
        }
        conn.close();
    }

    private void testDeadlock() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name clob)");
        stat.execute("insert into test select x, space(10000) from system_range(1, 3)");
        final Connection conn2 = this.getConnection("lob");
        Task task = new Task(){

            @Override
            public void call() throws Exception {
                Statement stat = conn2.createStatement();
                stat.setFetchSize(1);
                int i = 0;
                while (!this.stop) {
                    ResultSet rs = stat.executeQuery("select * from test where id > -" + i);
                    while (rs.next()) {
                    }
                    ++i;
                }
            }
        };
        task.execute();
        stat.execute("create table test2(id int primary key, name clob)");
        int i = 0;
        while (i < 100) {
            stat.execute("delete from test2");
            stat.execute("insert into test2 values(1, space(10000 + " + i + "))");
            ++i;
        }
        task.get();
        conn.close();
        conn2.close();
    }

    Connection getDeadlock2Connection() throws SQLException {
        return this.getConnection("lob;LOCK_TIMEOUT=60000");
    }

    private void testCopyManyLobs() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id identity default on null, data clob) as select null, space(10000)");
        stat.execute("insert into test(data) select data from test");
        stat.execute("insert into test(data) select data from test");
        stat.execute("insert into test(data) select data from test");
        stat.execute("insert into test(data) select data from test");
        stat.execute("delete from test where id < 10");
        stat.execute("shutdown compact");
        conn.close();
    }

    private void testCopyLob() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id identity, data clob) as select 1, space(10000)");
        stat.execute("insert into test(id, data) select 2, data from test");
        stat.execute("delete from test where id = 1");
        conn.close();
        conn = this.getConnection("lob");
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select * from test");
        rs.next();
        this.assertEquals(10000, rs.getString(2).length());
        conn.close();
    }

    private void testConcurrentCreate() throws Exception {
        this.deleteDb("lob");
        final JdbcConnection conn1 = (JdbcConnection)this.getConnection("lob");
        final JdbcConnection conn2 = (JdbcConnection)this.getConnection("lob");
        conn1.setAutoCommit(false);
        conn2.setAutoCommit(false);
        final byte[] buffer = new byte[10000];
        Task task1 = new Task(){

            @Override
            public void call() throws Exception {
                while (!this.stop) {
                    Blob b = conn1.createBlob();
                    OutputStream out = b.setBinaryStream(1L);
                    out.write(buffer);
                    out.close();
                }
            }
        };
        Task task2 = new Task(){

            @Override
            public void call() throws Exception {
                while (!this.stop) {
                    Blob b = conn2.createBlob();
                    OutputStream out = b.setBinaryStream(1L);
                    out.write(buffer);
                    out.close();
                }
            }
        };
        task1.execute();
        task2.execute();
        Thread.sleep(1000L);
        task1.get();
        task2.get();
        conn1.close();
        conn2.close();
    }

    private void testLobInLargeResult() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int, data clob) as select x, null from system_range(1, 1000)");
        stat.execute("insert into test values(0, space(10000))");
        stat.execute("set max_memory_rows 100");
        ResultSet rs = stat.executeQuery("select * from test order by id desc");
        while (rs.next()) {
        }
        conn.close();
    }

    private void testUniqueIndex() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        this.assertThrows(50100, stat).execute("create memory table test(x clob unique)");
        conn.close();
    }

    private void testConvert() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int, data blob)");
        stat.execute("insert into test values(1, '')");
        ResultSet rs = stat.executeQuery("select cast(data as clob) from test");
        rs.next();
        this.assertEquals("", rs.getString(1));
        stat.execute("drop table test");
        stat.execute("create table test(id int, data clob)");
        stat.execute("insert into test values(1, '')");
        rs = stat.executeQuery("select cast(data as blob) from test");
        rs.next();
        this.assertEquals("", rs.getString(1));
        conn.close();
    }

    private void testCreateAsSelect() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int, data clob) as select 1, space(10000)");
        conn.close();
    }

    private void testLobUpdateMany() throws SQLException {
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("create table post(id int primary key, text clob) as select x, space(96) from system_range(1, 329)");
        PreparedStatement prep = conn.prepareStatement("update post set text = ?");
        prep.setCharacterStream(1, (Reader)new StringReader(new String(new char[1025])), -1);
        prep.executeUpdate();
        conn.close();
    }

    private void testLobServerMemory() throws SQLException {
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT, DATA CLOB)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(1, ?)");
        StringReader reader = new StringReader(new String(new char[100000]));
        prep.setCharacterStream(1, (Reader)reader, -1);
        prep.execute();
        conn.close();
    }

    private void testLobVariable() throws SQLException {
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT, DATA CLOB)");
        stat.execute("INSERT INTO TEST VALUES(1, SPACE(100000))");
        stat.execute("SET @TOTAL = SELECT DATA FROM TEST WHERE ID=1");
        stat.execute("DROP TABLE TEST");
        stat.execute("CALL @TOTAL LIKE '%X'");
        stat.execute("CREATE TABLE TEST(ID INT, DATA CLOB)");
        stat.execute("INSERT INTO TEST VALUES(1, @TOTAL)");
        stat.execute("INSERT INTO TEST VALUES(2, @TOTAL)");
        stat.execute("DROP TABLE TEST");
        stat.execute("CALL @TOTAL LIKE '%X'");
        conn.close();
    }

    private void testLobDrop() throws SQLException {
        if (this.config.networked) {
            return;
        }
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        Statement stat = conn.createStatement();
        int i = 0;
        while (i < 500) {
            stat.execute("CREATE TABLE T" + i + "(ID INT, C CLOB)");
            ++i;
        }
        stat.execute("CREATE TABLE TEST(ID INT, C CLOB)");
        stat.execute("INSERT INTO TEST VALUES(1, SPACE(10000))");
        i = 0;
        while (i < 500) {
            stat.execute("DROP TABLE T" + i);
            ++i;
        }
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
        while (rs.next()) {
            rs.getString("C");
        }
        conn.close();
    }

    private void testLobNoClose() throws Exception {
        if (this.config.networked) {
            return;
        }
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        conn.createStatement().execute("CREATE TABLE TEST(ID IDENTITY, DATA CLOB)");
        conn.createStatement().execute("INSERT INTO TEST VALUES(1, SPACE(10000))");
        ResultSet rs = conn.createStatement().executeQuery("SELECT DATA FROM TEST");
        rs.next();
        SysProperties.lobCloseBetweenReads = true;
        Reader in = rs.getCharacterStream(1);
        in.read();
        conn.createStatement().execute("DELETE FROM TEST");
        SysProperties.lobCloseBetweenReads = false;
        conn.createStatement().execute("INSERT INTO TEST VALUES(1, SPACE(10000))");
        rs = conn.createStatement().executeQuery("SELECT DATA FROM TEST");
        rs.next();
        in = rs.getCharacterStream(1);
        in.read();
        conn.setAutoCommit(false);
        try {
            int x;
            conn.createStatement().execute("DELETE FROM TEST");
            conn.commit();
            int len = 0;
            while ((x = in.read()) >= 0) {
                ++len;
            }
            in.close();
            if (len > 0 && System.getProperty("os.name").indexOf("Windows") > 0) {
                this.fail("Error expected; len=" + len);
            }
        }
        catch (SQLException e) {
            this.assertKnownException(e);
        }
        conn.rollback();
        conn.close();
    }

    private void testLobTransactions(int spaceLen) throws SQLException {
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        conn.createStatement().execute("CREATE TABLE TEST(ID IDENTITY, DATA CLOB, DATA2 VARCHAR)");
        conn.setAutoCommit(false);
        Random random = new Random(0L);
        int rows = 0;
        Savepoint sp = null;
        int len = this.getSize(100, 400);
        int i = 0;
        while (i < len) {
            switch (random.nextInt(10)) {
                case 0: {
                    this.trace("insert " + i);
                    conn.createStatement().execute("INSERT INTO TEST(DATA, DATA2) VALUES('" + i + "' || SPACE(" + spaceLen + "), '" + i + "')");
                    ++rows;
                    break;
                }
                case 1: {
                    if (rows <= 0) break;
                    int x = random.nextInt(rows);
                    this.trace("delete " + x);
                    conn.createStatement().execute("DELETE FROM TEST WHERE ID=" + x);
                    break;
                }
                case 2: {
                    if (rows <= 0) break;
                    int x = random.nextInt(rows);
                    this.trace("update " + x);
                    conn.createStatement().execute("UPDATE TEST SET DATA='x' || DATA, DATA2='x' || DATA2 WHERE ID=" + x);
                    break;
                }
                case 3: {
                    if (rows <= 0) break;
                    this.trace("commit");
                    conn.commit();
                    sp = null;
                    break;
                }
                case 4: {
                    if (rows <= 0) break;
                    this.trace("rollback");
                    conn.rollback();
                    sp = null;
                    break;
                }
                case 5: {
                    this.trace("savepoint");
                    sp = conn.setSavepoint();
                    break;
                }
                case 6: {
                    if (sp == null) break;
                    this.trace("rollback to savepoint");
                    conn.rollback(sp);
                    break;
                }
                case 7: {
                    if (rows <= 0) break;
                    this.trace("checkpoint");
                    conn.createStatement().execute("CHECKPOINT");
                    this.trace("shutdown immediately");
                    conn.createStatement().execute("SHUTDOWN IMMEDIATELY");
                    this.trace("shutdown done");
                    conn = this.reconnect(conn);
                    conn.setAutoCommit(false);
                    sp = null;
                }
            }
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
            while (rs.next()) {
                int id = rs.getInt("ID");
                String d1 = rs.getString("DATA").trim();
                String d2 = rs.getString("DATA2");
                this.assertEquals("id:" + id, d2, d1);
            }
            ++i;
        }
        conn.close();
    }

    private void testLobRollbackStop() throws SQLException {
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        conn.createStatement().execute("CREATE TABLE TEST(ID INT PRIMARY KEY, DATA CLOB)");
        conn.createStatement().execute("INSERT INTO TEST VALUES(1, SPACE(10000))");
        conn.setAutoCommit(false);
        conn.createStatement().execute("DELETE FROM TEST");
        conn.createStatement().execute("CHECKPOINT");
        conn.createStatement().execute("SHUTDOWN IMMEDIATELY");
        conn = this.reconnect(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        this.assertTrue(rs.next());
        rs.getInt(1);
        this.assertEquals(10000, rs.getString(2).length());
        conn.close();
    }

    private void testLobCopy() throws SQLException {
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int, data clob)");
        stat.execute("insert into test values(1, space(1000));");
        stat.execute("insert into test values(2, space(10000));");
        stat.execute("create table test2(id int, data clob);");
        stat.execute("insert into test2 select * from test;");
        stat.execute("drop table test;");
        stat.execute("select * from test2;");
        stat.execute("update test2 set id=id;");
        stat.execute("select * from test2;");
        conn.close();
    }

    private void testLobHibernate() throws Exception {
        int ch;
        this.deleteDb("lob");
        Connection conn0 = this.reconnect(null);
        conn0.getAutoCommit();
        conn0.setAutoCommit(false);
        DatabaseMetaData dbMeta0 = conn0.getMetaData();
        dbMeta0.getDatabaseProductName();
        dbMeta0.getDatabaseMajorVersion();
        dbMeta0.getDatabaseProductVersion();
        dbMeta0.getDriverName();
        dbMeta0.getDriverVersion();
        dbMeta0.supportsResultSetType(1004);
        dbMeta0.supportsBatchUpdates();
        dbMeta0.dataDefinitionCausesTransactionCommit();
        dbMeta0.dataDefinitionIgnoredInTransactions();
        dbMeta0.supportsGetGeneratedKeys();
        conn0.getAutoCommit();
        conn0.getAutoCommit();
        conn0.commit();
        conn0.setAutoCommit(true);
        Statement stat0 = conn0.createStatement();
        stat0.executeUpdate("drop table CLOB_ENTITY if exists");
        stat0.getWarnings();
        stat0.executeUpdate("create table CLOB_ENTITY (ID bigint not null, DATA clob, CLOB_DATA clob, primary key (ID))");
        stat0.getWarnings();
        stat0.close();
        conn0.getWarnings();
        conn0.clearWarnings();
        conn0.setAutoCommit(false);
        conn0.getAutoCommit();
        conn0.getAutoCommit();
        PreparedStatement prep0 = conn0.prepareStatement("select max(ID) from CLOB_ENTITY");
        ResultSet rs0 = prep0.executeQuery();
        rs0.next();
        rs0.getLong(1);
        rs0.wasNull();
        rs0.close();
        prep0.close();
        conn0.getAutoCommit();
        PreparedStatement prep1 = conn0.prepareStatement("insert into CLOB_ENTITY(DATA, CLOB_DATA, ID) values (?, ?, ?)");
        prep1.setNull(1, 2005);
        StringBuilder buff = new StringBuilder(10000);
        int i = 0;
        while (i < 10000) {
            buff.append((char)(48 + i % 10));
            ++i;
        }
        StringReader x = new StringReader(buff.toString());
        prep1.setCharacterStream(2, (Reader)x, 10000);
        prep1.setLong(3, 1L);
        prep1.addBatch();
        prep1.executeBatch();
        prep1.close();
        conn0.getAutoCommit();
        conn0.getAutoCommit();
        conn0.commit();
        conn0.isClosed();
        conn0.getWarnings();
        conn0.clearWarnings();
        conn0.getAutoCommit();
        conn0.getAutoCommit();
        PreparedStatement prep2 = conn0.prepareStatement("select c_.ID as ID0_0_, c_.DATA as S_, c_.CLOB_DATA as CLOB3_0_0_ from CLOB_ENTITY c_ where c_.ID=?");
        prep2.setLong(1, 1L);
        ResultSet rs1 = prep2.executeQuery();
        rs1.next();
        rs1.getCharacterStream("S_");
        Clob clob0 = rs1.getClob("CLOB3_0_0_");
        rs1.wasNull();
        rs1.next();
        rs1.close();
        prep2.getMaxRows();
        prep2.getQueryTimeout();
        prep2.close();
        conn0.getAutoCommit();
        Reader r = clob0.getCharacterStream();
        int i2 = 0;
        while (i2 < 10000) {
            ch = r.read();
            if (ch != 48 + i2 % 10) {
                this.fail("expected " + (char)(48 + i2 % 10) + " got: " + ch + " (" + (char)ch + ")");
            }
            ++i2;
        }
        ch = r.read();
        if (ch != -1) {
            this.fail("expected -1 got: " + ch);
        }
        r.close();
        r = clob0.getCharacterStream(1235L, 1000L);
        i2 = 1234;
        while (i2 < 2234) {
            ch = r.read();
            if (ch != 48 + i2 % 10) {
                this.fail("expected " + (char)(48 + i2 % 10) + " got: " + ch + " (" + (char)ch + ")");
            }
            ++i2;
        }
        ch = r.read();
        if (ch != -1) {
            this.fail("expected -1 got: " + ch);
        }
        r.close();
        this.assertThrows(90008, clob0).getCharacterStream(10001L, 1L);
        this.assertThrows(90008, clob0).getCharacterStream(10002L, 0L);
        conn0.close();
    }

    private void testLobCopy2() throws SQLException {
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        Statement stat = conn.createStatement();
        conn = this.reconnect(conn);
        stat = conn.createStatement();
        stat.execute("create table test(text clob)");
        stat.execute("create table test2(text clob)");
        StringBuilder buff = new StringBuilder();
        int i = 0;
        while (i < 1000) {
            buff.append(' ');
            ++i;
        }
        String spaces = buff.toString();
        stat.execute("insert into test values('" + spaces + "')");
        stat.execute("insert into test2 select * from test");
        ResultSet rs = stat.executeQuery("select * from test2");
        rs.next();
        this.assertEquals(spaces, rs.getString(1));
        stat.execute("drop table test");
        rs = stat.executeQuery("select * from test2");
        rs.next();
        this.assertEquals(spaces, rs.getString(1));
        stat.execute("alter table test2 add column id int before text");
        rs = stat.executeQuery("select * from test2");
        rs.next();
        this.assertEquals(spaces, rs.getString("text"));
        conn.close();
    }

    private void testManyLobs() throws Exception {
        int l;
        Clob c;
        Blob b;
        int i;
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        conn.createStatement().execute("CREATE TABLE TEST(ID INT PRIMARY KEY, B BLOB, C CLOB)");
        int len = this.getSize(10, 2000);
        if (this.config.networked) {
            len = 100;
        }
        int first = 1;
        int increment = 19;
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(ID, B, C) VALUES(?, ?, ?)");
        int i2 = first;
        while (i2 < len) {
            int l2 = i2;
            prep.setInt(1, i2);
            prep.setBinaryStream(2, TestLob.getRandomStream(l2, i2), -1);
            prep.setCharacterStream(3, TestLob.getRandomReader(l2, i2), -1);
            prep.execute();
            i2 += increment;
        }
        conn = this.reconnect(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST ORDER BY ID");
        while (rs.next()) {
            i = rs.getInt("ID");
            b = rs.getBlob("B");
            c = rs.getClob("C");
            l = i;
            this.assertEquals((long)l, b.length());
            this.assertEquals((long)l, c.length());
            this.assertEqualStreams(TestLob.getRandomStream(l, i), b.getBinaryStream(), -1);
            this.assertEqualReaders(TestLob.getRandomReader(l, i), c.getCharacterStream(), -1);
        }
        prep = conn.prepareStatement("UPDATE TEST SET B=?, C=? WHERE ID=?");
        i = first;
        while (i < len) {
            int l3 = i;
            prep.setBinaryStream(1, TestLob.getRandomStream(l3, -i), -1);
            prep.setCharacterStream(2, TestLob.getRandomReader(l3, -i), -1);
            prep.setInt(3, i);
            prep.execute();
            i += increment;
        }
        conn = this.reconnect(conn);
        rs = conn.createStatement().executeQuery("SELECT * FROM TEST ORDER BY ID");
        while (rs.next()) {
            i = rs.getInt("ID");
            b = rs.getBlob("B");
            c = rs.getClob("C");
            l = i;
            this.assertEquals((long)l, b.length());
            this.assertEquals((long)l, c.length());
            this.assertEqualStreams(TestLob.getRandomStream(l, -i), b.getBinaryStream(), -1);
            this.assertEqualReaders(TestLob.getRandomReader(l, -i), c.getCharacterStream(), -1);
        }
        conn.close();
    }

    private void testClob() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        conn.createStatement().execute("CREATE TABLE TEST(ID IDENTITY, C CLOB)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(C) VALUES(?)");
        prep.setCharacterStream(1, (Reader)new CharArrayReader("Bohlen".toCharArray()), "Bohlen".length());
        prep.execute();
        prep.setCharacterStream(1, (Reader)new CharArrayReader("B\u00f6hlen".toCharArray()), "B\u00f6hlen".length());
        prep.execute();
        prep.setCharacterStream(1, TestLob.getRandomReader(501, 1), -1);
        prep.execute();
        prep.setCharacterStream(1, TestLob.getRandomReader(1501, 2), 401);
        prep.execute();
        conn = this.reconnect(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        this.assertEquals("Bohlen", rs.getString("C"));
        this.assertEqualReaders(new CharArrayReader("Bohlen".toCharArray()), rs.getCharacterStream("C"), -1);
        rs.next();
        this.assertEqualReaders(new CharArrayReader("B\u00f6hlen".toCharArray()), rs.getCharacterStream("C"), -1);
        rs.next();
        this.assertEqualReaders(TestLob.getRandomReader(501, 1), rs.getCharacterStream("C"), -1);
        Clob clob = rs.getClob("C");
        this.assertEqualReaders(TestLob.getRandomReader(501, 1), clob.getCharacterStream(), -1);
        this.assertEquals(501L, clob.length());
        rs.next();
        this.assertEqualReaders(TestLob.getRandomReader(401, 2), rs.getCharacterStream("C"), -1);
        this.assertEqualReaders(TestLob.getRandomReader(1500, 2), rs.getCharacterStream("C"), 401);
        clob = rs.getClob("C");
        this.assertEqualReaders(TestLob.getRandomReader(1501, 2), clob.getCharacterStream(), 401);
        this.assertEqualReaders(TestLob.getRandomReader(401, 2), clob.getCharacterStream(), 401);
        this.assertEquals(401L, clob.length());
        this.assertFalse(rs.next());
        conn.close();
    }

    private Connection reconnect(Connection conn) throws SQLException {
        long time = System.nanoTime();
        if (conn != null) {
            JdbcUtils.closeSilently(conn);
        }
        conn = this.getConnection("lob");
        this.trace("re-connect=" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        return conn;
    }

    private void testUpdateLob() throws SQLException {
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        PreparedStatement prep = conn.prepareStatement("CREATE TABLE IF NOT EXISTS p( id int primary key, rawbyte BLOB ); ");
        prep.execute();
        prep.close();
        prep = conn.prepareStatement("INSERT INTO p(id) VALUES(?);");
        int i = 0;
        while (i < 10) {
            prep.setInt(1, i);
            prep.execute();
            ++i;
        }
        prep.close();
        prep = conn.prepareStatement("UPDATE p set rawbyte=? WHERE id=?");
        i = 0;
        while (i < 8) {
            prep.setBinaryStream(1, TestLob.getRandomStream(10000, i), 0);
            prep.setInt(2, i);
            prep.execute();
            ++i;
        }
        prep.close();
        conn.commit();
        conn = this.reconnect(conn);
        conn.setAutoCommit(true);
        prep = conn.prepareStatement("UPDATE p set rawbyte=? WHERE id=?");
        i = 8;
        while (i < 10) {
            prep.setBinaryStream(1, TestLob.getRandomStream(10000, i), 0);
            prep.setInt(2, i);
            prep.execute();
            ++i;
        }
        prep.close();
        prep = conn.prepareStatement("SELECT * from p");
        ResultSet rs = prep.executeQuery();
        while (rs.next()) {
            int i2 = 1;
            while (i2 <= rs.getMetaData().getColumnCount()) {
                rs.getMetaData().getColumnName(i2);
                rs.getString(i2);
                ++i2;
            }
        }
        conn.close();
    }

    private void testLobReconnect() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, TEXT CLOB)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(1, ?)");
        String s = new String(TestLob.getRandomChars(10000, 1));
        byte[] data = s.getBytes(StandardCharsets.UTF_8);
        s = "";
        prep.setBinaryStream(1, (InputStream)new ByteArrayInputStream(data), 0);
        prep.execute();
        conn = this.reconnect(conn);
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST WHERE ID=1");
        rs.next();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        this.assertEqualStreams(in, rs.getBinaryStream("TEXT"), -1);
        prep = conn.prepareStatement("UPDATE TEST SET TEXT = ?");
        prep.setBinaryStream(1, (InputStream)new ByteArrayInputStream(data), 0);
        prep.execute();
        conn = this.reconnect(conn);
        stat = conn.createStatement();
        rs = stat.executeQuery("SELECT * FROM TEST WHERE ID=1");
        rs.next();
        this.assertEqualStreams(rs.getBinaryStream("TEXT"), new ByteArrayInputStream(data), -1);
        stat.execute("DROP TABLE IF EXISTS TEST");
        conn.close();
    }

    private void testLob(boolean clob) throws Exception {
        int size;
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        conn = this.reconnect(conn);
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, V " + (clob ? "CLOB" : "BLOB") + ")");
        int len = this.getSize(1, 1000);
        if (this.config.networked && this.config.big) {
            len = 100;
        }
        long time = System.nanoTime();
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        int i = 0;
        while (i < len) {
            prep.setInt(1, i);
            size = i * i;
            if (clob) {
                prep.setCharacterStream(2, TestLob.getRandomReader(size, i), 0);
            } else {
                prep.setBinaryStream(2, TestLob.getRandomStream(size, i), 0);
            }
            prep.execute();
            i += i + i + 1;
        }
        this.trace("insert=" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        this.traceMemory();
        conn = this.reconnect(conn);
        time = System.nanoTime();
        prep = conn.prepareStatement("SELECT ID, V FROM TEST");
        ResultSet rs = prep.executeQuery();
        while (rs.next()) {
            Object obj;
            int id = rs.getInt("ID");
            size = id * id;
            if (clob) {
                Reader rt = rs.getCharacterStream(2);
                this.assertEqualReaders(TestLob.getRandomReader(size, id), rt, -1);
                obj = rs.getObject(2);
                if (obj instanceof Clob) {
                    obj = ((Clob)obj).getCharacterStream();
                }
                this.assertEqualReaders(TestLob.getRandomReader(size, id), (Reader)obj, -1);
                continue;
            }
            InputStream in = rs.getBinaryStream(2);
            this.assertEqualStreams(TestLob.getRandomStream(size, id), in, -1);
            obj = rs.getObject(2);
            if (obj instanceof Blob) {
                obj = ((Blob)obj).getBinaryStream();
            }
            this.assertEqualStreams(TestLob.getRandomStream(size, id), (InputStream)obj, -1);
        }
        this.trace("select=" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        this.traceMemory();
        conn = this.reconnect(conn);
        time = System.nanoTime();
        prep = conn.prepareStatement("DELETE FROM TEST WHERE ID=?");
        i = 0;
        while (i < len) {
            prep.setInt(1, i);
            prep.executeUpdate();
            ++i;
        }
        this.trace("delete=" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        this.traceMemory();
        conn = this.reconnect(conn);
        conn.setAutoCommit(false);
        prep = conn.prepareStatement("INSERT INTO TEST VALUES(1, ?)");
        if (clob) {
            prep.setCharacterStream(1, TestLob.getRandomReader(0, 0), 0);
        } else {
            prep.setBinaryStream(1, TestLob.getRandomStream(0, 0), 0);
        }
        prep.execute();
        conn.rollback();
        prep.execute();
        conn.commit();
        conn.createStatement().execute("DELETE FROM TEST WHERE ID=1");
        conn.rollback();
        conn.createStatement().execute("DELETE FROM TEST WHERE ID=1");
        conn.commit();
        conn.createStatement().execute("DROP TABLE TEST");
        conn.close();
    }

    private void testJavaObject() throws SQLException {
        this.deleteDb("lob");
        JdbcConnection conn = (JdbcConnection)this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, DATA OTHER)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(1, ?)");
        prep.setObject(1, new TestLobObject("abc"));
        prep.execute();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        rs.next();
        Object oa = rs.getObject(2);
        this.assertEquals(TestLobObject.class.getName(), oa.getClass().getName());
        Object ob = rs.getObject("DATA");
        this.assertEquals(TestLobObject.class.getName(), ob.getClass().getName());
        this.assertEquals("TestLobObject: abc", oa.toString());
        this.assertEquals("TestLobObject: abc", ob.toString());
        this.assertFalse(rs.next());
        conn.createStatement().execute("drop table test");
        stat.execute("create table test(v other)");
        prep = conn.prepareStatement("insert into test values(?)");
        prep.setObject(1, JdbcUtils.serialize("", conn.getJavaObjectSerializer()));
        prep.execute();
        rs = stat.executeQuery("select v from test");
        while (rs.next()) {
            this.assertEquals("", (String)rs.getObject("v"));
        }
        conn.close();
    }

    private void testBufferedInputStreamBug() throws SQLException {
        this.deleteDb("lob");
        JdbcConnection conn = (JdbcConnection)this.getConnection("lob");
        conn.createStatement().execute("CREATE TABLE TEST(test BLOB)");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO TEST(test) VALUES(?)");
        ps.setBlob(1, new ByteArrayInputStream(new byte[257]));
        ps.executeUpdate();
        conn.close();
    }

    private static Reader getRandomReader(int len, int seed) {
        return new CharArrayReader(TestLob.getRandomChars(len, seed));
    }

    private static char[] getRandomChars(int len, int seed) {
        Random random = new Random(seed);
        char[] buff = new char[len];
        int i = 0;
        while (i < len) {
            char ch;
            while ((ch = (char)random.nextInt(65535)) >= '\ud800' && ch <= '\udfff') {
            }
            buff[i] = ch;
            ++i;
        }
        return buff;
    }

    private static InputStream getRandomStream(int len, int seed) {
        Random random = new Random(seed);
        byte[] buff = new byte[len];
        random.nextBytes(buff);
        return new ByteArrayInputStream(buff);
    }

    private void testUpdatingLobRow() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name clob, counter int)");
        stat.execute("insert into test(id, name) select x, space(100000) from system_range(1, 3)");
        ResultSet rs = stat.executeQuery("select name from test where id = 1");
        rs.next();
        Reader r = rs.getClob("name").getCharacterStream();
        Random random = new Random();
        char[] tmp = new char[256];
        while (r.read(tmp) > 0) {
            stat.execute("update test set counter = " + random.nextInt(1000) + " where id = 1");
        }
        r.close();
        conn.close();
    }

    private void testCommitOnExclusiveConnection() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob;EXCLUSIVE=1");
        Statement statement = conn.createStatement();
        statement.execute("drop table if exists TEST");
        statement.execute("create table TEST (COL INTEGER, LOB CLOB)");
        conn.setAutoCommit(false);
        statement.execute("insert into TEST (COL, LOB) values (1, '123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789')");
        statement.execute("update TEST set COL=2");
        conn.commit();
        conn.close();
    }

    private void testClobWithRandomUnicodeChars() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE logs(id int primary key auto_increment, message CLOB)");
        PreparedStatement s1 = conn.prepareStatement("INSERT INTO logs (message) VALUES ?");
        Random rand = new Random(1L);
        int i = 1;
        while (i <= 100) {
            String data = TestLob.randomUnicodeString(rand);
            s1.setString(1, data);
            s1.executeUpdate();
            ResultSet rs = stat.executeQuery("SELECT id, message FROM logs ORDER BY id DESC LIMIT 1");
            rs.next();
            String read = rs.getString(2);
            if (!read.equals(data)) {
                int j = 0;
                while (j < read.length()) {
                    this.assertEquals("pos: " + j + " i:" + i, read.charAt(j), data.charAt(j));
                    ++j;
                }
            }
            this.assertEquals(read, data);
            ++i;
        }
        conn.close();
    }

    /*
     * Unable to fully structure code
     */
    private static String randomUnicodeString(Random rand) {
        count = 10000;
        buffer = new char[count];
        if (true) ** GOTO lbl21
        do {
            if ((ch = (char)rand.nextInt()) >= '\udc00' && ch <= '\udfff') {
                if (count != 0) {
                    buffer[count] = ch;
                    buffer[--count] = (char)(55296 + rand.nextInt(128));
                }
            } else if (ch >= '\ud800' && ch <= '\udb7f') {
                if (count == 0) {
                    ++count;
                } else {
                    buffer[count] = (char)(56320 + rand.nextInt(128));
                    buffer[--count] = ch;
                }
            } else if (ch >= '\udb80' && ch <= '\udbff') {
                ++count;
            } else {
                buffer[count] = ch;
            }
lbl21:
            // 6 sources

            v0 = ++count;
            --count;
        } while (v0 != 0);
        return new String(buffer);
    }

    private void testLobInValueResultSet() throws SQLException {
        this.deleteDb("lob");
        JdbcConnection conn = (JdbcConnection)this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS VRS FOR '" + this.getClass().getName() + ".testLobInValueResultSetGet'");
        ResultSet rs = stat.executeQuery("SELECT * FROM VRS()");
        this.assertTrue(rs.next());
        Clob clob = rs.getClob(1);
        this.assertFalse(rs.next());
        this.assertEquals(MORE_THAN_128_CHARS, clob.getSubString(1L, Integer.MAX_VALUE));
        conn.close();
    }

    public static SimpleResultSet testLobInValueResultSetGet(Connection conn) throws SQLException {
        final Clob c = conn.createClob();
        c.setString(1L, MORE_THAN_128_CHARS);
        SimpleResultSet rs = new SimpleResultSet(){

            @Override
            public Object getObject(int columnIndex) throws SQLException {
                return c;
            }
        };
        rs.addColumn("L", 2005, 1000, 0);
        rs.addRow(MORE_THAN_128_CHARS);
        return rs;
    }

    private void testLimits() throws Exception {
        this.deleteDb("lob");
        JdbcConnection conn = (JdbcConnection)this.getConnection("lob");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INTEGER, B BLOB, C CLOB)");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO TEST VALUES (?, ?, ?)");
        ps.setInt(1, 1);
        byte[] b = new byte[1000000000];
        Arrays.fill(b, (byte)65);
        String s = new String(b, StandardCharsets.UTF_8);
        ps.setBytes(2, b);
        ps.setString(3, s);
        ps.executeUpdate();
        byte[] b2 = new byte[1000000001];
        Arrays.fill(b2, (byte)65);
        String s2 = new String(b2, StandardCharsets.UTF_8);
        this.assertThrows(22001, ps).setBytes(2, b2);
        ps.setBinaryStream(2, new ByteArrayInputStream(b2));
        this.assertThrows(22001, ps).setString(3, s2);
        ps.setCharacterStream(3, new StringReader(s2));
        ps.executeUpdate();
        Throwable throwable = null;
        Object var9_10 = null;
        try (ResultSet rs = stat.executeQuery("TABLE TEST ORDER BY ID");){
            this.assertTrue(rs.next());
            this.assertEquals(1, rs.getInt(1));
            this.testLimitsSmall(b, s, rs, 2);
            this.testLimitsSmall(b, s, rs, 2);
            this.testLimitsSmall(b, s, rs, 3);
            this.testLimitsSmall(b, s, rs, 3);
            this.assertTrue(rs.next());
            this.assertEquals(1, rs.getInt(1));
            this.testLimitsLarge(b2, s2, rs, 2);
            this.testLimitsLarge(b2, s2, rs, 2);
            this.testLimitsLarge(b2, s2, rs, 3);
            this.testLimitsLarge(b2, s2, rs, 3);
            this.assertFalse(rs.next());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        conn.close();
        this.testLimitsSmall(b, s, ValueBlob.createSmall(b));
        this.testLimitsSmall(b, s, ValueClob.createSmall(b, 1000000000L));
        this.testLimitsLarge(b2, s2, ValueBlob.createSmall(b2));
        this.testLimitsLarge(b2, s2, ValueClob.createSmall(b2, 1000000001L));
    }

    private void testLimitsSmall(byte[] b, String s, ResultSet rs, int index) throws SQLException {
        this.assertEquals(b, rs.getBytes(index));
        this.assertEquals(s, rs.getString(index));
    }

    private void testLimitsLarge(byte[] b, String s, ResultSet rs, int index) throws SQLException, IOException {
        this.assertThrows(22001, rs).getBytes(index);
        this.assertEquals(b, IOUtils.readBytesAndClose(rs.getBlob(index).getBinaryStream(), -1));
        this.assertThrows(22001, rs).getString(index);
        this.assertEquals(s, IOUtils.readStringAndClose(rs.getClob(index).getCharacterStream(), -1));
    }

    private void testLimitsSmall(byte[] b, String s, ValueLob v) {
        this.assertEquals(b, v.getBytesNoCopy());
        this.assertEquals(s, v.getString());
        this.assertEquals(s, v.getString());
    }

    /*
     * Unable to fully structure code
     */
    private void testLimitsLarge(byte[] b, String s, ValueLob v) throws IOException {
        try {
            this.assertEquals(b, v.getBytesNoCopy());
            throw new AssertionError();
        }
        catch (DbException e) {
            this.assertEquals(22001, e.getErrorCode());
            this.assertEquals(b, IOUtils.readBytesAndClose(v.getInputStream(), -1));
            i = 0;
            ** while (i < 2)
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.assertEquals(s, v.getString());
                throw new AssertionError();
            }
            catch (DbException e) {
                this.assertEquals(22001, e.getErrorCode());
                this.assertEquals(s, IOUtils.readStringAndClose(v.getReader(), -1));
                ++i;
            }
            continue;
        }
lbl17:
        // 1 sources

    }

    public void testConcurrentSelectAndUpdate() throws SQLException, InterruptedException {
        this.deleteDb("lob");
        Throwable throwable = null;
        Object var2_3 = null;
        try (JdbcConnection conn1 = (JdbcConnection)this.getConnection("lob");){
            Throwable throwable2 = null;
            Object var5_8 = null;
            try (JdbcConnection conn2 = (JdbcConnection)this.getConnection("lob");){
                Throwable throwable3 = null;
                Throwable throwable4 = null;
                try (Statement st = conn1.createStatement();){
                    String createTable = "create table t1 (id int, ver bigint, data text, primary key (id));";
                    st.execute(createTable);
                }
                catch (Throwable throwable5) {
                    if (throwable3 == null) {
                        throwable3 = throwable5;
                    } else if (throwable3 != throwable5) {
                        throwable3.addSuppressed(throwable5);
                    }
                    throw throwable3;
                }
                String insert = "insert into t1 (id, ver, data) values (1, 0, ?)";
                throwable4 = null;
                Object var9_17 = null;
                try (PreparedStatement insertStmt = conn1.prepareStatement(insert);){
                    String largeData = StringUtils.pad("", 512, "x", false);
                    insertStmt.setString(1, largeData);
                    insertStmt.executeUpdate();
                }
                catch (Throwable throwable6) {
                    if (throwable4 == null) {
                        throwable4 = throwable6;
                    } else if (throwable4 != throwable6) {
                        throwable4.addSuppressed(throwable6);
                    }
                    throw throwable4;
                }
                long startTimeNs = System.nanoTime();
                Thread thread1 = new Thread(() -> {
                    try {
                        String update = "update t1 set ver = ver + 1 where id = 1";
                        Throwable throwable = null;
                        Object var5_6 = null;
                        try (PreparedStatement ps = conn2.prepareStatement(update);){
                            while (!Thread.currentThread().isInterrupted() && System.nanoTime() - startTimeNs < 10000000000L) {
                                ps.executeUpdate();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                thread1.start();
                Throwable throwable7 = null;
                Object var12_22 = null;
                try (PreparedStatement st = conn1.prepareStatement("select * from t1 where id = 1");){
                    while (System.nanoTime() - startTimeNs < 10000000000L) {
                        st.executeQuery();
                    }
                }
                catch (Throwable throwable8) {
                    if (throwable7 == null) {
                        throwable7 = throwable8;
                    } else if (throwable7 != throwable8) {
                        throwable7.addSuppressed(throwable8);
                    }
                    throw throwable7;
                }
                thread1.join();
            }
            catch (Throwable throwable9) {
                if (throwable2 == null) {
                    throwable2 = throwable9;
                } else if (throwable2 != throwable9) {
                    throwable2.addSuppressed(throwable9);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable10) {
            if (throwable == null) {
                throwable = throwable10;
            } else if (throwable != throwable10) {
                throwable.addSuppressed(throwable10);
            }
            throw throwable;
        }
    }
}

