/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestMaterializedView
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb("materializedview");
        this.test1();
        this.deleteDb("materializedview");
    }

    private void test1() throws SQLException {
        Connection conn = this.getConnection("materializedview");
        Statement stat = conn.createStatement();
        stat.execute("create table test(a int, b int)");
        stat.execute("insert into test values(1, 1)");
        stat.execute("create materialized view test_view as select a, b from test");
        ResultSet rs = stat.executeQuery("select * from test_view");
        this.assertTrue(rs.next());
        this.assertEquals(rs.getInt(1), 1);
        this.assertEquals(rs.getInt(2), 1);
        this.assertFalse(rs.next());
        stat.execute("insert into test values(2, 2)");
        stat.execute("refresh materialized view test_view");
        rs = stat.executeQuery("select * from test_view");
        this.assertTrue(rs.next());
        this.assertEquals(rs.getInt(1), 1);
        this.assertEquals(rs.getInt(2), 1);
        this.assertTrue(rs.next());
        this.assertEquals(rs.getInt(1), 2);
        this.assertEquals(rs.getInt(2), 2);
        this.assertFalse(rs.next());
        this.assertThrows(90107, () -> stat.execute("drop table test"));
        stat.execute("drop materialized view test_view");
        stat.execute("drop table test");
        conn.close();
    }
}

