/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.store.fs.mem.FilePathMem;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Utils;

public class TestOutOfMemory
extends TestDb {
    private static final String DB_NAME = "outOfMemory";

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.vmlens;
    }

    @Override
    public void test() throws Exception {
        try {
            if (!this.config.ci) {
                System.gc();
                this.testMVStoreUsingInMemoryFileSystem();
                System.gc();
                this.testDatabaseUsingInMemoryFileSystem();
            }
            System.gc();
            if (!this.config.networked) {
                this.testUpdateWhenNearlyOutOfMemory();
            }
        }
        finally {
            System.gc();
        }
    }

    private void testMVStoreUsingInMemoryFileSystem() {
        FilePath.register(new FilePathMem());
        String fileName = "memFS:" + this.getTestName();
        AtomicReference exRef = new AtomicReference();
        MVStore store = new MVStore.Builder().fileName(fileName).backgroundExceptionHandler((t, e) -> {
            boolean bl = exRef.compareAndSet(null, e);
        }).open();
        try {
            MVMap<Integer, byte[]> map = store.openMap("test");
            Random r = new Random(1L);
            try {
                int i = 0;
                while (i < 100) {
                    byte[] data = new byte[0xA00000];
                    r.nextBytes(data);
                    map.put(i, data);
                    ++i;
                }
                Throwable throwable = (Throwable)exRef.get();
                if (throwable instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)throwable;
                }
                if (throwable instanceof MVStoreException) {
                    throw (MVStoreException)throwable;
                }
                this.fail();
            }
            catch (OutOfMemoryError | MVStoreException throwable) {
                // empty catch block
            }
            try {
                store.close();
            }
            catch (MVStoreException mVStoreException) {
                // empty catch block
            }
            store.closeImmediately();
            store = MVStore.open(fileName);
            store.openMap("test");
            store.close();
        }
        finally {
            store.closeImmediately();
            FileUtils.delete(fileName);
        }
    }

    private void testDatabaseUsingInMemoryFileSystem() throws SQLException, InterruptedException {
        String filename = "memFS:" + this.getTestName();
        String url = "jdbc:h2:" + filename + "/test";
        try {
            Connection conn = DriverManager.getConnection(url);
            Statement stat = conn.createStatement();
            long memoryFree = Utils.getMemoryFree();
            try {
                stat.execute("create table test(id int, name varchar) as select x, space(1000000+x) from system_range(1, 10000)");
                this.fail();
            }
            catch (SQLException e) {
                this.assertTrue("Unexpected error code: " + e.getErrorCode(), 90108 == e.getErrorCode() || 90030 == e.getErrorCode() || 90098 == e.getErrorCode() || 50000 == e.getErrorCode());
            }
            TestOutOfMemory.recoverAfterOOM(memoryFree * 3L / 4L);
            try {
                conn.close();
                this.fail();
            }
            catch (SQLException e) {
                this.assertTrue("Unexpected error code: " + e.getErrorCode(), 90108 == e.getErrorCode() || 90030 == e.getErrorCode() || 90098 == e.getErrorCode() || 50000 == e.getErrorCode());
            }
            TestOutOfMemory.recoverAfterOOM(memoryFree * 3L / 4L);
            conn = DriverManager.getConnection(url);
            stat = conn.createStatement();
            stat.execute("SELECT 1");
            conn.close();
        }
        finally {
            FileUtils.deleteRecursive(filename, true);
        }
    }

    private static void recoverAfterOOM(long expectedFreeMemory) throws InterruptedException {
        int i = 0;
        while (i < 50) {
            if (Utils.getMemoryFree() > expectedFreeMemory) break;
            Thread.sleep(20L);
            ++i;
        }
    }

    private void testUpdateWhenNearlyOutOfMemory() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb(DB_NAME);
        ProcessBuilder processBuilder = this.buildChild("outOfMemory;MAX_OPERATION_MEMORY=1000000", MyChild.class, "-XX:+UseParallelGC", "-Xmx128m");
        processBuilder.start().waitFor();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Connection conn = this.getConnection(DB_NAME);){
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("SELECT count(*) FROM stuff");
                this.assertTrue(rs.next());
                this.assertEquals(3000, rs.getInt(1));
                rs = stat.executeQuery("SELECT * FROM stuff WHERE id = 3000");
                this.assertTrue(rs.next());
                String text = rs.getString(2);
                this.assertFalse(rs.wasNull());
                this.assertEquals(1004, text.length());
                rs = stat.executeQuery("SELECT sum(length(text)) FROM stuff");
                this.assertTrue(rs.next());
                int totalSize = rs.getInt(1);
                if (3010893 > totalSize) {
                    TestBase.logErrorMessage("Durability failure - expected: 3010893, actual: " + totalSize);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb(DB_NAME);
        }
    }

    public static final class MyChild
    extends TestDb.Child {
        public static void main(String ... args) throws Exception {
            new MyChild(args).init().test();
        }

        private MyChild(String ... args) {
            super(args);
        }

        @Override
        public void test() {
            try {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (Connection conn = this.getConnection();){
                        Statement stat = conn.createStatement();
                        stat.execute("DROP ALL OBJECTS");
                        stat.execute("CREATE TABLE stuff (id INT, text VARCHAR)");
                        stat.execute("INSERT INTO stuff(id) SELECT x FROM system_range(1, 3000)");
                        PreparedStatement prep = conn.prepareStatement("UPDATE stuff SET text = IFNULL(text,'') || space(1000) || id");
                        prep.execute();
                        stat.execute("CHECKPOINT");
                        ResultSet rs = stat.executeQuery("SELECT sum(length(text)) FROM stuff");
                        this.assertTrue(rs.next());
                        this.assertEquals(3010893, rs.getInt(1));
                        this.eatMemory(80);
                        prep.execute();
                        this.fail();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException sQLException) {
                    this.freeMemory();
                }
            }
            finally {
                this.freeMemory();
            }
        }
    }
}

