/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.h2.engine.Database;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.JdbcUtils;

public class TestPowerOff
extends TestDb {
    private static final String DB_NAME = "powerOff";
    private String dir;
    private String url;
    private int maxPowerOffCount;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.memory;
    }

    @Override
    public void test() throws SQLException {
        if (this.config.big || this.config.googleAppEngine) {
            this.dir = this.getBaseDir();
            this.url = DB_NAME;
        } else {
            this.dir = "memFS:";
            this.url = "memFS:/powerOff";
        }
        this.url = String.valueOf(this.url) + ";FILE_LOCK=NO;TRACE_LEVEL_FILE=0";
        this.testLobCrash();
        this.testSummaryCrash();
        this.testCrash();
        this.testShutdown();
        this.testMemoryTables();
        this.testPersistentTables();
        this.deleteDb(this.dir, DB_NAME);
    }

    private void testLobCrash() throws SQLException {
        if (this.config.networked) {
            return;
        }
        this.deleteDb(this.dir, DB_NAME);
        Connection conn = this.getConnection(this.url);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id identity, data clob)");
        conn.close();
        conn = this.getConnection(this.url);
        stat = conn.createStatement();
        stat.execute("set write_delay 0");
        TestPowerOff.setPowerOffCount(conn, Integer.MAX_VALUE);
        stat.execute("insert into test(data) values space(11000)");
        int max = Integer.MAX_VALUE - TestPowerOff.getPowerOffCount(conn);
        int i = 0;
        while (i < max + 10) {
            conn.close();
            conn = this.getConnection(this.url);
            stat = conn.createStatement();
            stat.execute("insert into test(data) values space(11000)");
            stat.execute("set write_delay 0");
            TestPowerOff.setPowerOffCount(conn, i);
            try {
                stat.execute("insert into test(data) values space(11000)");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            JdbcUtils.closeSilently(conn);
            ++i;
        }
    }

    private void testSummaryCrash() throws SQLException {
        if (this.config.networked) {
            return;
        }
        this.deleteDb(this.dir, DB_NAME);
        Connection conn = this.getConnection(this.url);
        Statement stat = conn.createStatement();
        int i = 0;
        while (i < 10) {
            stat.execute("CREATE TABLE TEST" + i + "(ID INT PRIMARY KEY, NAME VARCHAR)");
            int j = 0;
            while (j < 10) {
                stat.execute("INSERT INTO TEST" + i + " VALUES(" + j + ", 'Hello')");
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            stat.execute("DROP TABLE TEST" + i);
            i += 2;
        }
        stat.execute("SET WRITE_DELAY 0");
        stat.execute("CHECKPOINT");
        int j = 0;
        while (j < 10) {
            stat.execute("INSERT INTO TEST1 VALUES(" + (10 + j) + ", 'World')");
            ++j;
        }
        stat.execute("SHUTDOWN IMMEDIATELY");
        JdbcUtils.closeSilently(conn);
        conn = this.getConnection(this.url);
        stat = conn.createStatement();
        i = 1;
        while (i < 10) {
            ResultSet rs = stat.executeQuery("SELECT * FROM TEST" + i + " ORDER BY ID");
            int j2 = 0;
            while (j2 < 10) {
                rs.next();
                this.assertEquals(j2, rs.getInt(1));
                this.assertEquals("Hello", rs.getString(2));
                ++j2;
            }
            if (i == 1) {
                j2 = 0;
                while (j2 < 10) {
                    rs.next();
                    this.assertEquals(j2 + 10, rs.getInt(1));
                    this.assertEquals("World", rs.getString(2));
                    ++j2;
                }
            }
            this.assertFalse(rs.next());
            i += 2;
        }
        conn.close();
    }

    private void testCrash() throws SQLException {
        if (this.config.networked) {
            return;
        }
        this.deleteDb(this.dir, DB_NAME);
        Random random = new Random(1L);
        int repeat = this.getSize(1, 20);
        int i = 0;
        while (i < repeat) {
            block7: {
                Connection conn = this.getConnection(this.url);
                conn.close();
                conn = this.getConnection(this.url);
                Statement stat = conn.createStatement();
                stat.execute("SET WRITE_DELAY 0");
                TestPowerOff.setPowerOffCount(conn, random.nextInt(100));
                try {
                    stat.execute("DROP TABLE IF EXISTS TEST");
                    stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
                    conn.setAutoCommit(false);
                    int len = this.getSize(3, 100);
                    int j = 0;
                    while (j < len) {
                        stat.execute("INSERT INTO TEST VALUES(" + j + ", 'Hello')");
                        if (random.nextInt(5) == 0) {
                            conn.commit();
                        }
                        if (random.nextInt(10) == 0) {
                            stat.execute("DROP TABLE IF EXISTS TEST");
                            stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
                        }
                        ++j;
                    }
                    stat.execute("DROP TABLE IF EXISTS TEST");
                    conn.close();
                }
                catch (SQLException e) {
                    if (e.getSQLState().equals("90098")) break block7;
                    TestBase.logError("power", e);
                }
            }
            ++i;
        }
    }

    private void testShutdown() throws SQLException {
        this.deleteDb(this.dir, DB_NAME);
        Connection conn = this.getConnection(this.url);
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        stat.execute("SHUTDOWN");
        conn.close();
        conn = this.getConnection(this.url);
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testMemoryTables() throws SQLException {
        if (this.config.networked) {
            return;
        }
        this.deleteDb(this.dir, DB_NAME);
        Connection conn = this.getConnection(this.url);
        Statement stat = conn.createStatement();
        stat.execute("CREATE MEMORY TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        stat.execute("CHECKPOINT");
        TestPowerOff.setPowerOffCount(conn, 1);
        try {
            stat.execute("INSERT INTO TEST VALUES(2, 'Hello')");
            stat.execute("INSERT INTO TEST VALUES(3, 'Hello')");
            stat.execute("CHECKPOINT");
            this.fail();
        }
        catch (SQLException e) {
            this.assertKnownException(e);
        }
        TestPowerOff.setPowerOffCount(conn, 0);
        try {
            conn.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        conn = this.getConnection(this.url);
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT COUNT(*) FROM TEST");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        conn.close();
    }

    private void testPersistentTables() throws SQLException {
        if (this.config.networked) {
            return;
        }
        if (this.config.cipher != null) {
            return;
        }
        this.deleteDb(this.dir, DB_NAME);
        this.testRun(true);
        int max = this.maxPowerOffCount;
        this.trace("max=" + max);
        this.runTest(0, max, true);
        this.recoverAndCheckConsistency();
        this.runTest(0, max, false);
        this.recoverAndCheckConsistency();
    }

    private void runTest(int min, int max, boolean withConsistencyCheck) throws SQLException {
        int i = min;
        while (i < max) {
            this.deleteDb(this.dir, DB_NAME);
            Database.setInitialPowerOffCount(i);
            int expect = this.testRun(false);
            if (withConsistencyCheck) {
                int got = this.recoverAndCheckConsistency();
                this.trace("test " + i + " of " + max + " expect=" + expect + " got=" + got);
            } else {
                this.trace("test " + i + " of " + max + " expect=" + expect);
            }
            ++i;
        }
        Database.setInitialPowerOffCount(0);
    }

    private int testRun(boolean init) throws SQLException {
        Connection conn;
        int state;
        block4: {
            if (init) {
                Database.setInitialPowerOffCount(Integer.MAX_VALUE);
            }
            state = 0;
            conn = null;
            try {
                conn = this.getConnection(this.url);
                Statement stat = conn.createStatement();
                stat.execute("SET WRITE_DELAY 0");
                stat.execute("CREATE TABLE IF NOT EXISTS TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
                state = 1;
                conn.setAutoCommit(false);
                stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
                stat.execute("INSERT INTO TEST VALUES(2, 'World')");
                conn.commit();
                state = 2;
                stat.execute("UPDATE TEST SET NAME='Hallo' WHERE ID=1");
                stat.execute("UPDATE TEST SET NAME='Welt' WHERE ID=2");
                conn.commit();
                state = 3;
                stat.execute("DELETE FROM TEST WHERE ID=1");
                stat.execute("DELETE FROM TEST WHERE ID=2");
                conn.commit();
                state = 1;
                stat.execute("DROP TABLE TEST");
                state = 0;
                if (init) {
                    this.maxPowerOffCount = Integer.MAX_VALUE - TestPowerOff.getPowerOffCount(conn);
                }
                conn.close();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("90098")) break block4;
                throw e;
            }
        }
        JdbcUtils.closeSilently(conn);
        return state;
    }

    private int recoverAndCheckConsistency() throws SQLException {
        int state;
        Database.setInitialPowerOffCount(0);
        Connection conn = this.getConnection(this.url);
        this.assertEquals(0, TestPowerOff.getPowerOffCount(conn));
        Statement stat = conn.createStatement();
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getTables(null, null, "TEST", null);
        if (!rs.next()) {
            state = 0;
        } else {
            rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
            if (!rs.next()) {
                state = 1;
            } else {
                this.assertEquals(1, rs.getInt(1));
                String name1 = rs.getString(2);
                this.assertTrue(rs.next());
                this.assertEquals(2, rs.getInt(1));
                String name2 = rs.getString(2);
                this.assertFalse(rs.next());
                if ("Hello".equals(name1)) {
                    this.assertEquals("World", name2);
                    state = 2;
                } else {
                    this.assertEquals("Hallo", name1);
                    this.assertEquals("Welt", name2);
                    state = 3;
                }
            }
        }
        conn.close();
        return state;
    }
}

