/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.api.Trigger;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.db.TestFunctions;

public class TestRights
extends TestDb {
    private Statement stat;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.testNullPassword();
        this.testLinkedTableMeta();
        this.testGrantMore();
        this.testGrantSchema();
        this.testRevokeSchema();
        this.testOpenNonAdminWithMode();
        this.testDisallowedTables();
        this.testDropOwnUser();
        this.testGetTables();
        this.testDropTempTables();
        this.testSchemaRenameUser();
        this.testAccessRights();
        this.testSchemaAdminRole();
        this.testTableRename();
        this.testSchemaRename();
        this.testSchemaDrop();
        this.testDropTable();
        this.testSchemaOwner();
        this.deleteDb("rights");
    }

    private void testNullPassword() throws SQLException {
        this.deleteDb("rights");
        Connection conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.stat.execute("create user test password null");
        this.stat.execute("alter user test set password null");
        this.stat.execute("create user test2 salt null hash null");
        this.stat.execute("alter user test set salt null hash null");
        conn.close();
    }

    private void testLinkedTableMeta() throws SQLException {
        this.deleteDb("rights");
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection("rights;OLD_INFORMATION_SCHEMA=TRUE");){
            this.stat = conn.createStatement();
            this.stat.execute("create user test password 'test'");
            this.stat.execute("create linked table test(null, 'jdbc:h2:mem:', 'sa', 'sa', 'DUAL')");
            Connection conn2 = this.getConnection("rights", "test", this.getPassword("test"));
            Statement stat2 = conn2.createStatement();
            ResultSet rs = stat2.executeQuery("select * from information_schema.tables where table_name = 'TEST'");
            this.assertTrue(rs.next());
            ResultSetMetaData meta = rs.getMetaData();
            int i = 1;
            while (i <= meta.getColumnCount()) {
                String s = rs.getString(i);
                this.assertFalse(s != null && s.contains("'sa'"));
                ++i;
            }
            conn2.close();
            rs = this.stat.executeQuery("select * from information_schema.tables where table_name = 'TEST'");
            this.assertTrue(rs.next());
            meta = rs.getMetaData();
            boolean foundPassword = false;
            int i2 = 1;
            while (i2 <= meta.getColumnCount()) {
                String s = rs.getString(i2);
                if (s != null && s.contains("'sa'")) {
                    foundPassword = true;
                }
                ++i2;
            }
            this.assertTrue(foundPassword);
            conn2.close();
            this.stat.execute("drop table test");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testGrantMore() throws SQLException {
        this.deleteDb("rights");
        Connection conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.stat.execute("create role new_role");
        this.stat.execute("create table test(id int)");
        this.stat.execute("grant select on test to new_role");
        ResultSet rs = this.stat.executeQuery("select * from information_schema.table_privileges");
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        this.stat.execute("grant insert on test to new_role");
        rs = this.stat.executeQuery("select * from information_schema.table_privileges");
        this.assertTrue(rs.next());
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        this.stat.execute("drop table test");
        this.stat.execute("drop role new_role");
        conn.close();
    }

    private void testGrantSchema() throws SQLException {
        this.deleteDb("rights");
        Connection connAdmin = this.getConnection("rights");
        Statement statAdmin = connAdmin.createStatement();
        statAdmin.execute("create user test_user password 'test'");
        statAdmin.execute("create table test1(id int)");
        statAdmin.execute("create table test2(id int)");
        statAdmin.execute("create table test3(id int)");
        statAdmin.execute("grant insert on schema public to test_user");
        statAdmin.execute("create table test4(id int)");
        Connection conn = this.getConnection("rights", "test_user", this.getPassword("test"));
        Statement stat = conn.createStatement();
        stat.execute("insert into test1 values (1)");
        stat.execute("insert into test2 values (1)");
        stat.execute("insert into test3 values (1)");
        stat.execute("insert into test4 values (1)");
        this.assertThrows(90096, stat, "select * from test1");
        this.assertThrows(90096, stat, "select * from test2");
        this.assertThrows(90096, stat, "select * from test3");
        this.assertThrows(90096, stat, "select * from test4");
        statAdmin.execute("create role test_role");
        statAdmin.execute("grant test_role to test_user");
        statAdmin.execute("grant select on schema public to test_role");
        statAdmin.execute("create table test5(id int)");
        stat.execute("insert into test1 values (2)");
        stat.execute("insert into test2 values (2)");
        stat.execute("insert into test3 values (2)");
        stat.execute("insert into test4 values (2)");
        stat.execute("insert into test5 values (1)");
        stat.execute("select * from test1");
        stat.execute("select * from test2");
        stat.execute("select * from test3");
        stat.execute("select * from test4");
        stat.execute("select * from test5");
        conn.close();
        connAdmin.close();
        this.deleteDb("rights");
    }

    private void testRevokeSchema() throws SQLException {
        this.deleteDb("rights");
        Connection connAdmin = this.getConnection("rights");
        Statement statAdmin = connAdmin.createStatement();
        statAdmin = connAdmin.createStatement();
        statAdmin.execute("create user test_user password 'test'");
        statAdmin.execute("create table test1(id int)");
        statAdmin.execute("create table test2(id int)");
        statAdmin.execute("create table test3(id int)");
        statAdmin.execute("grant insert on schema public to test_user");
        Connection conn = this.getConnection("rights", "test_user", this.getPassword("test"));
        Statement stat = conn.createStatement();
        stat.execute("insert into test1 values (1)");
        stat.execute("insert into test2 values (1)");
        stat.execute("insert into test3 values (1)");
        statAdmin.execute("revoke insert on schema public from test_user");
        statAdmin.execute("create table test4(id int)");
        this.assertThrows(90096, stat, "insert into test1 values (2)");
        this.assertThrows(90096, stat, "insert into test2 values (2)");
        this.assertThrows(90096, stat, "insert into test3 values (2)");
        this.assertThrows(90096, stat, "insert into test4 values (2)");
        statAdmin.execute("create role test_role");
        statAdmin.execute("grant test_role to test_user");
        statAdmin.execute("grant select on schema public to test_role");
        stat.execute("select * from test1");
        stat.execute("select * from test2");
        stat.execute("select * from test3");
        stat.execute("select * from test4");
        statAdmin.execute("revoke select on schema public from test_role");
        statAdmin.execute("create table test5(id int)");
        this.assertThrows(90096, stat, "select * from test1");
        this.assertThrows(90096, stat, "select * from test2");
        this.assertThrows(90096, stat, "select * from test3");
        this.assertThrows(90096, stat, "select * from test4");
        this.assertThrows(90096, stat, "select * from test5");
        conn.close();
        connAdmin.close();
        this.deleteDb("rights");
    }

    private void testOpenNonAdminWithMode() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("rights");
        Connection conn = this.getConnection("rights;MODE=MYSQL");
        this.stat = conn.createStatement();
        this.stat.execute("create user test password 'test'");
        Connection conn2 = this.getConnection("rights;MODE=MYSQL", "test", this.getPassword("test"));
        conn2.close();
        conn.close();
        if (this.config.memory) {
            return;
        }
        conn2 = this.getConnection("rights;MODE=MYSQL", "test", this.getPassword("test"));
        conn2.close();
        conn = this.getConnection("rights;MODE=MYSQL");
        conn2 = this.getConnection("rights;MODE=MYSQL", "test", this.getPassword("test"));
        conn2.close();
        this.stat = conn.createStatement();
        this.stat.execute("drop user test");
        conn.close();
    }

    private void testDisallowedTables() throws SQLException {
        this.deleteDb("rights");
        Connection conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.stat.execute("CREATE USER IF NOT EXISTS TEST PASSWORD 'TEST'");
        this.stat.execute("CREATE ROLE TEST_ROLE");
        this.stat.execute("CREATE TABLE ADMIN_ONLY(ID INT)");
        this.stat.execute("CREATE TABLE TEST(ID INT)");
        this.stat.execute("GRANT ALL ON TEST TO TEST");
        Connection conn2 = this.getConnection("rights", "TEST", this.getPassword("TEST"));
        Statement stat2 = conn2.createStatement();
        String sql = "select * from admin_only where 1=0";
        this.stat.execute(sql);
        this.assertThrows(90096, stat2).execute(sql);
        DatabaseMetaData meta = conn2.getMetaData();
        ResultSet rs = meta.getTables(null, "PUBLIC", "%", new String[]{"TABLE", "VIEW", "SEQUENCE"});
        this.assertTrue(rs.next());
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        String[] stringArray = new String[]{"information_schema.settings where setting_name='property.java.runtime.version'", "information_schema.users where user_name='SA'", "information_schema.roles", "information_schema.rights", "information_schema.sessions where user_name='SA'"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            rs = stat2.executeQuery("select * from " + s);
            this.assertFalse(rs.next());
            rs = this.stat.executeQuery("select * from " + s);
            this.assertTrue(rs.next());
            ++n2;
        }
        conn2.close();
        conn.close();
    }

    private void testDropOwnUser() throws SQLException {
        this.deleteDb("rights");
        String user = this.getUser().toUpperCase();
        Connection conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.assertThrows(90019, this.stat).execute("DROP USER " + user);
        this.stat.execute("CREATE USER TEST PASSWORD 'TEST' ADMIN");
        this.stat.execute("DROP USER " + user);
        conn.close();
        if (!this.config.memory) {
            this.assertThrows(28000, () -> this.getConnection("rights"));
        }
    }

    private void testGetTables() throws SQLException {
        this.deleteDb("rights");
        Connection conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.stat.execute("CREATE USER IF NOT EXISTS TEST PASSWORD 'TEST'");
        this.stat.execute("CREATE TABLE TEST(ID INT)");
        this.stat.execute("GRANT ALL ON TABLE TEST TO TEST");
        Connection conn2 = this.getConnection("rights", "TEST", this.getPassword("TEST"));
        DatabaseMetaData meta = conn2.getMetaData();
        meta.getTables(null, null, "%", new String[]{"TABLE", "VIEW", "SEQUENCE"});
        conn2.close();
        conn.close();
    }

    private void testDropTempTables() throws SQLException {
        this.deleteDb("rights");
        Connection conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.stat.execute("CREATE USER IF NOT EXISTS READER PASSWORD 'READER'");
        this.stat.execute("CREATE TABLE TEST(ID INT)");
        Connection conn2 = this.getConnection("rights", "READER", this.getPassword("READER"));
        Statement stat2 = conn2.createStatement();
        this.assertThrows(90096, stat2).execute("SELECT * FROM TEST");
        stat2.execute("CREATE LOCAL TEMPORARY TABLE IF NOT EXISTS MY_TEST(ID INT)");
        stat2.execute("INSERT INTO MY_TEST VALUES(1)");
        stat2.execute("SELECT * FROM MY_TEST");
        stat2.execute("DROP TABLE MY_TEST");
        conn2.close();
        conn.close();
    }

    private void testSchemaRenameUser() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("rights");
        Connection conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.stat.execute("create user test password ''");
        this.stat.execute("create schema b authorization test");
        this.stat.execute("create table b.test(id int)");
        this.stat.execute("alter user test rename to test1");
        conn.close();
        conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.stat.execute("select * from b.test");
        this.assertThrows(90107, this.stat).execute("drop user test1");
        this.stat.execute("drop schema b cascade");
        this.stat.execute("drop user test1");
        conn.close();
    }

    private void testSchemaAdminRole() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("rights");
        Connection conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.testTableType(conn, "MEMORY");
        this.testTableType(conn, "CACHED");
        this.executeSuccess("CREATE USER SCHEMA_CREATOR PASSWORD 'xyz'");
        this.executeSuccess("CREATE SCHEMA SCHEMA_RIGHT_TEST");
        this.executeSuccess("ALTER SCHEMA SCHEMA_RIGHT_TEST RENAME TO SCHEMA_RIGHT_TEST_RENAMED");
        this.executeSuccess("DROP SCHEMA SCHEMA_RIGHT_TEST_RENAMED");
        this.executeSuccess("CREATE SCHEMA SCHEMA_RIGHT_TEST_EXISTS");
        this.executeSuccess("CREATE TABLE SCHEMA_RIGHT_TEST_EXISTS.TEST_EXISTS(ID INT PRIMARY KEY, NAME VARCHAR)");
        conn.close();
        String url = "rights";
        conn = this.getConnection(url, "SCHEMA_CREATOR", this.getPassword("xyz"));
        this.stat = conn.createStatement();
        this.assertThrows(90040, this.stat).execute("CREATE SCHEMA SCHEMA_RIGHT_TEST_WILL_FAIL");
        this.assertThrows(90040, this.stat).execute("ALTER SCHEMA SCHEMA_RIGHT_TEST_EXISTS RENAME TO SCHEMA_RIGHT_TEST_WILL_FAIL");
        this.assertThrows(90096, this.stat).execute("DROP SCHEMA SCHEMA_RIGHT_TEST_EXISTS");
        conn.close();
        conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.executeSuccess("GRANT ALTER ANY SCHEMA TO SCHEMA_CREATOR");
        conn.close();
        conn = this.getConnection(url, "SCHEMA_CREATOR", this.getPassword("xyz"));
        this.stat = conn.createStatement();
        this.executeSuccess("CREATE SCHEMA SCHEMA_RIGHT_TEST");
        this.executeSuccess("ALTER SCHEMA SCHEMA_RIGHT_TEST RENAME TO S");
        this.executeSuccess("CREATE TABLE S.TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        this.executeSuccess("ALTER TABLE S.TEST ADD COLUMN QUESTION VARCHAR");
        this.executeSuccess("INSERT INTO  S.TEST (ID, NAME) VALUES (42, 'Adams')");
        this.executeSuccess("UPDATE S.TEST Set NAME = 'Douglas'");
        this.executeSuccess("DELETE FROM S.TEST");
        this.executeSuccess("DROP SCHEMA S CASCADE");
        this.executeSuccess("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        this.executeSuccess("ALTER TABLE TEST ADD COLUMN QUESTION VARCHAR");
        this.executeSuccess("INSERT INTO  TEST (ID, NAME) VALUES (42, 'Adams')");
        this.executeSuccess("UPDATE TEST Set NAME = 'Douglas'");
        this.executeSuccess("DELETE FROM TEST");
        conn.close();
        conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.executeSuccess("REVOKE ALTER ANY SCHEMA FROM SCHEMA_CREATOR");
        conn.close();
        conn = this.getConnection(url, "SCHEMA_CREATOR", this.getPassword("xyz"));
        this.stat = conn.createStatement();
        this.assertThrows(90040, this.stat).execute("CREATE SCHEMA SCHEMA_RIGHT_TEST");
        this.assertThrows(90040, this.stat).execute("ALTER SCHEMA SCHEMA_RIGHT_TEST_EXISTS RENAME TO SCHEMA_RIGHT_TEST_RENAMED");
        this.assertThrows(90096, this.stat).execute("DROP SCHEMA SCHEMA_RIGHT_TEST_EXISTS");
        this.assertThrows(90096, this.stat).execute("CREATE TABLE SCHEMA_RIGHT_TEST_EXISTS.TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        this.assertThrows(90096, this.stat).execute("INSERT INTO  SCHEMA_RIGHT_TEST_EXISTS.TEST_EXISTS (ID, NAME) VALUES (42, 'Adams')");
        this.assertThrows(90096, this.stat).execute("UPDATE SCHEMA_RIGHT_TEST_EXISTS.TEST_EXISTS Set NAME = 'Douglas'");
        this.assertThrows(90096, this.stat).execute("DELETE FROM SCHEMA_RIGHT_TEST_EXISTS.TEST_EXISTS");
        conn.close();
    }

    private void testTableRename() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("rights");
        Connection conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.stat.execute("create user test password '' admin");
        this.stat.execute("create schema b");
        this.stat.execute("create table b.t1(id int)");
        this.stat.execute("grant select on b.t1 to test");
        this.stat.execute("alter table b.t1 rename to b.t2");
        conn.close();
        conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.stat.execute("drop user test");
        conn.close();
    }

    private void testSchemaRename() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("rights");
        Connection conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.stat.execute("create user test password '' admin");
        this.stat.execute("create schema b");
        this.stat.execute("grant select on schema b to test");
        this.stat.execute("alter schema b rename to c");
        conn.close();
        conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.stat.execute("drop user test");
        conn.close();
    }

    private void testSchemaDrop() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("rights");
        Connection conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.stat.execute("create user test password '' admin");
        this.stat.execute("create schema b");
        this.stat.execute("grant select on schema b to test");
        this.stat.execute("drop schema b cascade");
        conn.close();
        conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.stat.execute("drop user test");
        conn.close();
    }

    private void testAccessRights() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("rights");
        Connection conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.testTableType(conn, "MEMORY");
        this.testTableType(conn, "CACHED");
        this.executeSuccess("CREATE USER PASS_READER PASSWORD 'abc'");
        this.executeSuccess("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        this.executeSuccess("CREATE TABLE PASS(ID INT PRIMARY KEY, NAME VARCHAR, PASSWORD VARCHAR)");
        this.executeSuccess("CREATE VIEW PASS_NAME AS SELECT ID, NAME FROM PASS");
        this.executeSuccess("GRANT SELECT ON PASS_NAME TO PASS_READER");
        this.executeSuccess("GRANT SELECT, INSERT, UPDATE ON TEST TO PASS_READER");
        conn.close();
        String url = "rights";
        conn = this.getConnection(url, "PASS_READER", this.getPassword("abc"));
        this.stat = conn.createStatement();
        this.executeSuccess("SELECT * FROM PASS_NAME");
        this.executeSuccess("SELECT * FROM (SELECT * FROM PASS_NAME)");
        this.executeSuccess("SELECT (SELECT NAME FROM PASS_NAME) P FROM PASS_NAME");
        this.executeError("SELECT (SELECT PASSWORD FROM PASS) P FROM PASS_NAME");
        this.executeError("SELECT * FROM PASS");
        this.executeError("INSERT INTO TEST SELECT 1, PASSWORD FROM PASS");
        this.executeError("INSERT INTO TEST VALUES(SELECT PASSWORD FROM PASS)");
        this.executeError("UPDATE TEST SET NAME=(SELECT PASSWORD FROM PASS)");
        this.executeError("DELETE FROM TEST WHERE NAME=(SELECT PASSWORD FROM PASS)");
        this.executeError("SELECT * FROM (SELECT * FROM PASS)");
        this.assertThrows(42102, this.stat).execute("CREATE VIEW X AS SELECT * FROM PASS_READER");
        this.assertThrows(90096, this.stat).execute("CREATE VIEW X AS SELECT * FROM PASS_NAME");
        conn.close();
        conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.executeSuccess("DROP TABLE TEST");
        this.executeSuccess("CREATE USER TEST PASSWORD 'abc'");
        this.executeSuccess("ALTER USER TEST ADMIN TRUE");
        this.executeSuccess("CREATE TABLE TEST(ID INT)");
        this.executeSuccess("CREATE SCHEMA SCHEMA_A AUTHORIZATION SA");
        this.executeSuccess("CREATE TABLE SCHEMA_A.TABLE_B(ID INT)");
        this.executeSuccess("GRANT ALL ON SCHEMA_A.TABLE_B TO TEST");
        this.executeSuccess("CREATE TABLE HIDDEN(ID INT)");
        this.executeSuccess("CREATE TABLE PUB_TABLE(ID INT)");
        this.executeSuccess("CREATE TABLE ROLE_TABLE(ID INT)");
        this.executeSuccess("CREATE ROLE TEST_ROLE");
        this.executeSuccess("GRANT SELECT ON ROLE_TABLE TO TEST_ROLE");
        this.executeSuccess("GRANT UPDATE ON ROLE_TABLE TO TEST_ROLE");
        this.executeSuccess("REVOKE UPDATE ON ROLE_TABLE FROM TEST_ROLE");
        this.assertThrows(90072, this.stat).execute("REVOKE SELECT, SUB1 ON ROLE_TABLE FROM TEST_ROLE");
        this.executeSuccess("GRANT TEST_ROLE TO TEST");
        this.executeSuccess("GRANT SELECT ON PUB_TABLE TO PUBLIC");
        this.executeSuccess("GRANT SELECT ON TEST TO TEST");
        this.executeSuccess("CREATE ROLE SUB1");
        this.executeSuccess("CREATE ROLE SUB2");
        this.executeSuccess("CREATE TABLE SUB_TABLE(ID INT)");
        this.executeSuccess("GRANT ALL ON SUB_TABLE TO SUB2");
        this.executeSuccess("REVOKE UPDATE, DELETE ON SUB_TABLE FROM SUB2");
        this.executeSuccess("GRANT SUB2 TO SUB1");
        this.executeSuccess("GRANT SUB1 TO TEST");
        this.executeSuccess("ALTER USER TEST SET PASSWORD 'def'");
        this.executeSuccess("CREATE USER TEST2 PASSWORD 'def' ADMIN");
        this.executeSuccess("ALTER USER TEST ADMIN FALSE");
        this.executeSuccess("SCRIPT TO '" + this.getBaseDir() + "/rights.sql' CIPHER AES PASSWORD 'test'");
        conn.close();
        try {
            this.getConnection("rights", "Test", this.getPassword("abc"));
            this.fail("mixed case user name");
        }
        catch (SQLException e) {
            this.assertKnownException(e);
        }
        try {
            this.getConnection("rights", "TEST", this.getPassword("abc"));
            this.fail("wrong password");
        }
        catch (SQLException e) {
            this.assertKnownException(e);
        }
        try {
            this.getConnection("rights", "TEST", this.getPassword(""));
            this.fail("wrong password");
        }
        catch (SQLException e) {
            this.assertKnownException(e);
        }
        conn = this.getConnection(url, "TEST", this.getPassword("def"));
        this.stat = conn.createStatement();
        this.assertThrows(90040, this.stat).execute("SET DEFAULT_TABLE_TYPE MEMORY");
        this.executeSuccess("SELECT * FROM TEST");
        this.executeSuccess("SELECT * FROM SYSTEM_RANGE(1,2)");
        this.executeSuccess("SELECT * FROM SCHEMA_A.TABLE_B");
        this.executeSuccess("SELECT * FROM PUB_TABLE");
        this.executeSuccess("SELECT * FROM ROLE_TABLE");
        this.executeError("UPDATE ROLE_TABLE SET ID=0");
        this.executeError("DELETE FROM ROLE_TABLE");
        this.executeError("SELECT * FROM HIDDEN");
        this.executeError("UPDATE TEST SET ID=0");
        this.executeError("CALL SELECT MIN(PASSWORD) FROM PASS");
        this.executeSuccess("SELECT * FROM SUB_TABLE");
        this.executeSuccess("INSERT INTO SUB_TABLE VALUES(1)");
        this.executeError("DELETE FROM SUB_TABLE");
        this.executeError("UPDATE SUB_TABLE SET ID=0");
        this.assertThrows(90040, this.stat).execute("CREATE USER TEST3 PASSWORD 'def'");
        this.assertThrows(90040, this.stat).execute("ALTER USER TEST2 ADMIN FALSE");
        this.assertThrows(90040, this.stat).execute("ALTER USER TEST2 SET PASSWORD 'ghi'");
        this.assertThrows(90040, this.stat).execute("ALTER USER TEST2 RENAME TO TEST_X");
        this.assertThrows(90040, this.stat).execute("ALTER USER TEST RENAME TO TEST_X");
        this.executeSuccess("ALTER USER TEST SET PASSWORD 'ghi'");
        this.assertThrows(90040, this.stat).execute("DROP USER TEST2");
        conn.close();
        conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.executeSuccess("DROP ROLE SUB1");
        this.executeSuccess("DROP TABLE ROLE_TABLE");
        this.executeSuccess("DROP USER TEST");
        conn.close();
        conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.executeSuccess("DROP TABLE IF EXISTS TEST");
        this.executeSuccess("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        this.executeSuccess("CREATE USER GUEST PASSWORD 'abc'");
        this.executeSuccess("GRANT SELECT ON TEST TO GUEST");
        this.executeSuccess("ALTER USER GUEST RENAME TO GAST");
        conn.close();
        conn = this.getConnection("rights");
        conn.close();
        FileUtils.delete(this.getBaseDir() + "/rights.sql");
    }

    private void testTableType(Connection conn, String type) throws SQLException {
        this.executeSuccess("SET DEFAULT_TABLE_TYPE " + type);
        this.executeSuccess("CREATE TABLE TEST(ID INT)");
        ResultSet rs = conn.createStatement().executeQuery("SELECT STORAGE_TYPE FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='TEST'");
        rs.next();
        this.assertEquals(type, rs.getString(1));
        this.executeSuccess("DROP TABLE TEST");
    }

    private void testDropTable() throws SQLException {
        this.deleteDb("rights");
        Connection conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.stat.execute("CREATE TABLE TEST(ID INT)");
        this.stat.execute("CREATE USER U PASSWORD '1'");
        this.stat.execute("GRANT ALL PRIVILEGES ON TEST TO U");
        Connection conn2 = this.getConnection("rights", "U", this.getPassword("1"));
        conn.close();
        this.stat = conn2.createStatement();
        this.assertEquals(1, this.stat.executeUpdate("INSERT INTO TEST VALUES 1"));
        this.assertEquals(1, this.stat.executeUpdate("UPDATE TEST SET ID = 2 WHERE ID = 1"));
        this.assertEquals(1, this.stat.executeUpdate("DELETE FROM TEST WHERE ID = 2"));
        this.executeError("DROP TABLE TEST");
        conn2.close();
    }

    private void testSchemaOwner() throws SQLException {
        this.deleteDb("rights");
        Connection connAdmin = this.getConnection("rights");
        Statement statAdmin = connAdmin.createStatement();
        statAdmin.execute("CREATE USER SCHEMA_ADMIN PASSWORD '1'");
        statAdmin.execute("GRANT ALTER ANY SCHEMA TO SCHEMA_ADMIN");
        Connection connSchemaAdmin = this.getConnection("rights", "SCHEMA_ADMIN", this.getPassword("1"));
        Statement statSchemaAdmin = connSchemaAdmin.createStatement();
        statAdmin.execute("CREATE USER SCHEMA_OWNER PASSWORD '1'");
        Connection connSchemaOwner = this.getConnection("rights", "SCHEMA_OWNER", this.getPassword("1"));
        Statement statSchemaOwner = connSchemaOwner.createStatement();
        statAdmin.execute("CREATE USER OTHER PASSWORD '1'");
        Connection connOther = this.getConnection("rights", "OTHER", this.getPassword("1"));
        Statement statOther = connOther.createStatement();
        this.testSchemaOwner(statAdmin, statSchemaAdmin, statSchemaOwner, statOther, "SCHEMA_OWNER");
        statAdmin.execute("CREATE ROLE SCHEMA_OWNER_ROLE");
        statAdmin.execute("GRANT SCHEMA_OWNER_ROLE TO SCHEMA_OWNER");
        this.testSchemaOwner(statAdmin, statSchemaAdmin, statSchemaOwner, statOther, "SCHEMA_OWNER_ROLE");
        this.testAdminAndSchemaOwner(statAdmin, statSchemaAdmin);
        statAdmin.close();
        statSchemaAdmin.close();
        statSchemaOwner.close();
    }

    private void testSchemaOwner(Statement statAdmin, Statement statSchemaAdmin, Statement statSchemaOwner, Statement statOther, String authorization) throws SQLException {
        this.executeSuccessErrorAdmin(statSchemaAdmin, statSchemaOwner, "CREATE SCHEMA S AUTHORIZATION " + authorization);
        this.executeSuccessError(statSchemaOwner, statOther, "CREATE DOMAIN S.D INT");
        this.executeSuccessError(statSchemaOwner, statOther, "ALTER DOMAIN S.D ADD CONSTRAINT S.D_C CHECK (VALUE > 0)");
        this.executeSuccessError(statSchemaOwner, statOther, "ALTER DOMAIN S.D DROP CONSTRAINT S.D_C");
        this.executeSuccessError(statSchemaOwner, statOther, "ALTER DOMAIN S.D RENAME TO S.D2");
        this.executeSuccessError(statSchemaOwner, statOther, "DROP DOMAIN S.D2");
        this.executeSuccessError(statSchemaOwner, statOther, "CREATE CONSTANT S.C VALUE 1");
        this.executeSuccessError(statSchemaOwner, statOther, "DROP CONSTANT S.C");
        this.executeSuccessErrorAdmin(statAdmin, statSchemaAdmin, "CREATE ALIAS S.F FOR 'java.lang.Math.max(long,long)'");
        this.executeSuccessError(statSchemaOwner, statOther, "DROP ALIAS S.F");
        this.executeSuccessErrorAdmin(statAdmin, statSchemaAdmin, "CREATE AGGREGATE S.A FOR '" + TestFunctions.MedianStringType.class.getName() + "'");
        this.executeSuccessError(statSchemaOwner, statOther, "DROP AGGREGATE S.A");
        this.executeSuccessError(statSchemaOwner, statOther, "CREATE SEQUENCE S.S");
        this.executeSuccessError(statSchemaOwner, statOther, "ALTER SEQUENCE S.S RESTART WITH 2");
        this.executeSuccessError(statSchemaOwner, statOther, "DROP SEQUENCE S.S");
        this.executeSuccessError(statSchemaOwner, statOther, "CREATE VIEW S.V AS SELECT 1");
        this.executeSuccessError(statSchemaOwner, statOther, "ALTER VIEW S.V RECOMPILE");
        this.executeSuccessError(statSchemaOwner, statOther, "ALTER VIEW S.V RENAME TO S.V2");
        this.executeSuccessError(statSchemaOwner, statOther, "DROP VIEW S.V2");
        this.executeSuccessError(statSchemaOwner, statOther, "CREATE TABLE S.T(ID INT)");
        this.executeSuccessError(statSchemaOwner, statOther, "ALTER TABLE S.T ADD V INT");
        this.executeSuccessError(statSchemaOwner, statOther, "ALTER TABLE S.T ADD CONSTRAINT S.T_C UNIQUE(V)");
        this.executeSuccessError(statSchemaOwner, statOther, "ALTER TABLE S.T DROP CONSTRAINT S.T_C");
        this.executeSuccessError(statSchemaOwner, statOther, "CREATE UNIQUE INDEX S.I ON S.T(V)");
        this.executeSuccessError(statSchemaOwner, statOther, "ALTER INDEX S.I RENAME TO S.I2");
        this.executeSuccessError(statSchemaOwner, statOther, "DROP INDEX S.I2");
        this.executeSuccessErrorAdmin(statAdmin, statSchemaAdmin, "CREATE TRIGGER S.G BEFORE INSERT ON S.T FOR EACH ROW CALL '" + TestTrigger.class.getName() + "'");
        this.executeSuccessError(statSchemaOwner, statOther, "DROP TRIGGER S.G");
        this.executeSuccessError(statSchemaOwner, statOther, "GRANT SELECT ON S.T TO OTHER");
        this.executeSuccessError(statSchemaOwner, statOther, "REVOKE SELECT ON S.T FROM OTHER");
        this.executeSuccessError(statSchemaOwner, statOther, "ALTER TABLE S.T RENAME TO S.T2");
        this.executeSuccessError(statSchemaOwner, statOther, "DROP TABLE S.T2");
        this.executeSuccessError(statSchemaOwner, statOther, "DROP SCHEMA S");
    }

    private void testAdminAndSchemaOwner(Statement statAdmin, Statement statSchemaAdmin) throws SQLException {
        this.executeSuccessErrorAdmin(statAdmin, statSchemaAdmin, "GRANT ALTER ANY SCHEMA TO OTHER");
        this.executeSuccessErrorAdmin(statAdmin, statSchemaAdmin, "REVOKE ALTER ANY SCHEMA FROM OTHER");
        this.executeSuccessErrorAdmin(statAdmin, statSchemaAdmin, "CREATE USER U PASSWORD '1'");
        this.executeSuccessErrorAdmin(statAdmin, statSchemaAdmin, "CREATE ROLE R");
        this.executeSuccessErrorAdmin(statAdmin, statSchemaAdmin, "GRANT R TO U");
        this.executeSuccessErrorAdmin(statAdmin, statSchemaAdmin, "REVOKE R FROM U");
        this.executeSuccessErrorAdmin(statAdmin, statSchemaAdmin, "DROP USER U");
        this.executeSuccessErrorAdmin(statAdmin, statSchemaAdmin, "DROP ROLE R");
    }

    private void executeSuccessErrorAdmin(Statement success, Statement error, String sql) throws SQLException {
        this.assertThrows(90040, error).execute(sql);
        success.execute(sql);
    }

    private void executeSuccessError(Statement success, Statement error, String sql) throws SQLException {
        this.assertThrows(90096, error).execute(sql);
        success.execute(sql);
    }

    private void executeError(String sql) throws SQLException {
        this.assertThrows(90096, this.stat).execute(sql);
    }

    private void executeSuccess(String sql) throws SQLException {
        if (this.stat.execute(sql)) {
            ResultSet rs = this.stat.getResultSet();
            rs.getConcurrency();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                meta.getCatalogName(i + 1);
                meta.getColumnClassName(i + 1);
                meta.getColumnDisplaySize(i + 1);
                meta.getColumnLabel(i + 1);
                meta.getColumnName(i + 1);
                meta.getColumnType(i + 1);
                meta.getColumnTypeName(i + 1);
                meta.getPrecision(i + 1);
                meta.getScale(i + 1);
                meta.getSchemaName(i + 1);
                meta.getTableName(i + 1);
                ++i;
            }
            while (rs.next()) {
                i = 0;
                while (i < columnCount) {
                    rs.getObject(i + 1);
                    ++i;
                }
            }
        }
    }

    public static class TestTrigger
    implements Trigger {
        @Override
        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
        }
    }
}

