/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import org.h2.api.Trigger;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestAll;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.ChangeFileEncryption;
import org.h2.tools.Recover;
import org.h2.util.Task;

public class TestRunscript
extends TestDb
implements Trigger {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
        TestAll config = new TestAll();
        config.traceLevelFile = 1;
        System.out.println(config);
        TestBase test = TestRunscript.createCaller();
        test.runTest(config);
    }

    @Override
    public void test() throws Exception {
        this.test(false);
        this.test(true);
        this.testDropReferencedUserDefinedFunction();
        this.testDropCascade();
        this.testScriptExcludeSchema();
        this.testScriptExcludeTable();
        this.testScriptExcludeFunctionAlias();
        this.testScriptExcludeConstant();
        this.testScriptExcludeSequence();
        this.testScriptExcludeConstraint();
        this.testScriptExcludeTrigger();
        this.testScriptExcludeRight();
        this.testRunscriptFromClasspath();
        this.testCancelScript();
        this.testEncoding();
        this.testClobPrimaryKey();
        this.testTruncateLargeLength();
        this.testVariableBinary();
        this.deleteDb("runscript");
    }

    private void testDropReferencedUserDefinedFunction() throws Exception {
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        stat.execute("create alias int_decode for 'java.lang.Integer.decode'");
        stat.execute("create table test(x varchar, y int as int_decode(x))");
        stat.execute("script simple drop to '" + this.getBaseDir() + "/backup.sql'");
        stat.execute("runscript from '" + this.getBaseDir() + "/backup.sql'");
        conn.close();
    }

    private void testDropCascade() throws Exception {
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        stat.execute("create table b(x int)");
        stat.execute("create view a as select * from b");
        stat.execute("script simple drop to '" + this.getBaseDir() + "/backup.sql'");
        stat.execute("runscript from '" + this.getBaseDir() + "/backup.sql'");
        conn.close();
    }

    private void testScriptExcludeSchema() throws Exception {
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        stat.execute("create schema include_schema1");
        stat.execute("create schema exclude_schema1");
        stat.execute("script schema include_schema1");
        ResultSet rs = stat.getResultSet();
        while (rs.next()) {
            this.assertFalse("The schema 'exclude_schema1' should not be present in the script", rs.getString(1).contains("exclude_schema1".toUpperCase()));
        }
        rs.close();
        stat.execute("create schema include_schema2");
        stat.execute("script nosettings schema include_schema1, include_schema2");
        rs = stat.getResultSet();
        this.assertResultRowCount(4, rs);
        rs.close();
        conn.close();
    }

    private void testScriptExcludeTable() throws Exception {
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        stat.execute("create schema a");
        stat.execute("create schema b");
        stat.execute("create schema c");
        stat.execute("create table a.test1(x varchar, y int)");
        stat.execute("create table a.test2(x varchar, y int)");
        stat.execute("create table b.test1(x varchar, y int)");
        stat.execute("create table b.test2(x varchar, y int)");
        stat.execute("script table a.test1");
        ResultSet rs = stat.getResultSet();
        while (rs.next()) {
            this.assertFalse("The table 'a.test2' should not be present in the script", rs.getString(1).contains("a.test2".toUpperCase()));
            this.assertFalse("The table 'b.test1' should not be present in the script", rs.getString(1).contains("b.test1".toUpperCase()));
            this.assertFalse("The table 'b.test2' should not be present in the script", rs.getString(1).contains("b.test2".toUpperCase()));
        }
        rs.close();
        stat.execute("set schema b");
        stat.execute("script table test1");
        rs = stat.getResultSet();
        while (rs.next()) {
            this.assertFalse("The table 'a.test1' should not be present in the script", rs.getString(1).contains("a.test1".toUpperCase()));
            this.assertFalse("The table 'a.test2' should not be present in the script", rs.getString(1).contains("a.test2".toUpperCase()));
            this.assertFalse("The table 'b.test2' should not be present in the script", rs.getString(1).contains("b.test2".toUpperCase()));
        }
        stat.execute("script nosettings table a.test1, test2");
        rs = stat.getResultSet();
        this.assertResultRowCount(8, rs);
        rs.close();
        conn.close();
    }

    private void testScriptExcludeFunctionAlias() throws Exception {
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        stat.execute("create schema a");
        stat.execute("create schema b");
        stat.execute("create schema c");
        stat.execute("create alias a.int_decode for 'java.lang.Integer.decode'");
        stat.execute("create table a.test(x varchar, y int as a.int_decode(x))");
        stat.execute("script schema b");
        ResultSet rs = stat.getResultSet();
        while (rs.next()) {
            this.assertFalse("The function alias 'int_decode' should not be present in the script", rs.getString(1).contains("int_decode".toUpperCase()));
        }
        rs.close();
        conn.close();
    }

    private void testScriptExcludeConstant() throws Exception {
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        stat.execute("create schema a");
        stat.execute("create schema b");
        stat.execute("create schema c");
        stat.execute("create constant a.default_email value 'no@thanks.org'");
        stat.execute("create table a.test1(x varchar, email varchar default a.default_email)");
        stat.execute("script schema b");
        ResultSet rs = stat.getResultSet();
        while (rs.next()) {
            this.assertFalse("The constant 'default_email' should not be present in the script", rs.getString(1).contains("default_email".toUpperCase()));
        }
        rs.close();
        conn.close();
    }

    private void testScriptExcludeSequence() throws Exception {
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        stat.execute("create schema a");
        stat.execute("create schema b");
        stat.execute("create schema c");
        stat.execute("create sequence a.seq_id");
        stat.execute("script schema b");
        ResultSet rs = stat.getResultSet();
        while (rs.next()) {
            this.assertFalse("The sequence 'seq_id' should not be present in the script", rs.getString(1).contains("seq_id".toUpperCase()));
        }
        rs.close();
        conn.close();
    }

    private void testScriptExcludeConstraint() throws Exception {
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        stat.execute("create schema a");
        stat.execute("create schema b");
        stat.execute("create schema c");
        stat.execute("create table a.test1(x varchar, y int)");
        stat.execute("alter table a.test1 add constraint unique_constraint unique (x, y) ");
        stat.execute("script schema b");
        ResultSet rs = stat.getResultSet();
        while (rs.next()) {
            this.assertFalse("The sequence 'unique_constraint' should not be present in the script", rs.getString(1).contains("unique_constraint".toUpperCase()));
        }
        rs.close();
        stat.execute("create table a.test2(x varchar, y int)");
        stat.execute("script table a.test2");
        rs = stat.getResultSet();
        while (rs.next()) {
            this.assertFalse("The sequence 'unique_constraint' should not be present in the script", rs.getString(1).contains("unique_constraint".toUpperCase()));
        }
        rs.close();
        conn.close();
    }

    private void testScriptExcludeTrigger() throws Exception {
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        stat.execute("create schema a");
        stat.execute("create schema b");
        stat.execute("create schema c");
        stat.execute("create table a.test1(x varchar, y int)");
        stat.execute("create trigger trigger_insert before insert on a.test1 for each row call \"org.h2.test.db.TestRunscript\"");
        stat.execute("script schema b");
        ResultSet rs = stat.getResultSet();
        while (rs.next()) {
            this.assertFalse("The trigger 'trigger_insert' should not be present in the script", rs.getString(1).contains("trigger_insert".toUpperCase()));
        }
        rs.close();
        stat.execute("create table a.test2(x varchar, y int)");
        stat.execute("script table a.test2");
        rs = stat.getResultSet();
        while (rs.next()) {
            this.assertFalse("The trigger 'trigger_insert' should not be present in the script", rs.getString(1).contains("trigger_insert".toUpperCase()));
        }
        rs.close();
        conn.close();
    }

    private void testScriptExcludeRight() throws Exception {
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        stat.execute("create user USER_A1 password 'test'");
        stat.execute("create user USER_B1 password 'test'");
        stat.execute("create schema a");
        stat.execute("create schema b");
        stat.execute("create schema c");
        stat.execute("create table a.test1(x varchar, y int)");
        stat.execute("create table b.test1(x varchar, y int)");
        stat.execute("grant select on a.test1 to USER_A1");
        stat.execute("grant select on b.test1 to USER_B1");
        stat.execute("script schema b");
        ResultSet rs = stat.getResultSet();
        while (rs.next()) {
            this.assertFalse("The grant to 'USER_A1' should not be present in the script", rs.getString(1).contains("to USER_A1".toUpperCase()));
        }
        rs.close();
        stat.execute("create user USER_A2 password 'test'");
        stat.execute("create table a.test2(x varchar, y int)");
        stat.execute("grant select on a.test2 to USER_A2");
        stat.execute("script table a.test2");
        rs = stat.getResultSet();
        while (rs.next()) {
            this.assertFalse("The grant to 'USER_A1' should not be present in the script", rs.getString(1).contains("to USER_A1".toUpperCase()));
            this.assertFalse("The grant to 'USER_B1' should not be present in the script", rs.getString(1).contains("to USER_B1".toUpperCase()));
        }
        rs.close();
        conn.close();
    }

    private void testRunscriptFromClasspath() throws Exception {
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        stat.execute("runscript from 'classpath:/org/h2/samples/newsfeed.sql'");
        stat.execute("select * from version");
        conn.close();
    }

    private void testCancelScript() throws Exception {
        if (this.config.ci) {
            return;
        }
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        final Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key) as select x from system_range(1, 20000)");
        stat.execute("script simple drop to '" + this.getBaseDir() + "/backup.sql'");
        stat.execute("set throttle 1000");
        Thread.sleep(200L);
        final String dir = this.getBaseDir();
        Task task = new Task(){

            @Override
            public void call() throws SQLException {
                stat.execute("script simple drop to '" + dir + "/backup2.sql'");
            }
        };
        task.execute();
        Thread.sleep(200L);
        stat.cancel();
        SQLException e = (SQLException)task.getException();
        this.assertNotNull(e);
        this.assertEquals(57014, e.getErrorCode());
        stat.execute("set throttle 1000");
        Thread.sleep(100L);
        task = new Task(){

            @Override
            public void call() throws SQLException {
                stat.execute("runscript from '" + dir + "/backup.sql'");
            }
        };
        task.execute();
        Thread.sleep(200L);
        stat.cancel();
        e = (SQLException)task.getException();
        this.assertNotNull(e);
        this.assertEquals(57014, e.getErrorCode());
        conn.close();
        FileUtils.delete(this.getBaseDir() + "/backup.sql");
        FileUtils.delete(this.getBaseDir() + "/backup2.sql");
    }

    private void testEncoding() throws SQLException {
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        stat.execute("create table \"t\u00f6\"(id int)");
        stat.execute("script to '" + this.getBaseDir() + "/backup.sql'");
        stat.execute("drop all objects");
        stat.execute("runscript from '" + this.getBaseDir() + "/backup.sql'");
        stat.execute("select * from \"t\u00f6\"");
        stat.execute("script to '" + this.getBaseDir() + "/backup.sql' charset 'UTF-8'");
        stat.execute("drop all objects");
        stat.execute("runscript from '" + this.getBaseDir() + "/backup.sql' charset 'UTF-8'");
        stat.execute("select * from \"t\u00f6\"");
        conn.close();
        FileUtils.delete(this.getBaseDir() + "/backup.sql");
    }

    public static int test(int a) {
        return Math.abs(a);
    }

    private void testClobPrimaryKey() throws SQLException {
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int not null, data clob) as select 1, space(4100)");
        stat.execute("alter table test add constraint primary_key_e primary key(id)");
        stat.execute("script to '" + this.getBaseDir() + "/backup.sql'");
        conn.close();
        this.deleteDb("runscript");
        conn = this.getConnection("runscript");
        stat = conn.createStatement();
        stat.execute("runscript from '" + this.getBaseDir() + "/backup.sql'");
        conn.close();
        this.deleteDb("runscriptRestore");
        FileUtils.delete(this.getBaseDir() + "/backup.sql");
    }

    private void test(boolean password) throws SQLException {
        this.deleteDb("runscript");
        Connection conn1 = this.getConnection("runscript");
        Statement stat1 = conn1.createStatement();
        stat1.execute("create table test (id identity, name varchar(12))");
        stat1.execute("insert into test (name) values ('first'), ('second')");
        stat1.execute("create table test2(id int primary key) as select x from system_range(1, 5000)");
        stat1.execute("create sequence testSeq start with 100 increment by 10");
        stat1.execute("create alias myTest for '" + this.getClass().getName() + ".test'");
        stat1.execute("create trigger myTrigger before insert on test nowait call \"" + this.getClass().getName() + "\"");
        stat1.execute("create view testView as select * from test where 1=0 union all select * from test where 0=1");
        stat1.execute("create user testAdmin salt '00' hash '01' admin");
        stat1.execute("create schema testSchema authorization testAdmin");
        stat1.execute("create table testSchema.parent(id int primary key, name varchar)");
        stat1.execute("create index idxname on testSchema.parent(name)");
        stat1.execute("create table testSchema.child(id int primary key, parentId int, name varchar, foreign key(parentId) references parent(id))");
        stat1.execute("create user testUser salt '02' hash '03'");
        stat1.execute("create role testRole");
        stat1.execute("grant all on testSchema.child to testUser");
        stat1.execute("grant select, insert on testSchema.parent to testRole");
        stat1.execute("grant testRole to testUser");
        stat1.execute("create table blob (v blob)");
        PreparedStatement prep = conn1.prepareStatement("insert into blob values (?)");
        prep.setBytes(1, new byte[65536]);
        prep.execute();
        Object sql = "script to ?";
        if (password) {
            sql = (String)sql + " CIPHER AES PASSWORD ?";
        }
        prep = conn1.prepareStatement((String)sql);
        prep.setString(1, this.getBaseDir() + "/backup.2.sql");
        if (password) {
            prep.setString(2, "t1e2s3t4");
        }
        prep.execute();
        this.deleteDb("runscriptRestore");
        Connection conn2 = this.getConnection("runscriptRestore");
        Statement stat2 = conn2.createStatement();
        sql = "runscript from '" + this.getBaseDir() + "/backup.2.sql'";
        if (password) {
            sql = (String)sql + " CIPHER AES PASSWORD 'wrongPassword'";
        }
        if (password) {
            this.assertThrows(90049, stat2).execute((String)sql);
        }
        sql = "runscript from '" + this.getBaseDir() + "/backup.2.sql'";
        if (password) {
            sql = (String)sql + " CIPHER AES PASSWORD 't1e2s3t4'";
        }
        stat2.execute((String)sql);
        stat2.execute("script to '" + this.getBaseDir() + "/backup.3.sql'");
        this.assertEqualDatabases(stat1, stat2);
        if (!this.config.memory && !this.config.reopen) {
            conn1.close();
            if (this.config.cipher != null) {
                ChangeFileEncryption.execute(this.getBaseDir(), "runscript", this.config.cipher, this.getFilePassword().toCharArray(), null, true);
            }
            Recover.execute(this.getBaseDir(), "runscript");
            this.deleteDb("runscriptRestoreRecover");
            Connection conn3 = this.getConnection("runscriptRestoreRecover");
            Statement stat3 = conn3.createStatement();
            stat3.execute("runscript from '" + this.getBaseDir() + "/runscript.h2.sql'");
            conn3.close();
            conn3 = this.getConnection("runscriptRestoreRecover");
            stat3 = conn3.createStatement();
            if (this.config.cipher != null) {
                ChangeFileEncryption.execute(this.getBaseDir(), "runscript", this.config.cipher, null, this.getFilePassword().toCharArray(), true);
            }
            conn1 = this.getConnection("runscript");
            stat1 = conn1.createStatement();
            this.assertEqualDatabases(stat1, stat3);
            conn3.close();
        }
        this.assertEqualDatabases(stat1, stat2);
        conn1.close();
        conn2.close();
        this.deleteDb("runscriptRestore");
        this.deleteDb("runscriptRestoreRecover");
        FileUtils.delete(this.getBaseDir() + "/backup.2.sql");
        FileUtils.delete(this.getBaseDir() + "/backup.3.sql");
        FileUtils.delete(this.getBaseDir() + "/runscript.h2.sql");
    }

    private void testTruncateLargeLength() throws Exception {
        this.deleteDb("runscript");
        Files.write(Paths.get(this.getBaseDir() + "/backup.sql", new String[0]), Collections.singleton("CREATE TABLE TEST(V VARCHAR(2147483647))"), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        this.assertThrows(90150, stat).execute("RUNSCRIPT FROM '" + this.getBaseDir() + "/backup.sql'");
        stat.execute("RUNSCRIPT FROM '" + this.getBaseDir() + "/backup.sql' QUIRKS_MODE");
        this.assertEquals(1000000000, stat.executeQuery("TABLE TEST").getMetaData().getPrecision(1));
        conn.close();
        this.deleteDb("runscript");
        FileUtils.delete(this.getBaseDir() + "/backup.sql");
    }

    private void testVariableBinary() throws SQLException {
        this.deleteDb("runscript");
        Connection conn = this.getConnection("runscript");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(B BINARY)");
        this.assertEquals(-2, stat.executeQuery("TABLE TEST").getMetaData().getColumnType(1));
        stat.execute("SCRIPT TO '" + this.getBaseDir() + "/backup.sql'");
        conn.close();
        this.deleteDb("runscript");
        conn = this.getConnection("runscript");
        stat = conn.createStatement();
        stat.execute("RUNSCRIPT FROM '" + this.getBaseDir() + "/backup.sql'");
        this.assertEquals(-2, stat.executeQuery("TABLE TEST").getMetaData().getColumnType(1));
        conn.close();
        this.deleteDb("runscript");
        conn = this.getConnection("runscript");
        stat = conn.createStatement();
        stat.execute("RUNSCRIPT FROM '" + this.getBaseDir() + "/backup.sql' VARIABLE_BINARY");
        this.assertEquals(-3, stat.executeQuery("TABLE TEST").getMetaData().getColumnType(1));
        conn.close();
        this.deleteDb("runscript");
        FileUtils.delete(this.getBaseDir() + "/backup.sql");
    }

    @Override
    public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) {
        if (!before) {
            throw new InternalError("before:" + before);
        }
        if (type != 1) {
            throw new InternalError("type:" + type);
        }
    }

    @Override
    public void fire(Connection conn, Object[] oldRow, Object[] newRow) {
    }

    @Override
    public void close() {
    }

    @Override
    public void remove() {
    }
}

