/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestSQLInjection
extends TestDb {
    private Connection conn;
    private Statement stat;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.reopen;
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb("sqlInjection");
        this.reconnect("sqlInjection");
        this.stat.execute("DROP TABLE IF EXISTS USERS");
        this.stat.execute("CREATE TABLE USERS(NAME VARCHAR PRIMARY KEY, PASSWORD VARCHAR, TYPE VARCHAR)");
        this.stat.execute("CREATE SCHEMA CONST");
        this.stat.execute("CREATE CONSTANT CONST.ACTIVE VALUE 'Active'");
        this.stat.execute("INSERT INTO USERS VALUES('James', '123456', CONST.ACTIVE)");
        this.assertTrue(this.checkPasswordInsecure("123456"));
        this.assertFalse(this.checkPasswordInsecure("abcdef"));
        this.assertTrue(this.checkPasswordInsecure("' OR ''='"));
        this.assertTrue(this.checkPasswordSecure("123456"));
        this.assertFalse(this.checkPasswordSecure("abcdef"));
        this.assertFalse(this.checkPasswordSecure("' OR ''='"));
        this.stat.execute("CALL 123");
        this.stat.execute("CALL 'Hello'");
        this.stat.execute("CALL $$Hello World$$");
        this.stat.execute("SET ALLOW_LITERALS NUMBERS");
        this.stat.execute("CALL 123");
        this.assertThrows(90116, this.stat).execute("CALL 'Hello'");
        this.assertThrows(90116, this.stat).execute("CALL $$Hello World$$");
        this.stat.execute("SET ALLOW_LITERALS NONE");
        try {
            this.checkPasswordInsecure("123456");
            this.fail();
        }
        catch (SQLException e) {
            this.assertKnownException(e);
        }
        this.assertTrue(this.checkPasswordSecure("123456"));
        this.assertFalse(this.checkPasswordSecure("' OR ''='"));
        this.conn.close();
        if (this.config.memory) {
            return;
        }
        this.reconnect("sqlInjection");
        try {
            this.checkPasswordInsecure("123456");
            this.fail();
        }
        catch (SQLException e) {
            this.assertKnownException(e);
        }
        this.assertTrue(this.checkPasswordSecure("123456"));
        this.assertFalse(this.checkPasswordSecure("' OR ''='"));
        this.conn.close();
        this.deleteDb("sqlInjection");
    }

    private boolean checkPasswordInsecure(String pwd) throws SQLException {
        String sql = "SELECT * FROM USERS WHERE PASSWORD='" + pwd + "'";
        ResultSet rs = this.conn.createStatement().executeQuery(sql);
        return rs.next();
    }

    private boolean checkPasswordSecure(String pwd) throws SQLException {
        String sql = "SELECT * FROM USERS WHERE PASSWORD=?";
        PreparedStatement prep = this.conn.prepareStatement(sql);
        prep.setString(1, pwd);
        ResultSet rs = prep.executeQuery();
        return rs.next();
    }

    private void reconnect(String name) throws SQLException {
        if (!this.config.memory && this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
        if (this.conn == null) {
            this.conn = this.getConnection(name);
            this.stat = this.conn.createStatement();
        }
    }
}

