/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestSetCollation
extends TestDb {
    private static final String[] TEST_STRINGS;
    private static final String DB_NAME = "collator";

    static {
        String[] stringArray = new String[7];
        stringArray[0] = "A";
        stringArray[1] = "\u00c4";
        stringArray[2] = "AA";
        stringArray[3] = "B";
        stringArray[4] = "$";
        stringArray[5] = "1A";
        TEST_STRINGS = stringArray;
    }

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testDefaultCollator();
        this.testCp500Collator();
        this.testDeCollator();
        this.testUrlParameter();
        this.testReopenDatabase();
        this.testReopenDatabaseWithUrlParameter();
        this.testReopenDatabaseWithDifferentCollationInUrl();
        this.testReopenDatabaseWithSameCollationInUrl();
    }

    private void testDefaultCollator() throws Exception {
        this.assertEquals(Arrays.asList(null, "$", "1A", "A", "AA", "B", "\u00c4"), this.orderedWithCollator(null));
    }

    private void testDeCollator() throws Exception {
        this.assertEquals(Arrays.asList(null, "$", "1A", "A", "\u00c4", "AA", "B"), this.orderedWithCollator("DE"));
        this.assertEquals(Arrays.asList(null, "$", "1A", "A", "\u00c4", "AA", "B"), this.orderedWithCollator("DEFAULT_DE"));
    }

    private void testCp500Collator() throws Exception {
        this.assertEquals(Arrays.asList(null, "A", "AA", "B", "1A", "$", "\u00c4"), this.orderedWithCollator("CHARSET_CP500"));
    }

    private void testUrlParameter() throws Exception {
        this.config.collation = "CHARSET_CP500";
        try {
            this.assertEquals(Arrays.asList(null, "A", "AA", "B", "1A", "$", "\u00c4"), this.orderedWithCollator(null));
        }
        finally {
            this.config.collation = null;
        }
    }

    private void testReopenDatabase() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.orderedWithCollator("DE");
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection con = this.getConnection(DB_NAME);){
            TestSetCollation.insertValues(con, new String[]{"A", "\u00c4"}, 100);
            this.assertEquals(Arrays.asList(null, "$", "1A", "A", "A", "\u00c4", "\u00c4", "AA", "B"), TestSetCollation.loadTableValues(con));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testReopenDatabaseWithUrlParameter() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.config.collation = "DE";
        try {
            this.orderedWithCollator(null);
        }
        finally {
            this.config.collation = null;
        }
        Throwable throwable = null;
        Object var2_4 = null;
        try (Connection con = this.getConnection(DB_NAME);){
            TestSetCollation.insertValues(con, new String[]{"A", "\u00c4"}, 100);
            this.assertEquals(Arrays.asList(null, "$", "1A", "A", "A", "\u00c4", "\u00c4", "AA", "B"), TestSetCollation.loadTableValues(con));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testReopenDatabaseWithDifferentCollationInUrl() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.config.collation = "DE";
        try {
            this.orderedWithCollator(null);
        }
        finally {
            this.config.collation = null;
        }
        this.config.collation = "CHARSET_CP500";
        try {
            try {
                this.getConnection(DB_NAME);
                this.fail();
            }
            catch (SQLException sQLException) {
                this.config.collation = null;
            }
        }
        finally {
            this.config.collation = null;
        }
    }

    private void testReopenDatabaseWithSameCollationInUrl() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.config.collation = "DE";
        try {
            this.orderedWithCollator(null);
        }
        finally {
            this.config.collation = null;
        }
        this.config.collation = "DE";
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection con = this.getConnection(DB_NAME);){
                TestSetCollation.insertValues(con, new String[]{"A", "\u00c4"}, 100);
                this.assertEquals(Arrays.asList(null, "$", "1A", "A", "A", "\u00c4", "\u00c4", "AA", "B"), TestSetCollation.loadTableValues(con));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.config.collation = null;
        }
    }

    /*
     * Loose catch block
     */
    private List<String> orderedWithCollator(String collator) throws SQLException {
        this.deleteDb(DB_NAME);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            List<String> list;
            Statement statement;
            Connection con;
            block17: {
                block16: {
                    con = this.getConnection(DB_NAME);
                    statement = con.createStatement();
                    if (collator != null) {
                        statement.execute("SET COLLATION " + collator);
                    }
                    statement.execute("CREATE TABLE charsettable(id INT PRIMARY KEY, testvalue VARCHAR(50))");
                    TestSetCollation.insertValues(con, TEST_STRINGS, 1);
                    list = TestSetCollation.loadTableValues(con);
                    if (statement == null) break block16;
                    statement.close();
                }
                if (con == null) break block17;
                con.close();
            }
            return list;
            {
                catch (Throwable throwable2) {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (con != null) {
                            con.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static void insertValues(Connection con, String[] values, int startId) throws SQLException {
        PreparedStatement ps = con.prepareStatement("INSERT INTO charsettable VALUES (?, ?)");
        int id = startId;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            ps.setInt(1, id++);
            ps.setString(2, value);
            ps.execute();
            ++n2;
        }
        ps.close();
    }

    private static List<String> loadTableValues(Connection con) throws SQLException {
        ArrayList<String> results = new ArrayList<String>();
        Statement statement = con.createStatement();
        ResultSet resultSet = statement.executeQuery("select testvalue from charsettable order by testvalue");
        while (resultSet.next()) {
            results.add(resultSet.getString(1));
        }
        statement.close();
        return results;
    }
}

