/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestSpaceReuse
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.memory;
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb("spaceReuse");
        long max = 0L;
        long now = 0L;
        long min = Long.MAX_VALUE;
        int i = 0;
        while (i < 20) {
            Connection conn = this.getConnection("spaceReuse");
            Statement stat = conn.createStatement();
            stat.execute("set retention_time 0");
            stat.execute("set write_delay 0");
            stat.execute("create table if not exists t(i int)");
            stat.execute("insert into t select x from system_range(1, 500)");
            conn.close();
            conn = this.getConnection("spaceReuse");
            conn.createStatement().execute("delete from t");
            conn.close();
            String fileName = this.getBaseDir() + "/spaceReuse.mv.db";
            now = FileUtils.size(fileName);
            this.assertTrue(now > 0L);
            if (i < 10) {
                max = Math.max(max, now);
            } else {
                min = Math.min(min, now);
            }
            ++i;
        }
        this.assertTrue("min: " + min + " max: " + max, min <= max);
        this.deleteDb("spaceReuse");
    }
}

