/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Random;
import org.h2.api.Aggregate;
import org.h2.message.DbException;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.SimpleResultSet;
import org.h2.tools.SimpleRowSource;
import org.h2.value.TypeInfo;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueToObjectConverter;
import org.h2.value.ValueToObjectConverter2;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;

public class TestSpatial
extends TestDb {
    private static final String URL = "spatial";

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        if (this.config.memory) {
            return false;
        }
        return ValueToObjectConverter.GEOMETRY_CLASS != null;
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb(URL);
        this.testSpatial();
        this.deleteDb(URL);
    }

    private void testSpatial() throws SQLException {
        this.testNaNs();
        this.testBug1();
        this.testSpatialValues();
        this.testOverlap();
        this.testNotOverlap();
        this.testPersistentSpatialIndex();
        this.testSpatialIndexQueryMultipleTable();
        this.testIndexTransaction();
        this.testJavaAlias();
        this.testJavaAliasTableFunction();
        this.testMemorySpatialIndex();
        this.testGeometryDataType();
        this.testWKB();
        this.testValueConversion();
        this.testEquals();
        this.testTableFunctionGeometry();
        this.testAggregateWithGeometry();
        this.testTableViewSpatialPredicate();
        this.testValueGeometryScript();
        this.testInPlaceUpdate();
        this.testScanIndexOnNonSpatialQuery();
        this.testStoreCorruption();
        this.testExplainSpatialIndexWithPk();
        this.testNullableGeometry();
        this.testNullableGeometryDelete();
        this.testNullableGeometryInsert();
        this.testNullableGeometryUpdate();
        this.testIndexUpdateNullGeometry();
        this.testInsertNull();
        this.testSpatialIndexWithOrder();
    }

    private void testNaNs() {
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(), 0, (CoordinateSequenceFactory)CoordinateArraySequenceFactory.instance());
        CoordinateSequence c2 = factory.getCoordinateSequenceFactory().create(1, 2, 0);
        c2.setOrdinate(0, 0, 1.0);
        c2.setOrdinate(0, 1, 1.0);
        CoordinateSequence c3 = factory.getCoordinateSequenceFactory().create(1, 3, 0);
        c3.setOrdinate(0, 0, 1.0);
        c3.setOrdinate(0, 1, 2.0);
        c3.setOrdinate(0, 2, 3.0);
        Point p2 = factory.createPoint(c2);
        Point p3 = factory.createPoint(c3);
        try {
            ValueGeometry.getFromGeometry(new MultiPoint(new Point[]{p2, p3}, factory));
            this.fail("Expected exception");
        }
        catch (DbException e) {
            this.assertEquals(22018, e.getErrorCode());
        }
    }

    private void testBug1() throws SQLException {
        this.deleteDb(URL);
        Connection conn = this.getConnection(URL);
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE VECTORS (ID INTEGER NOT NULL, GEOM GEOMETRY, S INTEGER)");
        stat.execute("INSERT INTO VECTORS(ID, GEOM, S) VALUES(0, 'POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))', 1)");
        stat.executeQuery("select * from (select * from VECTORS) WHERE S=1 AND GEOM && 'POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))'");
        conn.close();
        this.deleteDb(URL);
    }

    private void testSpatialValues() throws SQLException {
        this.deleteDb(URL);
        Connection conn = this.getConnection(URL);
        Statement stat = conn.createStatement();
        stat.execute("create memory table test(id int primary key, polygon geometry)");
        stat.execute("insert into test values(1, 'POLYGON ((1 1, 1 2, 2 2, 1 1))')");
        ResultSet rs = stat.executeQuery("select * from test");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("POLYGON ((1 1, 1 2, 2 2, 1 1))", rs.getString(2));
        GeometryFactory f = new GeometryFactory();
        Polygon polygon = f.createPolygon(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(1.0, 2.0), new Coordinate(2.0, 2.0), new Coordinate(1.0, 1.0)});
        this.assertTrue(polygon.equals(rs.getObject(2)));
        rs.close();
        rs = stat.executeQuery("select id, cast(polygon as varchar) from test");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals((Object)"POLYGON ((1 1, 1 2, 2 2, 1 1))", rs.getObject(2));
        this.assertTrue(polygon.equals(rs.getObject(2, Geometry.class)));
        rs.close();
        rs = stat.executeQuery("select * from test where polygon = 'POLYGON ((1 1, 1 2, 2 2, 1 1))'");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        stat.executeQuery("select * from test where polygon > 'POLYGON ((1 1, 1 2, 2 2, 1 1))'");
        stat.executeQuery("select * from test where polygon < 'POLYGON ((1 1, 1 2, 2 2, 1 1))'");
        stat.execute("drop table test");
        conn.close();
        this.deleteDb(URL);
    }

    static Geometry getRandomGeometry(Random geometryRand, double minX, double maxX, double minY, double maxY, double maxLength) {
        GeometryFactory factory = new GeometryFactory();
        Coordinate start = new Coordinate(geometryRand.nextDouble() * (maxX - minX) + minX, geometryRand.nextDouble() * (maxY - minY) + minY);
        double angle = geometryRand.nextDouble() * Math.PI * 2.0;
        double length = geometryRand.nextDouble() * maxLength;
        Coordinate end = new Coordinate(start.x + Math.cos(angle) * length, start.y + Math.sin(angle) * length);
        return factory.createLineString(new Coordinate[]{start, end});
    }

    private void testOverlap() throws SQLException {
        this.deleteDb(URL);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(URL);){
            Statement stat = conn.createStatement();
            stat.execute("create memory table test(id int primary key, poly geometry)");
            stat.execute("insert into test values(1, 'POLYGON ((1 1, 1 2, 2 2, 1 1))')");
            stat.execute("insert into test values(2, 'POLYGON ((3 1, 3 2, 4 2, 3 1))')");
            stat.execute("insert into test values(3, 'POLYGON ((1 3, 1 4, 2 4, 1 3))')");
            ResultSet rs = stat.executeQuery("select * from test where poly && 'POINT (1.5 1.5)'::Geometry");
            this.assertTrue(rs.next());
            this.assertEquals(1, rs.getInt("id"));
            this.assertFalse(rs.next());
            stat.execute("drop table test");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testPersistentSpatialIndex() throws SQLException {
        ResultSet rs;
        Statement stat;
        Connection conn;
        this.deleteDb(URL);
        Throwable throwable = null;
        Object var2_4 = null;
        try {
            conn = this.getConnection(URL);
            try {
                stat = conn.createStatement();
                stat.execute("create table test(id int primary key, poly geometry)");
                stat.execute("insert into test values(1, 'POLYGON ((1 1, 1 2, 2 2, 1 1))')");
                stat.execute("insert into test values(2,null)");
                stat.execute("insert into test values(3, 'POLYGON ((3 1, 3 2, 4 2, 3 1))')");
                stat.execute("insert into test values(4,null)");
                stat.execute("insert into test values(5, 'POLYGON ((1 3, 1 4, 2 4, 1 3))')");
                stat.execute("create spatial index on test(poly)");
                rs = stat.executeQuery("select * from test where poly && 'POINT (1.5 1.5)'::Geometry");
                this.assertTrue(rs.next());
                this.assertEquals(1, rs.getInt("id"));
                this.assertFalse(rs.next());
                rs.close();
                rs = stat.executeQuery("select * from test where poly && 'POINT (1.5 1.5)'::Geometry AND poly && 'POINT (1.7 1.75)'::Geometry");
                this.assertTrue(rs.next());
                this.assertEquals(1, rs.getInt("id"));
                this.assertFalse(rs.next());
                rs.close();
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (this.config.memory) {
            return;
        }
        throwable = null;
        var2_4 = null;
        try {
            conn = this.getConnection(URL);
            try {
                stat = conn.createStatement();
                rs = stat.executeQuery("select * from test where poly && 'POINT (1.5 1.5)'::Geometry");
                this.assertTrue(rs.next());
                this.assertEquals(1, rs.getInt("id"));
                this.assertFalse(rs.next());
                stat.execute("drop table test");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testNotOverlap() throws SQLException {
        this.deleteDb(URL);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(URL);){
            Statement stat = conn.createStatement();
            stat.execute("create memory table test(id int primary key, poly geometry)");
            stat.execute("insert into test values(1, 'POLYGON ((1 1, 1 2, 2 2, 1 1))')");
            stat.execute("insert into test values(2,null)");
            stat.execute("insert into test values(3, 'POLYGON ((3 1, 3 2, 4 2, 3 1))')");
            stat.execute("insert into test values(4,null)");
            stat.execute("insert into test values(5, 'POLYGON ((1 3, 1 4, 2 4, 1 3))')");
            ResultSet rs = stat.executeQuery("select * from test where NOT poly && 'POINT (1.5 1.5)'::Geometry");
            this.assertTrue(rs.next());
            this.assertEquals(3, rs.getInt("id"));
            this.assertTrue(rs.next());
            this.assertEquals(5, rs.getInt("id"));
            this.assertFalse(rs.next());
            stat.execute("drop table test");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void createTestTable(Statement stat) throws SQLException {
        stat.execute("create table area(idArea int primary key, the_geom geometry)");
        stat.execute("create spatial index on area(the_geom)");
        stat.execute("insert into area values(1, 'POLYGON ((-10 109, 90 109, 90 9, -10 9, -10 109))')");
        stat.execute("insert into area values(2, 'POLYGON ((90 109, 190 109, 190 9, 90 9, 90 109))')");
        stat.execute("insert into area values(3, 'POLYGON ((190 109, 290 109, 290 9, 190 9, 190 109))')");
        stat.execute("insert into area values(4, 'POLYGON ((-10 9, 90 9, 90 -91, -10 -91, -10 9))')");
        stat.execute("insert into area values(5, 'POLYGON ((90 9, 190 9, 190 -91, 90 -91, 90 9))')");
        stat.execute("insert into area values(6, 'POLYGON ((190 9, 290 9, 290 -91, 190 -91, 190 9))')");
        stat.execute("insert into area values(7,null)");
        stat.execute("insert into area values(8,null)");
        stat.execute("create table roads(idRoad int primary key, the_geom geometry)");
        stat.execute("create spatial index on roads(the_geom)");
        stat.execute("insert into roads values(1, 'LINESTRING (27.65595463138 -16.728733459357244, 47.61814744801515 40.435727788279806)')");
        stat.execute("insert into roads values(2, 'LINESTRING (17.674858223062415 55.861058601134246, 55.78449905482046 76.73062381852554)')");
        stat.execute("insert into roads values(3, 'LINESTRING (68.48771266540646 67.65689981096412, 108.4120982986768 88.52646502835542)')");
        stat.execute("insert into roads values(4, 'LINESTRING (177.3724007561437 18.65879017013235, 196.4272211720227 -16.728733459357244)')");
        stat.execute("insert into roads values(5, 'LINESTRING (106.5973534971645 -12.191871455576518, 143.79962192816637 30.454631379962223)')");
        stat.execute("insert into roads values(6, 'LINESTRING (144.70699432892252 55.861058601134246, 150.1512287334594 83.9896030245747)')");
        stat.execute("insert into roads values(7, 'LINESTRING (60.321361058601155 -13.099243856332663, 149.24385633270325 5.955576559546344)')");
        stat.execute("insert into roads values(8, null)");
        stat.execute("insert into roads values(9, null)");
    }

    private void testSpatialIndexQueryMultipleTable() throws SQLException {
        this.deleteDb(URL);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(URL);){
            Statement stat = conn.createStatement();
            TestSpatial.createTestTable(stat);
            this.testRoadAndArea(stat);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.deleteDb(URL);
    }

    private void testRoadAndArea(Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select idArea, COUNT(idRoad) roadCount from area, roads where area.the_geom && roads.the_geom GROUP BY idArea ORDER BY idArea");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt("idArea"));
        this.assertEquals(3, rs.getInt("roadCount"));
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt("idArea"));
        this.assertEquals(4, rs.getInt("roadCount"));
        this.assertTrue(rs.next());
        this.assertEquals(3, rs.getInt("idArea"));
        this.assertEquals(1, rs.getInt("roadCount"));
        this.assertTrue(rs.next());
        this.assertEquals(4, rs.getInt("idArea"));
        this.assertEquals(2, rs.getInt("roadCount"));
        this.assertTrue(rs.next());
        this.assertEquals(5, rs.getInt("idArea"));
        this.assertEquals(3, rs.getInt("roadCount"));
        this.assertTrue(rs.next());
        this.assertEquals(6, rs.getInt("idArea"));
        this.assertEquals(1, rs.getInt("roadCount"));
        this.assertFalse(rs.next());
        rs.close();
    }

    private void testIndexTransaction() throws SQLException {
        this.deleteDb(URL);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(URL);){
            conn.setAutoCommit(false);
            Statement stat = conn.createStatement();
            TestSpatial.createTestTable(stat);
            Savepoint sp = conn.setSavepoint();
            stat.execute("delete from roads where idRoad=9");
            stat.execute("delete from roads where idRoad=7");
            ResultSet rs = stat.executeQuery("select idArea, COUNT(idRoad) roadCount from area, roads where area.the_geom && roads.the_geom GROUP BY idArea ORDER BY idArea");
            this.assertTrue(rs.next());
            this.assertEquals(1, rs.getInt("idArea"));
            this.assertEquals(3, rs.getInt("roadCount"));
            this.assertTrue(rs.next());
            this.assertEquals(2, rs.getInt("idArea"));
            this.assertEquals(4, rs.getInt("roadCount"));
            this.assertTrue(rs.next());
            this.assertEquals(3, rs.getInt("idArea"));
            this.assertEquals(1, rs.getInt("roadCount"));
            this.assertTrue(rs.next());
            this.assertEquals(4, rs.getInt("idArea"));
            this.assertEquals(1, rs.getInt("roadCount"));
            this.assertTrue(rs.next());
            this.assertEquals(5, rs.getInt("idArea"));
            this.assertEquals(2, rs.getInt("roadCount"));
            this.assertTrue(rs.next());
            this.assertEquals(6, rs.getInt("idArea"));
            this.assertEquals(1, rs.getInt("roadCount"));
            this.assertFalse(rs.next());
            rs.close();
            conn.rollback(sp);
            this.testRoadAndArea(stat);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testMemorySpatialIndex() throws SQLException {
        this.deleteDb(URL);
        Connection conn = this.getConnection(URL);
        Statement stat = conn.createStatement();
        stat.execute("create memory table test(id int primary key, polygon geometry)");
        stat.execute("create spatial index idx_test_polygon on test(polygon)");
        stat.execute("insert into test values(1, 'POLYGON ((1 1, 1 2, 2 2, 1 1))')");
        stat.execute("insert into test values(2, null)");
        ResultSet rs = stat.executeQuery("select * from test where polygon && 'POLYGON ((1 1, 1 2, 2 2, 1 1))'::Geometry and polygon && 'POLYGON ((10 10, 10 20, 20 20, 10 10))'::Geometry");
        this.assertFalse(rs.next());
        rs = stat.executeQuery("explain select * from test where polygon && 'POLYGON ((1 1, 1 2, 2 2, 1 1))'::Geometry");
        rs.next();
        this.assertContains(rs.getString(1), "/* PUBLIC.IDX_TEST_POLYGON: POLYGON &&");
        stat.executeQuery("select * from test where polygon > 'POLYGON ((1 1, 1 2, 2 2, 1 1))'::Geometry");
        stat.executeQuery("select * from test where polygon < 'POLYGON ((1 1, 1 2, 2 2, 1 1))'::Geometry");
        rs = stat.executeQuery("select * from test where intersects(polygon, 'POLYGON ((1 1, 1 2, 2 2, 1 1))')");
        this.assertTrue(rs.next());
        rs = stat.executeQuery("select * from test where intersects(polygon, 'POINT (1 1)')");
        this.assertTrue(rs.next());
        rs = stat.executeQuery("select * from test where intersects(polygon, 'POINT (0 0)')");
        this.assertFalse(rs.next());
        stat.execute("drop table test");
        conn.close();
        this.deleteDb(URL);
    }

    private void testJavaAlias() throws SQLException {
        this.deleteDb(URL);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(URL);){
            Statement stat = conn.createStatement();
            stat.execute("CREATE ALIAS T_GEOM_FROM_TEXT FOR '" + TestSpatial.class.getName() + ".geomFromText'");
            stat.execute("create table test(id int primary key auto_increment, the_geom geometry)");
            stat.execute("insert into test(the_geom) values(T_GEOM_FROM_TEXT('POLYGON ((62 48, 84 48, 84 42, 56 34, 62 48))',1488))");
            stat.execute("DROP ALIAS T_GEOM_FROM_TEXT");
            ResultSet rs = stat.executeQuery("select the_geom from test");
            this.assertTrue(rs.next());
            this.assertEquals("POLYGON ((62 48, 84 48, 84 42, 56 34, 62 48))", rs.getObject(1).toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.deleteDb(URL);
    }

    private void testJavaAliasTableFunction() throws SQLException {
        this.deleteDb(URL);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(URL);){
            Statement stat = conn.createStatement();
            stat.execute("CREATE ALIAS T_RANDOM_GEOM_TABLE FOR '" + TestSpatial.class.getName() + ".getRandomGeometryTable'");
            stat.execute("create table test as select * from T_RANDOM_GEOM_TABLE(42,20,-100,100,-100,100,4)");
            stat.execute("DROP ALIAS T_RANDOM_GEOM_TABLE");
            ResultSet rs = stat.executeQuery("select count(*) from test");
            this.assertTrue(rs.next());
            this.assertEquals(20, rs.getInt(1));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.deleteDb(URL);
    }

    public static ResultSet getRandomGeometryTable(final long seed, final long rowCount, final double minX, final double maxX, final double minY, final double maxY, final double maxLength) {
        SimpleResultSet rs = new SimpleResultSet(new SimpleRowSource(){
            private final Random random;
            private int currentRow;
            {
                this.random = new Random(l);
            }

            @Override
            public Object[] readRow() throws SQLException {
                if ((long)this.currentRow++ < rowCount) {
                    return new Object[]{TestSpatial.getRandomGeometry(this.random, minX, maxX, minY, maxY, maxLength)};
                }
                return null;
            }

            @Override
            public void close() {
            }

            @Override
            public void reset() throws SQLException {
                this.random.setSeed(seed);
            }
        });
        rs.addColumn("the_geom", 1111, "GEOMETRY", Integer.MAX_VALUE, 0);
        return rs;
    }

    public static Geometry geomFromText(String text, int srid) throws SQLException {
        WKTReader wktReader = new WKTReader();
        wktReader.setIsOldJtsCoordinateSyntaxAllowed(false);
        try {
            Geometry geom = wktReader.read(text);
            geom.setSRID(srid);
            return geom;
        }
        catch (ParseException ex) {
            throw new SQLException(ex);
        }
    }

    private void testGeometryDataType() {
        GeometryFactory geometryFactory = new GeometryFactory();
        Point geometry = geometryFactory.createPoint(new Coordinate(0.0, 0.0));
        this.assertEquals(TypeInfo.TYPE_GEOMETRY, ValueToObjectConverter2.classToType(geometry.getClass()));
    }

    private void testWKB() {
        String ewkt = "SRID=27572;POLYGON Z ((67 13 6, 67 18 5, 59 18 4, 59 13 6, 67 13 6))";
        ValueGeometry geom3d = ValueGeometry.get(ewkt);
        this.assertEquals(ewkt, geom3d.getString());
        ValueGeometry copy = ValueGeometry.get(geom3d.getBytes());
        Geometry g = copy.getGeometry();
        this.assertEquals(6.0, g.getCoordinates()[0].getZ());
        this.assertEquals(5.0, g.getCoordinates()[1].getZ());
        this.assertEquals(4.0, g.getCoordinates()[2].getZ());
        copy = ValueGeometry.get(geom3d.getBytes());
        this.assertEquals(27572, g.getSRID());
        Point point = new GeometryFactory().createPoint(new Coordinate(1.1, 1.2));
        this.checkSRID(ValueGeometry.getFromGeometry(point).getBytes(), 0);
        this.checkSRID(new WKBWriter(2, 1, false).write((Geometry)point), 0);
        this.checkSRID(new WKBWriter(2, 1, true).write((Geometry)point), 0);
        this.checkSRID(new WKBWriter(2, 2, false).write((Geometry)point), 0);
        this.checkSRID(new WKBWriter(2, 2, true).write((Geometry)point), 0);
        ewkt = "POINT (1.1 1.2)";
        this.assertEquals(ewkt, ValueGeometry.getFromGeometry(point).getString());
        this.assertEquals(ewkt, ValueGeometry.get(ewkt).getString());
        point.setSRID(1000000000);
        this.checkSRID(ValueGeometry.getFromGeometry(point).getBytes(), 1000000000);
        this.checkSRID(new WKBWriter(2, 1, true).write((Geometry)point), 1000000000);
        this.checkSRID(new WKBWriter(2, 2, true).write((Geometry)point), 1000000000);
        ewkt = "SRID=1000000000;POINT (1.1 1.2)";
        this.assertEquals(ewkt, ValueGeometry.getFromGeometry(point).getString());
        this.assertEquals(ewkt, ValueGeometry.get(ewkt).getString());
    }

    private void checkSRID(byte[] bytes, int srid) {
        Point point = (Point)ValueGeometry.getFromEWKB(bytes).getGeometry();
        this.assertEquals(1.1, point.getX());
        this.assertEquals(1.2, point.getY());
        this.assertEquals(srid, point.getSRID());
        this.assertEquals(srid, point.getFactory().getSRID());
    }

    private void testValueConversion() throws SQLException {
        this.deleteDb(URL);
        Connection conn = this.getConnection(URL);
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS OBJ_STRING FOR '" + TestSpatial.class.getName() + ".getObjectString'");
        ResultSet rs = stat.executeQuery("select OBJ_STRING('POINT( 15 25 )'::geometry)");
        this.assertTrue(rs.next());
        this.assertEquals("POINT (15 25)", rs.getString(1));
        conn.close();
        this.deleteDb(URL);
    }

    public static String getObjectString(Geometry object) {
        return object.toString();
    }

    private void testEquals() {
        ValueGeometry geom3d = ValueGeometry.get("POLYGON Z((67 13 6, 67 18 5, 59 18 4, 59 13 6,  67 13 6))");
        ValueGeometry geom2d = ValueGeometry.get("POLYGON ((67 13, 67 18, 59 18, 59 13,  67 13))");
        this.assertFalse(geom3d.equals(geom2d));
        GeometryFactory geometryFactory = new GeometryFactory();
        Point geometry = geometryFactory.createPoint(new Coordinate(0.0, 0.0));
        geometry.setSRID(27572);
        ValueGeometry valueGeometry = ValueGeometry.getFromGeometry(geometry);
        Point geometry2 = geometryFactory.createPoint(new Coordinate(0.0, 0.0));
        geometry2.setSRID(5326);
        ValueGeometry valueGeometry2 = ValueGeometry.getFromGeometry(geometry2);
        this.assertFalse(valueGeometry.equals(valueGeometry2));
        ValueGeometry valueGeometry3 = ValueGeometry.getFromGeometry(geometry);
        this.assertEquals(valueGeometry, valueGeometry3);
        this.assertEquals(geometry.getSRID(), valueGeometry3.getGeometry().getSRID());
    }

    private void testTableFunctionGeometry() throws SQLException {
        this.deleteDb(URL);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(URL);){
            Statement stat = conn.createStatement();
            stat.execute("CREATE ALIAS POINT_TABLE FOR '" + TestSpatial.class.getName() + ".pointTable'");
            stat.execute("create table test as select * from point_table(1, 1)");
            ResultSet columnMeta = conn.getMetaData().getColumns(null, null, "TEST", "THE_GEOM");
            this.assertTrue(columnMeta.next());
            this.assertEquals("geometry", columnMeta.getString("TYPE_NAME").toLowerCase());
            this.assertFalse(columnMeta.next());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.deleteDb(URL);
    }

    public static ResultSet pointTable(double x, double y) {
        GeometryFactory factory = new GeometryFactory();
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn("THE_GEOM", 1111, "GEOMETRY", 0, 0);
        rs.addRow(factory.createPoint(new Coordinate(x, y)));
        return rs;
    }

    private void testAggregateWithGeometry() throws SQLException {
        this.deleteDb("spatialIndex");
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection("spatialIndex");){
            Statement st = conn.createStatement();
            st.execute("CREATE AGGREGATE TABLE_ENVELOPE FOR '" + TableEnvelope.class.getName() + "'");
            st.execute("CREATE TABLE test(the_geom GEOMETRY)");
            st.execute("INSERT INTO test VALUES ('POINT(1 1)'), (null), (null), ('POINT(10 5)')");
            ResultSet rs = st.executeQuery("select TABLE_ENVELOPE(the_geom) from test");
            this.assertEquals("geometry", rs.getMetaData().getColumnTypeName(1).toLowerCase());
            this.assertTrue(rs.next());
            this.assertTrue(rs.getObject(1) instanceof Geometry);
            this.assertTrue(new Envelope(1.0, 10.0, 1.0, 5.0).equals((Object)((Geometry)rs.getObject(1)).getEnvelopeInternal()));
            this.assertFalse(rs.next());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.deleteDb("spatialIndex");
    }

    private void testTableViewSpatialPredicate() throws SQLException {
        this.deleteDb(URL);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(URL);){
            Statement stat = conn.createStatement();
            stat.execute("drop table if exists test");
            stat.execute("drop view if exists test_view");
            stat.execute("create table test(id int primary key, poly geometry)");
            stat.execute("insert into test values(1, 'POLYGON ((1 1, 1 2, 2 2, 1 1))')");
            stat.execute("insert into test values(4, null)");
            stat.execute("insert into test values(2, 'POLYGON ((3 1, 3 2, 4 2, 3 1))')");
            stat.execute("insert into test values(3, 'POLYGON ((1 3, 1 4, 2 4, 1 3))')");
            stat.execute("create view test_view as select * from test");
            ResultSet rs = stat.executeQuery("select * from test where poly && 'POINT (1.5 1.5)'::Geometry");
            this.assertTrue(rs.next());
            this.assertEquals(1, rs.getInt("id"));
            this.assertFalse(rs.next());
            rs = stat.executeQuery("select * from test_view where poly && 'POINT (1.5 1.5)'::Geometry");
            this.assertTrue(rs.next());
            this.assertEquals(1, rs.getInt("id"));
            this.assertFalse(rs.next());
            rs.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.deleteDb(URL);
    }

    private void testValueGeometryScript() throws SQLException {
        ValueGeometry valueGeometry = ValueGeometry.get("POINT Z(1 1 5)");
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection conn = this.getConnection(URL);){
            ResultSet rs = conn.createStatement().executeQuery("SELECT " + valueGeometry.getSQL(0));
            this.assertTrue(rs.next());
            Object obj = rs.getObject(1);
            ValueGeometry g = ValueGeometry.getFromGeometry(obj);
            this.assertTrue("got: " + String.valueOf(g) + " exp: " + String.valueOf(valueGeometry), valueGeometry.equals(g));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testInPlaceUpdate() throws SQLException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(URL);){
            ResultSet rs = conn.createStatement().executeQuery("SELECT 'POINT(1 1)'::geometry");
            this.assertTrue(rs.next());
            ((Geometry)rs.getObject(1)).apply((CoordinateSequenceFilter)new AffineTransformation(1.0, 0.0, 1.0, 1.0, 0.0, 1.0));
            rs.close();
            rs = conn.createStatement().executeQuery("SELECT 'POINT(1 1)'::geometry");
            this.assertTrue(rs.next());
            this.assertEquals(1.0, ((Point)rs.getObject(1)).getX());
            this.assertEquals(1.0, ((Point)rs.getObject(1)).getY());
            rs.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testScanIndexOnNonSpatialQuery() throws SQLException {
        this.deleteDb(URL);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(URL);){
            Statement stat = conn.createStatement();
            stat.execute("drop table if exists test");
            stat.execute("create table test(id serial primary key, v double, the_geom geometry)");
            stat.execute("create spatial index spatial on test(the_geom)");
            ResultSet rs = stat.executeQuery("explain select * from test where _ROWID_ = 5");
            this.assertTrue(rs.next());
            this.assertFalse(rs.getString(1).contains("/* PUBLIC.SPATIAL: _ROWID_ = 5 */"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.deleteDb(URL);
    }

    private void testStoreCorruption() throws SQLException {
        this.deleteDb(URL);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(URL);){
            Statement stat = conn.createStatement();
            stat.execute("drop table if exists pt_cloud;\nCREATE TABLE PT_CLOUD AS  SELECT CONCAT('POINT(',A.X,' ',B.X,')')::geometry the_geom from system_range(1e6,1e6+10) A,system_range(6e6,6e6+10) B;\ncreate spatial index pt_index on pt_cloud(the_geom);");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                throw new SQLException(ex);
            }
            stat.execute("drop table if exists pt_cloud;\nCREATE TABLE PT_CLOUD AS  SELECT CONCAT('POINT(',A.X,' ',B.X,')')::geometry the_geom from system_range(1e6,1e6+50) A,system_range(6e6,6e6+50) B;\ncreate spatial index pt_index on pt_cloud(the_geom);\nshutdown compact;");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.deleteDb(URL);
    }

    private void testExplainSpatialIndexWithPk() throws SQLException {
        this.deleteDb(URL);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(URL);){
            Statement stat = conn.createStatement();
            stat.execute("drop table if exists pt_cloud;");
            stat.execute("CREATE TABLE PT_CLOUD(id serial, the_geom geometry)");
            stat.execute("INSERT INTO PT_CLOUD(the_geom) SELECT 'POINT(' || A.X || ' ' || B.X || ')' from system_range(0,120) A,system_range(0,10) B;");
            stat.execute("create spatial index on pt_cloud(the_geom);");
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (ResultSet rs = stat.executeQuery("explain select * from  PT_CLOUD where the_geom && 'POINT(1 1)'");){
                this.assertTrue(rs.next());
                this.assertFalse("H2 should use spatial index got this explain:\n" + rs.getString(1), rs.getString(1).contains("tableScan"));
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.deleteDb(URL);
    }

    private void testNullableGeometry() throws SQLException {
        this.deleteDb(URL);
        Connection conn = this.getConnection(URL);
        Statement stat = conn.createStatement();
        stat.execute("create memory table test(id int primary key, the_geom geometry)");
        stat.execute("create spatial index on test(the_geom)");
        stat.execute("insert into test values(1, null)");
        stat.execute("insert into test values(2, null)");
        stat.execute("delete from test where the_geom is null");
        stat.execute("insert into test values(1, null)");
        stat.execute("insert into test values(2, null)");
        stat.execute("insert into test values(3, 'POLYGON ((1000 2000, 1000 3000, 2000 3000, 1000 2000))')");
        stat.execute("insert into test values(4, null)");
        stat.execute("insert into test values(5, null)");
        stat.execute("insert into test values(6, 'POLYGON ((1000 3000, 1000 4000, 2000 4000, 1000 3000))')");
        ResultSet rs = stat.executeQuery("select * from test");
        int count = 0;
        while (rs.next()) {
            ++count;
            int id = rs.getInt(1);
            if (id == 3 || id == 6) {
                this.assertNotNull(rs.getObject(2));
                continue;
            }
            this.assertNull(rs.getObject(2));
        }
        this.assertEquals(6, count);
        rs = stat.executeQuery("select * from test where the_geom is null");
        count = 0;
        while (rs.next()) {
            ++count;
            this.assertNull(rs.getObject(2));
        }
        this.assertEquals(4, count);
        rs = stat.executeQuery("select * from test where the_geom is not null");
        count = 0;
        while (rs.next()) {
            ++count;
            this.assertNotNull(rs.getObject(2));
        }
        this.assertEquals(2, count);
        rs = stat.executeQuery("select * from test where intersects(the_geom, 'POLYGON ((1000 1000, 1000 2000, 2000 2000, 1000 1000))')");
        conn.close();
        if (!this.config.memory) {
            conn = this.getConnection(URL);
            stat = conn.createStatement();
            rs = stat.executeQuery("select * from test");
            this.assertTrue(rs.next());
            this.assertEquals(1, rs.getInt(1));
            this.assertNull(rs.getObject(2));
            conn.close();
        }
        this.deleteDb(URL);
    }

    private void testNullableGeometryDelete() throws SQLException {
        this.deleteDb(URL);
        Connection conn = this.getConnection(URL);
        Statement stat = conn.createStatement();
        stat.execute("create memory table test(id int primary key, the_geom geometry)");
        stat.execute("create spatial index on test(the_geom)");
        stat.execute("insert into test values(1, null)");
        stat.execute("insert into test values(2, null)");
        stat.execute("insert into test values(3, null)");
        ResultSet rs = stat.executeQuery("select * from test order by id");
        while (rs.next()) {
            this.assertNull(rs.getObject(2));
        }
        stat.execute("delete from test where id = 1");
        stat.execute("delete from test where id = 2");
        stat.execute("delete from test where id = 3");
        stat.execute("insert into test values(4, null)");
        stat.execute("insert into test values(5, null)");
        stat.execute("insert into test values(6, null)");
        stat.execute("delete from test where id = 4");
        stat.execute("delete from test where id = 5");
        stat.execute("delete from test where id = 6");
        conn.close();
        this.deleteDb(URL);
    }

    private void testNullableGeometryInsert() throws SQLException {
        this.deleteDb(URL);
        Connection conn = this.getConnection(URL);
        Statement stat = conn.createStatement();
        stat.execute("create memory table test(id identity, the_geom geometry)");
        stat.execute("create spatial index on test(the_geom)");
        int i = 0;
        while (i < 1000) {
            stat.execute("insert into test(the_geom) values null");
            ++i;
        }
        ResultSet rs = stat.executeQuery("select * from test");
        while (rs.next()) {
            this.assertNull(rs.getObject(2));
        }
        conn.close();
        this.deleteDb(URL);
    }

    private void testNullableGeometryUpdate() throws SQLException {
        this.deleteDb(URL);
        Connection conn = this.getConnection(URL);
        Statement stat = conn.createStatement();
        stat.execute("create memory table test(id int primary key, the_geom geometry, description varchar2(32))");
        stat.execute("create spatial index on test(the_geom)");
        int i = 0;
        while (i < 1000) {
            stat.execute("insert into test values(" + (i + 1) + ", null, null)");
            ++i;
        }
        ResultSet rs = stat.executeQuery("select * from test");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertNull(rs.getObject(2));
        stat.execute("update test set description='DESCRIPTION' where id = 1");
        stat.execute("update test set description='DESCRIPTION' where id = 2");
        stat.execute("update test set description='DESCRIPTION' where id = 3");
        conn.close();
        this.deleteDb(URL);
    }

    private void testIndexUpdateNullGeometry() throws SQLException {
        this.deleteDb(URL);
        Connection conn = this.getConnection(URL);
        Statement stat = conn.createStatement();
        stat.execute("drop table if exists DUMMY_11;");
        stat.execute("CREATE TABLE PUBLIC.DUMMY_11 (fid serial,  GEOM GEOMETRY);");
        stat.execute("CREATE SPATIAL INDEX PUBLIC_DUMMY_11_SPATIAL_INDEX on PUBLIC.DUMMY_11(GEOM);");
        stat.execute("insert into PUBLIC.DUMMY_11(geom) values(null);");
        stat.execute("update PUBLIC.DUMMY_11 set geom = 'POLYGON ((1 1, 5 1, 5 5, 1 5, 1 1))';");
        try (ResultSet rs = stat.executeQuery("select fid, GEOM from DUMMY_11 where  GEOM && 'POLYGON((1 1,5 1,5 5,1 5,1 1))';");){
            this.assertTrue(rs.next());
            this.assertEquals("POLYGON ((1 1, 5 1, 5 5, 1 5, 1 1))", rs.getString(2));
        }
        stat.execute("update PUBLIC.DUMMY_11 set geom = 'POLYGON ((10 10, 50 10, 50 50, 10 50, 10 10))';");
        rs = stat.executeQuery("select fid, GEOM from DUMMY_11 where  GEOM && 'POLYGON ((10 10, 50 10, 50 50, 10 50, 10 10))';");
        try {
            this.assertTrue(rs.next());
            this.assertEquals("POLYGON ((10 10, 50 10, 50 50, 10 50, 10 10))", rs.getString(2));
        }
        finally {
            rs.close();
        }
        conn.close();
        this.deleteDb(URL);
    }

    private void testInsertNull() throws SQLException {
        this.deleteDb(URL);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(URL);){
            Statement stat = conn.createStatement();
            stat.execute("\ndrop table if exists PUBLIC.DUMMY_12;\nCREATE TABLE PUBLIC.DUMMY_12 (\n    \"fid\" serial,\n    Z_ID INTEGER,\n    GEOM GEOMETRY,\n    CONSTRAINT CONSTRAINT_DUMMY_12 PRIMARY KEY (\"fid\")\n);\nCREATE INDEX PRIMARY_KEY_DUMMY_12 ON PUBLIC.DUMMY_12 (\"fid\");\nCREATE spatial INDEX PUBLIC_DUMMY_12_SPATIAL_INDEX_ ON PUBLIC.DUMMY_12 (GEOM);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (123,3125163,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (124,3125164,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (125,3125173,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (126,3125174,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (127,3125175,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (128,3125176,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (129,3125177,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (130,3125178,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (131,3125179,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (132,3125180,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (133,3125335,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (134,3125336,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (135,3125165,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (136,3125337,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (137,3125338,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (138,3125339,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (139,3125340,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (140,3125341,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (141,3125342,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (142,3125343,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (143,3125344,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (144,3125345,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (145,3125346,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (146,3125166,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (147,3125347,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (148,3125348,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (149,3125349,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (150,3125350,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (151,3125351,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (152,3125352,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (153,3125353,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (154,3125354,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (155,3125355,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (156,3125356,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (157,3125167,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (158,3125357,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (159,3125358,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (160,3125359,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (161,3125360,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (162,3125361,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (163,3125362,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (164,3125363,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (165,3125364,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (166,3125365,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (167,3125366,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (168,3125168,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (169,3125367,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (170,3125368,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (171,3125369,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (172,3125370,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (173,3125169,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (174,3125170,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (175,3125171,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (176,3125172,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (177,-2,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (178,-1,NULL);\nINSERT INTO PUBLIC.DUMMY_12 (\"fid\",Z_ID,GEOM) VALUES (179,-1,NULL);");
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (ResultSet rs = stat.executeQuery("select * from DUMMY_12");){
                this.assertTrue(rs.next());
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.deleteDb(URL);
    }

    private void testSpatialIndexWithOrder() throws SQLException {
        this.deleteDb(URL);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(URL);){
            Statement stat = conn.createStatement();
            stat.execute("DROP TABLE IF EXISTS BUILDINGS;CREATE TABLE BUILDINGS (PK BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, THE_GEOM geometry);insert into buildings(the_geom) SELECT 'POINT(1 1)'::geometry from SYSTEM_RANGE(1,10000);\nCREATE SPATIAL INDEX ON PUBLIC.BUILDINGS(THE_GEOM);\n");
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (ResultSet rs = stat.executeQuery("EXPLAIN SELECT * FROM BUILDINGS ORDER BY PK LIMIT 51;");){
                this.assertTrue(rs.next());
                this.assertTrue(rs.getString(1).contains("PRIMARY_KEY"));
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.deleteDb(URL);
    }

    public static class TableEnvelope
    implements Aggregate {
        private Envelope tableEnvelope;

        @Override
        public int getInternalType(int[] inputTypes) throws SQLException {
            int[] nArray = inputTypes;
            int n = inputTypes.length;
            int n2 = 0;
            while (n2 < n) {
                int inputType = nArray[n2];
                if (inputType != 37) {
                    throw new SQLException("TableEnvelope accept only Geometry argument");
                }
                ++n2;
            }
            return 37;
        }

        @Override
        public void init(Connection conn) throws SQLException {
            this.tableEnvelope = null;
        }

        @Override
        public void add(Object value) throws SQLException {
            if (value instanceof Geometry) {
                if (this.tableEnvelope == null) {
                    this.tableEnvelope = ((Geometry)value).getEnvelopeInternal();
                } else {
                    this.tableEnvelope.expandToInclude(((Geometry)value).getEnvelopeInternal());
                }
            }
        }

        @Override
        public Object getResult() throws SQLException {
            return new GeometryFactory().toGeometry(this.tableEnvelope);
        }
    }
}

