/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestSpeed
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb("speed");
        Connection conn = this.getConnection("speed");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        int len = this.getSize(1, 10000);
        int i = 0;
        while (i < len) {
            stat.execute("SELECT ID, NAME FROM TEST ORDER BY ID");
            ++i;
        }
        long time = System.nanoTime();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE CACHED TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        int max = this.getSize(1, 10000);
        int i2 = 0;
        while (i2 < max) {
            prep.setInt(1, i2);
            prep.setString(2, "abchelloasdfaldsjflajdflajdslfoajlskdfkjasdfabcfasdfadsfadfsalksdjflasjflajsdlkfjaksdjflkskd" + i2);
            prep.execute();
            ++i2;
        }
        time = System.nanoTime() - time;
        this.trace(TimeUnit.NANOSECONDS.toMillis(time) + " insert");
        time = System.nanoTime();
        prep = conn.prepareStatement("UPDATE TEST SET NAME='Another data row which is long' WHERE ID=?");
        i2 = 0;
        while (i2 < max) {
            prep.setInt(1, i2);
            prep.execute();
            ++i2;
        }
        time = System.nanoTime() - time;
        this.trace(TimeUnit.NANOSECONDS.toMillis(time) + " update");
        time = System.nanoTime();
        conn.close();
        time = System.nanoTime() - time;
        this.trace(TimeUnit.NANOSECONDS.toMillis(time) + " close");
        this.deleteDb("speed");
    }
}

