/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestSubqueryPerformanceOnLazyExecutionMode
extends TestDb {
    private static final int ROWS = 5000;
    private static final int FAIL_REPEATS = 5;

    public static void main(String[] a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.ci;
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("lazySubq");
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("lazySubq");){
                Throwable throwable2 = null;
                Object var5_8 = null;
                try (Statement stmt = conn.createStatement();){
                    stmt.execute("CREATE TABLE one (x INTEGER, y INTEGER )");
                    Throwable throwable3 = null;
                    Object var8_13 = null;
                    try (PreparedStatement prep = conn.prepareStatement("insert into one values (?,?)");){
                        int row = 0;
                        while (row < 5000) {
                            prep.setInt(1, row / 100);
                            prep.setInt(2, row);
                            prep.execute();
                            ++row;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    this.testSubqueryInCondition(stmt);
                    this.testSubqueryInJoin(stmt);
                    this.testSubqueryInJoinFirst(stmt);
                    this.testJoinTwoSubqueries(stmt);
                    this.testSubqueryInNestedJoin(stmt);
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("lazySubq");
        }
    }

    private void testSubqueryInCondition(Statement stmt) throws Exception {
        String sql = "SELECT COUNT (*) FROM one WHERE x IN (SELECT y FROM one WHERE y < 50)";
        this.checkExecutionTime(stmt, sql);
    }

    private void testSubqueryInJoin(Statement stmt) throws Exception {
        String sql = "SELECT COUNT (one.x) FROM one JOIN (SELECT y AS val FROM one WHERE y < 50) AS subq ON subq.val=one.x";
        this.checkExecutionTime(stmt, sql);
    }

    private void testSubqueryInJoinFirst(Statement stmt) throws Exception {
        String sql = "SELECT COUNT (one.x) FROM (SELECT y AS val FROM one WHERE y < 50) AS subq JOIN one ON subq.val=one.x";
        this.checkExecutionTime(stmt, sql);
    }

    private void testJoinTwoSubqueries(Statement stmt) throws Exception {
        String sql = "SELECT COUNT (one_sub.x) FROM (SELECT y AS val FROM one WHERE y < 50) AS subq JOIN (SELECT x FROM one) AS one_sub ON subq.val=one_sub.x";
        this.checkExecutionTime(stmt, sql);
    }

    private void testSubqueryInNestedJoin(Statement stmt) throws Exception {
        String sql = "SELECT COUNT (one.x) FROM one LEFT JOIN (SELECT 1 AS val_1) AS subq0 JOIN (SELECT y AS val FROM one WHERE y < 30) AS subq1 ON subq0.val_1 < subq1.val ON one.x = subq1.val WHERE one.x < 30";
        this.checkExecutionTime(stmt, sql, 3000);
    }

    private void checkExecutionTime(Statement stmt, String sql) throws Exception {
        this.checkExecutionTime(stmt, sql, 5000);
    }

    private void checkExecutionTime(Statement stmt, String sql, int expected) throws Exception {
        long totalNotLazy = 0L;
        long totalLazy = 0L;
        int successCnt = 0;
        int failCnt = 0;
        int i = 0;
        while (i < 5) {
            long tLazy = this.executeAndCheckResult(stmt, sql, true, expected);
            long tNotLazy = this.executeAndCheckResult(stmt, sql, false, expected);
            totalNotLazy += tNotLazy;
            totalLazy += tLazy;
            if (tNotLazy * 2L > tLazy) {
                ++successCnt;
                if (i == 0) {
                    break;
                }
            } else {
                ++failCnt;
            }
            ++i;
        }
        if (failCnt > successCnt) {
            this.fail("Lazy execution too slow. Avg lazy time: " + totalLazy / 5L + ", avg not lazy time: " + totalNotLazy / 5L);
        }
    }

    private long executeAndCheckResult(Statement stmt, String sql, boolean lazy, int expected) throws SQLException {
        if (lazy) {
            stmt.execute("SET LAZY_QUERY_EXECUTION 1");
        } else {
            stmt.execute("SET LAZY_QUERY_EXECUTION 0");
        }
        long t0 = System.currentTimeMillis();
        Throwable throwable = null;
        Object var8_8 = null;
        try (ResultSet rs = stmt.executeQuery(sql);){
            rs.next();
            this.assertEquals(expected, rs.getInt(1));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return System.currentTimeMillis() - t0;
    }
}

