/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.engine.SessionLocal;
import org.h2.jdbc.JdbcConnection;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestView
extends TestDb {
    private static int x;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb("view");
        this.testSubSubQuery();
        this.testSubQueryViewIndexCache();
        this.testInnerSelectWithRownum();
        this.testInnerSelectWithRange();
        this.testEmptyColumn();
        this.testChangeSchemaSearchPath();
        this.testParameterizedView();
        this.testCache();
        this.testCacheFunction(true);
        this.testCacheFunction(false);
        this.testInSelect();
        this.testUnionReconnect();
        this.testManyViews();
        this.testReferenceView();
        this.testViewAlterAndCommandCache();
        this.deleteDb("view");
    }

    private void testSubSubQuery() throws SQLException {
        Connection conn = this.getConnection("view");
        Statement stat = conn.createStatement();
        stat.execute("drop table test if exists");
        stat.execute("create table test(a int, b int, c int)");
        stat.execute("insert into test values(1, 1, 1)");
        ResultSet rs = stat.executeQuery("select 1 x from (select a, b, c from (select * from test) bbb where bbb.a >=1 and bbb.a <= 1) sp where sp.a = 1 and sp.b = 1 and sp.c = 1");
        this.assertTrue(rs.next());
        conn.close();
    }

    private void testSubQueryViewIndexCache() throws SQLException {
        if (this.config.networked) {
            return;
        }
        Connection conn = this.getConnection("view");
        Statement stat = conn.createStatement();
        stat.execute("drop table test if exists");
        stat.execute("create table test(id int primary key, name varchar(25) unique, age int unique)");
        SessionLocal s = (SessionLocal)((JdbcConnection)conn).getSession();
        s.clearViewIndexCache();
        this.assertTrue(s.getViewIndexCache(true).isEmpty());
        this.assertTrue(s.getViewIndexCache(false).isEmpty());
        stat.execute("create view v as select * from test");
        this.assertTrue(s.getViewIndexCache(true).isEmpty());
        this.assertTrue(s.getViewIndexCache(false).isEmpty());
        stat.executeQuery("select * from v where id > 0").next();
        int size1 = s.getViewIndexCache(false).size();
        this.assertTrue(size1 > 0);
        this.assertTrue(s.getViewIndexCache(true).isEmpty());
        stat.executeQuery("select * from v where name = 'xyz'").next();
        int size2 = s.getViewIndexCache(false).size();
        this.assertTrue(size2 > size1);
        this.assertTrue(s.getViewIndexCache(true).isEmpty());
        stat.executeQuery("select * from (select * from test) where age = 17").next();
        int size3 = s.getViewIndexCache(false).size();
        this.assertEquals(size2, size3);
        this.assertTrue(s.getViewIndexCache(true).isEmpty());
        s.clearViewIndexCache();
        this.assertTrue(s.getViewIndexCache(false).isEmpty());
        this.assertTrue(s.getViewIndexCache(true).isEmpty());
        stat.execute("drop view v");
        stat.execute("drop table test");
        conn.close();
    }

    private void testInnerSelectWithRownum() throws SQLException {
        Connection conn = this.getConnection("view");
        Statement stat = conn.createStatement();
        stat.execute("drop table test if exists");
        stat.execute("create table test(id int primary key, name varchar(1))");
        stat.execute("insert into test(id, name) values(1, 'b'), (3, 'a')");
        ResultSet rs = stat.executeQuery("select nr from (select rownum() as nr, a.id as id from (select id from test order by name) as a) as b where b.id = 1;");
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("select nr from (select row_number() over() as nr, a.id as id from (select id from test order by name) as a) as b where b.id = 1;");
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertFalse(rs.next());
        stat.execute("drop table test");
        conn.close();
    }

    private void testInnerSelectWithRange() throws SQLException {
        Connection conn = this.getConnection("view");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select x from (select x from (select x from system_range(1, 5)) where x > 2 and x < 4) where x = 3");
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        rs = stat.executeQuery("select x from (select x from (select x from system_range(1, 5)) where x = 3) where x > 2 and x < 4");
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testEmptyColumn() throws SQLException {
        this.deleteDb("view");
        Connection conn = this.getConnection("view");
        Statement stat = conn.createStatement();
        stat.execute("create table test(a int, b int)");
        stat.execute("create view test_view as select a, b from test");
        stat.execute("select * from test_view where a between 1 and 2 and b = 2");
        conn.close();
    }

    private void testChangeSchemaSearchPath() throws SQLException {
        this.deleteDb("view");
        Connection conn = this.getConnection("view");
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS X AS $$ int x() { return 1; } $$;");
        stat.execute("CREATE SCHEMA S");
        stat.execute("CREATE VIEW S.TEST AS SELECT X() FROM DUAL");
        stat.execute("SET SCHEMA=S");
        stat.execute("SET SCHEMA_SEARCH_PATH=S");
        stat.execute("SELECT * FROM TEST");
        conn.close();
    }

    private void testParameterizedView() throws SQLException {
        this.deleteDb("view");
        Connection conn = this.getConnection("view");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE Test(id INT AUTO_INCREMENT NOT NULL, f1 VARCHAR NOT NULL, f2 VARCHAR NOT NULL)");
        stat.execute("INSERT INTO Test(f1, f2) VALUES ('value1','value2')");
        stat.execute("INSERT INTO Test(f1, f2) VALUES ('value1','value3')");
        PreparedStatement ps = conn.prepareStatement("CREATE VIEW Test_View AS SELECT f2 FROM Test WHERE f1=?");
        ps.setString(1, "value1");
        this.assertThrows(50100, ps).executeUpdate();
        conn.close();
    }

    private void testCacheFunction(boolean deterministic) throws SQLException {
        this.deleteDb("view");
        Connection conn = this.getConnection("view");
        Statement stat = conn.createStatement();
        x = 8;
        stat.execute("CREATE ALIAS GET_X " + (deterministic ? "DETERMINISTIC" : "") + " FOR '" + this.getClass().getName() + ".getX'");
        stat.execute("CREATE VIEW V AS SELECT * FROM (SELECT GET_X())");
        ResultSet rs = stat.executeQuery("SELECT * FROM V");
        rs.next();
        this.assertEquals(8, rs.getInt(1));
        x = 5;
        rs = stat.executeQuery("SELECT * FROM V");
        rs.next();
        this.assertEquals(deterministic ? 8 : 5, rs.getInt(1));
        conn.close();
    }

    public static int getX() {
        return x;
    }

    private void testCache() throws SQLException {
        this.deleteDb("view");
        Connection conn = this.getConnection("view");
        Statement stat = conn.createStatement();
        stat.execute("SET @X 8");
        stat.execute("CREATE VIEW V AS SELECT * FROM (SELECT @X)");
        ResultSet rs = stat.executeQuery("SELECT * FROM V");
        rs.next();
        this.assertEquals(8, rs.getInt(1));
        stat.execute("SET @X 5");
        rs = stat.executeQuery("SELECT * FROM V");
        rs.next();
        this.assertEquals(5, rs.getInt(1));
        conn.close();
    }

    private void testInSelect() throws SQLException {
        this.deleteDb("view");
        Connection conn = this.getConnection("view");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key) as select 1");
        PreparedStatement prep = conn.prepareStatement("select * from test t where t.id in (select t2.id from test t2 where t2.id in (?, ?))");
        prep.setInt(1, 1);
        prep.setInt(2, 2);
        prep.execute();
        conn.close();
    }

    private void testUnionReconnect() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("view");
        Connection conn = this.getConnection("view");
        Statement stat = conn.createStatement();
        stat.execute("create table t1(k smallint, ts timestamp(6))");
        stat.execute("create table t2(k smallint, ts timestamp(6))");
        stat.execute("create table t3(k smallint, ts timestamp(6))");
        stat.execute("create view v_max_ts as select max(ts) from (select max(ts) as ts from t1 union select max(ts) as ts from t2 union select max(ts) as ts from t3)");
        stat.execute("create view v_test as select max(ts) as ts from t1 union select max(ts) as ts from t2 union select max(ts) as ts from t3");
        conn.close();
        conn = this.getConnection("view");
        stat = conn.createStatement();
        stat.execute("select * from v_max_ts");
        conn.close();
        this.deleteDb("view");
    }

    private void testManyViews() throws SQLException {
        this.deleteDb("view");
        Connection conn = this.getConnection("view");
        Statement s = conn.createStatement();
        s.execute("create table t0(id int primary key)");
        s.execute("insert into t0 values(1), (2), (3)");
        int i = 0;
        while (i < 30) {
            s.execute("create view t" + (i + 1) + " as select * from t" + i);
            s.execute("select * from t" + (i + 1));
            ResultSet rs = s.executeQuery("select count(*) from t" + (i + 1) + " where id=2");
            this.assertTrue(rs.next());
            this.assertEquals(1, rs.getInt(1));
            ++i;
        }
        conn.close();
        conn = this.getConnection("view");
        conn.close();
        this.deleteDb("view");
    }

    private void testReferenceView() throws SQLException {
        this.deleteDb("view");
        Connection conn = this.getConnection("view");
        Statement s = conn.createStatement();
        s.execute("create table t0(id int primary key)");
        s.execute("create view t1 as select * from t0");
        this.assertThrows(50100, s).execute("create table t2(id int primary key, col1 int not null, foreign key (col1) references t1(id))");
        conn.close();
        this.deleteDb("view");
    }

    private void testViewAlterAndCommandCache() throws SQLException {
        this.deleteDb("view");
        Connection conn = this.getConnection("view");
        Statement stat = conn.createStatement();
        stat.execute("create table t0(id int primary key)");
        stat.execute("create table t1(id int primary key)");
        stat.execute("insert into t0 values(0)");
        stat.execute("insert into t1 values(1)");
        stat.execute("create view v1 as select * from t0");
        ResultSet rs = stat.executeQuery("select * from v1");
        this.assertTrue(rs.next());
        this.assertEquals(0, rs.getInt(1));
        stat.execute("create or replace view v1 as select * from t1");
        rs = stat.executeQuery("select * from v1");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        conn.close();
        this.deleteDb("view");
    }
}

