/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestViewAlterTable
extends TestDb {
    private Connection conn;
    private Statement stat;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb(this.getTestName());
        this.conn = this.getConnection(this.getTestName());
        this.stat = this.conn.createStatement();
        this.testDropColumnWithoutViews();
        this.testViewsAreWorking();
        this.testAlterTableDropColumnNotInView();
        this.testAlterTableDropColumnInView();
        this.testAlterTableAddColumnWithView();
        this.testAlterTableAlterColumnDataTypeWithView();
        this.testSelectStar();
        this.testJoinAndAlias();
        this.testSubSelect();
        this.testForeignKey();
        this.testAlterTableDropColumnInViewWithDoubleQuotes();
        this.conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testDropColumnWithoutViews() throws SQLException {
        this.stat.execute("create table test(a int, b int, c int)");
        this.stat.execute("alter table test drop column c");
        this.stat.execute("drop table test");
    }

    private void testViewsAreWorking() throws SQLException {
        this.createTestData();
        this.checkViewRemainsValid();
    }

    private void testAlterTableDropColumnNotInView() throws SQLException {
        this.createTestData();
        this.stat.execute("alter table test drop column c");
        this.checkViewRemainsValid();
    }

    private void testAlterTableDropColumnInView() throws SQLException {
        this.stat.execute("create table test(id identity, name varchar) as select 1, 'Hello' from dual");
        this.stat.execute("create view test_view as select * from test");
        this.assertThrows(90083, this.stat).execute("alter table test drop name");
        ResultSet rs = this.stat.executeQuery("select * from test_view");
        this.assertTrue(rs.next());
        this.stat.execute("drop view test_view");
        this.stat.execute("drop table test");
        this.createTestData();
        this.assertThrows(90083, this.stat).execute("alter table test drop column a");
        this.stat.execute("drop table test cascade");
    }

    private void testAlterTableAddColumnWithView() throws SQLException {
        this.createTestData();
        this.stat.execute("alter table test add column d int");
        this.checkViewRemainsValid();
    }

    private void testAlterTableAlterColumnDataTypeWithView() throws SQLException {
        this.createTestData();
        this.stat.execute("alter table test alter b char(1)");
        this.checkViewRemainsValid();
    }

    private void testSelectStar() throws SQLException {
        this.createTestData();
        this.stat.execute("create view v4 as select * from test");
        this.stat.execute("alter table test add d int default 6");
        this.assertThrows(42122, this.stat).executeQuery("select d from v4");
        this.checkViewRemainsValid();
    }

    private void testJoinAndAlias() throws SQLException {
        this.createTestData();
        this.stat.execute("create view v4 as select v1.a dog, v3.a cat from v1 join v3 on v1.b = v3.a");
        this.stat.execute("alter table test add d int default 6");
        ResultSet rs = this.stat.executeQuery("select cat, dog from v4");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals(2, rs.getInt(2));
        this.assertFalse(rs.next());
        this.checkViewRemainsValid();
    }

    private void testSubSelect() throws SQLException {
        this.createTestData();
        this.stat.execute("create view v4 as select * from v3 where a in (select b from v2)");
        this.stat.execute("alter table test add d int default 6");
        ResultSet rs = this.stat.executeQuery("select a from v4");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertFalse(rs.next());
        this.checkViewRemainsValid();
    }

    private void testForeignKey() throws SQLException {
        this.createTestData();
        this.stat.execute("create table test2(z int, a int, primary key(z), foreign key (a) references TEST(a))");
        this.stat.execute("insert into test2(z, a) values (99, 1)");
        this.stat.execute("alter table test add d int default 6");
        ResultSet rs = this.stat.executeQuery("select z from test2");
        this.assertTrue(rs.next());
        this.assertEquals(99, rs.getInt(1));
        this.assertFalse(rs.next());
        this.stat.execute("drop table test2");
        this.checkViewRemainsValid();
    }

    private void createTestData() throws SQLException {
        this.stat.execute("create table test(a int primary key, b int, c int)");
        this.stat.execute("insert into test(a, b, c) values (1, 2, 3)");
        this.stat.execute("create view v1 as select a as b, b as a from test");
        this.stat.execute("create view v2 as select * from v1");
        this.stat.execute("create user if not exists test_user password 'x'");
        this.stat.execute("grant select on v2 to test_user");
        this.stat.execute("create view v3 as select a from test");
    }

    private void checkViewRemainsValid() throws SQLException {
        ResultSet rs = this.stat.executeQuery("select b from v1");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertFalse(rs.next());
        rs = this.stat.executeQuery("select b from v2");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertFalse(rs.next());
        rs = this.stat.executeQuery("select * from information_schema.rights");
        this.assertTrue(rs.next());
        this.assertEquals("TEST_USER", rs.getString("GRANTEE"));
        this.assertEquals("V2", rs.getString("TABLE_NAME"));
        rs = this.stat.executeQuery("select b from test");
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertFalse(rs.next());
        this.stat.execute("drop table test cascade");
        rs = this.conn.getMetaData().getTables(null, null, null, null);
        while (rs.next()) {
            this.assertEquals(rs.getString(2) + "." + rs.getString(3), "INFORMATION_SCHEMA", rs.getString(2));
        }
    }

    private void testAlterTableDropColumnInViewWithDoubleQuotes() throws SQLException {
        this.stat.execute("create table \"test\"(id identity, name varchar) as select 1, 'Hello' from dual");
        this.stat.execute("create view test_view as select * from \"test\"");
        this.assertThrows(90083, this.stat).execute("alter table \"test\" drop name");
        ResultSet rs = this.stat.executeQuery("select * from test_view");
        this.assertTrue(rs.next());
        this.stat.execute("drop view test_view");
        this.stat.execute("drop table \"test\"");
    }
}

