/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestBatchUpdates
extends TestDb {
    private static final String COFFEE_UPDATE = "UPDATE TEST SET PRICE=PRICE*20 WHERE TYPE_ID=?";
    private static final String COFFEE_SELECT = "SELECT PRICE FROM TEST WHERE KEY_ID=?";
    private static final String COFFEE_INSERT1 = "INSERT INTO TEST VALUES(9,'COFFEE-9',9.0,5)";
    private static final String COFFEE_DELETE1 = "DELETE FROM TEST WHERE KEY_ID=9";
    private static final String COFFEE_UPDATE1 = "UPDATE TEST SET PRICE=PRICE*20 WHERE TYPE_ID=1";
    private static final String COFFEE_SELECT1 = "SELECT PRICE FROM TEST WHERE KEY_ID>4";
    private static final String COFFEE_UPDATE_SET = "UPDATE TEST SET KEY_ID=?, C_NAME=? WHERE C_NAME=?";
    private static final String COFFEE_SELECT_CONTINUED = "SELECT COUNT(*) FROM TEST WHERE C_NAME='Continue-1'";
    private static final int COFFEE_SIZE = 10;
    private static final int COFFEE_TYPE = 11;
    private Connection conn;
    private Statement stat;
    private PreparedStatement prep;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.testRootCause();
        this.testExecuteCall();
        this.testException();
        this.testCoffee();
        this.deleteDb("batchUpdates");
    }

    private void testRootCause() throws SQLException {
        this.deleteDb("batchUpdates");
        this.conn = this.getConnection("batchUpdates");
        this.stat = this.conn.createStatement();
        this.stat.addBatch("select * from test_x");
        this.stat.addBatch("select * from test_y");
        try {
            this.stat.executeBatch();
        }
        catch (SQLException e) {
            this.assertContains(e.toString(), "TEST_X");
            e = e.getNextException();
            this.assertNotNull(e);
            this.assertContains(e.toString(), "TEST_X");
            e = e.getNextException();
            this.assertNotNull(e);
            this.assertContains(e.toString(), "TEST_Y");
            e = e.getNextException();
            this.assertNull(e);
        }
        this.stat.execute("create table test(id int)");
        PreparedStatement prep = this.conn.prepareStatement("insert into test values(?)");
        prep.setString(1, "TEST_X");
        prep.addBatch();
        prep.setString(1, "TEST_Y");
        prep.addBatch();
        try {
            prep.executeBatch();
        }
        catch (SQLException e) {
            this.assertContains(e.toString(), "TEST_X");
            e = e.getNextException();
            this.assertNotNull(e);
            this.assertContains(e.toString(), "TEST_X");
            e = e.getNextException();
            this.assertNotNull(e);
            this.assertContains(e.toString(), "TEST_Y");
            e = e.getNextException();
            this.assertNull(e);
        }
        this.stat.execute("drop table test");
        this.conn.close();
    }

    private void testExecuteCall() throws SQLException {
        this.deleteDb("batchUpdates");
        this.conn = this.getConnection("batchUpdates");
        this.stat = this.conn.createStatement();
        this.stat.execute("CREATE ALIAS updatePrices FOR '" + this.getClass().getName() + ".updatePrices'");
        CallableStatement call = this.conn.prepareCall("{call updatePrices(?, ?)}");
        call.setString(1, "Hello");
        call.setFloat(2, 1.4f);
        call.addBatch();
        call.setString(1, "World");
        call.setFloat(2, 3.2f);
        call.addBatch();
        int[] updateCounts = call.executeBatch();
        int total = 0;
        int[] nArray = updateCounts;
        int n = updateCounts.length;
        int n2 = 0;
        while (n2 < n) {
            int t = nArray[n2];
            total += t;
            ++n2;
        }
        this.assertEquals(4, total);
        this.conn.close();
    }

    public static int updatePrices(String message, double f) {
        return (int)f;
    }

    private void testException() throws SQLException {
        this.deleteDb("batchUpdates");
        this.conn = this.getConnection("batchUpdates");
        this.stat = this.conn.createStatement();
        this.stat.execute("create table test(id int primary key)");
        this.prep = this.conn.prepareStatement("insert into test values(?)");
        int i = 0;
        while (i < 700) {
            this.prep.setString(1, "x");
            this.prep.addBatch();
            ++i;
        }
        this.assertThrows(BatchUpdateException.class, this.prep).executeBatch();
        this.conn.close();
    }

    private void testCoffee() throws SQLException {
        this.deleteDb("batchUpdates");
        this.conn = this.getConnection("batchUpdates");
        this.stat = this.conn.createStatement();
        DatabaseMetaData meta = this.conn.getMetaData();
        this.assertTrue(meta.supportsBatchUpdates());
        this.stat.executeUpdate("CREATE TABLE TEST(KEY_ID INT PRIMARY KEY,C_NAME VARCHAR(255),PRICE DECIMAL(20,2),TYPE_ID INT)");
        String newName = null;
        float newPrice = 0.0f;
        int newType = 0;
        this.prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?,?,?,?)");
        int newKey = 1;
        int i = 1;
        while (i <= 11 && newKey <= 10) {
            int j = 1;
            while (j <= i && newKey <= 10) {
                newName = "COFFEE-" + newKey;
                newPrice = (float)newKey + 0.0f;
                newType = i;
                this.prep.setInt(1, newKey);
                this.prep.setString(2, newName);
                this.prep.setFloat(3, newPrice);
                this.prep.setInt(4, newType);
                this.prep.execute();
                ++newKey;
                ++j;
            }
            ++i;
        }
        this.trace("Inserted the Rows ");
        this.testAddBatch01();
        this.testAddBatch02();
        this.testClearBatch01();
        this.testClearBatch02();
        this.testExecuteBatch01();
        this.testExecuteBatch02();
        this.testExecuteBatch03();
        this.testExecuteBatch04();
        this.testExecuteBatch05();
        this.testExecuteBatch06();
        this.testExecuteBatch07();
        this.testContinueBatch01();
        this.conn.close();
    }

    private void testAddBatch01() throws SQLException {
        this.trace("testAddBatch01");
        int i = 0;
        int[] retValue = new int[3];
        String s = COFFEE_UPDATE;
        this.trace("Prepared Statement String:" + s);
        this.prep = this.conn.prepareStatement(s);
        this.assertThrows(90012, this.prep).addBatch();
        this.prep.setInt(1, 2);
        this.prep.addBatch();
        this.prep.setInt(1, 3);
        this.prep.addBatch();
        this.prep.setInt(1, 4);
        this.prep.addBatch();
        int[] updateCount = this.prep.executeBatch();
        int updateCountLen = updateCount.length;
        this.trace("updateCount length:" + updateCountLen);
        this.assertEquals(3, updateCountLen);
        String query1 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=2";
        String query2 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=3";
        String query3 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=4";
        ResultSet rs = this.stat.executeQuery(query1);
        rs.next();
        retValue[i++] = rs.getInt(1);
        rs = this.stat.executeQuery(query2);
        rs.next();
        retValue[i++] = rs.getInt(1);
        rs = this.stat.executeQuery(query3);
        rs.next();
        retValue[i++] = rs.getInt(1);
        int j = 0;
        while (j < updateCount.length) {
            this.trace("UpdateCount:" + updateCount[j]);
            this.assertEquals(updateCount[j], retValue[j]);
            ++j;
        }
    }

    private void testAddBatch02() throws SQLException {
        this.trace("testAddBatch02");
        int i = 0;
        int[] retValue = new int[3];
        int updCountLength = 0;
        String sUpdCoffee = COFFEE_UPDATE1;
        String sDelCoffee = COFFEE_DELETE1;
        String sInsCoffee = COFFEE_INSERT1;
        this.stat.addBatch(sUpdCoffee);
        this.stat.addBatch(sDelCoffee);
        this.stat.addBatch(sInsCoffee);
        int[] updateCount = this.stat.executeBatch();
        updCountLength = updateCount.length;
        this.trace("updateCount Length:" + updCountLength);
        this.assertEquals(3, updCountLength);
        String query1 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=1";
        ResultSet rs = this.stat.executeQuery(query1);
        rs.next();
        retValue[i++] = rs.getInt(1);
        retValue[i++] = 1;
        retValue[i++] = 1;
        this.trace("ReturnValue count : " + retValue.length);
        int j = 0;
        while (j < updateCount.length) {
            this.trace("Update Count:" + updateCount[j]);
            this.trace("Returned Value : " + retValue[j]);
            this.assertEquals("j:" + j, retValue[j], updateCount[j]);
            ++j;
        }
    }

    private void testClearBatch01() throws SQLException {
        this.trace("testClearBatch01");
        String sPrepStmt = COFFEE_UPDATE;
        this.trace("Prepared Statement String:" + sPrepStmt);
        this.prep = this.conn.prepareStatement(sPrepStmt);
        this.prep.setInt(1, 2);
        this.prep.addBatch();
        this.prep.setInt(1, 3);
        this.prep.addBatch();
        this.prep.setInt(1, 4);
        this.prep.addBatch();
        this.prep.clearBatch();
        this.assertEquals(0, this.prep.executeBatch().length);
    }

    private void testClearBatch02() throws SQLException {
        this.trace("testClearBatch02");
        String sUpdCoffee = COFFEE_UPDATE1;
        String sInsCoffee = COFFEE_INSERT1;
        String sDelCoffee = COFFEE_DELETE1;
        this.stat.addBatch(sUpdCoffee);
        this.stat.addBatch(sDelCoffee);
        this.stat.addBatch(sInsCoffee);
        this.stat.clearBatch();
        this.assertEquals(0, this.stat.executeBatch().length);
    }

    private void testExecuteBatch01() throws SQLException {
        this.trace("testExecuteBatch01");
        int i = 0;
        int[] retValue = new int[3];
        int updCountLength = 0;
        String sPrepStmt = COFFEE_UPDATE;
        this.trace("Prepared Statement String:" + sPrepStmt);
        this.prep = this.conn.prepareStatement(sPrepStmt);
        this.prep.setInt(1, 1);
        this.prep.addBatch();
        this.prep.setInt(1, 2);
        this.prep.addBatch();
        this.prep.setInt(1, 3);
        this.prep.addBatch();
        int[] updateCount = this.prep.executeBatch();
        updCountLength = updateCount.length;
        this.trace("Successfully Updated");
        this.trace("updateCount Length:" + updCountLength);
        if (updCountLength != 3) {
            this.fail("executeBatch");
        } else {
            this.trace("executeBatch executes the Batch of SQL statements");
        }
        String query1 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=1";
        String query2 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=2";
        String query3 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=3";
        ResultSet rs = this.stat.executeQuery(query1);
        rs.next();
        retValue[i++] = rs.getInt(1);
        rs = this.stat.executeQuery(query2);
        rs.next();
        retValue[i++] = rs.getInt(1);
        rs = this.stat.executeQuery(query3);
        rs.next();
        retValue[i++] = rs.getInt(1);
        this.trace("retValue length : " + retValue.length);
        int j = 0;
        while (j < updateCount.length) {
            this.trace("UpdateCount Value:" + updateCount[j]);
            this.trace("RetValue : " + retValue[j]);
            if (updateCount[j] != retValue[j]) {
                this.fail("j=" + j + " right:" + retValue[j]);
            }
            ++j;
        }
    }

    private void testExecuteBatch02() throws SQLException {
        this.trace("testExecuteBatch02");
        String sPrepStmt = COFFEE_UPDATE;
        this.trace("Prepared Statement String:" + sPrepStmt);
        this.prep = this.conn.prepareStatement(sPrepStmt);
        this.prep.setInt(1, 1);
        this.prep.setInt(1, 2);
        this.prep.setInt(1, 3);
        int[] updateCount = this.prep.executeBatch();
        int updCountLength = updateCount.length;
        this.trace("UpdateCount Length : " + updCountLength);
        if (updCountLength == 0) {
            this.trace("executeBatch does not execute Empty Batch");
        } else {
            this.fail("executeBatch");
        }
    }

    private void testExecuteBatch03() throws SQLException {
        this.trace("testExecuteBatch03");
        boolean batchExceptionFlag = false;
        String sPrepStmt = COFFEE_SELECT;
        this.trace("Prepared Statement String :" + sPrepStmt);
        this.prep = this.conn.prepareStatement(sPrepStmt);
        this.prep.setInt(1, 1);
        this.prep.addBatch();
        try {
            int[] updateCount = this.prep.executeBatch();
            this.trace("Update Count" + updateCount.length);
        }
        catch (BatchUpdateException b) {
            batchExceptionFlag = true;
        }
        if (batchExceptionFlag) {
            this.trace("select not allowed; correct");
        } else {
            this.fail("executeBatch select");
        }
    }

    private void testExecuteBatch04() throws SQLException {
        this.trace("testExecuteBatch04");
        int i = 0;
        int[] retValue = new int[3];
        int updCountLength = 0;
        String sUpdCoffee = COFFEE_UPDATE1;
        String sInsCoffee = COFFEE_INSERT1;
        String sDelCoffee = COFFEE_DELETE1;
        this.stat.addBatch(sUpdCoffee);
        this.stat.addBatch(sDelCoffee);
        this.stat.addBatch(sInsCoffee);
        int[] updateCount = this.stat.executeBatch();
        updCountLength = updateCount.length;
        this.trace("Successfully Updated");
        this.trace("updateCount Length:" + updCountLength);
        if (updCountLength != 3) {
            this.fail("executeBatch");
        } else {
            this.trace("executeBatch executes the Batch of SQL statements");
        }
        String query1 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=1";
        ResultSet rs = this.stat.executeQuery(query1);
        rs.next();
        retValue[i++] = rs.getInt(1);
        retValue[i++] = 1;
        retValue[i++] = 1;
        int j = 0;
        while (j < updateCount.length) {
            this.trace("Update Count : " + updateCount[j]);
            if (updateCount[j] != retValue[j]) {
                this.fail("j=" + j + " right:" + retValue[j]);
            }
            ++j;
        }
    }

    private void testExecuteBatch05() throws SQLException {
        this.trace("testExecuteBatch05");
        int updCountLength = 0;
        int[] updateCount = this.stat.executeBatch();
        updCountLength = updateCount.length;
        this.trace("updateCount Length:" + updCountLength);
        if (updCountLength == 0) {
            this.trace("executeBatch Method does not execute the Empty Batch ");
        } else {
            this.fail("executeBatch 0!=" + updCountLength);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void testExecuteBatch06() throws SQLException {
        block5: {
            this.trace("testExecuteBatch06");
            batchExceptionFlag = false;
            sInsCoffee = "INSERT INTO TEST VALUES(9,'COFFEE-9',9.0,5)";
            sDelCoffee = "DELETE FROM TEST WHERE KEY_ID=9";
            this.stat.addBatch(sInsCoffee);
            this.stat.addBatch(sInsCoffee);
            this.stat.addBatch(sDelCoffee);
            try {
                this.stat.executeBatch();
                break block5;
            }
            catch (BatchUpdateException b) {
                batchExceptionFlag = true;
                var8_5 = b.getUpdateCounts();
                var7_6 = var8_5.length;
                var6_7 = 0;
                ** while (var6_7 < var7_6)
            }
lbl-1000:
            // 1 sources

            {
                uc = var8_5[var6_7];
                this.trace("Update counts:" + uc);
                ++var6_7;
                continue;
            }
        }
        if (batchExceptionFlag) {
            this.trace("executeBatch insert duplicate; correct");
        } else {
            this.fail("executeBatch");
        }
    }

    private void testExecuteBatch07() throws SQLException {
        this.trace("testExecuteBatch07");
        boolean batchExceptionFlag = false;
        String selectCoffee = COFFEE_SELECT1;
        this.trace("selectCoffee = " + selectCoffee);
        Statement stmt = this.conn.createStatement();
        stmt.addBatch(selectCoffee);
        try {
            int[] updateCount = stmt.executeBatch();
            this.trace("updateCount Length : " + updateCount.length);
        }
        catch (BatchUpdateException be) {
            batchExceptionFlag = true;
        }
        if (batchExceptionFlag) {
            this.trace("executeBatch select");
        } else {
            this.fail("executeBatch");
        }
    }

    private void testContinueBatch01() throws SQLException {
        this.trace("testContinueBatch01");
        int[] batchUpdates = new int[3];
        int buCountLen = 0;
        try {
            String sPrepStmt = COFFEE_UPDATE_SET;
            this.trace("Prepared Statement String:" + sPrepStmt);
            this.prep = this.conn.prepareStatement(sPrepStmt);
            this.prep.setInt(1, 1);
            this.prep.setString(2, "Continue-1");
            this.prep.setString(3, "COFFEE-1");
            this.prep.addBatch();
            this.prep.setInt(1, 1);
            this.prep.setString(2, "Invalid");
            this.prep.setString(3, "COFFEE-3");
            this.prep.addBatch();
            this.prep.setInt(1, 2);
            this.prep.setString(2, "Continue-2");
            this.prep.setString(3, "COFFEE-2");
            this.prep.addBatch();
            this.prep.executeBatch();
        }
        catch (BatchUpdateException b) {
            this.trace("expected BatchUpdateException");
            batchUpdates = b.getUpdateCounts();
            buCountLen = batchUpdates.length;
        }
        if (buCountLen == 1) {
            this.trace("no continued updates - OK");
            return;
        }
        if (buCountLen == 3) {
            this.trace("Driver supports continued updates.");
            String query = COFFEE_SELECT_CONTINUED;
            this.trace("Query is: " + query);
            ResultSet rs = this.stat.executeQuery(query);
            rs.next();
            int count = rs.getInt(1);
            rs.close();
            this.stat.close();
            this.trace("Count val is: " + count);
            if (batchUpdates[1] != -3 || count != 1) {
                this.fail("insert failed");
            }
        }
    }
}

