/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.TimeZone;
import org.h2.engine.SysProperties;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.DateTimeUtils;

public class TestConnection
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testSetSupportedClientInfo();
        this.testSetUnsupportedClientInfo();
        this.testGetUnsupportedClientInfo();
        this.testSetSupportedClientInfoProperties();
        this.testSetUnsupportedClientInfoProperties();
        this.testSetInternalProperty();
        this.testSetInternalPropertyToInitialValue();
        this.testTransactionIsolationSetAndGet();
        this.testSetGetSchema();
        this.testCommitOnAutoCommitSetRunner();
        this.testRollbackOnAutoCommitSetRunner();
        this.testChangeTransactionLevelCommitRunner();
        this.testLockTimeout();
        this.testIgnoreUnknownSettings();
        this.testTimeZone();
    }

    private void testSetInternalProperty() throws SQLException {
        Connection conn = this.getConnection("clientInfoMySQL;MODE=MySQL");
        this.assertThrows(SQLClientInfoException.class, conn).setClientInfo("numServers", "SomeValue");
        this.assertThrows(SQLClientInfoException.class, conn).setClientInfo("server23", "SomeValue");
        conn.close();
    }

    private void testSetInternalPropertyToInitialValue() throws SQLException {
        Connection conn = this.getConnection("clientInfoMySQL;MODE=MySQL");
        String numServersPropertyName = "numServers";
        String numServers = conn.getClientInfo(numServersPropertyName);
        conn.setClientInfo(numServersPropertyName, numServers);
        this.assertEquals(conn.getClientInfo(numServersPropertyName), numServers);
        conn.close();
    }

    private void testSetUnsupportedClientInfoProperties() throws SQLException {
        Connection conn = this.getConnection("clientInfo");
        Properties properties = new Properties();
        properties.put("ClientUser", "someUser");
        this.assertThrows(SQLClientInfoException.class, conn).setClientInfo(properties);
        conn.close();
    }

    private void testSetSupportedClientInfoProperties() throws SQLException {
        Connection conn = this.getConnection("clientInfoDB2;MODE=DB2");
        conn.setClientInfo("ApplicationName", "Connection Test");
        Properties properties = new Properties();
        properties.put("ClientUser", "someUser");
        conn.setClientInfo(properties);
        this.assertNull(conn.getClientInfo("ApplicationName"));
        this.assertEquals(conn.getClientInfo("ClientUser"), "someUser");
        conn.close();
    }

    private void testSetSupportedClientInfo() throws SQLException {
        Connection conn = this.getConnection("clientInfoDB2;MODE=DB2");
        conn.setClientInfo("ApplicationName", "Connection Test");
        this.assertEquals(conn.getClientInfo("ApplicationName"), "Connection Test");
        conn.close();
    }

    private void testSetUnsupportedClientInfo() throws SQLException {
        Connection conn = this.getConnection("clientInfoDB2;MODE=DB2");
        this.assertThrows(SQLClientInfoException.class, conn).setClientInfo("UnsupportedName", "SomeValue");
        conn.close();
    }

    private void testGetUnsupportedClientInfo() throws SQLException {
        Connection conn = this.getConnection("clientInfo");
        this.assertNull(conn.getClientInfo("UnknownProperty"));
        conn.close();
    }

    private void testTransactionIsolationSetAndGet() throws Exception {
        this.deleteDb("transactionIsolation");
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("transactionIsolation");){
                this.assertEquals(2, conn.getTransactionIsolation());
                conn.setTransactionIsolation(1);
                this.assertEquals(1, conn.getTransactionIsolation());
                conn.setTransactionIsolation(4);
                this.assertEquals(4, conn.getTransactionIsolation());
                conn.setTransactionIsolation(6);
                this.assertEquals(6, conn.getTransactionIsolation());
                conn.setTransactionIsolation(8);
                this.assertEquals(8, conn.getTransactionIsolation());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("transactionIsolation");
        }
    }

    private void testCommitOnAutoCommitSetRunner() throws Exception {
        this.assertFalse("Default value must be false", SysProperties.FORCE_AUTOCOMMIT_OFF_ON_COMMIT);
        this.testCommitOnAutoCommitSet(false);
        try {
            SysProperties.FORCE_AUTOCOMMIT_OFF_ON_COMMIT = true;
            this.testCommitOnAutoCommitSet(true);
        }
        finally {
            SysProperties.FORCE_AUTOCOMMIT_OFF_ON_COMMIT = false;
        }
    }

    private void testCommitOnAutoCommitSet(boolean expectedPropertyEnabled) throws Exception {
        this.assertEquals(SysProperties.FORCE_AUTOCOMMIT_OFF_ON_COMMIT, expectedPropertyEnabled);
        Connection conn = this.getConnection("clientInfo");
        conn.setAutoCommit(false);
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        int index = 1;
        prep.setInt(index++, 1);
        prep.setString(index++, "test1");
        prep.execute();
        conn.commit();
        conn.setAutoCommit(true);
        index = 1;
        prep.setInt(index++, 2);
        prep.setString(index++, "test2");
        if (expectedPropertyEnabled) {
            prep.execute();
            try {
                conn.commit();
                throw new AssertionError((Object)"SQLException expected");
            }
            catch (SQLException e) {
                this.assertTrue(e.getMessage().contains("commit()"));
                this.assertEquals(90147, e.getErrorCode());
                ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM TEST");
                rs.next();
                this.assertTrue(rs.getInt(1) == 2);
                rs.close();
            }
        } else {
            prep.execute();
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM TEST");
            rs.next();
            this.assertTrue(rs.getInt(1) == 2);
            rs.close();
        }
        conn.close();
        prep.close();
    }

    private void testChangeTransactionLevelCommitRunner() throws Exception {
        this.assertFalse("Default value must be false", SysProperties.FORCE_AUTOCOMMIT_OFF_ON_COMMIT);
        this.testChangeTransactionLevelCommit(false);
        this.testChangeTransactionLevelCommit(true);
        try {
            SysProperties.FORCE_AUTOCOMMIT_OFF_ON_COMMIT = true;
            this.testChangeTransactionLevelCommit(true);
            this.testChangeTransactionLevelCommit(false);
        }
        finally {
            SysProperties.FORCE_AUTOCOMMIT_OFF_ON_COMMIT = false;
        }
    }

    private void testChangeTransactionLevelCommit(boolean setAutoCommit) throws Exception {
        Connection conn = this.getConnection("clientInfo");
        conn.setAutoCommit(setAutoCommit);
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        int index = 1;
        prep.setInt(index++, 1);
        prep.setString(index++, "test1");
        prep.execute();
        conn.setTransactionIsolation(1);
        conn.createStatement().executeQuery("SELECT COUNT(*) FROM TEST");
        conn.close();
        prep.close();
    }

    private void testRollbackOnAutoCommitSetRunner() throws Exception {
        this.assertFalse("Default value must be false", SysProperties.FORCE_AUTOCOMMIT_OFF_ON_COMMIT);
        this.testRollbackOnAutoCommitSet(false);
        try {
            SysProperties.FORCE_AUTOCOMMIT_OFF_ON_COMMIT = true;
            this.testRollbackOnAutoCommitSet(true);
        }
        finally {
            SysProperties.FORCE_AUTOCOMMIT_OFF_ON_COMMIT = false;
        }
    }

    private void testRollbackOnAutoCommitSet(boolean expectedPropertyEnabled) throws Exception {
        this.assertEquals(SysProperties.FORCE_AUTOCOMMIT_OFF_ON_COMMIT, expectedPropertyEnabled);
        Connection conn = this.getConnection("clientInfo");
        conn.setAutoCommit(false);
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        int index = 1;
        prep.setInt(index++, 1);
        prep.setString(index++, "test1");
        prep.execute();
        conn.rollback();
        conn.setAutoCommit(true);
        index = 1;
        prep.setInt(index++, 2);
        prep.setString(index++, "test2");
        if (expectedPropertyEnabled) {
            prep.execute();
            try {
                conn.rollback();
                throw new AssertionError((Object)"SQLException expected");
            }
            catch (SQLException e) {
                this.assertEquals(90147, e.getErrorCode());
                this.assertTrue(e.getMessage().contains("rollback()"));
                ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM TEST");
                rs.next();
                int count = rs.getInt(1);
                this.assertTrue("Found " + count + " rows", count == 1);
                rs.close();
            }
        } else {
            prep.execute();
            conn.rollback();
            ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM TEST");
            rs.next();
            int count = rs.getInt(1);
            this.assertTrue("Found " + count + " rows", count == 1);
            rs.close();
        }
        conn.close();
        prep.close();
    }

    private void testSetGetSchema() throws SQLException {
        ResultSet rs;
        this.deleteDb("schemaSetGet");
        Connection conn = this.getConnection("schemaSetGet");
        Statement s = conn.createStatement();
        s.executeUpdate("create schema my_test_schema");
        s.executeUpdate("create table my_test_schema.my_test_table(id int, nave varchar) as values (1, 'a')");
        this.assertEquals("PUBLIC", conn.getSchema());
        this.assertThrows(42102, s, "select * from my_test_table");
        this.assertThrows(90079, conn).setSchema("my_test_table");
        conn.setSchema("MY_TEST_SCHEMA");
        this.assertEquals("MY_TEST_SCHEMA", conn.getSchema());
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            rs = s.executeQuery("select * from my_test_table");
            try {
                this.assertTrue(rs.next());
                this.assertEquals(1, rs.getInt(1));
                this.assertEquals("a", rs.getString(2));
                this.assertFalse(rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.assertThrows(90079, conn).setSchema("NON_EXISTING_SCHEMA");
        this.assertEquals("MY_TEST_SCHEMA", conn.getSchema());
        s.executeUpdate("create schema \"otheR_schEma\"");
        s.executeUpdate("create table \"otheR_schEma\".my_test_table(id int, nave varchar) as values (2, 'b')");
        conn.setSchema("otheR_schEma");
        this.assertEquals("otheR_schEma", conn.getSchema());
        throwable = null;
        var4_6 = null;
        try {
            rs = s.executeQuery("select * from my_test_table");
            try {
                this.assertTrue(rs.next());
                this.assertEquals(2, rs.getInt(1));
                this.assertEquals("b", rs.getString(2));
                this.assertFalse(rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        s.execute("SET SCHEMA \"MY_TEST_SCHEMA\"");
        this.assertEquals("MY_TEST_SCHEMA", conn.getSchema());
        s.close();
        conn.close();
        this.deleteDb("schemaSetGet");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testLockTimeout() throws SQLException {
        this.deleteDb("lockTimeout");
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                Connection conn1 = this.getConnection("lockTimeout");
                try {
                    try (Connection conn2 = this.getConnection("lockTimeout;LOCK_TIMEOUT=6000");){
                        conn1.setAutoCommit(false);
                        conn2.setAutoCommit(false);
                        Statement s1 = conn1.createStatement();
                        Statement s2 = conn2.createStatement();
                        s1.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, V INT) AS VALUES (1, 2)");
                        conn1.commit();
                        s2.execute("INSERT INTO TEST VALUES (2, 4)");
                        s1.execute("UPDATE TEST SET V = 3 WHERE ID = 1");
                        s2.execute("SET LOCK_TIMEOUT 50");
                        long n = System.nanoTime();
                        this.assertThrows(50200, s2).execute("UPDATE TEST SET V = 4 WHERE ID = 1");
                        if (System.nanoTime() - n > 5000000000L) {
                            this.fail("LOCK_TIMEOUT wasn't set");
                        }
                    }
                    if (conn1 == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (conn1 == null) throw throwable;
                    conn1.close();
                    throw throwable;
                }
                conn1.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("lockTimeout");
        }
    }

    private void testIgnoreUnknownSettings() throws SQLException {
        this.deleteDb("ignoreUnknownSettings");
        this.assertThrows(90113, () -> this.getConnection("ignoreUnknownSettings;A=1"));
        try {
            Throwable throwable = null;
            Object var2_2 = null;
            try {
                Connection c = this.getConnection("ignoreUnknownSettings;IGNORE_UNKNOWN_SETTINGS=TRUE;A=1");
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("ignoreUnknownSettings");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testTimeZone() throws SQLException {
        this.deleteDb("timeZone");
        String tz1 = "Europe/London";
        String tz2 = "Europe/Paris";
        String tz3 = "Asia/Tokyo";
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (Connection c = this.getConnection("timeZone");){
                TimeZone tz = TimeZone.getDefault();
                try {
                    TimeZone.setDefault(TimeZone.getTimeZone(tz1));
                    DateTimeUtils.resetCalendar();
                    Throwable throwable2 = null;
                    Object var9_12 = null;
                    try (Connection c1 = this.getConnection("timeZone");){
                        TimeZone.setDefault(TimeZone.getTimeZone(tz2));
                        DateTimeUtils.resetCalendar();
                        Throwable throwable3 = null;
                        Object var12_17 = null;
                        try {
                            Connection c2 = this.getConnection("timeZone");
                            try {
                                try (Connection c3 = this.getConnection("timeZone;TIME ZONE=" + tz3);){
                                    this.checkTimeZone(tz1, c1);
                                    this.checkTimeZone(tz2, c2);
                                    this.checkTimeZone(tz3, c3);
                                }
                                if (c2 == null) return;
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                if (c2 == null) throw throwable3;
                                c2.close();
                                throw throwable3;
                            }
                            c2.close();
                            return;
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                                throw throwable3;
                            } else {
                                if (throwable3 == throwable5) throw throwable3;
                                throwable3.addSuppressed(throwable5);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable2 == null) {
                            throwable2 = throwable6;
                            throw throwable2;
                        } else {
                            if (throwable2 == throwable6) throw throwable2;
                            throwable2.addSuppressed(throwable6);
                        }
                        throw throwable2;
                    }
                }
                finally {
                    TimeZone.setDefault(tz);
                    DateTimeUtils.resetCalendar();
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                } else {
                    if (throwable == throwable7) throw throwable;
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("timeZone");
        }
    }

    private void checkTimeZone(String expected, Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME = 'TIME ZONE'");
        rs.next();
        this.assertEquals(expected, rs.getString(1));
    }
}

