/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;
import org.h2.jdbc.JdbcConnection;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.utils.RandomDataUtils;
import org.h2.util.IOUtils;

public class TestLobApi
extends TestDb {
    private JdbcConnection conn;
    private Statement stat;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb(this.getTestName());
        this.testUnsupportedOperations();
        this.testLobStaysOpenUntilCommitted();
        this.testInputStreamThrowsException(true);
        this.testInputStreamThrowsException(false);
        this.conn = (JdbcConnection)this.getConnection(this.getTestName());
        this.stat = this.conn.createStatement();
        this.stat.execute("create table test(id int, x blob)");
        this.testBlob(0);
        this.testBlob(1);
        this.testBlob(100);
        this.testBlob(100000);
        this.stat.execute("drop table test");
        this.stat.execute("create table test(id int, x clob)");
        this.testClob(0);
        this.testClob(1);
        this.testClob(100);
        this.testClob(100000);
        this.stat.execute("drop table test");
        this.conn.close();
    }

    private void testUnsupportedOperations() throws Exception {
        Connection conn = this.getConnection(this.getTestName());
        this.stat = conn.createStatement();
        this.stat.execute("create table test(id int, c clob, b blob)");
        this.stat.execute("insert into test values(1, 'x', x'00')");
        ResultSet rs = this.stat.executeQuery("select * from test order by id");
        rs.next();
        Clob clob = rs.getClob(2);
        byte[] data = IOUtils.readBytesAndClose(clob.getAsciiStream(), -1);
        this.assertEquals("x", new String(data, StandardCharsets.UTF_8));
        this.assertTrue(clob.toString().endsWith("'x'"));
        clob.free();
        this.assertTrue(clob.toString().endsWith("<closed>"));
        this.assertThrows(50100, clob).truncate(0L);
        this.assertThrows(50100, clob).setAsciiStream(1L);
        this.assertThrows(50100, clob).position("", 0L);
        this.assertThrows(50100, clob).position((Clob)null, 0L);
        Blob blob = rs.getBlob(3);
        this.assertThrows(50100, blob).truncate(0L);
        this.assertThrows(50100, blob).position(new byte[1], 0L);
        this.assertThrows(50100, blob).position((Blob)null, 0L);
        this.assertTrue(blob.toString().endsWith("X'00'"));
        blob.free();
        this.assertTrue(blob.toString().endsWith("<closed>"));
        this.stat.execute("drop table test");
        conn.close();
    }

    private void testLobStaysOpenUntilCommitted() throws Exception {
        Connection conn = this.getConnection(this.getTestName());
        this.stat = conn.createStatement();
        this.stat.execute("create table test(id identity, c clob, b blob)");
        PreparedStatement prep = conn.prepareStatement("insert into test(c, b) values(?, ?)");
        prep.setString(1, "");
        prep.setBytes(2, new byte[0]);
        prep.execute();
        Random r = new Random(1L);
        char[] charsSmall = new char[20];
        RandomDataUtils.randomChars(r, charsSmall);
        String dSmall = new String(charsSmall);
        prep.setCharacterStream(1, (Reader)new StringReader(dSmall), -1);
        byte[] bytesSmall = new byte[20];
        r.nextBytes(bytesSmall);
        prep.setBinaryStream(2, (InputStream)new ByteArrayInputStream(bytesSmall), -1);
        prep.execute();
        char[] chars = new char[100000];
        RandomDataUtils.randomChars(r, chars);
        String d = new String(chars);
        prep.setCharacterStream(1, (Reader)new StringReader(d), -1);
        byte[] bytes = new byte[100000];
        r.nextBytes(bytes);
        prep.setBinaryStream(2, (InputStream)new ByteArrayInputStream(bytes), -1);
        prep.execute();
        conn.setAutoCommit(false);
        ResultSet rs = this.stat.executeQuery("select * from test order by id");
        rs.next();
        Clob c1 = rs.getClob(2);
        Blob b1 = rs.getBlob(3);
        rs.next();
        Clob c2 = rs.getClob(2);
        Blob b2 = rs.getBlob(3);
        rs.next();
        Clob c3 = rs.getClob(2);
        Blob b3 = rs.getBlob(3);
        this.assertFalse(rs.next());
        rs.close();
        this.assertEquals(0L, c1.length());
        this.assertEquals(0L, b1.length());
        this.assertEquals("", c1.getSubString(1L, 0));
        this.assertEquals(new byte[0], b1.getBytes(1L, 0));
        this.assertEquals((long)charsSmall.length, c2.length());
        this.assertEquals((long)bytesSmall.length, b2.length());
        this.assertEquals(dSmall, c2.getSubString(1L, (int)c2.length()));
        this.assertEquals(bytesSmall, b2.getBytes(1L, (int)b2.length()));
        this.assertEquals((long)chars.length, c3.length());
        this.assertEquals((long)bytes.length, b3.length());
        this.assertEquals(d, c3.getSubString(1L, (int)c3.length()));
        this.assertEquals(bytes, b3.getBytes(1L, (int)b3.length()));
        this.stat.execute("drop table test");
        conn.close();
    }

    private void testInputStreamThrowsException(final boolean ioException) throws Exception {
        Connection conn = this.getConnection(this.getTestName());
        this.stat = conn.createStatement();
        this.stat.execute("create table test(id identity, c clob, b blob)");
        PreparedStatement prep = conn.prepareStatement("insert into test(c, b) values(?, ?)");
        this.assertThrows(90028, prep).setCharacterStream(1, new Reader(){
            int pos;

            @Override
            public int read(char[] buff, int off, int len) throws IOException {
                this.pos += len;
                if (this.pos > 100001) {
                    if (ioException) {
                        throw new IOException("");
                    }
                    throw new IllegalStateException();
                }
                return len;
            }

            @Override
            public void close() throws IOException {
            }
        }, -1);
        prep.setString(1, new String(new char[10000]));
        prep.setBytes(2, new byte[0]);
        prep.execute();
        prep.setString(1, "");
        this.assertThrows(90028, prep).setBinaryStream(2, new InputStream(){
            int pos;

            @Override
            public int read() throws IOException {
                ++this.pos;
                if (this.pos > 100001) {
                    if (ioException) {
                        throw new IOException("");
                    }
                    throw new IllegalStateException();
                }
                return 0;
            }
        }, -1);
        prep.setBytes(2, new byte[10000]);
        prep.execute();
        ResultSet rs = this.stat.executeQuery("select c, b from test order by id");
        rs.next();
        this.assertEquals(new String(new char[10000]), rs.getString(1));
        this.assertEquals(new byte[0], rs.getBytes(2));
        rs.next();
        this.assertEquals("", rs.getString(1));
        this.assertEquals(new byte[10000], rs.getBytes(2));
        this.stat.execute("drop table test");
        conn.close();
    }

    private void testBlob(int length) throws Exception {
        Random r = new Random(length);
        byte[] data = new byte[length];
        r.nextBytes(data);
        Blob b = this.conn.createBlob();
        OutputStream out = b.setBinaryStream(1L);
        out.write(data, 0, data.length);
        out.close();
        this.stat.execute("delete from test");
        PreparedStatement prep = this.conn.prepareStatement("insert into test values(?, ?)");
        prep.setInt(1, 1);
        prep.setBlob(2, b);
        prep.execute();
        prep.setInt(1, 2);
        b = this.conn.createBlob();
        this.assertEquals(length, b.setBytes(1L, data));
        prep.setBlob(2, b);
        prep.execute();
        prep.setInt(1, 3);
        Blob b2 = this.conn.createBlob();
        byte[] xdata = new byte[length + 2];
        System.arraycopy(data, 0, xdata, 1, length);
        this.assertEquals(length, b2.setBytes(1L, xdata, 1, length));
        prep.setBlob(2, b2);
        prep.execute();
        prep.setInt(1, 4);
        prep.setBlob(2, new ByteArrayInputStream(data));
        prep.execute();
        prep.setInt(1, 5);
        prep.setBlob(2, new ByteArrayInputStream(data), -1L);
        prep.execute();
        ResultSet rs = this.stat.executeQuery("select * from test");
        rs.next();
        Blob b3 = rs.getBlob(2);
        b3.toString();
        this.assertEquals((long)length, b3.length());
        byte[] bytes = b.getBytes(1L, length);
        byte[] bytes2 = b3.getBytes(1L, length);
        this.assertEquals(bytes, bytes2);
        rs.next();
        b3 = rs.getBlob(2);
        this.assertEquals((long)length, b3.length());
        bytes2 = b3.getBytes(1L, length);
        this.assertEquals(bytes, bytes2);
        rs.next();
        b3 = rs.getBlob(2);
        this.assertEquals((long)length, b3.length());
        bytes2 = b3.getBytes(1L, length);
        this.assertEquals(bytes, bytes2);
        while (rs.next()) {
            bytes2 = rs.getBytes(2);
            this.assertEquals(bytes, bytes2);
        }
    }

    private void testClob(int length) throws Exception {
        Random r = new Random(length);
        char[] data = new char[length];
        int i = 0;
        while (i < length) {
            char c;
            while ((c = (char)r.nextInt()) >= '\ud800' && c <= '\udfff') {
            }
            data[i] = c;
            ++i;
        }
        Clob c = this.conn.createClob();
        Writer out = c.setCharacterStream(1L);
        out.write(data, 0, data.length);
        out.close();
        this.stat.execute("delete from test");
        PreparedStatement prep = this.conn.prepareStatement("insert into test values(?, ?)");
        prep.setInt(1, 1);
        prep.setClob(2, c);
        prep.execute();
        c = this.conn.createClob();
        c.setString(1L, new String(data));
        prep.setInt(1, 2);
        prep.setClob(2, c);
        prep.execute();
        prep.setInt(1, 3);
        prep.setCharacterStream(2, new StringReader(new String(data)));
        prep.execute();
        prep.setInt(1, 4);
        prep.setCharacterStream(2, (Reader)new StringReader(new String(data)), -1);
        prep.execute();
        NClob nc = this.conn.createNClob();
        this.assertEquals(length, nc.setString(1L, new String(data)));
        prep.setInt(1, 5);
        prep.setNClob(2, nc);
        prep.execute();
        nc = this.conn.createNClob();
        char[] xdata = new char[length + 2];
        System.arraycopy(data, 0, xdata, 1, length);
        this.assertEquals(length, nc.setString(1L, new String(xdata), 1, length));
        prep.setInt(1, 6);
        prep.setNClob(2, nc);
        prep.execute();
        prep.setInt(1, 7);
        prep.setNClob(2, new StringReader(new String(data)));
        prep.execute();
        prep.setInt(1, 8);
        prep.setNClob(2, new StringReader(new String(data)), -1L);
        prep.execute();
        prep.setInt(1, 9);
        prep.setNString(2, new String(data));
        prep.execute();
        ResultSet rs = this.stat.executeQuery("select * from test");
        rs.next();
        Clob c2 = rs.getClob(2);
        c2.toString();
        this.assertEquals((long)length, c2.length());
        String s = c.getSubString(1L, length);
        String s2 = c2.getSubString(1L, length);
        while (rs.next()) {
            c2 = rs.getClob(2);
            this.assertEquals((long)length, c2.length());
            s2 = c2.getSubString(1L, length);
            this.assertEquals(s, s2);
        }
    }
}

