/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestManyJdbcObjects
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.testNestedResultSets();
        this.testManyConnections();
        this.testOneConnectionPrepare();
        this.deleteDb("manyObjects");
    }

    private void testNestedResultSets() throws SQLException {
        if (!this.config.networked) {
            return;
        }
        this.deleteDb("manyObjects");
        Connection conn = this.getConnection("manyObjects");
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rsTables = meta.getColumns(null, null, null, null);
        while (rsTables.next()) {
            meta.getExportedKeys(null, null, "TEST");
            meta.getImportedKeys(null, null, "TEST");
        }
        conn.close();
    }

    private void testManyConnections() throws SQLException {
        if (!this.config.networked || this.config.memory) {
            return;
        }
        this.deleteDb("manyObjects");
        int connCount = this.getSize(4, 40);
        Connection[] conn = new Connection[connCount];
        int i = 0;
        while (i < connCount) {
            conn[i] = this.getConnection("manyObjects");
            ++i;
        }
        int len = this.getSize(50, 500);
        int j = 0;
        while (j < len) {
            if (j % 10 == 0) {
                this.trace("j=" + j);
            }
            int i2 = 0;
            while (i2 < connCount) {
                conn[i2].getMetaData().getSchemas().close();
                ++i2;
            }
            ++j;
        }
        int i3 = 0;
        while (i3 < connCount) {
            conn[i3].close();
            ++i3;
        }
    }

    private void testOneConnectionPrepare() throws SQLException {
        this.deleteDb("manyObjects");
        Connection conn = this.getConnection("manyObjects");
        int size = this.getSize(10, 1000);
        int i = 0;
        while (i < size) {
            conn.getMetaData();
            ++i;
        }
        i = 0;
        while (i < size) {
            conn.createStatement();
            ++i;
        }
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        i = 0;
        while (i < size) {
            stat.executeQuery("SELECT * FROM TEST WHERE 1=0");
            ++i;
        }
        i = 0;
        while (i < size) {
            stat.executeQuery("SELECT * FROM TEST");
            ++i;
        }
        i = 0;
        while (i < size) {
            conn.prepareStatement("SELECT * FROM TEST");
            ++i;
        }
        PreparedStatement prep = conn.prepareStatement("SELECT * FROM TEST WHERE 1=0");
        i = 0;
        while (i < size) {
            prep.executeQuery();
            ++i;
        }
        prep = conn.prepareStatement("SELECT * FROM TEST");
        i = 0;
        while (i < size) {
            prep.executeQuery();
            ++i;
        }
        conn.close();
    }
}

