/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.Driver;
import org.h2.mode.DefaultNullOrdering;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestMetaData
extends TestDb {
    private static final String CATALOG = "METADATA";

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb("metaData");
        this.testUnwrap();
        this.testUnsupportedOperations();
        this.testTempTable();
        this.testColumnLobMeta();
        this.testColumnMetaData();
        this.testColumnPrecision();
        this.testColumnDefault();
        this.testColumnGenerated();
        this.testHiddenColumn();
        this.testCrossReferences();
        this.testProcedureColumns();
        this.testTypeInfo();
        this.testUDTs();
        this.testStatic();
        this.testNullsAreSortedAt();
        this.testGeneral();
        this.testAllowLiteralsNone();
        this.testClientInfo();
        this.testQueryStatistics();
        this.testQueryStatisticsLimit();
    }

    private void testUnwrap() throws SQLException {
        Connection conn = this.getConnection("metaData");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select 1 as x from dual");
        ResultSetMetaData meta = rs.getMetaData();
        this.assertTrue(meta.isWrapperFor(Object.class));
        this.assertTrue(meta.isWrapperFor(ResultSetMetaData.class));
        this.assertTrue(meta.isWrapperFor(meta.getClass()));
        this.assertTrue(meta == meta.unwrap(Object.class));
        this.assertTrue(meta == meta.unwrap(ResultSetMetaData.class));
        this.assertTrue(meta == meta.unwrap(meta.getClass()));
        this.assertFalse(meta.isWrapperFor(Integer.class));
        this.assertThrows(90008, meta).unwrap(Integer.class);
        conn.close();
    }

    private void testUnsupportedOperations() throws SQLException {
        Connection conn = this.getConnection("metaData");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select 1 as x from dual");
        ResultSetMetaData meta = rs.getMetaData();
        this.assertThrows(90008, meta).getColumnLabel(0);
        this.assertThrows(90008, meta).getColumnName(0);
        this.assertThrows(90008, meta).getColumnType(0);
        this.assertThrows(90008, meta).getColumnTypeName(0);
        this.assertThrows(90008, meta).getSchemaName(0);
        this.assertThrows(90008, meta).getTableName(0);
        this.assertThrows(90008, meta).getCatalogName(0);
        this.assertThrows(90008, meta).isAutoIncrement(0);
        this.assertThrows(90008, meta).isCaseSensitive(0);
        this.assertThrows(90008, meta).isSearchable(0);
        this.assertThrows(90008, meta).isCurrency(0);
        this.assertThrows(90008, meta).isNullable(0);
        this.assertThrows(90008, meta).isSigned(0);
        this.assertThrows(90008, meta).isReadOnly(0);
        this.assertThrows(90008, meta).isWritable(0);
        this.assertThrows(90008, meta).isDefinitelyWritable(0);
        this.assertThrows(90008, meta).getColumnClassName(0);
        this.assertThrows(90008, meta).getPrecision(0);
        this.assertThrows(90008, meta).getScale(0);
        this.assertThrows(90008, meta).getColumnDisplaySize(0);
        conn.close();
    }

    private void testColumnLobMeta() throws SQLException {
        Connection conn = this.getConnection("metaData");
        Statement stat = conn.createStatement();
        stat.executeUpdate("CREATE TABLE t (blob BLOB, clob CLOB)");
        stat.execute("INSERT INTO t VALUES('', '')");
        ResultSet rs = stat.executeQuery("SELECT blob,clob FROM t");
        ResultSetMetaData rsMeta = rs.getMetaData();
        this.assertEquals("java.sql.Blob", rsMeta.getColumnClassName(1));
        this.assertEquals("java.sql.Clob", rsMeta.getColumnClassName(2));
        rs.next();
        this.assertTrue(rs.getObject(1) instanceof Blob);
        this.assertTrue(rs.getObject(2) instanceof Clob);
        stat.executeUpdate("DROP TABLE t");
        conn.close();
    }

    private void testColumnMetaData() throws SQLException {
        Connection conn = this.getConnection("metaData");
        String sql = "select substring('Hello',0,1)";
        ResultSet rs = conn.prepareStatement(sql).executeQuery();
        rs.next();
        int type = rs.getMetaData().getColumnType(1);
        this.assertEquals(12, type);
        rs = conn.createStatement().executeQuery("SELECT COUNT(*) C FROM DUAL");
        this.assertEquals("C", rs.getMetaData().getColumnName(1));
        Statement stat = conn.createStatement();
        stat.execute("create table a(x int array)");
        stat.execute("insert into a values(ARRAY[1, 2])");
        rs = stat.executeQuery("SELECT x[1] FROM a");
        ResultSetMetaData rsMeta = rs.getMetaData();
        this.assertEquals(4, rsMeta.getColumnType(1));
        rs.next();
        this.assertEquals(Integer.class.getName(), rs.getObject(1).getClass().getName());
        stat.execute("drop table a");
        conn.close();
    }

    private void testColumnPrecision() throws SQLException {
        Connection conn = this.getConnection("metaData");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE ONE(X NUMBER(12,2), Y FLOAT)");
        stat.execute("CREATE TABLE TWO AS SELECT * FROM ONE");
        ResultSet rs = stat.executeQuery("SELECT * FROM ONE");
        ResultSetMetaData rsMeta = rs.getMetaData();
        this.assertEquals(12, rsMeta.getPrecision(1));
        this.assertEquals(53, rsMeta.getPrecision(2));
        this.assertEquals(2, rsMeta.getColumnType(1));
        this.assertEquals(6, rsMeta.getColumnType(2));
        rs = stat.executeQuery("SELECT * FROM TWO");
        rsMeta = rs.getMetaData();
        this.assertEquals(12, rsMeta.getPrecision(1));
        this.assertEquals(53, rsMeta.getPrecision(2));
        this.assertEquals(2, rsMeta.getColumnType(1));
        this.assertEquals(6, rsMeta.getColumnType(2));
        stat.execute("DROP TABLE ONE, TWO");
        conn.close();
    }

    private void testColumnDefault() throws SQLException {
        Connection conn = this.getConnection("metaData");
        DatabaseMetaData meta = conn.getMetaData();
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(A INT, B INT DEFAULT NULL)");
        ResultSet rs = meta.getColumns(null, null, "TEST", null);
        rs.next();
        this.assertEquals("A", rs.getString("COLUMN_NAME"));
        this.assertEquals(null, rs.getString("COLUMN_DEF"));
        rs.next();
        this.assertEquals("B", rs.getString("COLUMN_NAME"));
        this.assertEquals("NULL", rs.getString("COLUMN_DEF"));
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE TEST");
        conn.close();
    }

    private void testColumnGenerated() throws SQLException {
        Connection conn = this.getConnection("metaData");
        DatabaseMetaData meta = conn.getMetaData();
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(A INT, B INT AS A + 1)");
        ResultSet rs = meta.getColumns(null, null, "TEST", null);
        rs.next();
        this.assertEquals("A", rs.getString("COLUMN_NAME"));
        this.assertEquals("NO", rs.getString("IS_GENERATEDCOLUMN"));
        rs.next();
        this.assertEquals("B", rs.getString("COLUMN_NAME"));
        this.assertEquals("YES", rs.getString("IS_GENERATEDCOLUMN"));
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE TEST");
        conn.close();
    }

    private void testHiddenColumn() throws SQLException {
        Connection conn = this.getConnection("metaData");
        DatabaseMetaData meta = conn.getMetaData();
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(A INT, B INT INVISIBLE)");
        ResultSet rs = meta.getColumns(null, null, "TEST", null);
        this.assertTrue(rs.next());
        this.assertEquals("A", rs.getString("COLUMN_NAME"));
        this.assertFalse(rs.next());
        rs = meta.getPseudoColumns(null, null, "TEST", null);
        this.assertTrue(rs.next());
        this.assertEquals("B", rs.getString("COLUMN_NAME"));
        this.assertEquals("YES", rs.getString("IS_NULLABLE"));
        this.assertTrue(rs.next());
        this.assertEquals("_ROWID_", rs.getString("COLUMN_NAME"));
        this.assertEquals("NO", rs.getString("IS_NULLABLE"));
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE TEST");
        conn.close();
    }

    private void testProcedureColumns() throws SQLException {
        Connection conn = this.getConnection("metaData");
        DatabaseMetaData meta = conn.getMetaData();
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS PROP FOR 'java.lang.System.getProperty(java.lang.String)'");
        stat.execute("CREATE ALIAS EXIT FOR 'java.lang.System.exit'");
        ResultSet rs = meta.getProcedures(null, null, "EX%");
        int[] nArray = new int[9];
        nArray[0] = 12;
        nArray[1] = 12;
        nArray[2] = 12;
        nArray[6] = 12;
        nArray[7] = 5;
        nArray[8] = 12;
        this.assertResultSetMeta(rs, 9, new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "RESERVED1", "RESERVED2", "RESERVED3", "REMARKS", "PROCEDURE_TYPE", "SPECIFIC_NAME"}, nArray, null, null);
        String[][] stringArray = new String[1][];
        String[] stringArray2 = new String[9];
        stringArray2[0] = CATALOG;
        stringArray2[1] = "PUBLIC";
        stringArray2[2] = "EXIT";
        stringArray2[7] = "1";
        stringArray2[8] = "EXIT_1";
        stringArray[0] = stringArray2;
        this.assertResultSetOrdered(rs, stringArray);
        rs = meta.getProcedureColumns(null, null, null, null);
        this.assertResultSetMeta(rs, 20, new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME"}, new int[]{12, 12, 12, 12, 5, 4, 12, 4, 4, 5, 5, 5, 12, 12, 4, 4, 4, 4, 12, 12}, null, null);
        String[][] stringArray3 = new String[3][];
        String[] stringArray4 = new String[20];
        stringArray4[0] = CATALOG;
        stringArray4[1] = "PUBLIC";
        stringArray4[2] = "EXIT";
        stringArray4[3] = "P1";
        stringArray4[4] = "1";
        stringArray4[5] = "4";
        stringArray4[6] = "INTEGER";
        stringArray4[7] = "32";
        stringArray4[8] = "32";
        stringArray4[10] = "2";
        stringArray4[11] = "0";
        stringArray4[17] = "1";
        stringArray4[18] = "";
        stringArray4[19] = "EXIT_1";
        stringArray3[0] = stringArray4;
        String[] stringArray5 = new String[20];
        stringArray5[0] = CATALOG;
        stringArray5[1] = "PUBLIC";
        stringArray5[2] = "PROP";
        stringArray5[3] = "RESULT";
        stringArray5[4] = "5";
        stringArray5[5] = "12";
        stringArray5[6] = "CHARACTER VARYING";
        stringArray5[7] = "1000000000";
        stringArray5[8] = "1000000000";
        stringArray5[11] = "2";
        stringArray5[16] = "1000000000";
        stringArray5[17] = "0";
        stringArray5[18] = "";
        stringArray5[19] = "PROP_1";
        stringArray3[1] = stringArray5;
        String[] stringArray6 = new String[20];
        stringArray6[0] = CATALOG;
        stringArray6[1] = "PUBLIC";
        stringArray6[2] = "PROP";
        stringArray6[3] = "P1";
        stringArray6[4] = "1";
        stringArray6[5] = "12";
        stringArray6[6] = "CHARACTER VARYING";
        stringArray6[7] = "1000000000";
        stringArray6[8] = "1000000000";
        stringArray6[11] = "2";
        stringArray6[16] = "1000000000";
        stringArray6[17] = "1";
        stringArray6[18] = "";
        stringArray6[19] = "PROP_1";
        stringArray3[2] = stringArray6;
        this.assertResultSetOrdered(rs, stringArray3);
        stat.execute("DROP ALIAS EXIT");
        stat.execute("DROP ALIAS PROP");
        conn.close();
    }

    private void testTypeInfo() throws SQLException {
        Connection conn = this.getConnection("metaData");
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getTypeInfo();
        this.assertResultSetMeta(rs, 18, new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"}, new int[]{12, 4, 4, 12, 12, 12, 5, 16, 5, 16, 16, 16, 12, 5, 5, 4, 4, 4}, null, null);
        this.testTypeInfo(rs, "TINYINT", -6, 8L, null, null, null, false, false, true, (short)0, (short)0, 2);
        this.testTypeInfo(rs, "BIGINT", -5, 64L, null, null, null, false, false, true, (short)0, (short)0, 2);
        this.testTypeInfo(rs, "BINARY VARYING", -3, 1000000000L, "X'", "'", "LENGTH", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "BINARY", -2, 1000000000L, "X'", "'", "LENGTH", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "UUID", -2, 16L, "'", "'", null, false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "CHARACTER", 1, 1000000000L, "'", "'", "LENGTH", true, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "NUMERIC", 2, 100000L, null, null, "PRECISION,SCALE", false, true, true, (short)0, (short)Short.MAX_VALUE, 10);
        this.testTypeInfo(rs, "DECFLOAT", 2, 100000L, null, null, "PRECISION", false, false, true, (short)0, (short)0, 10);
        this.testTypeInfo(rs, "INTEGER", 4, 32L, null, null, null, false, false, true, (short)0, (short)0, 2);
        this.testTypeInfo(rs, "SMALLINT", 5, 16L, null, null, null, false, false, true, (short)0, (short)0, 2);
        this.testTypeInfo(rs, "REAL", 7, 24L, null, null, null, false, false, true, (short)0, (short)0, 2);
        this.testTypeInfo(rs, "DOUBLE PRECISION", 8, 53L, null, null, null, false, false, true, (short)0, (short)0, 2);
        this.testTypeInfo(rs, "CHARACTER VARYING", 12, 1000000000L, "'", "'", "LENGTH", true, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "VARCHAR_IGNORECASE", 12, 1000000000L, "'", "'", "LENGTH", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "BOOLEAN", 16, 1L, null, null, null, false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "DATE", 91, 10L, "DATE '", "'", null, false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "TIME", 92, 18L, "TIME '", "'", "SCALE", false, false, false, (short)0, (short)9, 0);
        this.testTypeInfo(rs, "TIMESTAMP", 93, 29L, "TIMESTAMP '", "'", "SCALE", false, false, false, (short)0, (short)9, 0);
        this.testTypeInfo(rs, "INTERVAL YEAR", 1111, 18L, "INTERVAL '", "' YEAR", "PRECISION", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "INTERVAL MONTH", 1111, 18L, "INTERVAL '", "' MONTH", "PRECISION", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "INTERVAL DAY", 1111, 18L, "INTERVAL '", "' DAY", "PRECISION", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "INTERVAL HOUR", 1111, 18L, "INTERVAL '", "' HOUR", "PRECISION", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "INTERVAL MINUTE", 1111, 18L, "INTERVAL '", "' MINUTE", "PRECISION", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "INTERVAL SECOND", 1111, 18L, "INTERVAL '", "' SECOND", "PRECISION,SCALE", false, false, false, (short)0, (short)9, 0);
        this.testTypeInfo(rs, "INTERVAL YEAR TO MONTH", 1111, 18L, "INTERVAL '", "' YEAR TO MONTH", "PRECISION", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "INTERVAL DAY TO HOUR", 1111, 18L, "INTERVAL '", "' DAY TO HOUR", "PRECISION", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "INTERVAL DAY TO MINUTE", 1111, 18L, "INTERVAL '", "' DAY TO MINUTE", "PRECISION", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "INTERVAL DAY TO SECOND", 1111, 18L, "INTERVAL '", "' DAY TO SECOND", "PRECISION,SCALE", false, false, false, (short)0, (short)9, 0);
        this.testTypeInfo(rs, "INTERVAL HOUR TO MINUTE", 1111, 18L, "INTERVAL '", "' HOUR TO MINUTE", "PRECISION", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "INTERVAL HOUR TO SECOND", 1111, 18L, "INTERVAL '", "' HOUR TO SECOND", "PRECISION,SCALE", false, false, false, (short)0, (short)9, 0);
        this.testTypeInfo(rs, "INTERVAL MINUTE TO SECOND", 1111, 18L, "INTERVAL '", "' MINUTE TO SECOND", "PRECISION,SCALE", false, false, false, (short)0, (short)9, 0);
        this.testTypeInfo(rs, "ENUM", 1111, 1000000000L, "'", "'", "ELEMENT [,...]", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "GEOMETRY", 1111, Integer.MAX_VALUE, "'", "'", "TYPE,SRID", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "JSON", 1111, 1000000000L, "JSON '", "'", "LENGTH", true, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "ROW", 1111, 0L, "ROW(", ")", "NAME DATA_TYPE [,...]", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "JAVA_OBJECT", 2000, 1000000000L, "X'", "'", "LENGTH", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "ARRAY", 2003, 65536L, "ARRAY[", "]", "CARDINALITY", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "BINARY LARGE OBJECT", 2004, Integer.MAX_VALUE, "X'", "'", "LENGTH", false, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "CHARACTER LARGE OBJECT", 2005, Integer.MAX_VALUE, "'", "'", "LENGTH", true, false, false, (short)0, (short)0, 0);
        this.testTypeInfo(rs, "TIME WITH TIME ZONE", 2013, 24L, "TIME WITH TIME ZONE '", "'", "SCALE", false, false, false, (short)0, (short)9, 0);
        this.testTypeInfo(rs, "TIMESTAMP WITH TIME ZONE", 2014, 35L, "TIMESTAMP WITH TIME ZONE '", "'", "SCALE", false, false, false, (short)0, (short)9, 0);
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testTypeInfo(ResultSet rs, String name, int type, long precision, String prefix, String suffix, String params, boolean caseSensitive, boolean fixed, boolean autoIncrement, short minScale, short maxScale, int radix) throws SQLException {
        this.assertTrue(rs.next());
        this.assertEquals(name, rs.getString(1));
        this.assertEquals(type, rs.getInt(2));
        this.assertEquals(precision, rs.getLong(3));
        this.assertEquals(prefix, rs.getString(4));
        this.assertEquals(suffix, rs.getString(5));
        this.assertEquals(params, rs.getString(6));
        this.assertEquals(1, rs.getShort(7));
        this.assertEquals(caseSensitive, rs.getBoolean(8));
        this.assertEquals(3, rs.getShort(9));
        this.assertFalse(rs.getBoolean(10));
        this.assertEquals(fixed, rs.getBoolean(11));
        this.assertEquals(autoIncrement, rs.getBoolean(12));
        this.assertEquals(name, rs.getString(13));
        this.assertEquals(minScale, rs.getShort(14));
        this.assertEquals(maxScale, rs.getShort(15));
        rs.getInt(16);
        this.assertTrue(rs.wasNull());
        rs.getInt(17);
        this.assertTrue(rs.wasNull());
        if (radix != 0) {
            this.assertEquals(radix, rs.getInt(18));
        } else {
            rs.getInt(18);
            this.assertTrue(rs.wasNull());
        }
    }

    private void testUDTs() throws SQLException {
        Connection conn = this.getConnection("metaData");
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getUDTs(null, null, null, null);
        this.assertResultSetMeta(rs, 7, new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"}, new int[]{12, 12, 12, 12, 4, 12, 5}, null, null);
        conn.close();
    }

    private void testCrossReferences() throws SQLException {
        Connection conn = this.getConnection("metaData");
        DatabaseMetaData meta = conn.getMetaData();
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE PARENT(A INT, B INT, PRIMARY KEY(A, B))");
        stat.execute("CREATE TABLE CHILD(ID INT PRIMARY KEY, PA INT, PB INT, CONSTRAINT AB FOREIGN KEY(PA, PB) REFERENCES PARENT(A, B))");
        ResultSet rs = meta.getCrossReference(null, "PUBLIC", "PARENT", null, "PUBLIC", "CHILD");
        this.checkCrossRef(rs);
        rs = meta.getImportedKeys(null, "PUBLIC", "CHILD");
        this.checkCrossRef(rs);
        rs = meta.getExportedKeys(null, "PUBLIC", "PARENT");
        this.checkCrossRef(rs);
        stat.execute("DROP TABLE PARENT, CHILD");
        conn.close();
    }

    private void checkCrossRef(ResultSet rs) throws SQLException {
        this.assertResultSetMeta(rs, 14, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5}, null, null);
        this.assertResultSetOrdered(rs, new String[][]{{CATALOG, "PUBLIC", "PARENT", "A", CATALOG, "PUBLIC", "CHILD", "PA", "1", "1", "1", "AB", "CONSTRAINT_8", "7"}, {CATALOG, "PUBLIC", "PARENT", "B", CATALOG, "PUBLIC", "CHILD", "PB", "2", "1", "1", "AB", "CONSTRAINT_8", "7"}});
    }

    private void testTempTable() throws SQLException {
        Connection conn = this.getConnection("metaData");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST_TEMP");
        stat.execute("CREATE TEMP TABLE TEST_TEMP(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("CREATE INDEX IDX_NAME ON TEST_TEMP(NAME)");
        stat.execute("ALTER TABLE TEST_TEMP ADD FOREIGN KEY(ID) REFERENCES(ID)");
        conn.close();
        conn = this.getConnection("metaData");
        stat = conn.createStatement();
        stat.execute("CREATE TEMP TABLE TEST_TEMP(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        ResultSet rs = stat.executeQuery("SELECT STORAGE_TYPE FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='TEST_TEMP'");
        rs.next();
        this.assertEquals("GLOBAL TEMPORARY", rs.getString("STORAGE_TYPE"));
        stat.execute("DROP TABLE IF EXISTS TEST_TEMP");
        conn.close();
    }

    private void testStatic() throws SQLException {
        Driver dr = Driver.load();
        Connection conn = this.getConnection("metaData");
        DatabaseMetaData meta = conn.getMetaData();
        this.assertEquals(dr.getMajorVersion(), meta.getDriverMajorVersion());
        this.assertEquals(dr.getMinorVersion(), meta.getDriverMinorVersion());
        this.assertTrue(dr.jdbcCompliant());
        this.assertEquals(0, dr.getPropertyInfo(null, null).length);
        this.assertNull(dr.connect("jdbc:test:false", null));
        this.assertTrue(meta.getNumericFunctions().length() > 0);
        this.assertTrue(meta.getStringFunctions().length() > 0);
        this.assertTrue(meta.getSystemFunctions().length() > 0);
        this.assertTrue(meta.getTimeDateFunctions().length() > 0);
        this.assertTrue(meta.allProceduresAreCallable());
        this.assertTrue(meta.allTablesAreSelectable());
        this.assertTrue(meta.dataDefinitionCausesTransactionCommit());
        this.assertFalse(meta.dataDefinitionIgnoredInTransactions());
        this.assertFalse(meta.deletesAreDetected(1003));
        this.assertFalse(meta.deletesAreDetected(1004));
        this.assertFalse(meta.deletesAreDetected(1005));
        this.assertFalse(meta.doesMaxRowSizeIncludeBlobs());
        this.assertEquals(".", meta.getCatalogSeparator());
        this.assertEquals("catalog", meta.getCatalogTerm());
        this.assertTrue(meta.getConnection() == conn);
        String versionStart = meta.getDatabaseMajorVersion() + "." + meta.getDatabaseMinorVersion();
        this.assertTrue(meta.getDatabaseProductVersion().startsWith(versionStart));
        this.assertEquals(meta.getDatabaseMajorVersion(), meta.getDriverMajorVersion());
        this.assertEquals(meta.getDatabaseMinorVersion(), meta.getDriverMinorVersion());
        int majorVersion = 4;
        this.assertEquals(majorVersion, meta.getJDBCMajorVersion());
        this.assertEquals(3, meta.getJDBCMinorVersion());
        this.assertEquals("H2", meta.getDatabaseProductName());
        this.assertEquals(2, meta.getDefaultTransactionIsolation());
        this.assertEquals("H2 JDBC Driver", meta.getDriverName());
        versionStart = meta.getDriverMajorVersion() + "." + meta.getDriverMinorVersion();
        this.assertTrue(meta.getDriverVersion().startsWith(versionStart));
        this.assertEquals("", meta.getExtraNameCharacters());
        this.assertEquals("\"", meta.getIdentifierQuoteString());
        this.assertEquals(0, meta.getMaxBinaryLiteralLength());
        this.assertEquals(0, meta.getMaxCatalogNameLength());
        this.assertEquals(0, meta.getMaxCharLiteralLength());
        this.assertEquals(0, meta.getMaxColumnNameLength());
        this.assertEquals(0, meta.getMaxColumnsInGroupBy());
        this.assertEquals(0, meta.getMaxColumnsInIndex());
        this.assertEquals(0, meta.getMaxColumnsInOrderBy());
        this.assertEquals(0, meta.getMaxColumnsInSelect());
        this.assertEquals(0, meta.getMaxColumnsInTable());
        this.assertEquals(0, meta.getMaxConnections());
        this.assertEquals(0, meta.getMaxCursorNameLength());
        this.assertEquals(0, meta.getMaxIndexLength());
        this.assertEquals(0, meta.getMaxProcedureNameLength());
        this.assertEquals(0, meta.getMaxRowSize());
        this.assertEquals(0, meta.getMaxSchemaNameLength());
        this.assertEquals(0, meta.getMaxStatementLength());
        this.assertEquals(0, meta.getMaxStatements());
        this.assertEquals(0, meta.getMaxTableNameLength());
        this.assertEquals(0, meta.getMaxTablesInSelect());
        this.assertEquals(0, meta.getMaxUserNameLength());
        this.assertEquals("procedure", meta.getProcedureTerm());
        this.assertEquals(2, meta.getResultSetHoldability());
        this.assertEquals(2, meta.getSQLStateType());
        this.assertFalse(meta.locatorsUpdateCopy());
        this.assertEquals("schema", meta.getSchemaTerm());
        this.assertEquals("\\", meta.getSearchStringEscape());
        this.assertTrue(meta.getURL().startsWith("jdbc:h2:"));
        this.assertTrue(meta.getUserName().length() > 1);
        this.assertFalse(meta.insertsAreDetected(1003));
        this.assertFalse(meta.insertsAreDetected(1004));
        this.assertFalse(meta.insertsAreDetected(1005));
        this.assertTrue(meta.isCatalogAtStart());
        this.assertFalse(meta.isReadOnly());
        this.assertTrue(meta.nullPlusNonNullIsNull());
        this.assertFalse(meta.othersDeletesAreVisible(1003));
        this.assertFalse(meta.othersDeletesAreVisible(1004));
        this.assertFalse(meta.othersDeletesAreVisible(1005));
        this.assertFalse(meta.othersInsertsAreVisible(1003));
        this.assertFalse(meta.othersInsertsAreVisible(1004));
        this.assertFalse(meta.othersInsertsAreVisible(1005));
        this.assertFalse(meta.othersUpdatesAreVisible(1003));
        this.assertFalse(meta.othersUpdatesAreVisible(1004));
        this.assertFalse(meta.othersUpdatesAreVisible(1005));
        this.assertFalse(meta.ownDeletesAreVisible(1003));
        this.assertFalse(meta.ownDeletesAreVisible(1004));
        this.assertFalse(meta.ownDeletesAreVisible(1005));
        this.assertFalse(meta.ownInsertsAreVisible(1003));
        this.assertFalse(meta.ownInsertsAreVisible(1004));
        this.assertFalse(meta.ownInsertsAreVisible(1005));
        this.assertTrue(meta.ownUpdatesAreVisible(1003));
        this.assertTrue(meta.ownUpdatesAreVisible(1004));
        this.assertTrue(meta.ownUpdatesAreVisible(1005));
        this.assertFalse(meta.storesLowerCaseIdentifiers());
        this.assertFalse(meta.storesLowerCaseQuotedIdentifiers());
        this.assertFalse(meta.storesMixedCaseIdentifiers());
        this.assertFalse(meta.storesMixedCaseQuotedIdentifiers());
        this.assertTrue(meta.storesUpperCaseIdentifiers());
        this.assertFalse(meta.storesUpperCaseQuotedIdentifiers());
        this.assertTrue(meta.supportsAlterTableWithAddColumn());
        this.assertTrue(meta.supportsAlterTableWithDropColumn());
        this.assertTrue(meta.supportsANSI92EntryLevelSQL());
        this.assertFalse(meta.supportsANSI92IntermediateSQL());
        this.assertFalse(meta.supportsANSI92FullSQL());
        this.assertTrue(meta.supportsBatchUpdates());
        this.assertTrue(meta.supportsCatalogsInDataManipulation());
        this.assertTrue(meta.supportsCatalogsInIndexDefinitions());
        this.assertTrue(meta.supportsCatalogsInPrivilegeDefinitions());
        this.assertFalse(meta.supportsCatalogsInProcedureCalls());
        this.assertTrue(meta.supportsCatalogsInTableDefinitions());
        this.assertTrue(meta.supportsColumnAliasing());
        this.assertTrue(meta.supportsConvert());
        this.assertTrue(meta.supportsConvert(4, 12));
        this.assertTrue(meta.supportsCoreSQLGrammar());
        this.assertTrue(meta.supportsCorrelatedSubqueries());
        this.assertFalse(meta.supportsDataDefinitionAndDataManipulationTransactions());
        this.assertTrue(meta.supportsDataManipulationTransactionsOnly());
        this.assertFalse(meta.supportsDifferentTableCorrelationNames());
        this.assertTrue(meta.supportsExpressionsInOrderBy());
        this.assertFalse(meta.supportsExtendedSQLGrammar());
        this.assertFalse(meta.supportsFullOuterJoins());
        this.assertTrue(meta.supportsGetGeneratedKeys());
        this.assertFalse(meta.supportsMultipleOpenResults());
        this.assertFalse(meta.supportsNamedParameters());
        this.assertTrue(meta.supportsGroupBy());
        this.assertTrue(meta.supportsGroupByBeyondSelect());
        this.assertTrue(meta.supportsGroupByUnrelated());
        this.assertTrue(meta.supportsIntegrityEnhancementFacility());
        this.assertTrue(meta.supportsLikeEscapeClause());
        this.assertTrue(meta.supportsLimitedOuterJoins());
        this.assertTrue(meta.supportsMinimumSQLGrammar());
        this.assertFalse(meta.supportsMixedCaseIdentifiers());
        this.assertTrue(meta.supportsMixedCaseQuotedIdentifiers());
        this.assertFalse(meta.supportsMultipleResultSets());
        this.assertTrue(meta.supportsMultipleTransactions());
        this.assertTrue(meta.supportsNonNullableColumns());
        this.assertFalse(meta.supportsOpenCursorsAcrossCommit());
        this.assertFalse(meta.supportsOpenCursorsAcrossRollback());
        this.assertTrue(meta.supportsOpenStatementsAcrossCommit());
        this.assertTrue(meta.supportsOpenStatementsAcrossRollback());
        this.assertTrue(meta.supportsOrderByUnrelated());
        this.assertTrue(meta.supportsOuterJoins());
        this.assertFalse(meta.supportsPositionedDelete());
        this.assertFalse(meta.supportsPositionedUpdate());
        this.assertTrue(meta.supportsResultSetConcurrency(1003, 1007));
        this.assertTrue(meta.supportsResultSetConcurrency(1003, 1008));
        this.assertTrue(meta.supportsResultSetConcurrency(1004, 1007));
        this.assertTrue(meta.supportsResultSetConcurrency(1004, 1008));
        this.assertFalse(meta.supportsResultSetConcurrency(1005, 1007));
        this.assertFalse(meta.supportsResultSetConcurrency(1005, 1008));
        this.assertFalse(meta.supportsResultSetHoldability(1));
        this.assertTrue(meta.supportsResultSetHoldability(2));
        this.assertTrue(meta.supportsSavepoints());
        this.assertFalse(meta.supportsStatementPooling());
        this.assertTrue(meta.supportsResultSetType(1003));
        this.assertTrue(meta.supportsResultSetType(1004));
        this.assertFalse(meta.supportsResultSetType(1005));
        this.assertTrue(meta.supportsSchemasInDataManipulation());
        this.assertTrue(meta.supportsSchemasInIndexDefinitions());
        this.assertTrue(meta.supportsSchemasInPrivilegeDefinitions());
        this.assertTrue(meta.supportsSchemasInProcedureCalls());
        this.assertTrue(meta.supportsSchemasInTableDefinitions());
        this.assertTrue(meta.supportsSelectForUpdate());
        this.assertFalse(meta.supportsStoredProcedures());
        this.assertTrue(meta.supportsSubqueriesInComparisons());
        this.assertTrue(meta.supportsSubqueriesInExists());
        this.assertTrue(meta.supportsSubqueriesInIns());
        this.assertTrue(meta.supportsSubqueriesInQuantifieds());
        this.assertTrue(meta.supportsTableCorrelationNames());
        this.assertTrue(meta.supportsTransactions());
        this.assertFalse(meta.supportsTransactionIsolationLevel(0));
        this.assertTrue(meta.supportsTransactionIsolationLevel(2));
        this.assertTrue(meta.supportsTransactionIsolationLevel(1));
        this.assertTrue(meta.supportsTransactionIsolationLevel(4));
        this.assertTrue(meta.supportsTransactionIsolationLevel(6));
        this.assertTrue(meta.supportsTransactionIsolationLevel(8));
        this.assertTrue(meta.supportsUnion());
        this.assertTrue(meta.supportsUnionAll());
        this.assertFalse(meta.updatesAreDetected(1003));
        this.assertFalse(meta.updatesAreDetected(1004));
        this.assertFalse(meta.updatesAreDetected(1005));
        this.assertFalse(meta.usesLocalFilePerTable());
        this.assertTrue(meta.usesLocalFiles());
        conn.close();
    }

    private void testNullsAreSortedAt() throws SQLException {
        Connection conn = this.getConnection("metaData");
        Statement stat = conn.createStatement();
        DatabaseMetaData meta = conn.getMetaData();
        this.testNullsAreSortedAt(meta, DefaultNullOrdering.LOW);
        stat.execute("SET DEFAULT_NULL_ORDERING LOW");
        this.testNullsAreSortedAt(meta, DefaultNullOrdering.LOW);
        stat.execute("SET DEFAULT_NULL_ORDERING HIGH");
        this.testNullsAreSortedAt(meta, DefaultNullOrdering.HIGH);
        stat.execute("SET DEFAULT_NULL_ORDERING FIRST");
        this.testNullsAreSortedAt(meta, DefaultNullOrdering.FIRST);
        stat.execute("SET DEFAULT_NULL_ORDERING LAST");
        this.testNullsAreSortedAt(meta, DefaultNullOrdering.LAST);
        stat.execute("SET DEFAULT_NULL_ORDERING LOW");
        conn.close();
    }

    private void testNullsAreSortedAt(DatabaseMetaData meta, DefaultNullOrdering ordering) throws SQLException {
        this.assertEquals(ordering == DefaultNullOrdering.HIGH, meta.nullsAreSortedHigh());
        this.assertEquals(ordering == DefaultNullOrdering.LOW, meta.nullsAreSortedLow());
        this.assertEquals(ordering == DefaultNullOrdering.FIRST, meta.nullsAreSortedAtStart());
        this.assertEquals(ordering == DefaultNullOrdering.LAST, meta.nullsAreSortedAtEnd());
    }

    private void testMore() throws SQLException {
        Connection conn = this.getConnection("metaData");
        DatabaseMetaData meta = conn.getMetaData();
        Statement stat = conn.createStatement();
        conn.setReadOnly(true);
        conn.setReadOnly(false);
        this.assertFalse(conn.isReadOnly());
        this.assertTrue(conn.isReadOnly() == meta.isReadOnly());
        this.assertTrue(conn == meta.getConnection());
        conn.setCatalog("XYZ");
        this.trace(conn.getCatalog());
        String product = meta.getDatabaseProductName();
        this.trace("meta.getDatabaseProductName:" + product);
        String version = meta.getDatabaseProductVersion();
        this.trace("meta.getDatabaseProductVersion:" + version);
        int major = meta.getDriverMajorVersion();
        this.trace("meta.getDriverMajorVersion:" + major);
        int minor = meta.getDriverMinorVersion();
        this.trace("meta.getDriverMinorVersion:" + minor);
        String driverName = meta.getDriverName();
        this.trace("meta.getDriverName:" + driverName);
        String driverVersion = meta.getDriverVersion();
        this.trace("meta.getDriverVersion:" + driverVersion);
        meta.getSearchStringEscape();
        String url = meta.getURL();
        this.trace("meta.getURL:" + url);
        String user = meta.getUserName();
        this.trace("meta.getUserName:" + user);
        this.trace("meta.nullsAreSortedHigh:" + meta.nullsAreSortedHigh());
        this.trace("meta.nullsAreSortedLow:" + meta.nullsAreSortedLow());
        this.trace("meta.nullsAreSortedAtStart:" + meta.nullsAreSortedAtStart());
        this.trace("meta.nullsAreSortedAtEnd:" + meta.nullsAreSortedAtEnd());
        int count = (meta.nullsAreSortedHigh() ? 1 : 0) + (meta.nullsAreSortedLow() ? 1 : 0) + (meta.nullsAreSortedAtStart() ? 1 : 0) + (meta.nullsAreSortedAtEnd() ? 1 : 0);
        this.assertTrue(count == 1);
        this.trace("meta.allProceduresAreCallable:" + meta.allProceduresAreCallable());
        this.assertTrue(meta.allProceduresAreCallable());
        this.trace("meta.allTablesAreSelectable:" + meta.allTablesAreSelectable());
        this.assertTrue(meta.allTablesAreSelectable());
        this.trace("getTables");
        ResultSet rs = meta.getTables(null, "PUBLIC", null, new String[]{"TABLE"});
        this.assertResultSetMeta(rs, 10, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12}, null, null);
        if (rs.next()) {
            this.fail("Database is not empty after dropping all tables");
        }
        stat.executeUpdate("CREATE TABLE TEST(ID INT PRIMARY KEY,TEXT_V VARCHAR(120),DEC_V DECIMAL(12,3),NUM_V NUMERIC(12,3),DATE_V DATETIME,BLOB_V BLOB,CLOB_V CLOB)");
        rs = meta.getTables(null, "PUBLIC", null, new String[]{"TABLE"});
        this.assertResultSetOrdered(rs, new String[][]{{CATALOG, "PUBLIC", "TEST", "BASE TABLE"}});
        this.trace("getColumns");
        rs = meta.getColumns(null, null, "TEST", null);
        this.assertResultSetMeta(rs, 24, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN"}, new int[]{12, 12, 12, 12, 4, 12, 4, 4, 4, 4, 4, 12, 12, 4, 4, 4, 4, 12, 12, 12, 12, 5, 12, 12}, null, null);
        String[][] stringArray = new String[7][];
        String[] stringArray2 = new String[18];
        stringArray2[0] = CATALOG;
        stringArray2[1] = "PUBLIC";
        stringArray2[2] = "TEST";
        stringArray2[3] = "ID";
        stringArray2[4] = "4";
        stringArray2[5] = "INTEGER";
        stringArray2[6] = "32";
        stringArray2[8] = "0";
        stringArray2[9] = "2";
        stringArray2[10] = "0";
        stringArray2[15] = "32";
        stringArray2[16] = "1";
        stringArray2[17] = "NO";
        stringArray[0] = stringArray2;
        String[] stringArray3 = new String[18];
        stringArray3[0] = CATALOG;
        stringArray3[1] = "PUBLIC";
        stringArray3[2] = "TEST";
        stringArray3[3] = "TEXT_V";
        stringArray3[4] = "12";
        stringArray3[5] = "CHARACTER VARYING";
        stringArray3[6] = "120";
        stringArray3[8] = "0";
        stringArray3[10] = "1";
        stringArray3[15] = "120";
        stringArray3[16] = "2";
        stringArray3[17] = "YES";
        stringArray[1] = stringArray3;
        String[] stringArray4 = new String[18];
        stringArray4[0] = CATALOG;
        stringArray4[1] = "PUBLIC";
        stringArray4[2] = "TEST";
        stringArray4[3] = "DEC_V";
        stringArray4[4] = "3";
        stringArray4[5] = "DECIMAL";
        stringArray4[6] = "12";
        stringArray4[8] = "3";
        stringArray4[9] = "10";
        stringArray4[10] = "1";
        stringArray4[15] = "12";
        stringArray4[16] = "3";
        stringArray4[17] = "YES";
        stringArray[2] = stringArray4;
        String[] stringArray5 = new String[18];
        stringArray5[0] = CATALOG;
        stringArray5[1] = "PUBLIC";
        stringArray5[2] = "TEST";
        stringArray5[3] = "NUM_V";
        stringArray5[4] = "2";
        stringArray5[5] = "NUMERIC";
        stringArray5[6] = "12";
        stringArray5[8] = "3";
        stringArray5[9] = "10";
        stringArray5[10] = "1";
        stringArray5[15] = "12";
        stringArray5[16] = "4";
        stringArray5[17] = "YES";
        stringArray[3] = stringArray5;
        String[] stringArray6 = new String[18];
        stringArray6[0] = CATALOG;
        stringArray6[1] = "PUBLIC";
        stringArray6[2] = "TEST";
        stringArray6[3] = "DATE_V";
        stringArray6[4] = "93";
        stringArray6[5] = "TIMESTAMP";
        stringArray6[6] = "26";
        stringArray6[8] = "6";
        stringArray6[10] = "1";
        stringArray6[15] = "26";
        stringArray6[16] = "5";
        stringArray6[17] = "YES";
        stringArray[4] = stringArray6;
        String[] stringArray7 = new String[18];
        stringArray7[0] = CATALOG;
        stringArray7[1] = "PUBLIC";
        stringArray7[2] = "TEST";
        stringArray7[3] = "BLOB_V";
        stringArray7[4] = "2004";
        stringArray7[5] = "BINARY LARGE OBJECT";
        stringArray7[6] = "2147483647";
        stringArray7[8] = "0";
        stringArray7[10] = "1";
        stringArray7[15] = "2147483647";
        stringArray7[16] = "6";
        stringArray7[17] = "YES";
        stringArray[5] = stringArray7;
        String[] stringArray8 = new String[18];
        stringArray8[0] = CATALOG;
        stringArray8[1] = "PUBLIC";
        stringArray8[2] = "TEST";
        stringArray8[3] = "CLOB_V";
        stringArray8[4] = "2005";
        stringArray8[5] = "CHARACTER LARGE OBJECT";
        stringArray8[6] = "2147483647";
        stringArray8[8] = "0";
        stringArray8[10] = "1";
        stringArray8[15] = "2147483647";
        stringArray8[16] = "7";
        stringArray8[17] = "YES";
        stringArray[6] = stringArray8;
        this.assertResultSetOrdered(rs, stringArray);
        this.trace("getIndexInfo");
        stat.executeUpdate("CREATE INDEX IDX_TEXT_DEC ON TEST(TEXT_V,DEC_V)");
        stat.executeUpdate("CREATE UNIQUE INDEX IDX_DATE ON TEST(DATE_V)");
        rs = meta.getIndexInfo(null, null, "TEST", false, false);
        this.assertResultSetMeta(rs, 13, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"}, new int[]{12, 12, 12, 16, 12, 12, 5, 5, 12, 12, -5, -5, 12}, null, null);
        this.assertResultSetOrdered(rs, new String[][]{{CATALOG, "PUBLIC", "TEST", "FALSE", CATALOG, "IDX_DATE", "3", "1", "DATE_V", "A", "0", "0"}, {CATALOG, "PUBLIC", "TEST", "FALSE", CATALOG, "PRIMARY_KEY_2", "3", "1", "ID", "A", "0", "0"}, {CATALOG, "PUBLIC", "TEST", "TRUE", CATALOG, "IDX_TEXT_DEC", "3", "1", "TEXT_V", "A", "0", "0"}, {CATALOG, "PUBLIC", "TEST", "TRUE", CATALOG, "IDX_TEXT_DEC", "3", "2", "DEC_V", "A", "0", "0"}}, new int[]{11});
        stat.executeUpdate("DROP INDEX IDX_TEXT_DEC");
        stat.executeUpdate("DROP INDEX IDX_DATE");
        rs = meta.getIndexInfo(null, null, "TEST", false, false);
        this.assertResultSetMeta(rs, 13, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"}, new int[]{12, 12, 12, 16, 12, 12, 5, 5, 12, 12, -5, -5, 12}, null, null);
        this.assertResultSetOrdered(rs, new String[][]{{CATALOG, "PUBLIC", "TEST", "FALSE", CATALOG, "PRIMARY_KEY_2", "3", "1", "ID", "A", "0", "0"}}, new int[]{11});
        this.trace("getPrimaryKeys");
        rs = meta.getPrimaryKeys(null, null, "TEST");
        this.assertResultSetMeta(rs, 6, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"}, new int[]{12, 12, 12, 12, 5, 12}, null, null);
        this.assertResultSetOrdered(rs, new String[][]{{CATALOG, "PUBLIC", "TEST", "ID", "1", "CONSTRAINT_2"}});
        this.trace("getTables - using a wildcard");
        stat.executeUpdate("CREATE TABLE T_2(B INT,A VARCHAR(6),C INT,PRIMARY KEY(C,A,B))");
        stat.executeUpdate("CREATE TABLE TX2(B INT,A VARCHAR(6),C INT,PRIMARY KEY(C,A,B))");
        rs = meta.getTables(null, null, "T_2", null);
        this.assertResultSetOrdered(rs, new String[][]{{CATALOG, "PUBLIC", "TX2", "BASE TABLE"}, {CATALOG, "PUBLIC", "T_2", "BASE TABLE"}});
        this.trace("getTables - using a quoted _ character");
        rs = meta.getTables(null, null, "T\\_2", null);
        this.assertResultSetOrdered(rs, new String[][]{{CATALOG, "PUBLIC", "T_2", "BASE TABLE"}});
        this.trace("getTables - using the % wildcard");
        rs = meta.getTables(null, "PUBLIC", "%", new String[]{"TABLE"});
        this.assertResultSetOrdered(rs, new String[][]{{CATALOG, "PUBLIC", "TEST", "BASE TABLE"}, {CATALOG, "PUBLIC", "TX2", "BASE TABLE"}, {CATALOG, "PUBLIC", "T_2", "BASE TABLE"}});
        stat.execute("DROP TABLE TEST");
        this.trace("getColumns - using wildcards");
        rs = meta.getColumns(null, null, "___", "B%");
        this.assertResultSetOrdered(rs, new String[][]{{CATALOG, "PUBLIC", "TX2", "B", "4", "INTEGER", "32"}, {CATALOG, "PUBLIC", "T_2", "B", "4", "INTEGER", "32"}});
        this.trace("getColumns - using wildcards");
        rs = meta.getColumns(null, null, "_\\__", "%");
        this.assertResultSetOrdered(rs, new String[][]{{CATALOG, "PUBLIC", "T_2", "B", "4", "INTEGER", "32"}, {CATALOG, "PUBLIC", "T_2", "A", "12", "CHARACTER VARYING", "6"}, {CATALOG, "PUBLIC", "T_2", "C", "4", "INTEGER", "32"}});
        this.trace("getIndexInfo");
        stat.executeUpdate("CREATE UNIQUE INDEX A_INDEX ON TX2(B,C,A)");
        stat.executeUpdate("CREATE INDEX B_INDEX ON TX2(A,B,C)");
        rs = meta.getIndexInfo(null, null, "TX2", false, false);
        this.assertResultSetOrdered(rs, new String[][]{{CATALOG, "PUBLIC", "TX2", "FALSE", CATALOG, "A_INDEX", "3", "1", "B", "A"}, {CATALOG, "PUBLIC", "TX2", "FALSE", CATALOG, "A_INDEX", "3", "2", "C", "A"}, {CATALOG, "PUBLIC", "TX2", "FALSE", CATALOG, "A_INDEX", "3", "3", "A", "A"}, {CATALOG, "PUBLIC", "TX2", "FALSE", CATALOG, "PRIMARY_KEY_14", "3", "1", "C", "A"}, {CATALOG, "PUBLIC", "TX2", "FALSE", CATALOG, "PRIMARY_KEY_14", "3", "2", "A", "A"}, {CATALOG, "PUBLIC", "TX2", "FALSE", CATALOG, "PRIMARY_KEY_14", "3", "3", "B", "A"}, {CATALOG, "PUBLIC", "TX2", "TRUE", CATALOG, "B_INDEX", "3", "1", "A", "A"}, {CATALOG, "PUBLIC", "TX2", "TRUE", CATALOG, "B_INDEX", "3", "2", "B", "A"}, {CATALOG, "PUBLIC", "TX2", "TRUE", CATALOG, "B_INDEX", "3", "3", "C", "A"}}, new int[]{11});
        this.trace("getPrimaryKeys");
        rs = meta.getPrimaryKeys(null, null, "T_2");
        this.assertResultSetOrdered(rs, new String[][]{{CATALOG, "PUBLIC", "T_2", "A", "2", "CONSTRAINT_1"}, {CATALOG, "PUBLIC", "T_2", "B", "3", "CONSTRAINT_1"}, {CATALOG, "PUBLIC", "T_2", "C", "1", "CONSTRAINT_1"}});
        stat.executeUpdate("DROP TABLE TX2");
        stat.executeUpdate("DROP TABLE T_2");
        stat.executeUpdate("CREATE TABLE PARENT(ID INT PRIMARY KEY)");
        stat.executeUpdate("CREATE TABLE CHILD(P_ID INT,ID INT,PRIMARY KEY(P_ID,ID),FOREIGN KEY(P_ID) REFERENCES PARENT(ID))");
        this.trace("getImportedKeys");
        rs = meta.getImportedKeys(null, null, "CHILD");
        this.assertResultSetMeta(rs, 14, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5}, null, null);
        this.trace("getExportedKeys");
        rs = meta.getExportedKeys(null, null, "PARENT");
        this.assertResultSetMeta(rs, 14, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5}, null, null);
        this.trace("getCrossReference");
        rs = meta.getCrossReference(null, null, "PARENT", null, null, "CHILD");
        this.assertResultSetMeta(rs, 14, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5}, null, null);
        rs = meta.getSchemas();
        this.assertResultSetMeta(rs, 2, new String[]{"TABLE_SCHEM", "TABLE_CATALOG"}, new int[]{12, 12}, null, null);
        this.assertTrue(rs.next());
        this.assertEquals("INFORMATION_SCHEMA", rs.getString(1));
        this.assertTrue(rs.next());
        this.assertEquals("PUBLIC", rs.getString(1));
        this.assertFalse(rs.next());
        rs = meta.getSchemas(null, null);
        this.assertResultSetMeta(rs, 2, new String[]{"TABLE_SCHEM", "TABLE_CATALOG"}, new int[]{12, 12}, null, null);
        this.assertTrue(rs.next());
        this.assertEquals("INFORMATION_SCHEMA", rs.getString(1));
        this.assertTrue(rs.next());
        this.assertEquals("PUBLIC", rs.getString(1));
        this.assertFalse(rs.next());
        rs = meta.getCatalogs();
        this.assertResultSetMeta(rs, 1, new String[]{"TABLE_CAT"}, new int[]{12}, null, null);
        this.assertResultSetOrdered(rs, new String[][]{{CATALOG}});
        rs = meta.getTableTypes();
        this.assertResultSetMeta(rs, 1, new String[]{"TABLE_TYPE"}, new int[]{12}, null, null);
        this.assertResultSetOrdered(rs, new String[][]{{"BASE TABLE"}, {"GLOBAL TEMPORARY"}, {"LOCAL TEMPORARY"}, {"SYNONYM"}, {"VIEW"}});
        rs = meta.getTypeInfo();
        this.assertResultSetMeta(rs, 18, new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"}, new int[]{12, 4, 4, 12, 12, 12, 5, 16, 5, 16, 16, 16, 12, 5, 5, 4, 4, 4}, null, null);
        rs = meta.getTablePrivileges(null, null, null);
        this.assertResultSetMeta(rs, 7, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12}, null, null);
        rs = meta.getColumnPrivileges(null, null, "TEST", null);
        this.assertResultSetMeta(rs, 8, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12}, null, null);
        this.assertNull(conn.getWarnings());
        conn.clearWarnings();
        this.assertNull(conn.getWarnings());
        conn.close();
    }

    private void testGeneral() throws SQLException {
        Connection conn = this.getConnection("metaData");
        DatabaseMetaData meta = conn.getMetaData();
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("CREATE INDEX IDXNAME ON TEST(NAME)");
        ResultSet rs = meta.getCatalogs();
        rs.next();
        this.assertEquals(CATALOG, rs.getString(1));
        this.assertFalse(rs.next());
        rs = meta.getSchemas();
        rs.next();
        this.assertEquals("INFORMATION_SCHEMA", rs.getString("TABLE_SCHEM"));
        rs.next();
        this.assertEquals("PUBLIC", rs.getString("TABLE_SCHEM"));
        this.assertFalse(rs.next());
        rs = meta.getSchemas(null, null);
        rs.next();
        this.assertEquals("INFORMATION_SCHEMA", rs.getString("TABLE_SCHEM"));
        rs.next();
        this.assertEquals("PUBLIC", rs.getString("TABLE_SCHEM"));
        this.assertFalse(rs.next());
        rs = meta.getSchemas(null, "PUBLIC");
        rs.next();
        this.assertEquals("PUBLIC", rs.getString("TABLE_SCHEM"));
        this.assertFalse(rs.next());
        rs = meta.getTableTypes();
        rs.next();
        this.assertEquals("BASE TABLE", rs.getString("TABLE_TYPE"));
        rs.next();
        this.assertEquals("GLOBAL TEMPORARY", rs.getString("TABLE_TYPE"));
        rs.next();
        this.assertEquals("LOCAL TEMPORARY", rs.getString("TABLE_TYPE"));
        rs.next();
        this.assertEquals("SYNONYM", rs.getString("TABLE_TYPE"));
        rs.next();
        this.assertEquals("VIEW", rs.getString("TABLE_TYPE"));
        this.assertFalse(rs.next());
        rs = meta.getTables(null, "PUBLIC", null, new String[]{"TABLE"});
        this.assertNull(rs.getStatement());
        rs.next();
        this.assertEquals("TEST", rs.getString("TABLE_NAME"));
        this.assertFalse(rs.next());
        rs = meta.getTables(null, "INFORMATION_SCHEMA", null, new String[]{"BASE TABLE", "VIEW"});
        String[] stringArray = new String[]{"CONSTANTS", "ENUM_VALUES", "INDEXES", "INDEX_COLUMNS", "INFORMATION_SCHEMA_CATALOG_NAME", "IN_DOUBT", "LOCKS", "QUERY_STATISTICS", "RIGHTS", "ROLES", "SESSIONS", "SESSION_STATE", "SETTINGS", "SYNONYMS", "USERS", "CHECK_CONSTRAINTS", "COLLATIONS", "COLUMNS", "COLUMN_PRIVILEGES", "CONSTRAINT_COLUMN_USAGE", "DOMAINS", "DOMAIN_CONSTRAINTS", "ELEMENT_TYPES", "FIELDS", "KEY_COLUMN_USAGE", "PARAMETERS", "REFERENTIAL_CONSTRAINTS", "ROUTINES", "SCHEMATA", "SEQUENCES", "TABLES", "TABLE_CONSTRAINTS", "TABLE_PRIVILEGES", "TRIGGERS", "VIEWS"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            rs.next();
            this.assertEquals(name, rs.getString("TABLE_NAME"));
            ++n2;
        }
        this.assertFalse(rs.next());
        rs = meta.getColumns(null, null, "TEST", null);
        rs.next();
        this.assertEquals("ID", rs.getString("COLUMN_NAME"));
        rs.next();
        this.assertEquals("NAME", rs.getString("COLUMN_NAME"));
        this.assertFalse(rs.next());
        rs = meta.getPrimaryKeys(null, null, "TEST");
        rs.next();
        this.assertEquals("ID", rs.getString("COLUMN_NAME"));
        this.assertFalse(rs.next());
        rs = meta.getBestRowIdentifier(null, null, "TEST", 2, false);
        rs.next();
        this.assertEquals("ID", rs.getString("COLUMN_NAME"));
        this.assertFalse(rs.next());
        rs = meta.getIndexInfo(null, null, "TEST", false, false);
        rs.next();
        String index = rs.getString("INDEX_NAME");
        this.assertTrue(index.startsWith("PRIMARY_KEY"));
        this.assertEquals("ID", rs.getString("COLUMN_NAME"));
        rs.next();
        this.assertEquals("IDXNAME", rs.getString("INDEX_NAME"));
        this.assertEquals("NAME", rs.getString("COLUMN_NAME"));
        this.assertFalse(rs.next());
        rs = meta.getIndexInfo(null, null, "TEST", true, false);
        rs.next();
        index = rs.getString("INDEX_NAME");
        this.assertTrue(index.startsWith("PRIMARY_KEY"));
        this.assertEquals("ID", rs.getString("COLUMN_NAME"));
        this.assertFalse(rs.next());
        rs = meta.getVersionColumns(null, null, "TEST");
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE TEST");
        rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.SETTINGS");
        int mvStoreSettingsCount = 0;
        int pageStoreSettingsCount = 0;
        while (rs.next()) {
            String name = rs.getString("SETTING_NAME");
            this.trace(name + "=" + rs.getString("SETTING_VALUE"));
            if ("COMPRESS".equals(name) || "REUSE_SPACE".equals(name)) {
                ++mvStoreSettingsCount;
                continue;
            }
            if (!name.startsWith("PAGE_STORE_")) continue;
            ++pageStoreSettingsCount;
        }
        this.assertEquals(2, mvStoreSettingsCount);
        this.assertEquals(0, pageStoreSettingsCount);
        this.testMore();
        conn.close();
        this.deleteDb("metaData");
    }

    private void testAllowLiteralsNone() throws SQLException {
        Connection conn = this.getConnection("metaData");
        Statement stat = conn.createStatement();
        stat.execute("SET ALLOW_LITERALS NONE");
        DatabaseMetaData meta = conn.getMetaData();
        meta.getBestRowIdentifier(null, null, "TEST", 0, false);
        meta.getCatalogs();
        meta.getColumnPrivileges(null, null, "TEST", null);
        meta.getColumns(null, null, null, null);
        meta.getCrossReference(null, null, "TEST", null, null, "TEST");
        meta.getExportedKeys(null, null, "TEST");
        meta.getImportedKeys(null, null, "TEST");
        meta.getIndexInfo(null, null, "TEST", false, false);
        meta.getPrimaryKeys(null, null, "TEST");
        meta.getProcedureColumns(null, null, null, null);
        meta.getProcedures(null, null, null);
        meta.getSchemas();
        meta.getSchemas(null, null);
        meta.getSuperTables(null, null, null);
        meta.getTablePrivileges(null, null, null);
        meta.getTables(null, null, null, null);
        meta.getTableTypes();
        meta.getTypeInfo();
        meta.getUDTs(null, null, null, null);
        meta.getVersionColumns(null, null, null);
        conn.close();
        this.deleteDb("metaData");
    }

    private void testClientInfo() throws SQLException {
        Connection conn = this.getConnection("metaData");
        this.assertNull(conn.getClientInfo("xxx"));
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getClientInfoProperties();
        ResultSetMetaData rsMeta = rs.getMetaData();
        this.assertEquals("NAME", rsMeta.getColumnName(1));
        this.assertEquals("MAX_LEN", rsMeta.getColumnName(2));
        this.assertEquals("DEFAULT_VALUE", rsMeta.getColumnName(3));
        this.assertEquals("DESCRIPTION", rsMeta.getColumnName(4));
        this.assertEquals("VALUE", rsMeta.getColumnName(5));
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        if (this.config.networked) {
            this.assertEquals(2, count);
        } else {
            this.assertEquals(1, count);
        }
        rs.close();
        conn.close();
        this.deleteDb("metaData");
    }

    private void testQueryStatistics() throws SQLException {
        Connection conn = this.getConnection("metaData");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar) as select x, space(1000) from system_range(1, 2000)");
        ResultSet rs = stat.executeQuery("select * from INFORMATION_SCHEMA.QUERY_STATISTICS");
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("SET QUERY_STATISTICS TRUE");
        int count = 100;
        int i = 0;
        while (i < count) {
            this.execute(stat, "select * from test limit 10");
            ++i;
        }
        rs = stat.executeQuery("select * from INFORMATION_SCHEMA.QUERY_STATISTICS ORDER BY EXECUTION_COUNT desc");
        this.assertTrue(rs.next());
        this.assertEquals("select * from test limit 10", rs.getString("SQL_STATEMENT"));
        this.assertEquals(count, rs.getInt("EXECUTION_COUNT"));
        this.assertEquals(this.config.lazy ? 0 : 10 * count, rs.getInt("CUMULATIVE_ROW_COUNT"));
        rs.close();
        conn.close();
        this.deleteDb("metaData");
    }

    private void testQueryStatisticsLimit() throws SQLException {
        Connection conn = this.getConnection("metaData");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar) as select x, space(1000) from system_range(1, 2000)");
        ResultSet rs = stat.executeQuery("select * from INFORMATION_SCHEMA.QUERY_STATISTICS");
        this.assertFalse(rs.next());
        rs.close();
        int statisticsMaxEntries = 200;
        this.assertTrue(statisticsMaxEntries > 100);
        stat.execute("SET QUERY_STATISTICS_MAX_ENTRIES " + statisticsMaxEntries);
        stat.execute("SET QUERY_STATISTICS TRUE");
        int i = 0;
        while (i < statisticsMaxEntries * 2) {
            stat.execute("select * from test where id = " + i);
            ++i;
        }
        rs = stat.executeQuery("select count(*) from INFORMATION_SCHEMA.QUERY_STATISTICS");
        this.assertTrue(rs.next());
        this.assertEquals(statisticsMaxEntries, rs.getInt(1));
        rs.close();
        int statisticsMaxEntriesNew = 50;
        this.assertTrue(statisticsMaxEntriesNew < 100);
        stat.execute("SET QUERY_STATISTICS_MAX_ENTRIES " + statisticsMaxEntriesNew);
        int i2 = 0;
        while (i2 < statisticsMaxEntriesNew * 2) {
            stat.execute("select * from test where id = " + i2);
            ++i2;
        }
        rs = stat.executeQuery("select count(*) from INFORMATION_SCHEMA.QUERY_STATISTICS");
        this.assertTrue(rs.next());
        this.assertEquals(statisticsMaxEntriesNew, rs.getInt(1));
        rs.close();
        conn.close();
        this.deleteDb("metaData");
    }
}

