/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.UUID;
import org.h2.api.H2Type;
import org.h2.api.Interval;
import org.h2.api.IntervalQualifier;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Task;

public class TestPreparedStatement
extends TestDb {
    private static final int LOB_SIZE = 4000;
    private static final int LOB_SIZE_BIG = 524288;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("preparedStatement");
        Connection conn = this.getConnection("preparedStatement");
        this.testUnwrap(conn);
        this.testUnsupportedOperations(conn);
        TestPreparedStatement.testChangeType(conn);
        TestPreparedStatement.testCallTablePrepared(conn);
        this.testValues(conn);
        this.testToString(conn);
        this.testExecuteUpdateCall(conn);
        this.testPrepareExecute(conn);
        this.testEnum(conn);
        this.testUUID(conn);
        this.testUUIDAsJavaObject(conn);
        this.testLobTempFiles(conn);
        this.testExecuteErrorTwice(conn);
        this.testTempView(conn);
        this.testInsertFunction(conn);
        this.testPrepareRecompile(conn);
        this.testMaxRowsChange(conn);
        this.testUnknownDataType(conn);
        this.testCancelReuse(conn);
        TestPreparedStatement.testCoalesce(conn);
        this.testPreparedStatementMetaData(conn);
        this.testBigDecimal(conn);
        this.testDate(conn);
        this.testDate8(conn);
        this.testTime8(conn);
        this.testOffsetTime8(conn);
        this.testDateTime8(conn);
        this.testOffsetDateTime8(conn);
        this.testZonedDateTime8(conn);
        this.testInstant8(conn);
        this.testInterval(conn);
        this.testInterval8(conn);
        this.testJson(conn);
        this.testArray(conn);
        this.testSetObject(conn);
        this.testSetObject2(conn);
        this.testPreparedSubquery(conn);
        this.testLikeIndex(conn);
        this.testCasewhen(conn);
        this.testSubquery(conn);
        this.testObject(conn);
        this.testDataTypes(conn);
        this.testGetMoreResults(conn);
        this.testBlob(conn);
        this.testClob(conn);
        this.testParameterMetaData(conn);
        this.testColumnMetaDataWithEquals(conn);
        this.testColumnMetaDataWithIn(conn);
        this.testMultipleStatements(conn);
        this.testParameterInSubquery(conn);
        this.testAfterRollback(conn);
        this.testUnnestWithArrayParameter(conn);
        conn.close();
        this.testPreparedStatementWithLiteralsNone();
        this.testPreparedStatementWithIndexedParameterAndLiteralsNone();
        this.testPreparedStatementWithAnyParameter();
        this.deleteDb("preparedStatement");
    }

    private void testUnwrap(Connection conn) throws SQLException {
        this.assertTrue(conn.isWrapperFor(Object.class));
        this.assertTrue(conn.isWrapperFor(Connection.class));
        this.assertTrue(conn.isWrapperFor(conn.getClass()));
        this.assertFalse(conn.isWrapperFor(String.class));
        this.assertTrue(conn == conn.unwrap(Object.class));
        this.assertTrue(conn == conn.unwrap(Connection.class));
        this.assertThrows(90008, conn).unwrap(String.class);
    }

    private void testUnsupportedOperations(Connection conn) throws Exception {
        PreparedStatement prep = conn.prepareStatement("select ? from dual");
        this.assertThrows(90130, prep).addBatch("select 1");
        this.assertThrows(90130, prep).executeUpdate("create table test(id int)");
        this.assertThrows(90130, prep).executeUpdate("create table test(id int)", new int[0]);
        this.assertThrows(90130, prep).executeUpdate("create table test(id int)", new String[0]);
        this.assertThrows(90130, prep).executeUpdate("create table test(id int)", 1);
        this.assertThrows(90130, prep).execute("create table test(id int)");
        this.assertThrows(90130, prep).execute("create table test(id int)", new int[0]);
        this.assertThrows(90130, prep).execute("create table test(id int)", new String[0]);
        this.assertThrows(90130, prep).execute("create table test(id int)", 1);
        this.assertThrows(90130, prep).executeQuery("select * from dual");
        this.assertThrows(50100, prep).setURL(1, new URL("http://www.acme.com"));
        this.assertThrows(50100, prep).setRowId(1, null);
        this.assertThrows(50100, prep).setUnicodeStream(1, null, 0);
        ParameterMetaData meta = prep.getParameterMetaData();
        this.assertTrue(meta.toString(), meta.toString().endsWith("parameterCount=1"));
        this.assertThrows(50100, conn).createStruct("Integer", new Object[0]);
    }

    private static void testChangeType(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("select (? || ? || ?) from dual");
        prep.setString(1, "a");
        prep.setString(2, "b");
        prep.setString(3, "c");
        prep.executeQuery();
        prep.setInt(1, 1);
        prep.setString(2, "ab");
        prep.setInt(3, 45);
        prep.executeQuery();
    }

    private static void testCallTablePrepared(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("select * from table(x int = (1))");
        prep.executeQuery();
        prep.executeQuery();
    }

    private void testValues(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("values(?, ?)");
        prep.setInt(1, 1);
        prep.setString(2, "Hello");
        ResultSet rs = prep.executeQuery();
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        prep = conn.prepareStatement("select * from values(?, ?), (2, 'World!')");
        prep.setInt(1, 1);
        prep.setString(2, "Hello");
        rs = prep.executeQuery();
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("World!", rs.getString(2));
        prep = conn.prepareStatement("values 1, 2");
        rs = prep.executeQuery();
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        rs.next();
        this.assertEquals(2, rs.getInt(1));
    }

    private void testToString(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("call 1");
        this.assertTrue(prep.toString().endsWith(": call 1"));
        prep = conn.prepareStatement("call ?");
        this.assertTrue(prep.toString().endsWith(": call ?"));
        prep.setString(1, "Hello World");
        this.assertTrue(prep.toString().endsWith(": call ? {1: 'Hello World'}"));
    }

    private void testExecuteUpdateCall(Connection conn) throws SQLException {
        this.assertThrows(22018, conn.createStatement()).executeUpdate("CALL HASH('SHA256', STRINGTOUTF8('Password'), 1000)");
    }

    private void testPrepareExecute(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("prepare test(int, int) as select ?1*?2");
        ResultSet rs = stat.executeQuery("execute test(3, 2)");
        rs.next();
        this.assertEquals(6, rs.getInt(1));
        stat.execute("deallocate test");
    }

    private void testLobTempFiles(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, DATA CLOB)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        int i = 0;
        while (i < 5) {
            prep.setInt(1, i);
            if (i % 2 == 0) {
                prep.setCharacterStream(2, (Reader)new StringReader(TestPreparedStatement.getString(i)), -1);
            }
            prep.execute();
            ++i;
        }
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        int check = 0;
        int i2 = 0;
        while (i2 < 5) {
            this.assertTrue(rs.next());
            if (i2 % 2 == 0) {
                check = i2;
            }
            this.assertEquals(TestPreparedStatement.getString(check), rs.getString(2));
            ++i2;
        }
        this.assertFalse(rs.next());
        stat.execute("DELETE FROM TEST");
        i2 = 0;
        while (i2 < 3) {
            prep.setInt(1, i2);
            prep.setCharacterStream(2, (Reader)new StringReader(TestPreparedStatement.getString(i2)), -1);
            prep.addBatch();
            ++i2;
        }
        prep.executeBatch();
        rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        i2 = 0;
        while (i2 < 3) {
            this.assertTrue(rs.next());
            this.assertEquals(TestPreparedStatement.getString(i2), rs.getString(2));
            ++i2;
        }
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE TEST");
    }

    private static String getString(int i) {
        return new String(new char[100000]).replace('\u0000', (char)(48 + i));
    }

    private void testExecuteErrorTwice(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("CREATE TABLE BAD AS SELECT A");
        this.assertThrows(42122, prep).execute();
        this.assertThrows(42122, prep).execute();
    }

    private void testTempView(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(FIELD INT PRIMARY KEY)");
        stat.execute("INSERT INTO TEST VALUES(1)");
        stat.execute("INSERT INTO TEST VALUES(2)");
        PreparedStatement prep = conn.prepareStatement("select FIELD FROM (select FIELD FROM (SELECT FIELD  FROM TEST WHERE FIELD = ?) AS T2 WHERE T2.FIELD = ?) AS T3 WHERE T3.FIELD = ?");
        prep.setInt(1, 1);
        prep.setInt(2, 1);
        prep.setInt(3, 1);
        ResultSet rs = prep.executeQuery();
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        prep.setInt(1, 2);
        prep.setInt(2, 2);
        prep.setInt(3, 2);
        rs = prep.executeQuery();
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        stat.execute("DROP TABLE TEST");
    }

    private void testInsertFunction(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT, H VARBINARY)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, HASH('SHA256', STRINGTOUTF8(?), 5))");
        prep.setInt(1, 1);
        prep.setString(2, "One");
        prep.execute();
        prep.setInt(1, 2);
        prep.setString(2, "Two");
        prep.execute();
        ResultSet rs = stat.executeQuery("SELECT COUNT(DISTINCT H) FROM TEST");
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareRecompile(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        PreparedStatement prep = conn.prepareStatement("SELECT COUNT(*) FROM DUAL WHERE ? IS NULL");
        prep.setString(1, null);
        prep.executeQuery();
        stat.execute("CREATE TABLE TEST(ID INT)");
        stat.execute("DROP TABLE TEST");
        prep.setString(1, null);
        prep.executeQuery();
        prep.setString(1, "X");
        ResultSet rs = prep.executeQuery();
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        stat.execute("CREATE TABLE t1 (c1 INT, c2 VARCHAR(10))");
        stat.execute("INSERT INTO t1 SELECT X, CONCAT('Test', X)  FROM SYSTEM_RANGE(1, 5);");
        prep = conn.prepareStatement("SELECT c1, c2 FROM t1 WHERE c1 = ?");
        prep.setInt(1, 1);
        prep.executeQuery();
        stat.execute("CREATE TABLE t2 (x int PRIMARY KEY)");
        prep.setInt(1, 2);
        rs = prep.executeQuery();
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        prep.setInt(1, 3);
        rs = prep.executeQuery();
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        stat.execute("DROP TABLE t1, t2");
    }

    private void testMaxRowsChange(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT * FROM SYSTEM_RANGE(1, 100)");
        int j = 1;
        while (j < 20) {
            prep.setMaxRows(j);
            ResultSet rs = prep.executeQuery();
            int i = 0;
            while (i < j) {
                this.assertTrue(rs.next());
                ++i;
            }
            this.assertFalse(rs.next());
            ++j;
        }
    }

    private void testUnknownDataType(Connection conn) throws SQLException {
        this.assertThrows(50004, conn).prepareStatement("SELECT * FROM (SELECT ? FROM DUAL)");
        this.assertThrows(50004, conn).prepareStatement("VALUES BITAND(?, ?)");
        PreparedStatement prep = conn.prepareStatement("SELECT -?");
        prep.setInt(1, 1);
        this.execute(prep);
        prep = conn.prepareStatement("SELECT ?-?");
        prep.setInt(1, 1);
        prep.setInt(2, 2);
        this.execute(prep);
    }

    private void testCancelReuse(Connection conn) throws Exception {
        conn.createStatement().execute("CREATE ALIAS SLEEP FOR 'java.lang.Thread.sleep(long)'");
        final PreparedStatement prep = conn.prepareStatement("SELECT SLEEP(?) FROM SYSTEM_RANGE(1, 10000) LIMIT ?");
        prep.setInt(1, 1);
        prep.setInt(2, 10000);
        Task t = new Task(){

            @Override
            public void call() throws SQLException {
                TestPreparedStatement.this.execute(prep);
            }
        };
        t.execute();
        Thread.sleep(100L);
        prep.cancel();
        SQLException e = (SQLException)t.getException();
        this.assertNotNull(e);
        this.assertEquals(57014, e.getErrorCode());
        prep.setInt(1, 1);
        prep.setInt(2, 1);
        ResultSet rs = prep.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals(0, rs.getInt(1));
        this.assertFalse(rs.next());
    }

    private static void testCoalesce(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.executeUpdate("create table test(tm timestamp)");
        stat.executeUpdate("insert into test values(current_timestamp)");
        PreparedStatement prep = conn.prepareStatement("update test set tm = coalesce(?,tm)");
        prep.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
        prep.executeUpdate();
        stat.executeUpdate("drop table test");
    }

    private void testPreparedStatementMetaData(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("select * from table(x int = ?, name varchar = ?)");
        ResultSetMetaData meta = prep.getMetaData();
        this.assertEquals(2, meta.getColumnCount());
        this.assertEquals("INTEGER", meta.getColumnTypeName(1));
        this.assertEquals("CHARACTER VARYING", meta.getColumnTypeName(2));
        prep = conn.prepareStatement("call 1");
        meta = prep.getMetaData();
        this.assertEquals(1, meta.getColumnCount());
        this.assertEquals("INTEGER", meta.getColumnTypeName(1));
        prep = conn.prepareStatement("SELECT * FROM UNNEST(ARRAY[1, 2])");
        meta = prep.getMetaData();
        this.assertEquals(1, meta.getColumnCount());
        this.assertEquals("INTEGER", meta.getColumnTypeName(1));
    }

    private void testArray(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("select * from table(x int = ?) order by x");
        prep.setObject(1, new Object[]{new BigDecimal("1"), "2"});
        ResultSet rs = prep.executeQuery();
        rs.next();
        this.assertEquals("1", rs.getString(1));
        rs.next();
        this.assertEquals("2", rs.getString(1));
        this.assertFalse(rs.next());
    }

    private void testEnum(Connection conn) throws SQLException {
        ResultSet rs;
        PreparedStatement prep;
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE test_enum(size ENUM('small', 'medium', 'large'))");
        String[] badSizes = new String[]{"green", "smol", "0"};
        int i = 0;
        while (i < badSizes.length) {
            PreparedStatement prep2 = conn.prepareStatement("INSERT INTO test_enum VALUES(?)");
            prep2.setObject(1, badSizes[i]);
            this.assertThrows(22030, prep2).execute();
            ++i;
        }
        String[] goodSizes = new String[]{"small", "medium", "large"};
        int i2 = 0;
        while (i2 < goodSizes.length) {
            prep = conn.prepareStatement("INSERT INTO test_enum VALUES(?)");
            prep.setObject(1, goodSizes[i2]);
            prep.execute();
            rs = stat.executeQuery("SELECT * FROM test_enum");
            int j = 0;
            while (j <= i2) {
                rs.next();
                ++j;
            }
            this.assertEquals(goodSizes[i2], rs.getString(1));
            this.assertEquals(i2 + 1, rs.getInt(1));
            Object o = rs.getObject(1);
            this.assertEquals(String.class, o.getClass());
            ++i2;
        }
        i2 = 0;
        while (i2 < goodSizes.length) {
            prep = conn.prepareStatement("SELECT * FROM test_enum WHERE size = ?");
            prep.setObject(1, goodSizes[i2]);
            rs = prep.executeQuery();
            rs.next();
            String s = rs.getString(1);
            this.assertTrue(s.equals(goodSizes[i2]));
            this.assertFalse(rs.next());
            ++i2;
        }
        i2 = 0;
        while (i2 < badSizes.length) {
            prep = conn.prepareStatement("SELECT * FROM test_enum WHERE size = ?");
            prep.setObject(1, badSizes[i2]);
            if (this.config.lazy && !this.config.networked) {
                ResultSet resultSet = prep.executeQuery();
                this.assertThrows(22030, resultSet).next();
            } else {
                this.assertThrows(22030, prep).executeQuery();
            }
            ++i2;
        }
        stat.execute("DROP TABLE test_enum");
    }

    private void testUUID(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("create table test_uuid(id uuid primary key)");
        UUID uuid = new UUID(-2L, -1L);
        PreparedStatement prep = conn.prepareStatement("insert into test_uuid values(?)");
        prep.setObject(1, uuid);
        prep.execute();
        ResultSet rs = stat.executeQuery("select * from test_uuid");
        rs.next();
        this.assertEquals("ffffffff-ffff-fffe-ffff-ffffffffffff", rs.getString(1));
        Object o = rs.getObject(1);
        this.assertEquals("java.util.UUID", o.getClass().getName());
        stat.execute("drop table test_uuid");
    }

    private void testUUIDAsJavaObject(Connection conn) throws SQLException {
        String uuidStr = "12345678-1234-4321-8765-123456789012";
        Statement stat = conn.createStatement();
        stat.execute("create table test_uuid(id uuid primary key)");
        UUID origUUID = UUID.fromString(uuidStr);
        PreparedStatement prep = conn.prepareStatement("insert into test_uuid values(?)");
        prep.setObject(1, (Object)origUUID, 2000);
        prep.execute();
        prep = conn.prepareStatement("select * from test_uuid where id=?");
        prep.setObject(1, (Object)origUUID, 2000);
        ResultSet rs = prep.executeQuery();
        rs.next();
        Object o = rs.getObject(1);
        this.assertTrue(o instanceof UUID);
        UUID selectedUUID = (UUID)o;
        this.assertTrue(selectedUUID.toString().equals(uuidStr));
        this.assertTrue(selectedUUID.equals(origUUID));
        stat.execute("drop table test_uuid");
    }

    private void testSetObject(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(C CHAR(1))");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?)");
        prep.setObject(1, Character.valueOf('x'));
        prep.execute();
        stat.execute("DROP TABLE TEST");
        stat.execute("CREATE TABLE TEST(ID INT, DATA VARBINARY, JAVA OTHER)");
        prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?, ?)");
        prep.setInt(1, 1);
        prep.setObject(2, 11);
        prep.setObject(3, null);
        prep.execute();
        prep.setInt(1, 2);
        prep.setObject(2, (Object)101, 2000);
        prep.setObject(3, (Object)103, 2000);
        prep.execute();
        PreparedStatement p2 = conn.prepareStatement("SELECT * FROM TEST ORDER BY ID");
        ResultSet rs = p2.executeQuery();
        rs.next();
        Object o = rs.getObject(2);
        this.assertTrue(o instanceof byte[]);
        this.assertNull(rs.getObject(3));
        rs.next();
        o = rs.getObject(2);
        this.assertTrue(o instanceof byte[]);
        o = rs.getObject(3);
        this.assertTrue(o instanceof Integer);
        this.assertEquals(103, (int)((Integer)o));
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE TEST");
    }

    private void testSetObject2(Connection conn) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PreparedStatement prep = conn.prepareStatement("VALUES (?1, ?1 IS OF(INTEGER), ?1 IS OF(BIGINT))");){
            int i = 1;
            while (i <= 6) {
                ResultSet rs;
                TestPreparedStatement.testSetObject2SetObjectType(prep, i, i);
                Throwable throwable2 = null;
                Object var7_11 = null;
                try {
                    rs = prep.executeQuery();
                    try {
                        rs.next();
                        this.assertEquals(Integer.toString(i), rs.getString(1));
                        if (i == 1) {
                            this.assertFalse(rs.getBoolean(2));
                            this.assertTrue(rs.getBoolean(3));
                        } else {
                            this.assertTrue(rs.getBoolean(2));
                            this.assertFalse(rs.getBoolean(3));
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                TestPreparedStatement.testSetObject2SetObjectType(prep, i, null);
                throwable2 = null;
                var7_11 = null;
                try {
                    rs = prep.executeQuery();
                    try {
                        rs.next();
                        this.assertNull(rs.getObject(1));
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
                ++i;
            }
            prep.setObject(1, 1);
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private static void testSetObject2SetObjectType(PreparedStatement prep, int method, Object value) throws SQLException {
        switch (method) {
            case 1: {
                prep.setObject(1, value);
                break;
            }
            case 2: {
                prep.setObject(1, value, 4);
                break;
            }
            case 3: {
                prep.setObject(1, value, JDBCType.INTEGER);
                break;
            }
            case 4: {
                prep.setObject(1, value, 4, 0);
                break;
            }
            case 5: {
                prep.setObject(1, value, JDBCType.INTEGER, 0);
                break;
            }
            case 6: {
                prep.setObject(1, value, H2Type.INTEGER, 0);
            }
        }
    }

    private void testBigDecimal(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT ?, ?");
        BigDecimal bd = new BigDecimal("12300").setScale(-2, RoundingMode.UNNECESSARY);
        prep.setBigDecimal(1, bd);
        prep.setObject(2, bd);
        ResultSet rs = prep.executeQuery();
        rs.next();
        bd = rs.getBigDecimal(1);
        this.assertEquals(12300, bd.intValue());
        this.assertEquals(0, bd.scale());
        bd = rs.getBigDecimal(2);
        this.assertEquals(12300, bd.intValue());
        this.assertEquals(0, bd.scale());
    }

    private void testDate(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT ?");
        Timestamp ts = Timestamp.valueOf("2001-02-03 04:05:06");
        prep.setObject(1, new java.util.Date(ts.getTime()));
        ResultSet rs = prep.executeQuery();
        rs.next();
        Timestamp ts2 = rs.getTimestamp(1);
        this.assertEquals(ts.toString(), ts2.toString());
    }

    private void testDate8(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT ?");
        LocalDate localDate = LocalDate.parse("2001-02-03");
        prep.setObject(1, localDate);
        ResultSet rs = prep.executeQuery();
        rs.next();
        LocalDate localDate2 = rs.getObject(1, LocalDate.class);
        this.assertEquals(localDate, localDate2);
        rs.close();
        localDate = LocalDate.parse("-0509-01-01");
        prep.setObject(1, localDate);
        rs = prep.executeQuery();
        rs.next();
        localDate2 = rs.getObject(1, LocalDate.class);
        this.assertEquals(localDate, localDate2);
        rs.close();
        prep.setString(1, "1500-02-28");
        rs = prep.executeQuery();
        rs.next();
        localDate2 = rs.getObject(1, LocalDate.class);
        this.assertEquals(LocalDate.parse("1500-02-28"), localDate2);
        rs.close();
        prep.setString(1, "-0100-02-28");
        rs = prep.executeQuery();
        rs.next();
        localDate2 = rs.getObject(1, LocalDate.class);
        this.assertEquals(LocalDate.parse("-0100-02-28"), localDate2);
        rs.close();
        Statement stat = conn.createStatement();
        stat.execute("SET TIME ZONE '1'");
        TimeZone old = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("GMT+01"));
        try {
            localDate = LocalDate.parse("1582-10-05");
            prep.setObject(1, localDate);
            rs = prep.executeQuery();
            rs.next();
            localDate2 = rs.getObject(1, LocalDate.class);
            this.assertEquals(localDate, localDate2);
            this.assertEquals("1582-10-05", rs.getString(1));
            this.assertEquals(Date.valueOf("1582-09-25"), rs.getDate(1));
            GregorianCalendar gc = new GregorianCalendar();
            gc.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gc.clear();
            gc.set(1, 1582);
            gc.set(2, 9);
            gc.set(5, 5);
            Date expected = new Date(gc.getTimeInMillis());
            gc.clear();
            this.assertEquals(expected, rs.getDate(1, (Calendar)gc));
            rs.close();
        }
        finally {
            stat.execute("SET TIME ZONE LOCAL");
            TimeZone.setDefault(old);
        }
    }

    private void testTime8(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT ?");
        LocalTime localTime = LocalTime.parse("04:05:06");
        prep.setObject(1, localTime);
        ResultSet rs = prep.executeQuery();
        rs.next();
        LocalTime localTime2 = rs.getObject(1, LocalTime.class);
        this.assertEquals(localTime, localTime2);
        rs.close();
        localTime = LocalTime.parse("04:05:06.123456789");
        prep.setObject(1, localTime);
        rs = prep.executeQuery();
        rs.next();
        localTime2 = rs.getObject(1, LocalTime.class);
        this.assertEquals(localTime, localTime2);
        rs.close();
    }

    private void testOffsetTime8(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT ?");
        OffsetTime offsetTime = OffsetTime.parse("04:05:06+02:30");
        prep.setObject(1, offsetTime);
        ResultSet rs = prep.executeQuery();
        rs.next();
        OffsetTime offsetTime2 = rs.getObject(1, OffsetTime.class);
        this.assertEquals(offsetTime, offsetTime2);
        this.assertFalse(rs.next());
        rs.close();
        prep.setObject(1, (Object)offsetTime, 2013);
        rs = prep.executeQuery();
        rs.next();
        offsetTime2 = rs.getObject(1, OffsetTime.class);
        this.assertEquals(offsetTime, offsetTime2);
        this.assertFalse(rs.next());
        rs.close();
    }

    private void testDateTime8(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT ?");
        LocalDateTime localDateTime = LocalDateTime.parse("2001-02-03T04:05:06");
        prep.setObject(1, localDateTime);
        ResultSet rs = prep.executeQuery();
        rs.next();
        LocalDateTime localDateTime2 = rs.getObject(1, LocalDateTime.class);
        this.assertEquals(localDateTime, localDateTime2);
        rs.close();
    }

    private void testOffsetDateTime8(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT ?");
        OffsetDateTime offsetDateTime = OffsetDateTime.parse("2001-02-03T04:05:06+02:30");
        prep.setObject(1, offsetDateTime);
        ResultSet rs = prep.executeQuery();
        rs.next();
        OffsetDateTime offsetDateTime2 = rs.getObject(1, OffsetDateTime.class);
        this.assertEquals(offsetDateTime, offsetDateTime2);
        this.assertFalse(rs.next());
        rs.close();
        prep.setObject(1, (Object)offsetDateTime, 2014);
        rs = prep.executeQuery();
        rs.next();
        offsetDateTime2 = rs.getObject(1, OffsetDateTime.class);
        this.assertEquals(offsetDateTime, offsetDateTime2);
        rs.getObject(1);
        this.assertFalse(rs.next());
        rs.close();
    }

    private void testZonedDateTime8(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT ?");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse("2001-02-03T04:05:06+02:30");
        prep.setObject(1, zonedDateTime);
        ResultSet rs = prep.executeQuery();
        rs.next();
        ZonedDateTime zonedDateTime2 = rs.getObject(1, ZonedDateTime.class);
        this.assertEquals(zonedDateTime, zonedDateTime2);
        this.assertFalse(rs.next());
        rs.close();
        prep.setObject(1, (Object)zonedDateTime, 2014);
        rs = prep.executeQuery();
        rs.next();
        zonedDateTime2 = rs.getObject(1, ZonedDateTime.class);
        this.assertEquals(zonedDateTime, zonedDateTime2);
        this.assertFalse(rs.next());
        rs.close();
    }

    private void testInstant8(Connection conn) throws Exception {
        PreparedStatement prep = conn.prepareStatement("SELECT ?");
        this.testInstant8Impl(prep, Instant.now());
        this.testInstant8Impl(prep, Instant.parse("2000-01-15T12:13:14.123456789Z"));
        this.testInstant8Impl(prep, Instant.parse("1500-09-10T23:22:11.123456789Z"));
    }

    private void testInstant8Impl(PreparedStatement prep, Instant instant) throws SQLException {
        prep.setObject(1, instant);
        ResultSet rs = prep.executeQuery();
        rs.next();
        Instant instant2 = rs.getObject(1, Instant.class);
        this.assertEquals(instant, instant2);
        Timestamp ts = rs.getTimestamp(1);
        this.assertEquals(instant, ts.toInstant());
        this.assertFalse(rs.next());
        rs.close();
        prep.setTimestamp(1, ts);
        rs = prep.executeQuery();
        rs.next();
        instant2 = rs.getObject(1, Instant.class);
        this.assertEquals(instant, instant2);
        this.assertFalse(rs.next());
        rs.close();
    }

    private void testInterval(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT ?");
        Interval interval = new Interval(IntervalQualifier.MINUTE, false, 100L, 0L);
        prep.setObject(1, interval);
        ResultSet rs = prep.executeQuery();
        rs.next();
        this.assertEquals("INTERVAL '100' MINUTE", rs.getString(1));
        this.assertEquals(interval, rs.getObject(1));
        this.assertEquals(interval, rs.getObject(1, Interval.class));
    }

    private void testInterval8(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT ?");
        this.testPeriod8(prep, 1, 2, "INTERVAL '1-2' YEAR TO MONTH");
        this.testPeriod8(prep, -1, -2, "INTERVAL '-1-2' YEAR TO MONTH");
        this.testPeriod8(prep, 1, -8, "INTERVAL '0-4' YEAR TO MONTH", 0, 4);
        this.testPeriod8(prep, -1, 8, "INTERVAL '-0-4' YEAR TO MONTH", 0, -4);
        this.testPeriod8(prep, 0, 0, "INTERVAL '0-0' YEAR TO MONTH");
        this.testPeriod8(prep, 100, 0, "INTERVAL '100' YEAR");
        this.testPeriod8(prep, -100, 0, "INTERVAL '-100' YEAR");
        this.testPeriod8(prep, 0, 100, "INTERVAL '100' MONTH");
        this.testPeriod8(prep, 0, -100, "INTERVAL '-100' MONTH");
        Period period = Period.of(0, 0, 1);
        this.assertThrows(90008, prep).setObject(1, period);
        Duration duration = Duration.ofSeconds(-4L, 900000000L);
        prep.setObject(1, duration);
        ResultSet rs = prep.executeQuery();
        rs.next();
        this.assertEquals("INTERVAL '-3.1' SECOND", rs.getString(1));
        this.assertEquals(duration, rs.getObject(1, Duration.class));
    }

    private void testPeriod8(PreparedStatement prep, int years, int months, String expectedString) throws SQLException {
        this.testPeriod8(prep, years, months, expectedString, years, months);
    }

    private void testPeriod8(PreparedStatement prep, int years, int months, String expectedString, int expYears, int expMonths) throws SQLException {
        Period period = Period.of(years, months, 0);
        Period expectedPeriod = Period.of(expYears, expMonths, 0);
        prep.setObject(1, period);
        ResultSet rs = prep.executeQuery();
        rs.next();
        this.assertEquals(expectedString, rs.getString(1));
        this.assertEquals(expectedPeriod, rs.getObject(1, Period.class));
    }

    private void testJson(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID BIGINT, J JSON)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES (?, ?)");
        prep.setInt(1, 1);
        prep.setString(2, "[1]");
        prep.executeUpdate();
        prep = conn.prepareStatement("INSERT INTO TEST VALUES (?, ? FORMAT JSON)");
        prep.setInt(1, 2);
        prep.setString(2, "[1]");
        prep.executeUpdate();
        prep.setInt(1, 3);
        prep.setString(2, null);
        prep.executeUpdate();
        prep = conn.prepareStatement("INSERT INTO TEST VALUES (?, ?)");
        prep.setInt(1, 4);
        prep.setObject(2, (Object)"[1]", H2Type.JSON);
        prep.executeUpdate();
        prep.setInt(1, 5);
        prep.setObject(2, null, H2Type.JSON);
        prep.executeUpdate();
        Throwable throwable = null;
        Object var5_6 = null;
        try (ResultSet rs = stat.executeQuery("SELECT J FROM TEST ORDER BY ID");){
            this.assertTrue(rs.next());
            this.assertEquals("\"[1]\"", rs.getString(1));
            int i = 0;
            while (i < 2) {
                this.assertTrue(rs.next());
                this.assertEquals("[1]", rs.getString(1));
                this.assertTrue(rs.next());
                this.assertEquals(null, rs.getString(1));
                ++i;
            }
            this.assertFalse(rs.next());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        stat.execute("DROP TABLE TEST");
    }

    private void testPreparedSubquery(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.executeUpdate("CREATE TABLE TEST(ID IDENTITY, FLAG BIT)");
        s.executeUpdate("INSERT INTO TEST(ID, FLAG) VALUES(0, FALSE)");
        s.executeUpdate("INSERT INTO TEST(ID, FLAG) VALUES(1, FALSE)");
        PreparedStatement u = conn.prepareStatement("SELECT ID, FLAG FROM TEST ORDER BY ID");
        PreparedStatement p = conn.prepareStatement("UPDATE TEST SET FLAG=true WHERE ID=(SELECT ?)");
        p.clearParameters();
        p.setLong(1, 0L);
        this.assertEquals(1, p.executeUpdate());
        p.clearParameters();
        p.setLong(1, 1L);
        this.assertEquals(1, p.executeUpdate());
        ResultSet rs = u.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals(0, rs.getInt(1));
        this.assertTrue(rs.getBoolean(2));
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertTrue(rs.getBoolean(2));
        p = conn.prepareStatement("SELECT * FROM TEST WHERE EXISTS(SELECT * FROM TEST WHERE ID=?)");
        p.setInt(1, -1);
        rs = p.executeQuery();
        this.assertFalse(rs.next());
        p.setInt(1, 1);
        rs = p.executeQuery();
        this.assertTrue(rs.next());
        s.executeUpdate("DROP TABLE IF EXISTS TEST");
    }

    private void testParameterMetaData(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT ?, ?, ? FROM DUAL");
        ParameterMetaData pm = prep.getParameterMetaData();
        this.assertEquals("java.lang.String", pm.getParameterClassName(1));
        this.assertEquals("CHARACTER VARYING", pm.getParameterTypeName(1));
        this.assertEquals(3, pm.getParameterCount());
        this.assertEquals(1, pm.getParameterMode(1));
        this.assertEquals(12, pm.getParameterType(1));
        this.assertEquals(0, pm.getPrecision(1));
        this.assertEquals(0, pm.getScale(1));
        this.assertEquals(2, pm.isNullable(1));
        this.assertEquals(pm.isSigned(1), true);
        this.assertThrows(90008, pm).getPrecision(0);
        this.assertThrows(90008, pm).getPrecision(4);
        prep.close();
        this.assertThrows(90007, pm).getPrecision(1);
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST3(ID INT, NAME VARCHAR(255), DATA1 DECIMAL(10,2), DATA2 NUMERIC(10,2))");
        PreparedStatement prep1 = conn.prepareStatement("UPDATE TEST3 SET ID=?, NAME=?, DATA1=?, DATA2=?");
        PreparedStatement prep2 = conn.prepareStatement("INSERT INTO TEST3 VALUES(?, ?, ?, ?)");
        this.checkParameter(prep1, 1, "java.lang.Integer", 4, "INTEGER", 32, 0);
        this.checkParameter(prep1, 2, "java.lang.String", 12, "CHARACTER VARYING", 255, 0);
        this.checkParameter(prep1, 3, "java.math.BigDecimal", 3, "DECIMAL", 10, 2);
        this.checkParameter(prep1, 4, "java.math.BigDecimal", 2, "NUMERIC", 10, 2);
        this.checkParameter(prep2, 1, "java.lang.Integer", 4, "INTEGER", 32, 0);
        this.checkParameter(prep2, 2, "java.lang.String", 12, "CHARACTER VARYING", 255, 0);
        this.checkParameter(prep2, 3, "java.math.BigDecimal", 3, "DECIMAL", 10, 2);
        this.checkParameter(prep2, 4, "java.math.BigDecimal", 2, "NUMERIC", 10, 2);
        PreparedStatement prep3 = conn.prepareStatement("SELECT * FROM TEST3 WHERE ID=? AND NAME LIKE ? AND ?>DATA1 AND ?>DATA2");
        this.checkParameter(prep3, 1, "java.lang.Integer", 4, "INTEGER", 32, 0);
        this.checkParameter(prep3, 2, "java.lang.String", 12, "CHARACTER VARYING", 0, 0);
        this.checkParameter(prep3, 3, "java.math.BigDecimal", 3, "DECIMAL", 10, 2);
        this.checkParameter(prep3, 4, "java.math.BigDecimal", 2, "NUMERIC", 10, 2);
        stat.execute("DROP TABLE TEST3");
    }

    private void checkParameter(PreparedStatement prep, int index, String className, int type, String typeName, int precision, int scale) throws SQLException {
        ParameterMetaData meta = prep.getParameterMetaData();
        this.assertEquals(className, meta.getParameterClassName(index));
        this.assertEquals(type, meta.getParameterType(index));
        this.assertEquals(typeName, meta.getParameterTypeName(index));
        this.assertEquals(precision, meta.getPrecision(index));
        this.assertEquals(scale, meta.getScale(index));
    }

    private void testLikeIndex(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, V INT, NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 2, 'Hello')");
        stat.execute("INSERT INTO TEST VALUES(2, 4, 'World')");
        stat.execute("create index idxname on test(name);");
        PreparedStatement prep = conn.prepareStatement("EXPLAIN SELECT * FROM TEST WHERE NAME LIKE ?");
        this.assertEquals(1, prep.getParameterMetaData().getParameterCount());
        PreparedStatement prepExe = conn.prepareStatement("SELECT * FROM TEST WHERE NAME LIKE ?");
        prep.setString(1, "%orld");
        prepExe.setString(1, "%orld");
        ResultSet rs = prep.executeQuery();
        rs.next();
        String plan = rs.getString(1);
        this.assertContains(plan, ".tableScan");
        rs = prepExe.executeQuery();
        rs.next();
        this.assertEquals("World", rs.getString(3));
        this.assertFalse(rs.next());
        prep.setString(1, "H%");
        prepExe.setString(1, "H%");
        rs = prep.executeQuery();
        rs.next();
        String plan1 = rs.getString(1);
        this.assertContains(plan1, "IDXNAME");
        rs = prepExe.executeQuery();
        rs.next();
        this.assertEquals("Hello", rs.getString(3));
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE IF EXISTS TEST");
    }

    private void testCasewhen(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT)");
        stat.execute("INSERT INTO TEST VALUES(1),(2),(3)");
        PreparedStatement prep = conn.prepareStatement("EXPLAIN SELECT COUNT(*) FROM TEST WHERE CASEWHEN(ID=1, ID, ID)=? GROUP BY ID");
        prep.setInt(1, 1);
        ResultSet rs = prep.executeQuery();
        rs.next();
        String plan = rs.getString(1);
        this.trace(plan);
        rs.close();
        prep = conn.prepareStatement("EXPLAIN SELECT COUNT(*) FROM TEST WHERE CASE ID WHEN 1 THEN ID WHEN 2 THEN ID ELSE ID END=? GROUP BY ID");
        prep.setInt(1, 1);
        rs = prep.executeQuery();
        rs.next();
        plan = rs.getString(1);
        this.trace(plan);
        prep = conn.prepareStatement("SELECT COUNT(*) FROM TEST WHERE CASEWHEN(ID=1, ID, ID)=? GROUP BY ID");
        prep.setInt(1, 1);
        rs = prep.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertFalse(rs.next());
        prep = conn.prepareStatement("SELECT COUNT(*) FROM TEST WHERE CASE ID WHEN 1 THEN ID WHEN 2 THEN ID ELSE ID END=? GROUP BY ID");
        prep.setInt(1, 1);
        rs = prep.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertFalse(rs.next());
        prep = conn.prepareStatement("SELECT * FROM TEST WHERE ? IS NULL");
        prep.setString(1, "Hello");
        rs = prep.executeQuery();
        this.assertFalse(rs.next());
        this.assertThrows(50004, conn).prepareStatement("select ? from dual union select ? from dual");
        prep = conn.prepareStatement("select cast(? as varchar) from dual union select ? from dual");
        this.assertEquals(2, prep.getParameterMetaData().getParameterCount());
        prep.setString(1, "a");
        prep.setString(2, "a");
        rs = prep.executeQuery();
        rs.next();
        this.assertEquals("a", rs.getString(1));
        this.assertEquals("a", rs.getString(1));
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE TEST");
    }

    private void testSubquery(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT)");
        stat.execute("INSERT INTO TEST VALUES(1),(2),(3)");
        PreparedStatement prep = conn.prepareStatement("select x.id, ? from (select * from test where id in(?, ?)) x where x.id*2 <>  ?");
        this.assertEquals(4, prep.getParameterMetaData().getParameterCount());
        prep.setInt(1, 0);
        prep.setInt(2, 1);
        prep.setInt(3, 2);
        prep.setInt(4, 4);
        ResultSet rs = prep.executeQuery();
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals(0, rs.getInt(2));
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE TEST");
    }

    private void testDataTypes(Connection conn) throws SQLException {
        conn.createStatement(1003, 1007);
        conn.createStatement(1005, 1008);
        Statement stat = conn.createStatement();
        this.trace("Create tables");
        stat.execute("CREATE TABLE T_INT(ID INT PRIMARY KEY,V INT)");
        stat.execute("CREATE TABLE T_VARCHAR(ID INT PRIMARY KEY,V VARCHAR(255))");
        stat.execute("CREATE TABLE T_DECIMAL_0(ID INT PRIMARY KEY,V DECIMAL(30,0))");
        stat.execute("CREATE TABLE T_DECIMAL_10(ID INT PRIMARY KEY,V DECIMAL(20,10))");
        stat.execute("CREATE TABLE T_DATETIME(ID INT PRIMARY KEY,V DATETIME)");
        stat.execute("CREATE TABLE T_BIGINT(ID INT PRIMARY KEY,V DECIMAL(30,0))");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO T_INT VALUES(?,?)", 1003, 1007);
        prep.setInt(1, 1);
        prep.setInt(2, 0);
        prep.executeUpdate();
        prep.setInt(1, 2);
        prep.setInt(2, -1);
        prep.executeUpdate();
        prep.setInt(1, 3);
        prep.setInt(2, 3);
        prep.executeUpdate();
        prep.setInt(1, 4);
        prep.setNull(2, 4, "INTEGER");
        prep.setNull(2, 4);
        prep.executeUpdate();
        prep.setInt(1, 5);
        prep.setBigDecimal(2, new BigDecimal("0"));
        prep.executeUpdate();
        prep.setInt(1, 6);
        prep.setString(2, "-1");
        prep.executeUpdate();
        prep.setInt(1, 7);
        prep.setObject(2, 3);
        prep.executeUpdate();
        prep.setObject(1, "8");
        prep.setObject(2, null);
        prep.executeUpdate();
        prep.setInt(1, 9);
        prep.setObject(2, (Object)-4, 12);
        prep.executeUpdate();
        prep.setInt(1, 10);
        prep.setObject(2, (Object)"5", 4);
        prep.executeUpdate();
        prep.setInt(1, 11);
        prep.setObject(2, null, 4);
        prep.executeUpdate();
        prep.setInt(1, 12);
        prep.setBoolean(2, true);
        prep.executeUpdate();
        prep.setInt(1, 13);
        prep.setBoolean(2, false);
        prep.executeUpdate();
        prep.setInt(1, 14);
        prep.setByte(2, (byte)-20);
        prep.executeUpdate();
        prep.setInt(1, 15);
        prep.setByte(2, (byte)100);
        prep.executeUpdate();
        prep.setInt(1, 16);
        prep.setShort(2, (short)30000);
        prep.executeUpdate();
        prep.setInt(1, 17);
        prep.setShort(2, (short)-30000);
        prep.executeUpdate();
        prep.setInt(1, 18);
        prep.setLong(2, Integer.MAX_VALUE);
        prep.executeUpdate();
        prep.setInt(1, 19);
        prep.setLong(2, Integer.MIN_VALUE);
        prep.executeUpdate();
        this.assertTrue(stat.execute("SELECT * FROM T_INT ORDER BY ID"));
        ResultSet rs = stat.getResultSet();
        String[][] stringArray = new String[19][];
        stringArray[0] = new String[]{"1", "0"};
        stringArray[1] = new String[]{"2", "-1"};
        stringArray[2] = new String[]{"3", "3"};
        String[] stringArray2 = new String[2];
        stringArray2[0] = "4";
        stringArray[3] = stringArray2;
        stringArray[4] = new String[]{"5", "0"};
        stringArray[5] = new String[]{"6", "-1"};
        stringArray[6] = new String[]{"7", "3"};
        String[] stringArray3 = new String[2];
        stringArray3[0] = "8";
        stringArray[7] = stringArray3;
        stringArray[8] = new String[]{"9", "-4"};
        stringArray[9] = new String[]{"10", "5"};
        String[] stringArray4 = new String[2];
        stringArray4[0] = "11";
        stringArray[10] = stringArray4;
        stringArray[11] = new String[]{"12", "1"};
        stringArray[12] = new String[]{"13", "0"};
        stringArray[13] = new String[]{"14", "-20"};
        stringArray[14] = new String[]{"15", "100"};
        stringArray[15] = new String[]{"16", "30000"};
        stringArray[16] = new String[]{"17", "-30000"};
        stringArray[17] = new String[]{"18", "2147483647"};
        stringArray[18] = new String[]{"19", "-2147483648"};
        this.assertResultSetOrdered(rs, stringArray);
        prep = conn.prepareStatement("INSERT INTO T_DECIMAL_0 VALUES(?,?)");
        prep.setInt(1, 1);
        prep.setLong(2, Long.MAX_VALUE);
        prep.executeUpdate();
        prep.setInt(1, 2);
        prep.setLong(2, Long.MIN_VALUE);
        prep.executeUpdate();
        prep.setInt(1, 3);
        prep.setFloat(2, 10.0f);
        prep.executeUpdate();
        prep.setInt(1, 4);
        prep.setFloat(2, -20.0f);
        prep.executeUpdate();
        prep.setInt(1, 5);
        prep.setFloat(2, 30.0f);
        prep.executeUpdate();
        prep.setInt(1, 6);
        prep.setFloat(2, -40.0f);
        prep.executeUpdate();
        rs = stat.executeQuery("SELECT V FROM T_DECIMAL_0 ORDER BY ID");
        this.checkBigDecimal(rs, new String[]{"9223372036854775807", "-9223372036854775808", "10", "-20", "30", "-40"});
        prep = conn.prepareStatement("INSERT INTO T_BIGINT VALUES(?,?)");
        prep.setInt(1, 1);
        prep.setObject(2, new BigInteger("9223372036854775807"));
        prep.executeUpdate();
        prep.setInt(1, 2);
        prep.setObject(2, Long.MIN_VALUE);
        prep.executeUpdate();
        prep.setInt(1, 3);
        prep.setObject(2, 10);
        prep.executeUpdate();
        prep.setInt(1, 4);
        prep.setObject(2, -20);
        prep.executeUpdate();
        prep.setInt(1, 5);
        prep.setObject(2, 30);
        prep.executeUpdate();
        prep.setInt(1, 6);
        prep.setObject(2, -40);
        prep.executeUpdate();
        prep.setInt(1, 7);
        prep.setObject(2, new BigInteger("-60"));
        prep.executeUpdate();
        rs = stat.executeQuery("SELECT V FROM T_BIGINT ORDER BY ID");
        this.checkBigDecimal(rs, new String[]{"9223372036854775807", "-9223372036854775808", "10", "-20", "30", "-40", "-60"});
    }

    private void testGetMoreResults(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT)");
        stat.execute("INSERT INTO TEST VALUES(1)");
        PreparedStatement prep = conn.prepareStatement("SELECT * FROM TEST");
        prep.getMetaData();
        this.assertTrue(prep.execute());
        ResultSet rs = prep.getResultSet();
        this.assertFalse(prep.getMoreResults());
        this.assertEquals(-1, prep.getUpdateCount());
        this.assertThrows(90007, rs).next();
        this.assertEquals(-1, prep.getUpdateCount());
        prep = conn.prepareStatement("UPDATE TEST SET ID = 2");
        this.assertFalse(prep.execute());
        this.assertEquals(1, prep.getUpdateCount());
        this.assertFalse(prep.getMoreResults(1));
        this.assertEquals(-1, prep.getUpdateCount());
        this.assertThrows(90007, rs).next();
        this.assertEquals(-1, prep.getUpdateCount());
        prep = conn.prepareStatement("DELETE FROM TEST");
        prep.executeUpdate();
        this.assertFalse(prep.getMoreResults());
        this.assertEquals(-1, prep.getUpdateCount());
        stat.execute("DROP TABLE TEST");
    }

    private void testObject(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        PreparedStatement prep = conn.prepareStatement("SELECT ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? FROM TEST");
        prep.setObject(1, Boolean.TRUE);
        prep.setObject(2, "Abc");
        prep.setObject(3, new BigDecimal("10.2"));
        prep.setObject(4, (byte)-1);
        prep.setObject(5, (short)Short.MAX_VALUE);
        prep.setObject(6, Integer.MIN_VALUE);
        prep.setObject(7, Long.MAX_VALUE);
        prep.setObject(8, Float.valueOf(Float.MAX_VALUE));
        prep.setObject(9, Double.MAX_VALUE);
        prep.setObject(10, Date.valueOf("2001-02-03"));
        prep.setObject(11, Time.valueOf("04:05:06"));
        prep.setObject(12, Timestamp.valueOf("2001-02-03 04:05:06.123456789"));
        prep.setObject(13, new java.util.Date(Date.valueOf("2001-02-03").getTime()));
        prep.setObject(14, new byte[]{10, 20, 30});
        prep.setObject(15, (Object)Character.valueOf('a'), 2000);
        prep.setObject(16, (Object)"2001-01-02", 91);
        prep.setObject(17, (Object)"2001-01-02", 0);
        prep.setObject(18, (Object)"3.725", 8);
        prep.setObject(19, (Object)"23:22:21", 92);
        prep.setObject(20, (Object)new BigInteger("12345"), 2000);
        prep.setArray(21, conn.createArrayOf("TINYINT", new Object[]{(byte)1}));
        prep.setArray(22, conn.createArrayOf("SMALLINT", new Object[]{(short)-2}));
        ResultSet rs = prep.executeQuery();
        rs.next();
        this.assertTrue(rs.getObject(1).equals(Boolean.TRUE));
        this.assertTrue(rs.getObject(2).equals("Abc"));
        this.assertTrue(rs.getObject(3).equals(new BigDecimal("10.2")));
        this.assertTrue(rs.getObject(4).equals(-1));
        this.assertTrue(rs.getObject(5).equals(Short.MAX_VALUE));
        this.assertTrue(rs.getObject(6).equals(Integer.MIN_VALUE));
        this.assertTrue(rs.getObject(7).equals(Long.MAX_VALUE));
        this.assertTrue(rs.getObject(8).equals(Float.valueOf(Float.MAX_VALUE)));
        this.assertTrue(rs.getObject(9).equals(Double.MAX_VALUE));
        this.assertTrue(rs.getObject(10).equals(Date.valueOf("2001-02-03")));
        this.assertEquals("04:05:06", rs.getObject(11).toString());
        this.assertTrue(rs.getObject(11).equals(Time.valueOf("04:05:06")));
        this.assertTrue(rs.getObject(12).equals(Timestamp.valueOf("2001-02-03 04:05:06.123456789")));
        this.assertTrue(rs.getObject(13).equals(Timestamp.valueOf("2001-02-03 00:00:00")));
        this.assertEquals(new byte[]{10, 20, 30}, (byte[])rs.getObject(14));
        this.assertTrue(rs.getObject(15).equals(Character.valueOf('a')));
        this.assertTrue(rs.getObject(16).equals(Date.valueOf("2001-01-02")));
        this.assertTrue(rs.getObject(17) == null && rs.wasNull());
        this.assertTrue(rs.getObject(18).equals(3.725));
        this.assertTrue(rs.getObject(19).equals(Time.valueOf("23:22:21")));
        this.assertTrue(rs.getObject(20).equals(new BigInteger("12345")));
        Object[] a = (Object[])((Array)rs.getObject(21)).getArray();
        this.assertEquals(a[0], (Object)1);
        a = (Object[])((Array)rs.getObject(22)).getArray();
        this.assertEquals(a[0], (Object)-2);
        stat.execute("DROP TABLE TEST");
    }

    private int getLength() {
        return this.getSize(4000, 524288);
    }

    private void testBlob(Connection conn) throws SQLException {
        this.trace("testBlob");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T_BLOB(ID INT PRIMARY KEY,V1 BLOB,V2 BLOB)");
        this.trace("table created");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO T_BLOB VALUES(?,?,?)");
        prep.setInt(1, 1);
        prep.setBytes(2, null);
        prep.setNull(3, -2);
        prep.executeUpdate();
        prep.setInt(1, 2);
        prep.setBinaryStream(2, (InputStream)null, 0);
        prep.setNull(3, 2004);
        prep.executeUpdate();
        int length = this.getLength();
        byte[] big1 = new byte[length];
        byte[] big2 = new byte[length];
        int i = 0;
        while (i < big1.length) {
            big1[i] = (byte)(i * 11 % 254);
            big2[i] = (byte)(i * 17 % 251);
            ++i;
        }
        prep.setInt(1, 3);
        prep.setBytes(2, big1);
        prep.setBytes(3, big2);
        prep.executeUpdate();
        prep.setInt(1, 4);
        ByteArrayInputStream buffer = new ByteArrayInputStream(big2);
        prep.setBinaryStream(2, (InputStream)buffer, big2.length);
        buffer = new ByteArrayInputStream(big1);
        prep.setBinaryStream(3, (InputStream)buffer, big1.length);
        prep.executeUpdate();
        try {
            buffer.close();
            this.trace("buffer not closed");
        }
        catch (IOException e) {
            this.trace("buffer closed");
        }
        prep.setInt(1, 5);
        buffer = new ByteArrayInputStream(big2);
        prep.setObject(2, (Object)buffer, 2004, 0);
        buffer = new ByteArrayInputStream(big1);
        prep.setObject(3, buffer);
        prep.executeUpdate();
        ResultSet rs = stat.executeQuery("SELECT ID, V1, V2 FROM T_BLOB ORDER BY ID");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertTrue(rs.getBytes(2) == null && rs.wasNull());
        this.assertTrue(rs.getBytes(3) == null && rs.wasNull());
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertTrue(rs.getBytes(2) == null && rs.wasNull());
        this.assertTrue(rs.getBytes(3) == null && rs.wasNull());
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        this.assertEquals(big1, rs.getBytes(2));
        this.assertEquals(big2, rs.getBytes(3));
        rs.next();
        this.assertEquals(4, rs.getInt(1));
        this.assertEquals(big2, rs.getBytes(2));
        this.assertEquals(big1, rs.getBytes(3));
        rs.next();
        this.assertEquals(5, rs.getInt(1));
        this.assertEquals(big2, rs.getBytes(2));
        this.assertEquals(big1, rs.getBytes(3));
        this.assertFalse(rs.next());
    }

    private void testClob(Connection conn) throws SQLException {
        this.trace("testClob");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T_CLOB(ID INT PRIMARY KEY,V1 CLOB,V2 CLOB)");
        StringBuilder asciiBuffer = new StringBuilder();
        int len = this.getLength();
        int i = 0;
        while (i < len) {
            asciiBuffer.append((char)(97 + i % 20));
            ++i;
        }
        String ascii1 = asciiBuffer.toString();
        String ascii2 = "Number2 " + ascii1;
        PreparedStatement prep = conn.prepareStatement("INSERT INTO T_CLOB VALUES(?,?,?)");
        prep.setInt(1, 1);
        prep.setString(2, null);
        prep.setNull(3, 2005);
        prep.executeUpdate();
        prep.clearParameters();
        prep.setInt(1, 2);
        prep.setAsciiStream(2, (InputStream)null, 0);
        prep.setCharacterStream(3, (Reader)null, 0);
        prep.executeUpdate();
        prep.clearParameters();
        prep.setInt(1, 3);
        prep.setCharacterStream(2, (Reader)new StringReader(ascii1), ascii1.length());
        prep.setCharacterStream(3, (Reader)null, 0);
        prep.setAsciiStream(3, (InputStream)new ByteArrayInputStream(ascii2.getBytes()), ascii2.length());
        prep.executeUpdate();
        prep.clearParameters();
        prep.setInt(1, 4);
        prep.setNull(2, 2005);
        prep.setString(2, ascii2);
        prep.setCharacterStream(3, (Reader)null, 0);
        prep.setNull(3, 2005);
        prep.setString(3, ascii1);
        prep.executeUpdate();
        prep.clearParameters();
        prep.setInt(1, 5);
        prep.setObject(2, new StringReader(ascii1));
        prep.setObject(3, (Object)new StringReader(ascii2), 2005, 0);
        prep.executeUpdate();
        ResultSet rs = stat.executeQuery("SELECT ID, V1, V2 FROM T_CLOB ORDER BY ID");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertTrue(rs.getCharacterStream(2) == null && rs.wasNull());
        this.assertTrue(rs.getAsciiStream(3) == null && rs.wasNull());
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertTrue(rs.getString(2) == null && rs.wasNull());
        this.assertTrue(rs.getString(3) == null && rs.wasNull());
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        this.assertEquals(ascii1, rs.getString(2));
        this.assertEquals(ascii2, rs.getString(3));
        rs.next();
        this.assertEquals(4, rs.getInt(1));
        this.assertEquals(ascii2, rs.getString(2));
        this.assertEquals(ascii1, rs.getString(3));
        rs.next();
        this.assertEquals(5, rs.getInt(1));
        this.assertEquals(ascii1, rs.getString(2));
        this.assertEquals(ascii2, rs.getString(3));
        this.assertFalse(rs.next());
        this.assertNull(prep.getWarnings());
        prep.clearWarnings();
        this.assertNull(prep.getWarnings());
        this.assertTrue(conn == prep.getConnection());
    }

    private void testPreparedStatementWithLiteralsNone() throws SQLException {
        this.deleteDb("preparedStatement");
        Connection conn = this.getConnection("preparedStatement;ANALYZE_AUTO=100");
        conn.createStatement().execute("SET ALLOW_LITERALS NONE");
        conn.prepareStatement("CREATE TABLE test (id INT)").execute();
        PreparedStatement ps = conn.prepareStatement("INSERT INTO test (id) VALUES (?)");
        int i = 0;
        while (i < 200) {
            ps.setInt(1, i);
            ps.executeUpdate();
            ++i;
        }
        conn.close();
        this.deleteDb("preparedStatement");
    }

    private void testPreparedStatementWithIndexedParameterAndLiteralsNone() throws SQLException {
        this.deleteDb("preparedStatement");
        Connection conn = this.getConnection("preparedStatement;ANALYZE_AUTO=100");
        conn.createStatement().execute("SET ALLOW_LITERALS NONE");
        conn.prepareStatement("CREATE TABLE test (id INT)").execute();
        PreparedStatement ps = conn.prepareStatement("INSERT INTO test (id) VALUES (?1)");
        ps.setInt(1, 1);
        ps.executeUpdate();
        conn.close();
        this.deleteDb("preparedStatement");
    }

    private void testPreparedStatementWithAnyParameter() throws SQLException {
        this.deleteDb("preparedStatement");
        Connection conn = this.getConnection("preparedStatement");
        conn.prepareStatement("CREATE TABLE TEST(ID INT PRIMARY KEY, V INT UNIQUE)").execute();
        PreparedStatement ps = conn.prepareStatement("INSERT INTO TEST(ID, V) VALUES (?, ?)");
        int i = 0;
        while (i < 10000) {
            ps.setInt(1, i);
            ps.setInt(2, i * 10);
            ps.executeUpdate();
            ++i;
        }
        Integer[] values = new Integer[]{-100, 10, 200, 3000, 40000, 500000};
        int[] expected = new int[]{1, 20, 300, 4000};
        ps = conn.prepareStatement("SELECT ID FROM TEST WHERE V IN (SELECT * FROM TABLE(X INT=?)) ORDER BY ID");
        this.anyParameterCheck(ps, values, expected);
        ps = conn.prepareStatement("SELECT ID FROM TEST INNER JOIN TABLE(X INT=?) T ON TEST.V = T.X");
        this.anyParameterCheck(ps, values, expected);
        ps = conn.prepareStatement("SELECT ID FROM TEST WHERE V = ANY(?)");
        this.assertThrows(90012, ps).executeQuery();
        this.anyParameterCheck(ps, values, expected);
        this.anyParameterCheck(ps, 300, new int[]{30});
        this.anyParameterCheck(ps, -5, new int[0]);
        ps = conn.prepareStatement("SELECT V, CASE V WHEN = ANY(?) THEN 1 ELSE 2 END FROM (VALUES DATE '2000-01-01', DATE '2010-01-01') T(V) ORDER BY V");
        ps.setObject(1, new LocalDate[]{LocalDate.of(2000, 1, 1), LocalDate.of(2030, 1, 1)});
        Throwable throwable = null;
        Object var6_8 = null;
        try (ResultSet rs = ps.executeQuery();){
            this.assertTrue(rs.next());
            this.assertEquals(LocalDate.of(2000, 1, 1), rs.getObject(1, LocalDate.class));
            this.assertEquals(1, rs.getInt(2));
            this.assertTrue(rs.next());
            this.assertEquals(LocalDate.of(2010, 1, 1), rs.getObject(1, LocalDate.class));
            this.assertEquals(2, rs.getInt(2));
            this.assertFalse(rs.next());
            this.assertEquals("CASE V WHEN = ANY(?1) THEN 1 ELSE 2 END", rs.getMetaData().getColumnLabel(2));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        conn.close();
        this.deleteDb("preparedStatement");
    }

    private void anyParameterCheck(PreparedStatement ps, Object values, int[] expected) throws SQLException {
        ps.setObject(1, values);
        Throwable throwable = null;
        Object var5_6 = null;
        try (ResultSet rs = ps.executeQuery();){
            int[] nArray = expected;
            int n = expected.length;
            int n2 = 0;
            while (n2 < n) {
                int exp = nArray[n2];
                this.assertTrue(rs.next());
                this.assertEquals(exp, rs.getInt(1));
                ++n2;
            }
            this.assertFalse(rs.next());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void checkBigDecimal(ResultSet rs, String[] value) throws SQLException {
        String[] stringArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            this.assertTrue(rs.next());
            BigDecimal x = rs.getBigDecimal(1);
            this.trace("v=" + v + " x=" + String.valueOf(x));
            if (v == null) {
                this.assertNull(x);
            } else {
                this.assertTrue(x.compareTo(new BigDecimal(v)) == 0);
            }
            ++n2;
        }
        this.assertFalse(rs.next());
    }

    private void testColumnMetaDataWithEquals(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE TEST( id INT, someColumn INT )");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO TEST VALUES(?,?)");
        ps.setInt(1, 0);
        ps.setInt(2, 999);
        ps.execute();
        ps = conn.prepareStatement("SELECT * FROM TEST WHERE someColumn = ?");
        this.assertEquals(4, ps.getParameterMetaData().getParameterType(1));
        stmt.execute("DROP TABLE TEST");
    }

    private void testColumnMetaDataWithIn(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE TEST( id INT, someColumn INT )");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO TEST VALUES( ? , ? )");
        ps.setInt(1, 0);
        ps.setInt(2, 999);
        ps.execute();
        ps = conn.prepareStatement("SELECT * FROM TEST WHERE someColumn IN (?,?)");
        this.assertEquals(4, ps.getParameterMetaData().getParameterType(1));
        stmt.execute("DROP TABLE TEST");
    }

    private void testMultipleStatements(Connection conn) throws SQLException {
        this.assertThrows(90123, conn).prepareStatement("SELECT ?; SELECT ?1");
        this.assertThrows(90123, conn).prepareStatement("SELECT ?1; SELECT ?");
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE TEST (ID IDENTITY, V INT)");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO TEST(V) VALUES ?; INSERT INTO TEST(V) VALUES ?");
        ps.setInt(1, 1);
        ps.setInt(2, 2);
        ps.executeUpdate();
        ps = conn.prepareStatement("INSERT INTO TEST(V) VALUES ?2; INSERT INTO TEST(V) VALUES ?1;");
        ps.setInt(1, 3);
        ps.setInt(2, 4);
        ps.executeUpdate();
        Throwable throwable = null;
        Object var5_6 = null;
        try (ResultSet rs = stmt.executeQuery("SELECT V FROM TEST ORDER BY ID");){
            this.assertTrue(rs.next());
            this.assertEquals(1, rs.getInt(1));
            this.assertTrue(rs.next());
            this.assertEquals(2, rs.getInt(1));
            this.assertTrue(rs.next());
            this.assertEquals(4, rs.getInt(1));
            this.assertTrue(rs.next());
            this.assertEquals(3, rs.getInt(1));
            this.assertFalse(rs.next());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        stmt.execute("DROP TABLE TEST");
        ps = conn.prepareStatement("CREATE TABLE A (C1 INT);CREATE INDEX A_IDX ON A(C1);ALTER TABLE A ADD (C2 INT);CREATE TABLE B AS (SELECT C1 FROM A);");
        ps.executeUpdate();
        stmt.execute("DROP TABLE A, B");
    }

    private void testParameterInSubquery(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T1(ID1 BIGINT PRIMARY KEY, S INT NOT NULL)");
        stat.execute("CREATE TABLE T2(ID1 BIGINT REFERENCES T1, ID2 BIGINT)");
        stat.executeUpdate("INSERT INTO T1(ID1, S) VALUES(1, 1), (2, 1)");
        stat.executeUpdate("INSERT INTO T2(ID1, ID2) VALUES(1, 1), (2, 2)");
        PreparedStatement query = conn.prepareStatement("SELECT ID2 FROM (SELECT * FROM T1 WHERE ID1 IN (SELECT ID1 FROM T2 WHERE ID2 = ?) AND S = ?) T1 JOIN T2 USING(ID1)");
        query.setLong(1, 2L);
        query.setInt(2, 1);
        ResultSet rs = query.executeQuery();
        rs.next();
        this.assertEquals(2L, rs.getLong(1));
        query.setLong(1, 1L);
        rs = query.executeQuery();
        rs.next();
        this.assertEquals(1L, rs.getLong(1));
        stat.execute("DROP TABLE T2, T1");
    }

    private void testAfterRollback(Connection conn) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement stat = conn.createStatement();){
            try {
                ResultSet rs;
                stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
                conn.setAutoCommit(false);
                stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
                PreparedStatement pstmt = conn.prepareStatement("SELECT count(*) FROM TEST");
                Throwable throwable2 = null;
                Object var7_11 = null;
                try {
                    rs = pstmt.executeQuery();
                    try {
                        this.assertTrue(rs.next());
                        this.assertEquals(1, rs.getInt(1));
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                conn.rollback();
                throwable2 = null;
                var7_11 = null;
                try {
                    rs = pstmt.executeQuery();
                    try {
                        this.assertTrue(rs.next());
                        this.assertEquals(0, rs.getInt(1));
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
            finally {
                stat.execute("DROP TABLE IF EXISTS TEST");
                conn.setAutoCommit(true);
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private void testUnnestWithArrayParameter(Connection conn) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT * FROM (SELECT * FROM UNNEST(CAST(? AS INTEGER ARRAY)) UNION SELECT * FROM UNNEST(CAST(? AS INTEGER ARRAY))) ORDER BY 1");
        prep.setObject(1, new Integer[]{1, 2, 3});
        prep.setObject(2, new Integer[]{3, 4, 5});
        Throwable throwable = null;
        Object var4_5 = null;
        try (ResultSet rs = prep.executeQuery();){
            int i = 1;
            while (i <= 5) {
                this.assertTrue(rs.next());
                this.assertEquals(i, rs.getInt(1));
                ++i;
            }
            this.assertFalse(rs.next());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        prep = conn.prepareStatement("SELECT ARRAY_AGG(V) FROM UNNEST(ARRAY[CAST(? AS INTEGER), CAST(? AS INTEGER)]) T(V)");
        prep.setInt(1, 1);
        prep.setInt(2, 2);
        ResultSet rs = prep.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals(new Integer[]{1, 2}, rs.getObject(1, Integer[].class));
    }
}

