/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.h2.jdbc.JdbcConnection;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.IOUtils;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TestSQLXML
extends TestDb {
    private static final String XML = "<xml a=\"v\">Text</xml>";
    private JdbcConnection conn;
    private Statement stat;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb(this.getTestName());
        this.conn = (JdbcConnection)this.getConnection(this.getTestName());
        this.stat = this.conn.createStatement();
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, X CLOB)");
        this.stat.execute("INSERT INTO TEST VALUES (1, NULL)");
        this.testGetters();
        this.testSetters();
        this.conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testGetters() throws SQLException, IOException, XMLStreamException {
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST");
        this.assertTrue(rs.next());
        this.assertNull(rs.getSQLXML(2));
        this.assertNull(rs.getSQLXML("X"));
        this.assertEquals(1, this.stat.executeUpdate("UPDATE TEST SET X = '<xml a=\"v\">Text</xml>'"));
        rs = this.stat.executeQuery("SELECT * FROM TEST");
        this.assertTrue(rs.next());
        SQLXML sqlxml = rs.getObject(2, SQLXML.class);
        this.assertEquals(XML, sqlxml.getString());
        sqlxml = rs.getSQLXML(2);
        this.assertEquals(XML, IOUtils.readStringAndClose(IOUtils.getReader(sqlxml.getBinaryStream()), -1));
        this.assertEquals(XML, IOUtils.readStringAndClose(sqlxml.getCharacterStream(), -1));
        this.assertEquals(XML, sqlxml.getString());
        DOMSource domSource = sqlxml.getSource(DOMSource.class);
        Node n = domSource.getNode().getFirstChild();
        this.assertEquals("xml", n.getNodeName());
        this.assertEquals("v", n.getAttributes().getNamedItem("a").getNodeValue());
        this.assertEquals("Text", n.getFirstChild().getNodeValue());
        SAXSource saxSource = sqlxml.getSource(SAXSource.class);
        this.assertEquals(XML, IOUtils.readStringAndClose(IOUtils.getReader(saxSource.getInputSource().getByteStream()), -1));
        StAXSource staxSource = sqlxml.getSource(StAXSource.class);
        XMLStreamReader stxReader = staxSource.getXMLStreamReader();
        this.assertEquals(7, stxReader.getEventType());
        this.assertEquals(1, stxReader.next());
        this.assertEquals("xml", stxReader.getLocalName());
        this.assertEquals("a", stxReader.getAttributeLocalName(0));
        this.assertEquals("v", stxReader.getAttributeValue(0));
        this.assertEquals(4, stxReader.next());
        this.assertEquals("Text", stxReader.getText());
        this.assertEquals(2, stxReader.next());
        this.assertEquals(8, stxReader.next());
        StreamSource streamSource = sqlxml.getSource(StreamSource.class);
        this.assertEquals(XML, IOUtils.readStringAndClose(IOUtils.getReader(streamSource.getInputStream()), -1));
        this.assertThrows(50100, sqlxml).getSource(Source.class);
    }

    private void testSetters() throws SQLException, IOException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        Closeable out;
        SQLXML sqlxml = this.conn.createSQLXML();
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            out = sqlxml.setBinaryStream();
            try {
                ((OutputStream)out).write(XML.getBytes(StandardCharsets.UTF_8));
            }
            finally {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.testSettersImpl(sqlxml);
        sqlxml = this.conn.createSQLXML();
        throwable = null;
        var3_5 = null;
        try {
            out = sqlxml.setCharacterStream();
            try {
                ((Writer)out).write(XML);
            }
            finally {
                if (out != null) {
                    ((Writer)out).close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        this.testSettersImpl(sqlxml);
        sqlxml = this.conn.createSQLXML();
        sqlxml.setString(XML);
        this.testSettersImpl(sqlxml);
        TransformerFactory tf = TransformerFactory.newInstance();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DOMSource domSource = new DOMSource(dbf.newDocumentBuilder().parse(new InputSource(new StringReader(XML))));
        sqlxml = this.conn.createSQLXML();
        tf.newTransformer().transform(domSource, sqlxml.setResult(DOMResult.class));
        this.testSettersImpl(sqlxml);
        sqlxml = this.conn.createSQLXML();
        tf.newTransformer().transform(domSource, sqlxml.setResult(SAXResult.class));
        this.testSettersImpl(sqlxml);
        sqlxml = this.conn.createSQLXML();
        tf.newTransformer().transform(domSource, sqlxml.setResult(StAXResult.class));
        this.testSettersImpl(sqlxml);
        sqlxml = this.conn.createSQLXML();
        tf.newTransformer().transform(domSource, sqlxml.setResult(StreamResult.class));
        this.testSettersImpl(sqlxml);
        this.assertThrows(50100, sqlxml).setResult(Result.class);
        this.testSettersImpl(null);
    }

    private void assertXML(String actual) {
        if (actual.startsWith("<?")) {
            actual = actual.substring(actual.indexOf("?>") + 2);
        }
        this.assertEquals(XML, actual);
    }

    private void testSettersImplAssert(SQLXML sqlxml) throws SQLException {
        ResultSet rs = this.stat.executeQuery("SELECT X FROM TEST");
        this.assertTrue(rs.next());
        SQLXML v = rs.getSQLXML(1);
        if (sqlxml != null) {
            this.assertXML(v.getString());
        } else {
            this.assertNull(v);
        }
    }

    private void testSettersImpl(SQLXML sqlxml) throws SQLException {
        PreparedStatement prep = this.conn.prepareStatement("UPDATE TEST SET X = ?");
        prep.setSQLXML(1, sqlxml);
        this.assertEquals(1, prep.executeUpdate());
        this.testSettersImplAssert(sqlxml);
        prep.setObject(1, sqlxml);
        this.assertEquals(1, prep.executeUpdate());
        this.testSettersImplAssert(sqlxml);
        Statement st = this.conn.createStatement(1003, 1008);
        ResultSet rs = st.executeQuery("SELECT * FROM TEST FOR UPDATE");
        this.assertTrue(rs.next());
        rs.updateSQLXML(2, sqlxml);
        rs.updateRow();
        this.testSettersImplAssert(sqlxml);
        rs = st.executeQuery("SELECT * FROM TEST FOR UPDATE");
        this.assertTrue(rs.next());
        rs.updateSQLXML("X", sqlxml);
        rs.updateRow();
        this.testSettersImplAssert(sqlxml);
        rs = st.executeQuery("SELECT * FROM TEST FOR UPDATE");
        this.assertTrue(rs.next());
        rs.updateObject(2, (Object)sqlxml);
        rs.updateRow();
        this.testSettersImplAssert(sqlxml);
    }
}

