/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestTransactionIsolation
extends TestDb {
    private Connection conn1;
    private Connection conn2;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.testTableLevelLocking();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testTableLevelLocking() throws SQLException {
        block27: {
            Statement stmt;
            Connection conn;
            Object var2_4;
            Throwable throwable;
            block25: {
                this.deleteDb("transactionIsolation");
                this.conn1 = this.getConnection("transactionIsolation");
                this.conn1.setAutoCommit(false);
                this.conn2 = this.getConnection("transactionIsolation");
                this.conn2.setAutoCommit(false);
                this.assertEquals(2, this.conn1.getMetaData().getDefaultTransactionIsolation());
                this.assertEquals(2, this.conn1.getTransactionIsolation());
                throwable = null;
                var2_4 = null;
                try {
                    conn = this.getConnection("transactionIsolation");
                    try {
                        stmt = conn.createStatement();
                        try {
                            stmt.execute("CREATE TABLE TEST(ID INT)");
                        }
                        finally {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        if (conn == null) break block25;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (conn == null) throw throwable;
                        conn.close();
                        throw throwable;
                    }
                    conn.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            this.testIt(1);
            this.testIt(2);
            this.testIt(4);
            this.testIt(8);
            throwable = null;
            var2_4 = null;
            try {
                conn = this.getConnection("transactionIsolation");
                try {
                    stmt = conn.createStatement();
                    try {
                        stmt.execute("DROP TABLE TEST");
                        stmt.execute("CREATE TABLE TEST(ID INT UNIQUE)");
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    if (conn == null) break block27;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (conn == null) throw throwable;
                    conn.close();
                    throw throwable;
                }
                conn.close();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        this.testIt(1);
        this.testIt(2);
        this.testIt(4);
        this.testIt(8);
        this.conn2.close();
        this.conn1.close();
        this.deleteDb("transactionIsolation");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testIt(int isolationLevel2) throws SQLException {
        block13: {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                Connection conn = this.getConnection("transactionIsolation");
                try {
                    try (Statement stmt = conn.createStatement();){
                        stmt.execute("DELETE FROM TEST");
                        stmt.execute("INSERT INTO TEST VALUES(1)");
                    }
                    if (conn == null) break block13;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (conn == null) throw throwable;
                    conn.close();
                    throw throwable;
                }
                conn.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        this.conn2.setTransactionIsolation(isolationLevel2);
        this.assertEquals(isolationLevel2, this.conn2.getTransactionIsolation());
        this.testRowLocks(1);
        this.testRowLocks(2);
        this.testRowLocks(4);
        this.testRowLocks(8);
        this.testDirtyRead(1, 1, true, true);
        this.testDirtyRead(2, 2, false, true);
        this.testDirtyRead(4, 3, false, false);
        this.testDirtyRead(8, 4, false, false);
    }

    private void testDirtyRead(int isolationLevel, int value, boolean dirtyVisible, boolean committedVisible) throws SQLException {
        this.conn1.setTransactionIsolation(isolationLevel);
        this.assertSingleValue(this.conn1.createStatement(), "SELECT * FROM TEST", value);
        int newValue = value + 1;
        this.conn2.createStatement().executeUpdate("UPDATE TEST SET ID=" + newValue);
        this.assertSingleValue(this.conn1.createStatement(), "SELECT * FROM TEST", dirtyVisible ? newValue : value);
        this.conn2.commit();
        this.assertSingleValue(this.conn1.createStatement(), "SELECT * FROM TEST", committedVisible ? newValue : value);
    }

    private void testRowLocks(int isolationLevel) throws SQLException {
        this.conn1.setTransactionIsolation(isolationLevel);
        this.assertSingleValue(this.conn1.createStatement(), "SELECT * FROM TEST", 1);
        this.assertSingleValue(this.conn2.createStatement(), "SELECT * FROM TEST FOR UPDATE", 1);
        this.assertThrows(50200, this.conn1.createStatement()).executeUpdate("DELETE FROM TEST");
        this.conn2.commit();
    }
}

