/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestZloty
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.testZloty();
        this.testModifyBytes();
        this.deleteDb("zloty");
    }

    private void testModifyBytes() throws SQLException {
        this.deleteDb("zloty");
        Connection conn = this.getConnection("zloty");
        conn.createStatement().execute("CREATE TABLE TEST(ID INT, DATA BINARY)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        byte[] shared = new byte[1];
        prep.setInt(1, 0);
        prep.setBytes(2, shared);
        prep.execute();
        shared[0] = 1;
        prep.setInt(1, 1);
        prep.setBytes(2, shared);
        prep.execute();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        this.assertEquals(0, rs.getBytes(2)[0]);
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals(1, rs.getBytes(2)[0]);
        rs.getBytes((int)2)[0] = 2;
        this.assertEquals(1, rs.getBytes(2)[0]);
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testZloty() throws SQLException {
        this.deleteDb("zloty");
        Connection conn = this.getConnection("zloty");
        conn.createStatement().execute("CREATE TABLE TEST(ID INT, AMOUNT DECIMAL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        prep.setInt(1, 1);
        prep.setBigDecimal(2, new BigDecimal("10.0"));
        prep.execute();
        prep.setInt(1, 2);
        this.assertThrows(90125, prep).setBigDecimal(2, new ZlotyBigDecimal("11.0"));
        prep.setInt(1, 3);
        BigDecimal value = new BigDecimal("12.100000"){
            private static final long serialVersionUID = 1L;

            @Override
            public String toString() {
                return "12,100000 EURO";
            }
        };
        this.assertThrows(90125, prep).setBigDecimal(2, value);
        conn.close();
    }

    private static class ZlotyBigDecimal
    extends BigDecimal {
        private static final long serialVersionUID = 1L;

        public ZlotyBigDecimal(String s) {
            super(s);
        }

        @Override
        public int compareTo(BigDecimal bd) {
            return -super.compareTo(bd);
        }
    }
}

