/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbcx;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.jdbcx.SimpleXid;
import org.h2.util.JdbcUtils;

public class TestXA
extends TestDb {
    private static final String DB_NAME1 = "xadb1";
    private static final String DB_NAME2 = "xadb2";

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testRollbackWithoutPrepare();
        this.testRollbackAfterPrepare();
        this.testXAAutoCommit();
        this.deleteDb("xa");
        this.testMixedXaNormal();
        this.testXA(true);
        this.deleteDb(DB_NAME1);
        this.deleteDb(DB_NAME2);
        this.testXA(false);
        this.deleteDb("xa");
        this.deleteDb(DB_NAME1);
        this.deleteDb(DB_NAME2);
    }

    private void testRollbackWithoutPrepare() throws Exception {
        if (this.config.memory) {
            return;
        }
        Xid xid = new Xid(){

            @Override
            public int getFormatId() {
                return 3145;
            }

            @Override
            public byte[] getGlobalTransactionId() {
                return new byte[]{1, 2, 3, 4, 5, 6, 6, 7, 8};
            }

            @Override
            public byte[] getBranchQualifier() {
                return new byte[]{34, 43, 33, 3, 3, 3, 33, 33, 3};
            }
        };
        this.deleteDb("xa");
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(this.getURL("xa", true));
        ds.setPassword(this.getPassword());
        Connection dm = ds.getConnection();
        Statement stat = dm.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS TEST(ID INT PRIMARY KEY, VAL INT)");
        stat.execute("INSERT INTO TEST(ID,VAL) VALUES (1,1)");
        dm.close();
        XAConnection c = ds.getXAConnection();
        XAResource xa = c.getXAResource();
        Connection connection = c.getConnection();
        xa.start(xid, 0x200000);
        PreparedStatement ps = connection.prepareStatement("UPDATE TEST SET VAL=? WHERE ID=?");
        ps.setInt(1, new Random().nextInt());
        ps.setInt(2, 1);
        ps.close();
        xa.rollback(xid);
        connection.close();
        c.close();
        this.deleteDb("xa");
    }

    private void testRollbackAfterPrepare() throws Exception {
        if (this.config.memory) {
            return;
        }
        Xid xid = new Xid(){

            @Override
            public int getFormatId() {
                return 3145;
            }

            @Override
            public byte[] getGlobalTransactionId() {
                return new byte[]{1, 2, 3, 4, 5, 6, 6, 7, 8};
            }

            @Override
            public byte[] getBranchQualifier() {
                return new byte[]{34, 43, 33, 3, 3, 3, 33, 33, 3};
            }
        };
        this.deleteDb("xa");
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(this.getURL("xa", true));
        ds.setPassword(this.getPassword());
        Connection dm = ds.getConnection();
        Statement stat = dm.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS TEST(ID INT PRIMARY KEY, VAL INT)");
        stat.execute("INSERT INTO TEST(ID,VAL) VALUES (1,1)");
        dm.close();
        XAConnection c = ds.getXAConnection();
        XAResource xa = c.getXAResource();
        Connection connection = c.getConnection();
        xa.start(xid, 0x200000);
        PreparedStatement ps = connection.prepareStatement("UPDATE TEST SET VAL=? WHERE ID=?");
        ps.setInt(1, new Random().nextInt());
        ps.setInt(2, 1);
        ps.close();
        xa.prepare(xid);
        xa.rollback(xid);
        connection.close();
        c.close();
        this.deleteDb("xa");
    }

    private void testMixedXaNormal() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:test");
        ds.setUser("sa");
        ds.setPassword("");
        XAConnection xa = ds.getXAConnection();
        Connection c = xa.getConnection();
        this.assertTrue(c.getAutoCommit());
        MyXid xid = new MyXid();
        XAResource res = xa.getXAResource();
        res.start(xid, 0);
        this.assertFalse(c.getAutoCommit());
        res.end(xid, 0x4000000);
        res.commit(xid, true);
        this.assertTrue(c.getAutoCommit());
        res.start(xid, 0);
        this.assertFalse(c.getAutoCommit());
        res.end(xid, 0x20000000);
        res.rollback(xid);
        this.assertTrue(c.getAutoCommit());
        c.close();
        xa.close();
    }

    private void testXAAutoCommit() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:test");
        ds.setUser("sa");
        ds.setPassword("");
        XAConnection xa = ds.getXAConnection();
        MyXid xid = new MyXid();
        xa.getXAResource().start(xid, 0);
        Connection c = xa.getConnection();
        this.assertFalse(c.getAutoCommit());
        c.close();
        xa.close();
    }

    private void testXA(boolean useOneDatabase) throws SQLException {
        block39: {
            String url1 = this.getURL(DB_NAME1, true);
            String url2 = this.getURL(DB_NAME2, true);
            PooledConnection xaConn1 = null;
            PooledConnection xaConn2 = null;
            Connection conn1 = null;
            Connection conn2 = null;
            Statement stat1 = null;
            Statement stat2 = null;
            try {
                try {
                    this.trace("xads1 = createXADatasource1()");
                    XADataSource xaDs1 = this.createXADatasource(useOneDatabase, url1);
                    this.trace("xads2 = createXADatasource2()");
                    XADataSource xaDs2 = this.createXADatasource(useOneDatabase, url2);
                    this.trace("xacon1 = xads1.getXAConnection()");
                    xaConn1 = xaDs1.getXAConnection();
                    this.trace("xacon2 = xads2.getXAConnection()");
                    xaConn2 = xaDs2.getXAConnection();
                    this.trace("xares1 = xacon1.getXAResource()");
                    XAResource xares1 = xaConn1.getXAResource();
                    this.trace("xares2 = xacon2.getXAResource()");
                    XAResource xares2 = xaConn2.getXAResource();
                    this.trace("xares1.recover(XAResource.TMSTARTRSCAN)");
                    Xid[] xids1 = xares1.recover(0x1000000);
                    if (xids1 == null || xids1.length == 0) {
                        this.trace("xares1.recover(XAResource.TMSTARTRSCAN): 0");
                    } else {
                        this.trace("xares1.recover(XAResource.TMSTARTRSCAN): " + xids1.length);
                    }
                    this.trace("xares2.recover(XAResource.TMSTARTRSCAN)");
                    Xid[] xids2 = xares2.recover(0x1000000);
                    if (xids2 == null || xids2.length == 0) {
                        this.trace("xares2.recover(XAResource.TMSTARTRSCAN): 0");
                    } else {
                        this.trace("xares2.recover(XAResource.TMSTARTRSCAN): " + xids2.length);
                    }
                    this.trace("con1 = xacon1.getConnection()");
                    conn1 = xaConn1.getConnection();
                    this.trace("stmt1 = con1.createStatement()");
                    stat1 = conn1.createStatement();
                    this.trace("con2 = xacon2.getConnection()");
                    conn2 = xaConn2.getConnection();
                    this.trace("stmt2 = con2.createStatement()");
                    stat2 = conn2.createStatement();
                    if (useOneDatabase) {
                        this.trace("stmt1.executeUpdate(\"DROP TABLE xatest1\")");
                        try {
                            stat1.executeUpdate("DROP TABLE xatest1");
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        this.trace("stmt2.executeUpdate(\"DROP TABLE xatest2\")");
                        try {
                            stat2.executeUpdate("DROP TABLE xatest2");
                        }
                        catch (SQLException sQLException) {}
                    } else {
                        this.trace("stmt1.executeUpdate(\"DROP TABLE xatest\")");
                        try {
                            stat1.executeUpdate("DROP TABLE xatest");
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        this.trace("stmt2.executeUpdate(\"DROP TABLE xatest\")");
                        try {
                            stat2.executeUpdate("DROP TABLE xatest");
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (useOneDatabase) {
                        this.trace("stmt1.executeUpdate(\"CREATE TABLE xatest1 (id INT PRIMARY KEY, value INT)\")");
                        stat1.executeUpdate("CREATE TABLE xatest1 (id INT PRIMARY KEY, v INT)");
                        this.trace("stmt2.executeUpdate(\"CREATE TABLE xatest2 (id INT PRIMARY KEY, v INT)\")");
                        stat2.executeUpdate("CREATE TABLE xatest2 (id INT PRIMARY KEY, v INT)");
                    } else {
                        this.trace("stmt1.executeUpdate(\"CREATE TABLE xatest (id INT PRIMARY KEY, value INT)\")");
                        stat1.executeUpdate("CREATE TABLE xatest (id INT PRIMARY KEY, v INT)");
                        this.trace("stmt2.executeUpdate(\"CREATE TABLE xatest (id INT PRIMARY KEY, v INT)\")");
                        stat2.executeUpdate("CREATE TABLE xatest (id INT PRIMARY KEY, v INT)");
                    }
                    if (useOneDatabase) {
                        this.trace("stmt1.executeUpdate(\"INSERT INTO xatest1 VALUES (1, 0)\")");
                        stat1.executeUpdate("INSERT INTO xatest1 VALUES (1, 0)");
                        this.trace("stmt2.executeUpdate(\"INSERT INTO xatest2 VALUES (2, 0)\")");
                        stat2.executeUpdate("INSERT INTO xatest2 VALUES (2, 0)");
                    } else {
                        this.trace("stmt1.executeUpdate(\"INSERT INTO xatest VALUES (1, 0)\")");
                        stat1.executeUpdate("INSERT INTO xatest VALUES (1, 0)");
                        this.trace("stmt2.executeUpdate(\"INSERT INTO xatest VALUES (2, 0)\")");
                        stat2.executeUpdate("INSERT INTO xatest VALUES (2, 0)");
                    }
                    SimpleXid xid1 = null;
                    SimpleXid xid2 = null;
                    if (useOneDatabase) {
                        xid1 = SimpleXid.createRandom();
                        xid2 = SimpleXid.createRandom();
                    } else {
                        xid2 = xid1 = SimpleXid.createRandom();
                    }
                    if (useOneDatabase) {
                        this.trace("xares1.start(xid1, XAResource.TMNOFLAGS)");
                        xares1.start(xid1, 0);
                        this.trace("xares2.start(xid2, XAResource.TMJOIN)");
                        xares2.start(xid2, 0x200000);
                    } else {
                        this.trace("xares1.start(xid1, XAResource.TMNOFLAGS)");
                        xares1.start(xid1, 0);
                        this.trace("xares2.start(xid2, XAResource.TMNOFLAGS)");
                        xares2.start(xid2, 0);
                    }
                    if (useOneDatabase) {
                        this.trace("stmt1.executeUpdate(\"UPDATE xatest1 SET v=1 WHERE id=1\")");
                        stat1.executeUpdate("UPDATE xatest1 SET v=1 WHERE id=1");
                        this.trace("stmt2.executeUpdate(\"UPDATE xatest2 SET v=1 WHERE id=2\")");
                        stat2.executeUpdate("UPDATE xatest2 SET v=1 WHERE id=2");
                    } else {
                        this.trace("stmt1.executeUpdate(\"UPDATE xatest SET v=1 WHERE id=1\")");
                        stat1.executeUpdate("UPDATE xatest SET v=1 WHERE id=1");
                        this.trace("stmt2.executeUpdate(\"UPDATE xatest SET v=1 WHERE id=2\")");
                        stat2.executeUpdate("UPDATE xatest SET v=1 WHERE id=2");
                    }
                    this.trace("xares1.end(xid1, XAResource.TMSUCCESS)");
                    xares1.end(xid1, 0x4000000);
                    this.trace("xares2.end(xid2, XAResource.TMSUCCESS)");
                    xares2.end(xid2, 0x4000000);
                    this.trace("ret1 = xares1.prepare(xid1)");
                    int ret1 = xares1.prepare(xid1);
                    this.trace("xares1.prepare(xid1): " + ret1);
                    this.trace("ret2 = xares2.prepare(xid2)");
                    int ret2 = xares2.prepare(xid2);
                    this.trace("xares2.prepare(xid2): " + ret2);
                    if (ret1 != 0 && ret1 != 3) {
                        throw new IllegalStateException("xares1.prepare(xid1) must return XA_OK or XA_RDONLY");
                    }
                    if (ret2 != 0 && ret2 != 3) {
                        throw new IllegalStateException("xares2.prepare(xid2) must return XA_OK or XA_RDONLY");
                    }
                    if (ret1 == 0) {
                        this.trace("xares1.commit(xid1, false)");
                        xares1.commit(xid1, false);
                    }
                    if (ret2 == 0) {
                        this.trace("xares2.commit(xid2, false)");
                        xares2.commit(xid2, false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JdbcUtils.closeSilently(stat1);
                    JdbcUtils.closeSilently(stat2);
                    JdbcUtils.closeSilently(conn1);
                    JdbcUtils.closeSilently(conn2);
                    if (xaConn1 != null) {
                        xaConn1.close();
                    }
                    if (xaConn2 != null) {
                        xaConn2.close();
                    }
                    break block39;
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilently(stat1);
                JdbcUtils.closeSilently(stat2);
                JdbcUtils.closeSilently(conn1);
                JdbcUtils.closeSilently(conn2);
                if (xaConn1 != null) {
                    xaConn1.close();
                }
                if (xaConn2 != null) {
                    xaConn2.close();
                }
                throw throwable;
            }
            JdbcUtils.closeSilently(stat1);
            JdbcUtils.closeSilently(stat2);
            JdbcUtils.closeSilently(conn1);
            JdbcUtils.closeSilently(conn2);
            if (xaConn1 != null) {
                xaConn1.close();
            }
            if (xaConn2 != null) {
                xaConn2.close();
            }
        }
    }

    private XADataSource createXADatasource(boolean useOneDatabase, String url) {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setPassword(this.getPassword(""));
        ds.setUser("sa");
        if (useOneDatabase) {
            ds.setURL(this.getURL("xa", true));
        } else {
            ds.setURL(url);
        }
        return ds;
    }

    public static class MyXid
    implements Xid {
        private final byte[] branchQualifier = new byte[1];
        private final byte[] globalTransactionId = new byte[1];

        @Override
        public byte[] getBranchQualifier() {
            return this.branchQualifier;
        }

        @Override
        public int getFormatId() {
            return 0;
        }

        @Override
        public byte[] getGlobalTransactionId() {
            return this.globalTransactionId;
        }
    }
}

