/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbcx;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.transaction.xa.Xid;
import org.h2.Driver;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.jdbcx.SimpleXid;
import org.h2.util.JdbcUtils;

public class TestXASimple
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testTwoPhase();
        this.testSimple();
    }

    private void testTwoPhase() throws Exception {
        if (this.config.memory || this.config.networked) {
            return;
        }
        this.testTwoPhase("xaSimple2a", true, true);
        this.testTwoPhase("xaSimple2b", true, false);
    }

    private void testTwoPhase(String db, boolean shutdown, boolean commit) throws Exception {
        this.deleteDb(db);
        JdbcDataSource ds = new JdbcDataSource();
        ds.setPassword(this.getPassword());
        ds.setUser("sa");
        ds.setURL(this.getURL(db, true));
        XAConnection xa = ds.getXAConnection();
        Connection conn = xa.getConnection();
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar(255))");
        SimpleXid xid = SimpleXid.createRandom();
        xa.getXAResource().start(xid, 0);
        conn.setAutoCommit(false);
        stat.execute("insert into test values(1, 'Hello')");
        xa.getXAResource().end(xid, 0x4000000);
        xa.getXAResource().prepare(xid);
        if (shutdown) {
            TestXASimple.shutdown(ds);
        }
        xa = ds.getXAConnection();
        Xid[] list = xa.getXAResource().recover(0x1000000);
        this.assertEquals(1, list.length);
        this.assertTrue(((Object)xid).equals(list[0]));
        if (commit) {
            xa.getXAResource().commit(list[0], false);
        } else {
            xa.getXAResource().rollback(list[0]);
        }
        conn = xa.getConnection();
        conn.createStatement().executeQuery("select * from test");
        if (shutdown) {
            TestXASimple.shutdown(ds);
        }
        xa = ds.getXAConnection();
        list = xa.getXAResource().recover(0x1000000);
        this.assertEquals(0, list.length);
        conn = xa.getConnection();
        ResultSet rs = conn.createStatement().executeQuery("select * from test");
        if (commit) {
            this.assertTrue(rs.next());
        } else {
            this.assertFalse(rs.next());
        }
        xa.close();
    }

    private static void shutdown(JdbcDataSource ds) throws SQLException {
        Connection conn = ds.getConnection();
        conn.createStatement().execute("shutdown immediately");
        JdbcUtils.closeSilently(conn);
    }

    private void testSimple() throws SQLException {
        this.deleteDb("xaSimple1");
        this.deleteDb("xaSimple2");
        Driver.load();
        JdbcDataSource ds1 = new JdbcDataSource();
        ds1.setPassword(this.getPassword());
        ds1.setUser("sa");
        ds1.setURL(this.getURL("xaSimple1", true));
        JdbcDataSource ds2 = new JdbcDataSource();
        ds2.setPassword(this.getPassword());
        ds2.setUser("sa");
        ds2.setURL(this.getURL("xaSimple2", true));
        XAConnection xa1 = ds1.getXAConnection();
        Connection c1 = xa1.getConnection();
        c1.setAutoCommit(false);
        XAConnection xa2 = ds2.getXAConnection();
        Connection c2 = xa2.getConnection();
        c2.setAutoCommit(false);
        c1.createStatement().executeUpdate("create table test(id int, test varchar(255))");
        c2.createStatement().executeUpdate("create table test(id int, test varchar(255))");
        c1.close();
        c2.close();
        xa1.close();
        xa2.close();
        this.deleteDb("xaSimple1");
        this.deleteDb("xaSimple2");
    }
}

