/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.mvcc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.CyclicBarrier;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Task;

public class TestMvccMultiThreaded
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void test() throws Exception {
        this.testConcurrentSelectForUpdate();
        this.testMergeWithUniqueKeyViolation();
        this.testConcurrentMerge();
        this.testConcurrentUpdate();
    }

    private void testConcurrentSelectForUpdate() throws Exception {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection(this.getTestName());
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int not null primary key, updated int not null)");
        stat.execute("insert into test(id, updated) values(1, 100)");
        ArrayList<Task> tasks = new ArrayList<Task>();
        int count = 3;
        int i = 0;
        while (i < count) {
            Task task = new Task(){

                @Override
                public void call() throws Exception {
                    Throwable throwable = null;
                    Object var2_3 = null;
                    try (Connection conn = TestMvccMultiThreaded.this.getConnection(TestMvccMultiThreaded.this.getTestName());){
                        Statement stat = conn.createStatement();
                        while (!this.stop) {
                            stat.execute("select * from test where id=1 for update");
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }.execute();
            tasks.add(task);
            ++i;
        }
        i = 0;
        while (i < 10) {
            Thread.sleep(100L);
            ResultSet rs = stat.executeQuery("select * from test");
            this.assertTrue(rs.next());
            ++i;
        }
        for (Task t : tasks) {
            t.get();
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testMergeWithUniqueKeyViolation() throws Exception {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection(this.getTestName());
        Statement stat = conn.createStatement();
        stat.execute("create table test(x int primary key, y int unique)");
        stat.execute("insert into test values(1, 1)");
        this.assertThrows(23505, stat).execute("merge into test values(2, 1)");
        stat.execute("merge into test values(1, 2)");
        conn.close();
    }

    private void testConcurrentMerge() throws Exception {
        this.deleteDb(this.getTestName());
        int len = 3;
        Connection[] connList = new Connection[len];
        int i = 0;
        while (i < len) {
            Connection conn;
            connList[i] = conn = this.getConnection(this.getTestName() + ";LOCK_TIMEOUT=500");
            ++i;
        }
        Connection conn = connList[0];
        conn.createStatement().execute("create table test(id int primary key, name varchar)");
        Task[] tasks = new Task[len];
        int i2 = 0;
        while (i2 < len) {
            final Connection c = connList[i2];
            c.setAutoCommit(false);
            tasks[i2] = new Task(){

                @Override
                public void call() throws Exception {
                    while (!this.stop) {
                        c.createStatement().execute("merge into test values(1, 'x')");
                        c.commit();
                    }
                }
            };
            tasks[i2].execute();
            ++i2;
        }
        Thread.sleep(1000L);
        i2 = 0;
        while (i2 < len) {
            tasks[i2].get();
            ++i2;
        }
        i2 = 0;
        while (i2 < len) {
            connList[i2].close();
            ++i2;
        }
        this.deleteDb(this.getTestName());
    }

    private void testConcurrentUpdate() throws Exception {
        this.deleteDb(this.getTestName());
        int len = 2;
        final Connection[] connList = new Connection[len];
        int i = 0;
        while (i < len) {
            connList[i] = this.getConnection(this.getTestName());
            ++i;
        }
        Connection conn = connList[0];
        conn.createStatement().execute("create table test(id int primary key, v int)");
        conn.createStatement().execute("insert into test values(0, 0)");
        int count = 1000;
        Task[] tasks = new Task[len];
        final CyclicBarrier barrier = new CyclicBarrier(len);
        int i2 = 0;
        while (i2 < len) {
            final int x = i2;
            connList[x].setAutoCommit(false);
            tasks[i2] = new Task(){

                @Override
                public void call() throws Exception {
                    int a = 0;
                    while (a < 1000) {
                        ResultSet rs = connList[x].createStatement().executeQuery("select v from test for update");
                        TestMvccMultiThreaded.this.assertTrue(rs.next());
                        connList[x].createStatement().execute("update test set v=v+1");
                        connList[x].commit();
                        barrier.await();
                        ++a;
                    }
                }
            };
            tasks[i2].execute();
            ++i2;
        }
        i2 = 0;
        while (i2 < len) {
            tasks[i2].get();
            ++i2;
        }
        ResultSet rs = conn.createStatement().executeQuery("select v from test");
        rs.next();
        this.assertEquals(1000 * len, rs.getInt(1));
        int i3 = 0;
        while (i3 < len) {
            connList[i3].close();
            ++i3;
        }
    }
}

