/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.poweroff;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.TimeUnit;

public class Listener
implements Runnable {
    private volatile int maxValue;

    public static void main(String ... args) throws IOException {
        new Listener().test(args);
    }

    private void test(String ... args) throws IOException {
        int port = 9099;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
            }
            ++i;
        }
        this.listen(port);
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("Max=" + this.maxValue);
        }
    }

    private void listen(int port) throws IOException {
        new Thread(this).start();
        ServerSocket serverSocket = new ServerSocket(port);
        System.out.println("Listening on " + serverSocket.toString());
        this.maxValue = 0;
        while (true) {
            Socket socket = serverSocket.accept();
            DataInputStream in = new DataInputStream(socket.getInputStream());
            System.out.println("Connected");
            long time = System.nanoTime();
            try {
                int value;
                while ((value = in.readInt()) >= 0) {
                    this.maxValue = Math.max(this.maxValue, value);
                }
            }
            catch (IOException e) {
                System.out.println("Closed with Exception: " + String.valueOf(e));
            }
            time = System.nanoTime() - time;
            int operationsPerSecond = (int)(TimeUnit.SECONDS.toNanos(1L) * (long)this.maxValue / time);
            System.out.println("Max=" + this.maxValue + " operations/sec=" + operationsPerSecond);
        }
    }
}

