/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.poweroff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.util.IOUtils;

public class TestRecover {
    private static final int MAX_STRING_LENGTH = 10000;
    private static final String NODE = System.getProperty("test.node", "");
    private static final String DIR = System.getProperty("test.dir", "/temp/db");
    private static final String TEST_DIRECTORY = DIR + "/data" + NODE;
    private static final String BACKUP_DIRECTORY = DIR + "/last";
    private static final String URL = System.getProperty("test.url", "jdbc:h2:" + TEST_DIRECTORY + "/test");
    private static final String DRIVER = System.getProperty("test.driver", "org.h2.Driver");

    public static void main(String ... args) throws Exception {
        System.out.println("URL=" + URL);
        System.out.println("backup...");
        new File(TEST_DIRECTORY).mkdirs();
        File backup = TestRecover.backup(TEST_DIRECTORY, BACKUP_DIRECTORY, "data", 10, NODE);
        System.out.println("check consistency...");
        if (!TestRecover.testConsistency()) {
            System.out.println("error! renaming file");
            backup.renameTo(new File(backup.getParentFile(), "error-" + backup.getName()));
        }
        System.out.println("deleting old run...");
        TestRecover.deleteRecursive(new File(TEST_DIRECTORY));
        System.out.println("testing...");
        TestRecover.testLoop();
    }

    private static File backup(String sourcePath, String targetPath, String basePath, int max, String node) throws IOException {
        File root = new File(targetPath);
        if (!root.exists()) {
            root.mkdirs();
        }
        while (true) {
            File oldest = null;
            int count = 0;
            File[] fileArray = root.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String name = f.getName();
                if (f.isFile() && name.startsWith("backup") && name.endsWith(".zip")) {
                    ++count;
                    if (oldest == null || f.lastModified() < oldest.lastModified()) {
                        oldest = f;
                    }
                }
                ++n2;
            }
            if (count < max) break;
            oldest.delete();
        }
        String date = DateTimeFormatter.ofPattern("yyMMdd-HHmmss").format(LocalDateTime.now());
        File zipFile = new File(root, "backup-" + date + "-" + node + ".zip");
        ArrayList<File> list = new ArrayList<File>();
        File base = new File(sourcePath);
        TestRecover.listRecursive(list, base);
        if (list.size() == 0) {
            FileOutputStream out = new FileOutputStream(zipFile);
            out.close();
        } else {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(zipFile);
                ZipOutputStream zipOut = new ZipOutputStream(out);
                String baseName = base.getAbsolutePath();
                for (File f : list) {
                    String fileName = f.getAbsolutePath();
                    Object entryName = fileName;
                    if (fileName.startsWith(baseName)) {
                        entryName = ((String)entryName).substring(baseName.length());
                    }
                    if (((String)entryName).startsWith("\\")) {
                        entryName = ((String)entryName).substring(1);
                    }
                    if (!((String)entryName).startsWith("/")) {
                        entryName = "/" + (String)entryName;
                    }
                    ZipEntry entry = new ZipEntry(basePath + (String)entryName);
                    zipOut.putNextEntry(entry);
                    Throwable throwable = null;
                    Object var19_24 = null;
                    try (FileInputStream in = new FileInputStream(fileName);){
                        IOUtils.copyAndCloseInput(in, zipOut);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    zipOut.closeEntry();
                }
                zipOut.closeEntry();
                zipOut.close();
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(out);
                throw throwable;
            }
            IOUtils.closeSilently(out);
        }
        return zipFile;
    }

    private static void listRecursive(List<File> list, File file) throws IOException {
        File[] l = file.listFiles();
        int i = 0;
        while (l != null && i < l.length) {
            File f = l[i];
            if (f.isDirectory()) {
                TestRecover.listRecursive(list, f);
            } else {
                list.add(f);
            }
            ++i;
        }
    }

    private static void deleteRecursive(File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                TestRecover.deleteRecursive(f);
                ++n2;
            }
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete " + file.getAbsolutePath());
        }
    }

    private static void testLoop() throws Exception {
        SecureRandom random = new SecureRandom();
        while (true) {
            TestRecover.runOneTest(random.nextInt());
        }
    }

    private static Connection openConnection() throws Exception {
        Class.forName(DRIVER);
        Connection conn = DriverManager.getConnection(URL, "sa", "sa");
        Statement stat = conn.createStatement();
        try {
            stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, D INT, NAME VARCHAR(10000))");
            stat.execute("CREATE INDEX IDX_TEST_D ON TEST(D)");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return conn;
    }

    private static void closeConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (DRIVER.startsWith("org.apache.derby")) {
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                Driver driver = (Driver)Class.forName(DRIVER).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                DriverManager.registerDriver(driver);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void runOneTest(int i) throws Exception {
        Random random = new Random(i);
        Connection conn = TestRecover.openConnection();
        PreparedStatement prepInsert = null;
        PreparedStatement prepDelete = null;
        conn.setAutoCommit(false);
        int id = 0;
        while (true) {
            int op;
            boolean rollback = random.nextInt(10) == 1;
            int len = random.nextInt(10) == 1 ? random.nextInt(100) * 2 : random.nextInt(2) * 2;
            if (rollback && random.nextBoolean()) {
                ++len;
            }
            if ((op = random.nextInt()) % 1000000 == 0) {
                TestRecover.closeConnection(conn);
                conn = TestRecover.openConnection();
                conn.setAutoCommit(false);
                prepInsert = null;
                prepDelete = null;
            }
            if (random.nextBoolean()) {
                if (prepInsert == null) {
                    prepInsert = conn.prepareStatement("INSERT INTO TEST(ID, D, NAME) VALUES(?, ?, ?)");
                }
                prepInsert.setInt(1, id);
                prepInsert.setInt(2, random.nextInt(10000));
                StringBuilder buff = new StringBuilder();
                buff.append(len);
                switch (random.nextInt(10)) {
                    case 0: {
                        len = random.nextInt(10000);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        len = random.nextInt(500);
                        break;
                    }
                    default: {
                        len = 0;
                    }
                }
                len -= 10;
                while (len > 0) {
                    buff.append('-');
                    --len;
                }
                buff.append("->");
                String s = buff.toString();
                prepInsert.setString(3, s);
                prepInsert.execute();
            } else {
                ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM TEST");
                rs.next();
                int count = rs.getInt(1);
                rs.close();
                if (count > 1000) {
                    if (prepDelete == null) {
                        prepDelete = conn.prepareStatement("DELETE FROM TEST WHERE ROWNUM <= 4");
                    }
                    prepDelete.execute();
                }
            }
            if (rollback) {
                conn.rollback();
            } else {
                conn.commit();
            }
            ++id;
        }
    }

    private static boolean testConsistency() {
        PrintWriter p = null;
        try {
            p = new PrintWriter(new FileOutputStream(TEST_DIRECTORY + "/result.txt"));
            p.println("Results");
            p.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(0);
        }
        Connection conn = null;
        try {
            conn = TestRecover.openConnection();
            TestRecover.test(conn, "");
            TestRecover.test(conn, "ORDER BY D");
            TestRecover.closeConnection(conn);
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            t.printStackTrace(p);
            return false;
        }
        finally {
            if (conn != null) {
                try {
                    TestRecover.closeConnection(conn);
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                    t2.printStackTrace(p);
                }
            }
            if (p != null) {
                p.flush();
                p.close();
                IOUtils.closeSilently(p);
            }
        }
    }

    private static void test(Connection conn, String order) throws Exception {
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST " + order);
        int max = 0;
        int count = 0;
        while (rs.next()) {
            ++count;
            int id = rs.getInt("ID");
            String name = rs.getString("NAME");
            if (!name.endsWith(">")) {
                throw new Exception("unexpected entry " + id + " value " + name);
            }
            int idx = name.indexOf(45);
            if (idx < 0) {
                throw new Exception("unexpected entry " + id + " value " + name);
            }
            int value = Integer.parseInt(name.substring(0, idx));
            if (value % 2 != 0) {
                throw new Exception("unexpected odd entry " + id + " value " + value);
            }
            max = Math.max(max, id);
        }
        rs.close();
        System.out.println("max row id: " + max + " rows: " + count);
    }
}

