/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.poweroff;

import java.io.File;
import java.io.FileDescriptor;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;

public class TestWrite {
    private TestWrite() {
    }

    public static void main(String ... args) throws Exception {
        TestWrite.testFile("rw", false);
        TestWrite.testFile("rwd", false);
        TestWrite.testFile("rws", false);
        TestWrite.testFile("rw", true);
        TestWrite.testFile("rwd", true);
        TestWrite.testFile("rws", true);
        TestWrite.testDatabase("org.h2.Driver", "jdbc:h2:./test", "sa", "");
        TestWrite.testDatabase("org.hsqldb.jdbcDriver", "jdbc:hsqldb:test4", "sa", "");
        TestWrite.testDatabase("org.apache.derby.iapi.jdbc.AutoloadedDriver", "jdbc:derby:test;create=true", "sa", "");
        TestWrite.testDatabase("com.mysql.cj.jdbc.Driver", "jdbc:mysql://localhost/test", "sa", "sa");
        TestWrite.testDatabase("org.postgresql.Driver", "jdbc:postgresql:test", "sa", "sa");
    }

    private static void testFile(String mode, boolean flush) throws Exception {
        long time;
        System.out.println("Testing RandomAccessFile(.., \"" + mode + "\")...");
        if (flush) {
            System.out.println("  with FileDescriptor.sync()");
        }
        RandomAccessFile file = new RandomAccessFile("test.txt", mode);
        file.setLength(0L);
        FileDescriptor fd = file.getFD();
        long start = System.nanoTime();
        byte[] data = new byte[1];
        file.write(data);
        int i = 0;
        if (flush) {
            while (true) {
                file.seek(0L);
                file.write(data);
                fd.sync();
                if ((i & 0xF) != 0 || (time = System.nanoTime() - start) <= TimeUnit.SECONDS.toNanos(5L)) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                file.seek(0L);
                file.write(data);
                if ((i & 0x3FF) == 0 && (time = System.nanoTime() - start) > TimeUnit.SECONDS.toNanos(5L)) break;
                ++i;
            }
        }
        time = System.nanoTime() - start;
        System.out.println("Time: " + TimeUnit.NANOSECONDS.toMillis(time));
        System.out.println("Operations: " + i);
        System.out.println("Operations/second: " + (long)i * TimeUnit.SECONDS.toNanos(1L) / time);
        System.out.println();
        file.close();
        new File("test.txt").delete();
    }

    private static void testDatabase(String driver, String url, String user, String password) throws Exception {
        long time;
        Class.forName(driver);
        Connection conn = DriverManager.getConnection(url, user, password);
        System.out.println("Testing Database, URL=" + url);
        Statement stat = conn.createStatement();
        try {
            stat.execute("DROP TABLE TEST");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stat.execute("CREATE TABLE TEST(ID INT)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?)");
        long start = System.nanoTime();
        int i = 0;
        while (true) {
            prep.setInt(1, i);
            prep.execute();
            if ((i & 0xF) == 0 && (time = System.nanoTime() - start) > TimeUnit.SECONDS.toNanos(5L)) break;
            ++i;
        }
        time = System.nanoTime() - start;
        System.out.println("Time: " + TimeUnit.NANOSECONDS.toMillis(time));
        System.out.println("Operations: " + i);
        System.out.println("Operations/second: " + (long)i * TimeUnit.SECONDS.toNanos(1L) / time);
        System.out.println();
        stat.execute("DROP TABLE TEST");
        conn.close();
    }
}

