/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.rowlock;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Task;

public class TestRowLocks
extends TestDb {
    Statement s1;
    Statement s2;
    private Connection c1;
    private Connection c2;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testCases();
        this.deleteDb(this.getTestName());
    }

    private void testCases() throws Exception {
        this.deleteDb(this.getTestName());
        this.c1 = this.getConnection(this.getTestName());
        this.s1 = this.c1.createStatement();
        this.s1.execute("SET LOCK_TIMEOUT 10000");
        this.s1.execute("CREATE TABLE TEST AS SELECT X ID, 'Hello' NAME FROM SYSTEM_RANGE(1, 3)");
        this.c1.commit();
        this.c1.setAutoCommit(false);
        this.s1.execute("UPDATE TEST SET NAME='Hallo' WHERE ID=1");
        this.c2 = this.getConnection(this.getTestName());
        this.c2.setAutoCommit(false);
        this.s2 = this.c2.createStatement();
        this.assertEquals("Hallo", TestRowLocks.getSingleValue(this.s1, "SELECT NAME FROM TEST WHERE ID=1"));
        this.assertEquals("Hello", TestRowLocks.getSingleValue(this.s2, "SELECT NAME FROM TEST WHERE ID=1"));
        this.s2.execute("UPDATE TEST SET NAME='Hallo' WHERE ID=2");
        this.assertThrows(50200, this.s2).executeUpdate("UPDATE TEST SET NAME='Hi' WHERE ID=1");
        this.c1.commit();
        this.c2.commit();
        this.assertEquals("Hallo", TestRowLocks.getSingleValue(this.s1, "SELECT NAME FROM TEST WHERE ID=1"));
        this.assertEquals("Hallo", TestRowLocks.getSingleValue(this.s2, "SELECT NAME FROM TEST WHERE ID=1"));
        this.s2.execute("UPDATE TEST SET NAME='H1' WHERE ID=1");
        Task task = new Task(){

            @Override
            public void call() throws SQLException {
                TestRowLocks.this.s1.execute("UPDATE TEST SET NAME='H2' WHERE ID=1");
            }
        };
        task.execute();
        Thread.sleep(100L);
        this.c2.commit();
        task.get();
        this.c1.commit();
        this.assertEquals("H2", TestRowLocks.getSingleValue(this.s1, "SELECT NAME FROM TEST WHERE ID=1"));
        this.assertEquals("H2", TestRowLocks.getSingleValue(this.s2, "SELECT NAME FROM TEST WHERE ID=1"));
        this.c1.close();
        this.c2.close();
    }

    private static String getSingleValue(Statement stat, String sql) throws SQLException {
        ResultSet rs = stat.executeQuery(sql);
        return rs.next() ? rs.getString(1) : null;
    }
}

