/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.server;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestInit
extends TestDb {
    public static void main(String[] a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        String init1 = this.getBaseDir() + "/test-init-1.sql";
        String init2 = this.getBaseDir() + "/test-init-2.sql";
        FileUtils.createDirectories(FileUtils.getParent(init1));
        OutputStreamWriter w = new OutputStreamWriter(FileUtils.newOutputStream(init1, false));
        PrintWriter writer = new PrintWriter(w);
        writer.println("create table test(id int generated by default as identity, name varchar);");
        writer.println("insert into test(name) values('cat');");
        writer.close();
        w = new OutputStreamWriter(FileUtils.newOutputStream(init2, false));
        writer = new PrintWriter(w);
        writer.println("insert into test(name) values('dog');");
        writer.close();
        this.deleteDb("initDb");
        Connection conn = this.getConnection("initDb;INIT=RUNSCRIPT FROM '" + init1 + "'\\;RUNSCRIPT FROM '" + init2 + "'");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select name from test order by name");
        this.assertTrue(rs.next());
        this.assertEquals("cat", rs.getString(1));
        this.assertTrue(rs.next());
        this.assertEquals("dog", rs.getString(1));
        this.assertFalse(rs.next());
        conn.close();
        this.deleteDb("initDb");
        FileUtils.delete(init1);
        FileUtils.delete(init2);
    }
}

