/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2.security.AES;

public class CalculateHashConstant
implements Runnable {
    private static BitSet primeNumbers = new BitSet();
    private static int[] randomValues;
    private static AtomicInteger high;
    private static Set<Integer> candidates;
    private int constant;
    private int[] fromTo = new int[1024];
    private final AES aes = new AES();
    private final byte[] data;

    static {
        high = new AtomicInteger(32);
        candidates = Collections.synchronizedSet(new HashSet());
    }

    public CalculateHashConstant() {
        this.aes.setKey("Hello Welt Hallo Welt".getBytes());
        this.data = new byte[16];
    }

    public static void main(String ... args) throws Exception {
        int i = 0;
        while (i < 65536) {
            if (BigInteger.valueOf(i).isProbablePrime(20)) {
                primeNumbers.set(i);
            }
            ++i;
        }
        randomValues = CalculateHashConstant.getRandomValues(1000, 1);
        Random r = new Random(1L);
        int i2 = 0;
        while (i2 < randomValues.length) {
            CalculateHashConstant.randomValues[i2] = r.nextInt();
            ++i2;
        }
        Thread[] threads = new Thread[8];
        int i3 = 0;
        while (i3 < 8) {
            threads[i3] = new Thread(new CalculateHashConstant());
            threads[i3].start();
            ++i3;
        }
        i3 = 0;
        while (i3 < 8) {
            threads[i3].join();
            ++i3;
        }
        int finalCount = 10000;
        int[] randomValues = CalculateHashConstant.getRandomValues(finalCount, 10);
        System.out.println();
        System.out.println("AES:");
        CalculateHashConstant test = new CalculateHashConstant();
        int av = 0;
        test = new CalculateHashConstant(){

            @Override
            public int hash(int x) {
                return this.secureHash(x);
            }
        };
        int[] minMax = test.getDependencies(test, randomValues);
        System.out.println("Dependencies: " + minMax[0] + ".." + minMax[1]);
        av = 0;
        int j = 0;
        while (j < 100) {
            av += test.getAvalanche(test, randomValues[j]);
            ++j;
        }
        System.out.println("AvalancheSum: " + av);
        minMax = test.getEffect(test, finalCount * 10, 11);
        System.out.println("Effect: " + minMax[0] + ".." + minMax[1]);
        test = new CalculateHashConstant();
        int best = 0;
        int dist = Integer.MAX_VALUE;
        int[] nArray = new int[]{17519491, 17524211, 18288011, 18409851, 18419083, 18527101, 18638323, 19039063, 19048503, 19048711, 19604727, 19680517, 20031751, 20033443, 20035203, 20091517, 20093179, 20228151, 20355323, 20361123, 20503051, 20510051, 20535237, 21433115, 21555579, 21714983, 22063159, 22137213, 22146365, 22173447, 22235911, 22481819, 22598275, 22623211, 22628299, 22765363, 23517821, 23786659, 23792455, 23898375, 24044933, 24512931, 24578851, 24782087, 25514883, 25908099, 26058555, 26063741, 26354951, 26611005, 26807631, 26811003, 26954503, 26956675, 27107131, 27440771, 27528587, 27570317, 27695355, 27709339, 27727037, 27824771, 27952835, 28397067, 28415739, 28439229, 28511003, 28517639, 28594037, 28642531, 28676733, 28749731, 28878583, 29010183, 29041927, 29533943, 29655895, 29972421, 30114647, 30166277, 30249603, 30287491, 30513403, 30692227, 30731581, 30775547, 30986883, 31022907, 31139063, 31150979, 31168893, 31745523, 32610555, 32683651, 32811063, 34183419, 34518659, 34908423, 34942659, 35036987, 35056957, 35170039, 35212039, 35411719, 35739897, 35982671, 35988743, 36273507, 36367677, 36393859, 36480983, 37066491, 37106667, 37312453, 37430519, 38235771, 38426565, 38491011, 38988727, 39122247, 39375491, 39409415, 39409605, 39606023, 40020023, 40076119, 40130599, 40235709, 40301245, 40412919, 40504099, 40685179, 41093959, 41224995, 41268867, 42231283, 42274127, 42797895, 43108733, 43132167, 43260539, 43297031, 43300483, 43381437, 43425595, 43438005, 43478651, 43556667, 43594731, 2730247, 43722371, 43811671, 43884347, 44148999, 44323715, 44380021, 44585859, 44748699, 44850995, 44898939, 44901639, 45266563, 45330315, 45497957, 45668875, 45695339, 45819127, 46445437, 46583707, 46796051, 46867719, 46868867, 46983547, 47067227, 47101571, 47271435, 2955899, 2958599, 47361931, 47454843, 47662715, 47764099, 47800507, 47888003, 47931187, 48062267, 48425911, 48443013, 48670665, 48780163, 48817541, 48849083, 49524643, 49688485, 51283513, 51587459, 51711311, 51761051, 51785637, 51826299, 51975357, 52073085, 52340795, 52370043, 52974467, 52993851, 53031915, 53063587, 53106439, 3319543, 53142917, 53156475, 53168903, 53171075, 53172263, 53406075, 53526107, 53562891, 53680037, 53718923, 53850019, 53851005, 53942907, 54083173, 54110471, 54336123, 54679303, 54920915, 55030653, 55128155, 55256707, 3454595, 55422883, 55495037, 55649923, 55661443, 55662343, 55764357, 55816053, 55883395, 55962941, 55979941, 56029885, 56049973, 56209315, 56283779, 56305283, 56467259, 56749373, 57088635, 57094053, 57458267, 58038523, 58050941, 58501383, 59353351, 59532787, 59569479, 59651051, 59972219, 60135675, 60265091, 60345979, 60371947, 60383419, 60496519, 60514099, 60588851, 60630279, 61167655, 61382459, 61469373, 61548931, 61581271, 61714339, 61970171, 62037819, 62074501, 62187899, 62465547, 62608259, 63219975, 63228285, 63360923, 63526663, 63592389, 63613191, 63645315, 63646083, 63844443, 64051449, 64053093, 64145029, 64178951, 64450171, 64541315, 64550243, 64677253, 64839867, 65390973, 65742467, 65750651, 66425469, 66426619, 68478341, 69514109, 69578659, 70144899, 70344549, 70407943, 70563459, 71848835, 71887227, 71931643, 72040037, 72265635, 72439559, 72558979, 72564325, 72607109, 72660611, 72673659, 72718587, 72722695, 72807101, 72965947, 73244475, 73509127, 73574455, 73685031, 74067877, 74097171, 74108827, 74130695, 74164279, 74536711, 74642759, 74828157, 75076227, 75107645, 75278599, 75671815, 75716359, 75778823, 76100587, 76199555, 76240935, 76665063, 76686599, 76717883, 76736891, 4797419, 76761863, 76912891, 76935869, 76951461, 76985987, 77191805, 77196605, 77248131, 77788487, 77803141, 77984445, 78026491, 78303131, 78336899, 78358583, 78558851, 78568061, 78706331, 78720933, 78724709, 79014151, 79015843, 79212451, 79226245, 79230349, 79320839, 79451911, 79865911, 80065405, 80080189, 80117133, 80278925, 80294891, 80407645, 80549797, 80621659, 80680859, 80726393, 80789083, 80866621, 5055751, 80940427, 80947587, 81005285, 81005963, 81065623, 81324411, 81392317, 81399101, 81585541, 81599099, 81741435, 81942279, 82102653, 82196531, 82516603, 82519683, 5158531, 82635131, 82765189, 82919013, 83275683, 84194173, 84813443, 84850307, 85143173, 85241997, 85387643, 5347579, 85586621, 85635965, 85665411, 86157367, 86190467, 86271475, 86401211, 86553581, 86589843, 86593035, 86661061, 86945675, 86956669, 86959493, 87080595, 87117323, 87222651, 87296795, 87369629, 87398651, 88248963, 88738595, 88810743, 88938405, 89044611, 89233659, 89276005, 89348037, 89384325, 89509787, 89793783, 89990407, 90102397, 90464051, 90696925, 90836285, 91304027, 91311627, 91531319, 91903751, 91973107, 92038643, 92770947, 93038647, 93187389, 93690107, 93888315, 93890619, 93935557, 93975229, 94098299, 94152967, 94215995, 94265531, 94679933, 94781747, 94818203, 94936891, 5935741, 94978405, 94978451, 94984441, 94986427, 95077331, 95262971, 95328507, 95525115, 95611259, 95685469, 95799677, 95903539, 95989667, 96030219, 96085239, 97171075, 97192775, 97193189, 97232855, 97566355, 97592963, 97651911, 97772933, 98740487, 98780795, 98945405, 99131195, 99296899, 99981563, 99985671, 6778491, 6903557, 7022979, 9017595, 9090691, 9742391, 9827005, 10033787, 10049285, 10949821, 11078243, 11088875, 11376891, 11757043, 11839751, 11901179, 11913597, 11922749, 11966715, 12396445, 12931971, 13087613, 13163019, 13241123, 13276923, 13291419, 13313667, 13441659, 13915011, 13952389, 14069667, 14241291, 14349639, 14359163, 14461191, 14495365, 15129213, 15289867, 15313159, 15509463, 16033847};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i4;
            test.constant = i4 = nArray[n2];
            System.out.println();
            System.out.println("Constant: 0x" + Integer.toHexString(i4));
            minMax = test.getDependencies(test, randomValues);
            System.out.println("Dependencies: " + minMax[0] + ".." + minMax[1]);
            int d = minMax[1] - minMax[0];
            av = 0;
            int j2 = 0;
            while (j2 < 100) {
                av += test.getAvalanche(test, randomValues[j2]);
                ++j2;
            }
            System.out.println("AvalancheSum: " + av);
            minMax = test.getEffect(test, finalCount * 10, 11);
            System.out.println("Effect: " + minMax[0] + ".." + minMax[1]);
            if ((d += minMax[1] - minMax[0]) < dist) {
                dist = d;
                best = i4;
            }
            ++n2;
        }
        System.out.println();
        System.out.println("Best constant: 0x" + Integer.toHexString(best));
        test.constant = best;
        long collisions = test.getCollisionCount();
        System.out.println("Collisions: " + collisions);
    }

    static long calcMultiplicativeInverse(long a) {
        return BigInteger.valueOf(a).modPow(BigInteger.valueOf(Integer.MAX_VALUE), BigInteger.valueOf(0x100000000L)).longValue();
    }

    static long calcMultiplicativeInverseLong(long a) {
        BigInteger oneShift64 = BigInteger.valueOf(1L).shiftLeft(64);
        BigInteger oneShift63 = BigInteger.valueOf(1L).shiftLeft(63);
        return BigInteger.valueOf(a).modPow(oneShift63.subtract(BigInteger.ONE), oneShift64).longValue();
    }

    void storeRandomFile() throws Exception {
        File f = new File(System.getProperty("user.home") + "/temp/rand.txt");
        FileOutputStream out = new FileOutputStream(f);
        CalculateHashConstant test = new CalculateHashConstant();
        byte[] buff = new byte[4];
        int i = 0;
        while (i < 1250000) {
            int y = test.hash(i);
            CalculateHashConstant.writeInt(buff, 0, y);
            out.write(buff);
            ++i;
        }
        out.close();
    }

    private static int[] getRandomValues(int count, int seed) {
        int[] values = new int[count];
        Random r = new Random(seed);
        int i = 0;
        while (i < count) {
            values[i] = r.nextInt();
            ++i;
        }
        return values;
    }

    @Override
    public void run() {
        int currentHigh;
        while ((currentHigh = high.getAndIncrement()) <= 65535) {
            System.out.println("testing " + Integer.toHexString(currentHigh) + "....");
            this.addCandidates(currentHigh);
        }
    }

    private void addCandidates(int currentHigh) {
        int low = 0;
        while (low <= 65535) {
            if (primeNumbers.get(low)) {
                int[] minMax;
                long es;
                int i;
                this.constant = i = currentHigh << 16 | low;
                int av = this.getAvalanche(this, 0);
                if (Math.abs(av - 16000) <= 130 && Math.abs((av = this.getAvalanche(this, -1)) - 16000) <= 130 && (es = this.getEffectSquare(this, randomValues)) <= 259000L && CalculateHashConstant.isWithin(4800, 5200, minMax = this.getEffect(this, 10000, 1)) && CalculateHashConstant.isWithin(7720, 8240, minMax = this.getDependencies(this, randomValues)) && CalculateHashConstant.isWithin(49000, 51000, minMax = this.getEffect(this, 100000, 3))) {
                    System.out.println(Integer.toHexString(i) + " hit av:" + av + " bits:" + Integer.bitCount(i) + " es:" + es + " prime:" + BigInteger.valueOf(i).isProbablePrime(15));
                    candidates.add(i);
                }
            }
            ++low;
        }
    }

    long getCollisionCount() {
        BitSet set = new BitSet();
        BitSet neg = new BitSet();
        long collisions = 0L;
        long t = System.nanoTime();
        int i = Integer.MIN_VALUE;
        while (i != Integer.MAX_VALUE) {
            long n;
            int x = this.hash(i);
            if (x >= 0) {
                if (set.get(x)) {
                    ++collisions;
                } else {
                    set.set(x);
                }
            } else if (neg.get(x = -(x + 1))) {
                ++collisions;
            } else {
                neg.set(x);
            }
            if ((i & 0xFFFFF) == 0 && (n = System.nanoTime()) - t > TimeUnit.SECONDS.toNanos(5L)) {
                System.out.println(Integer.toHexString(this.constant) + " " + Integer.toHexString(i) + " collisions: " + collisions);
                t = n;
            }
            ++i;
        }
        return collisions;
    }

    private static boolean isWithin(int min, int max, int[] range) {
        return range[0] >= min && range[1] <= max;
    }

    int[] getDependencies(CalculateHashConstant h, int[] values) {
        Arrays.fill(this.fromTo, 0);
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int x = nArray[n2];
            int shift = 0;
            while (shift < 32) {
                int x1 = h.hash(x);
                int x2 = h.hash(x ^ 1 << shift);
                int x3 = x1 ^ x2;
                int s = 0;
                while (s < 32) {
                    if ((x3 & 1 << s) != 0) {
                        int s2 = 0;
                        while (s2 < 32) {
                            if (s != s2 && (x3 & 1 << s2) != 0) {
                                int n3 = s * 32 + s2;
                                this.fromTo[n3] = this.fromTo[n3] + 1;
                            }
                            ++s2;
                        }
                    }
                    ++s;
                }
                ++shift;
            }
            ++n2;
        }
        int a = Integer.MAX_VALUE;
        int b = Integer.MIN_VALUE;
        int[] nArray2 = this.fromTo;
        int n4 = this.fromTo.length;
        int n5 = 0;
        while (n5 < n4) {
            int x = nArray2[n5];
            if (x != 0) {
                if (x < a) {
                    a = x;
                }
                if (x > b) {
                    b = x;
                }
            }
            ++n5;
        }
        return new int[]{a, b};
    }

    int getAvalanche(CalculateHashConstant h, int value) {
        int changedBitsSum = 0;
        int i = 0;
        while (i < 32) {
            int x = value ^ 1 << i;
            int shift = 0;
            while (shift < 32) {
                int x1 = h.hash(x);
                int x2 = h.hash(x ^ 1 << shift);
                int x3 = x1 ^ x2;
                changedBitsSum += Integer.bitCount(x3);
                ++shift;
            }
            ++i;
        }
        return changedBitsSum * 1000 / 32 / 32;
    }

    long getEffectSquare(CalculateHashConstant h, int[] values) {
        Arrays.fill(this.fromTo, 0);
        int total = 0;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int x = nArray[n2];
            int shift = 0;
            while (shift < 32) {
                int x1 = h.hash(x);
                int x2 = h.hash(x ^ 1 << shift);
                int x3 = x1 ^ x2;
                int s = 0;
                while (s < 32) {
                    if ((x3 & 1 << s) != 0) {
                        int n3 = shift * 32 + s;
                        this.fromTo[n3] = this.fromTo[n3] + 1;
                        ++total;
                    }
                    ++s;
                }
                ++shift;
            }
            ++n2;
        }
        long sqDist = 0L;
        int expected = total / 32 / 32;
        int[] nArray2 = this.fromTo;
        int n4 = this.fromTo.length;
        int n5 = 0;
        while (n5 < n4) {
            int x = nArray2[n5];
            int dist = Math.abs(x - expected);
            sqDist += (long)(dist * dist);
            ++n5;
        }
        return sqDist;
    }

    int[] getEffect(CalculateHashConstant h, int count, int seed) {
        Random r = new Random();
        r.setSeed(seed);
        Arrays.fill(this.fromTo, 0);
        int i = 0;
        while (i < count) {
            int x = r.nextInt();
            int shift = 0;
            while (shift < 32) {
                int x1 = h.hash(x);
                int x2 = h.hash(x ^ 1 << shift);
                int x3 = x1 ^ x2;
                int s = 0;
                while (s < 32) {
                    if ((x3 & 1 << s) != 0) {
                        int n = shift * 32 + s;
                        this.fromTo[n] = this.fromTo[n] + 1;
                    }
                    ++s;
                }
                ++shift;
            }
            ++i;
        }
        int a = Integer.MAX_VALUE;
        int b = Integer.MIN_VALUE;
        int[] nArray = this.fromTo;
        int n = this.fromTo.length;
        int n2 = 0;
        while (n2 < n) {
            int x = nArray[n2];
            if (x < a) {
                a = x;
            }
            if (x > b) {
                b = x;
            }
            ++n2;
        }
        return new int[]{a, b};
    }

    int hash(int x) {
        x = (x >>> 16 ^ x) * this.constant;
        x = (x >>> 16 ^ x) * this.constant;
        x = x >>> 16 ^ x;
        return x;
    }

    int secureHash(int x) {
        Arrays.fill(this.data, (byte)0);
        CalculateHashConstant.writeInt(this.data, 0, x);
        this.aes.encrypt(this.data, 0, 16);
        return CalculateHashConstant.readInt(this.data, 0);
    }

    private static void writeInt(byte[] buff, int pos, int x) {
        buff[pos++] = (byte)(x >> 24);
        buff[pos++] = (byte)(x >> 16);
        buff[pos++] = (byte)(x >> 8);
        buff[pos++] = (byte)x;
    }

    private static int readInt(byte[] buff, int pos) {
        return (buff[pos++] << 24) + ((buff[pos++] & 0xFF) << 16) + ((buff[pos++] & 0xFF) << 8) + (buff[pos] & 0xFF);
    }
}

