/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.util.TreeSet;
import org.h2.mvstore.DataUtils;
import org.h2.util.MathUtils;

public class FreeSpaceTree {
    private final int firstFreeBlock;
    private final int blockSize;
    private TreeSet<BlockRange> freeSpace = new TreeSet();

    public FreeSpaceTree(int firstFreeBlock, int blockSize) {
        this.firstFreeBlock = firstFreeBlock;
        if (Integer.bitCount(blockSize) != 1) {
            throw DataUtils.newIllegalArgumentException("Block size is not a power of 2", new Object[0]);
        }
        this.blockSize = blockSize;
        this.clear();
    }

    public synchronized void clear() {
        this.freeSpace.clear();
        this.freeSpace.add(new BlockRange(this.firstFreeBlock, Integer.MAX_VALUE - this.firstFreeBlock));
    }

    public synchronized long allocate(int length) {
        int blocks = this.getBlockCount(length);
        BlockRange x = null;
        for (BlockRange b : this.freeSpace) {
            if (b.blocks < blocks) continue;
            x = b;
            break;
        }
        long pos = this.getPos(x.start);
        if (x.blocks == blocks) {
            this.freeSpace.remove(x);
        } else {
            x.start += blocks;
            x.blocks -= blocks;
        }
        return pos;
    }

    public synchronized void markUsed(long pos, int length) {
        int blocks;
        int start = this.getBlock(pos);
        BlockRange x = new BlockRange(start, blocks = this.getBlockCount(length));
        BlockRange prev = this.freeSpace.floor(x);
        if (prev == null) {
            throw DataUtils.newMVStoreException(3, "Free space already marked", new Object[0]);
        }
        if (prev.start == start) {
            if (prev.blocks == blocks) {
                this.freeSpace.remove(prev);
            } else {
                prev.start += blocks;
                prev.blocks -= blocks;
            }
        } else if (prev.start + prev.blocks == start + blocks) {
            prev.blocks -= blocks;
        } else {
            x.start = start + blocks;
            x.blocks = prev.start + prev.blocks - x.start;
            this.freeSpace.add(x);
            prev.blocks = start - prev.start;
        }
    }

    public synchronized void free(long pos, int length) {
        int blocks;
        int start = this.getBlock(pos);
        BlockRange x = new BlockRange(start, blocks = this.getBlockCount(length));
        BlockRange next = this.freeSpace.ceiling(x);
        if (next == null) {
            throw DataUtils.newMVStoreException(3, "Free space sentinel is missing", new Object[0]);
        }
        BlockRange prev = this.freeSpace.lower(x);
        if (prev != null && prev.start + prev.blocks == start) {
            prev.blocks += blocks;
            if (prev.start + prev.blocks == next.start) {
                prev.blocks += next.blocks;
                this.freeSpace.remove(next);
            }
            return;
        }
        if (start + blocks == next.start) {
            next.start -= blocks;
            next.blocks += blocks;
            return;
        }
        this.freeSpace.add(x);
    }

    private long getPos(int block) {
        return (long)block * (long)this.blockSize;
    }

    private int getBlock(long pos) {
        return (int)(pos / (long)this.blockSize);
    }

    private int getBlockCount(int length) {
        if (length <= 0) {
            throw DataUtils.newMVStoreException(3, "Free space invalid length", new Object[0]);
        }
        return MathUtils.roundUpInt(length, this.blockSize) / this.blockSize;
    }

    public String toString() {
        return this.freeSpace.toString();
    }

    private static final class BlockRange
    implements Comparable<BlockRange> {
        public int start;
        public int blocks;

        public BlockRange(int start, int blocks) {
            this.start = start;
            this.blocks = blocks;
        }

        @Override
        public int compareTo(BlockRange o) {
            return Integer.compare(this.start, o.start);
        }

        public String toString() {
            if (this.blocks + this.start == Integer.MAX_VALUE) {
                return Integer.toHexString(this.start) + "-";
            }
            return Integer.toHexString(this.start) + "-" + Integer.toHexString(this.start + this.blocks - 1);
        }
    }
}

