/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.nio.ByteBuffer;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.DataType;

public class RowDataType
extends BasicDataType<Object[]> {
    private final DataType<Object>[] types;

    RowDataType(DataType[] types) {
        this.types = types;
    }

    public Object[][] createStorage(int size) {
        return new Object[size][];
    }

    @Override
    public int compare(Object[] ax, Object[] bx) {
        if (ax == bx) {
            return 0;
        }
        int al = ax.length;
        int bl = bx.length;
        int len = Math.min(al, bl);
        int i = 0;
        while (i < len) {
            int comp = this.types[i].compare(ax[i], bx[i]);
            if (comp != 0) {
                return comp;
            }
            ++i;
        }
        if (len < al) {
            return -1;
        }
        if (len < bl) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getMemory(Object[] x) {
        int len = x.length;
        int memory = 0;
        int i = 0;
        while (i < len) {
            memory += this.types[i].getMemory(x[i]);
            ++i;
        }
        return memory;
    }

    @Override
    public Object[] read(ByteBuffer buff) {
        int len = DataUtils.readVarInt(buff);
        Object[] x = new Object[len];
        int i = 0;
        while (i < len) {
            x[i] = this.types[i].read(buff);
            ++i;
        }
        return x;
    }

    @Override
    public void write(WriteBuffer buff, Object[] x) {
        int len = x.length;
        buff.putVarInt(len);
        int i = 0;
        while (i < len) {
            this.types[i].write(buff, x[i]);
            ++i;
        }
    }
}

