/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.store.FileLister;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Task;

public class TestBenchmark
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testConcurrency();
        this.test(true);
        this.test(false);
        this.test(true);
        this.test(false);
        this.test(true);
        this.test(false);
    }

    private void testConcurrency() throws Exception {
        String fileName = "nioMemFS:/" + this.getTestName();
        FileUtils.delete(fileName);
        MVStore store = new MVStore.Builder().cacheSize(16).fileName(fileName).open();
        MVMap<Integer, byte[]> map = store.openMap("test");
        byte[] data = new byte[1024];
        int count = 1000000;
        int i = 0;
        while (i < count) {
            map.put(i, data);
            ++i;
        }
        store.close();
        int concurrency = 1024;
        while (concurrency > 0) {
            this.testConcurrency(fileName, concurrency, count);
            this.testConcurrency(fileName, concurrency, count);
            this.testConcurrency(fileName, concurrency, count);
            concurrency /= 2;
        }
        FileUtils.delete(fileName);
    }

    private void testConcurrency(String fileName, int concurrency, final int count) throws Exception {
        Thread.sleep(1000L);
        final MVStore store = new MVStore.Builder().cacheSize(256).cacheConcurrency(concurrency).fileName(fileName).open();
        int threadCount = 128;
        final CountDownLatch wait = new CountDownLatch(1);
        final AtomicInteger counter = new AtomicInteger();
        final AtomicBoolean stopped = new AtomicBoolean();
        Task[] tasks = new Task[threadCount];
        int i = 0;
        while (i < threadCount) {
            final int x = i;
            Task t = new Task(){

                @Override
                public void call() throws Exception {
                    MVMap map = store.openMap("test");
                    Random random = new Random(x);
                    wait.await();
                    while (!stopped.get()) {
                        int key = random.nextInt(count);
                        byte[] data = (byte[])map.get(key);
                        if (data.length <= 1) continue;
                        counter.incrementAndGet();
                    }
                }
            };
            t.execute("t" + i);
            tasks[i] = t;
            ++i;
        }
        wait.countDown();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        stopped.set(true);
        Task[] taskArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            Task t = taskArray[n2];
            t.get();
            ++n2;
        }
        String msg = "concurrency " + concurrency + " threads " + threadCount + " requests: " + String.valueOf(counter);
        System.out.println(msg);
        this.trace(msg);
        store.close();
    }

    private void test(boolean mvStore) throws Exception {
        this.testCreateIndex(mvStore);
    }

    private void testCreateIndex(boolean mvStore) throws Exception {
        FileUtils.deleteRecursive(this.getBaseDir(), true);
        Object url = "mvstore";
        if (mvStore) {
            url = (String)url + ";MV_STORE=TRUE";
        }
        url = this.getURL((String)url, true);
        Connection conn = this.getConnection((String)url);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id bigint primary key, data bigint)");
        conn.setAutoCommit(false);
        PreparedStatement prep = conn.prepareStatement("insert into test values(?, ?)");
        int rowCount = 1000000;
        Random r = new Random(1L);
        int i = 0;
        while (i < rowCount) {
            prep.setInt(1, i);
            prep.setInt(2, r.nextInt());
            prep.execute();
            if (i % 10000 == 0) {
                conn.commit();
            }
            ++i;
        }
        long start = System.nanoTime();
        stat.execute("create index on test(data)");
        System.out.println(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " " + (mvStore ? "mvstore" : "default"));
        conn.createStatement().execute("shutdown compact");
        conn.close();
        for (String f : FileLister.getDatabaseFiles(this.getBaseDir(), "mvstore", true)) {
            System.out.println("   " + f + " " + FileUtils.size(f));
        }
    }

    private void testBinary(boolean mvStore) throws Exception {
        FileUtils.deleteRecursive(this.getBaseDir(), true);
        Object url = "mvstore";
        if (mvStore) {
            url = (String)url + ";MV_STORE=TRUE";
        }
        url = this.getURL((String)url, true);
        Connection conn = this.getConnection((String)url);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id bigint primary key, data blob)");
        conn.setAutoCommit(false);
        PreparedStatement prep = conn.prepareStatement("insert into test values(?, ?)");
        byte[] data = new byte[0x100000];
        int rowCount = 100;
        int readCount = 20 * rowCount;
        long start = System.nanoTime();
        int i = 0;
        while (i < rowCount) {
            prep.setInt(1, i);
            TestBenchmark.randomize(data, i);
            prep.setBytes(2, data);
            prep.execute();
            if (i % 100 == 0) {
                conn.commit();
            }
            ++i;
        }
        prep = conn.prepareStatement("select * from test where id = ?");
        i = 0;
        while (i < readCount) {
            prep.setInt(1, i % rowCount);
            prep.executeQuery();
            ++i;
        }
        System.out.println(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " " + (mvStore ? "mvstore" : "default"));
        conn.close();
    }

    private static void randomize(byte[] data, int i) {
        Random r = new Random(i);
        r.nextBytes(data);
    }

    private void testInsertSelect(boolean mvStore) throws Exception {
        FileUtils.deleteRecursive(this.getBaseDir(), true);
        Object url = "mvstore";
        if (mvStore) {
            url = (String)url + ";MV_STORE=TRUE;LOG=0;COMPRESS=TRUE";
        }
        url = this.getURL((String)url, true);
        Connection conn = this.getConnection((String)url);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id bigint primary key, name varchar)");
        conn.setAutoCommit(false);
        PreparedStatement prep = conn.prepareStatement("insert into test values(?, ?)");
        String data = "Hello World";
        int rowCount = 100000;
        int readCount = 20 * rowCount;
        int i = 0;
        while (i < rowCount) {
            prep.setInt(1, i);
            prep.setString(2, data);
            prep.execute();
            if (i % 100 == 0) {
                conn.commit();
            }
            ++i;
        }
        long start = System.nanoTime();
        prep = conn.prepareStatement("select * from test where id = ?");
        int i2 = 0;
        while (i2 < readCount) {
            prep.setInt(1, i2 % rowCount);
            prep.executeQuery();
            ++i2;
        }
        System.out.println(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " " + (mvStore ? "mvstore" : "default"));
        conn.createStatement().execute("shutdown compact");
        conn.close();
        for (String f : FileLister.getDatabaseFiles(this.getBaseDir(), "mvstore", true)) {
            System.out.println("   " + f + " " + FileUtils.size(f));
        }
    }
}

