/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.test.TestBase;
import org.h2.util.Task;

public class TestCacheConcurrentLIRS
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testConcurrent();
    }

    private void testConcurrent() {
        int x;
        CacheLongKeyLIRS.Config cc = new CacheLongKeyLIRS.Config();
        cc.maxMemory = 100L;
        final CacheLongKeyLIRS<Integer> test = new CacheLongKeyLIRS<Integer>(cc);
        int threadCount = 8;
        final CountDownLatch wait = new CountDownLatch(1);
        final AtomicBoolean stopped = new AtomicBoolean();
        Task[] tasks = new Task[threadCount];
        final int[] getCounts = new int[threadCount];
        int offset = 1000000;
        int i = 0;
        while (i < 100) {
            test.put(1000000 + i, i);
            ++i;
        }
        final int[] keys = new int[1000];
        Random random = new Random(1L);
        int i2 = 0;
        while (i2 < keys.length) {
            int key;
            while ((key = (int)Math.abs(random.nextGaussian() * 50.0)) > 100) {
            }
            keys[i2] = key;
            ++i2;
        }
        i2 = 0;
        while (i2 < threadCount) {
            x = i2;
            Task t = new Task(){

                @Override
                public void call() throws Exception {
                    Random random = new Random(x);
                    wait.await();
                    int i = 0;
                    while (!stopped.get()) {
                        int key = keys[random.nextInt(keys.length)];
                        test.get(1000000 + key);
                        if ((i & 0x7F) == 0) {
                            test.put(1000000 + random.nextInt(100), random.nextInt());
                        }
                        ++i;
                    }
                    getCounts[x] = i;
                }
            };
            t.execute("t" + i2);
            tasks[i2] = t;
            ++i2;
        }
        wait.countDown();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        stopped.set(true);
        Task[] taskArray = tasks;
        int n = tasks.length;
        x = 0;
        while (x < n) {
            Task t = taskArray[x];
            t.get();
            ++x;
        }
        int totalCount = 0;
        int[] nArray = getCounts;
        int n2 = getCounts.length;
        n = 0;
        while (n < n2) {
            x = nArray[n];
            totalCount += x;
            ++n;
        }
        this.trace("requests: " + totalCount);
    }
}

