/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.test.TestBase;

public class TestCacheLongKeyLIRS
extends TestBase {
    private static final int MEMORY_OVERHEAD = CacheLongKeyLIRS.getMemoryOverhead();

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testCache();
    }

    private void testCache() {
        this.testRandomSmallCache();
        this.testEdgeCases();
        this.testSize();
        this.testClear();
        this.testGetPutPeekRemove();
        this.testPruneStack();
        this.testLimitHot();
        this.testLimitNonResident();
        this.testLimitMemory();
        this.testScanResistance();
        this.testRandomOperations();
    }

    private void testRandomSmallCache() {
        Random r = new Random(1L);
        int i = 0;
        while (i < 10000) {
            int j = 0;
            StringBuilder buff = new StringBuilder();
            int maxSize = 1 + r.nextInt(10);
            buff.append("size:").append(maxSize).append('\n');
            CacheLongKeyLIRS<Integer> test = TestCacheLongKeyLIRS.createCache(maxSize, maxSize);
            while (j < 30) {
                String lastState = TestCacheLongKeyLIRS.toString(test);
                try {
                    int key = r.nextInt(5);
                    switch (r.nextInt(3)) {
                        case 0: {
                            int memory = r.nextInt(5) + 1;
                            buff.append("add ").append(key).append(' ').append(memory).append('\n');
                            test.put(key, j, memory);
                            break;
                        }
                        case 1: {
                            buff.append("remove ").append(key).append('\n');
                            test.remove(key);
                            break;
                        }
                        case 2: {
                            buff.append("get ").append(key).append('\n');
                            test.get(key);
                        }
                    }
                    this.verify(test, 0, null);
                }
                catch (Throwable ex) {
                    this.println(i + "\n" + String.valueOf(buff) + "\n" + lastState + "\n" + TestCacheLongKeyLIRS.toString(test));
                    throw ex;
                }
                ++j;
            }
            ++i;
        }
    }

    private void testEdgeCases() {
        CacheLongKeyLIRS<Integer> test = TestCacheLongKeyLIRS.createCache(1, 1);
        test.put(1L, 10, 100L);
        this.assertEquals(0, test.size());
        this.assertThrows(IllegalArgumentException.class, () -> test.put(1L, null, 100L));
        this.assertThrows(IllegalArgumentException.class, () -> test.setMaxMemory(0L));
    }

    private void testSize() {
        this.verifyMapSize(7, 16);
        this.verifyMapSize(13, 32);
        this.verifyMapSize(25, 64);
        this.verifyMapSize(49, 128);
        this.verifyMapSize(97, 256);
        this.verifyMapSize(193, 512);
        this.verifyMapSize(385, 1024);
        this.verifyMapSize(769, 2048);
        CacheLongKeyLIRS<Integer> test = TestCacheLongKeyLIRS.createCache(16000, 1000);
        int j = 0;
        while (j < 2000) {
            test.put(j, j);
            ++j;
        }
        this.assertEquals(32, test.size() - test.sizeHot());
        this.assertEquals(1000, test.size());
        this.assertEquals(1000, test.sizeNonResident());
    }

    private void verifyMapSize(int elements, int expectedMapSize) {
        CacheLongKeyLIRS<Integer> test = TestCacheLongKeyLIRS.createCache((elements - 1) * 16, elements - 1);
        int i = 0;
        while (i < elements - 1) {
            test.put(i, i * 10);
            ++i;
        }
        this.assertTrue(test.sizeMapArray() + "<" + expectedMapSize, test.sizeMapArray() < expectedMapSize);
        test = TestCacheLongKeyLIRS.createCache(elements * 16, elements);
        i = 0;
        while (i < elements + 1) {
            test.put(i, i * 10);
            ++i;
        }
        this.assertEquals(expectedMapSize, test.sizeMapArray());
        test = TestCacheLongKeyLIRS.createCache(elements * 2 * 16, elements * 2);
        i = 0;
        while (i < elements * 2) {
            test.put(i, i * 10);
            ++i;
        }
        this.assertTrue(test.sizeMapArray() + ">" + expectedMapSize, test.sizeMapArray() > expectedMapSize);
    }

    private void testGetPutPeekRemove() {
        CacheLongKeyLIRS<Integer> test = TestCacheLongKeyLIRS.createCache(4, 4);
        test.put(1L, 10, 1L);
        test.put(2L, 20, 1L);
        test.put(3L, 30, 1L);
        this.assertNull(test.peek(4L));
        this.assertNull(test.get(4L));
        test.put(4L, 40, 1L);
        this.verify(test, 4, "stack: 4 3 2 1 cold: non-resident:");
        this.assertEquals(30, (int)((Integer)test.get(3L)));
        this.assertEquals(20, (int)((Integer)test.get(2L)));
        this.assertEquals(20, (int)((Integer)test.peek(2L)));
        this.assertEquals(20, (int)((Integer)test.get(2L)));
        this.assertEquals(10, (int)((Integer)test.peek(1L)));
        this.assertEquals(10, (int)((Integer)test.get(1L)));
        this.verify(test, 4, "stack: 1 2 3 4 cold: non-resident:");
        test.put(3L, 30, 1L);
        this.verify(test, 4, "stack: 3 1 2 4 cold: non-resident:");
        test.put(5L, 50, 1L);
        this.verify(test, 4, "stack: 5 3 1 2 cold: 5 non-resident: 4");
        this.assertEquals((long)(1 + MEMORY_OVERHEAD), test.getMemory(1L));
        this.assertEquals((long)(1 + MEMORY_OVERHEAD), test.getMemory(5L));
        this.assertEquals(0L, test.getMemory(4L));
        this.assertEquals(0L, test.getMemory(100L));
        this.assertNotNull(test.peek(4L));
        this.assertNotNull(test.get(4L));
        this.assertEquals(10, (int)((Integer)test.get(1L)));
        this.assertEquals(20, (int)((Integer)test.get(2L)));
        this.assertEquals(30, (int)((Integer)test.get(3L)));
        this.verify(test, 5, "stack: 3 2 1 cold: 4 5 non-resident:");
        this.assertEquals(50, (int)((Integer)test.get(5L)));
        this.verify(test, 5, "stack: 5 3 2 1 cold: 5 4 non-resident:");
        this.assertEquals(50, (int)((Integer)test.get(5L)));
        this.verify(test, 5, "stack: 5 3 2 cold: 1 4 non-resident:");
        this.assertEquals(50, (int)((Integer)test.remove(5L)));
        this.assertNull(test.remove(5L));
        this.verify(test, 4, "stack: 3 2 1 cold: 4 non-resident:");
        this.assertNotNull(test.remove(4L));
        this.verify(test, 3, "stack: 3 2 1 cold: non-resident:");
        this.assertNull(test.remove(4L));
        this.verify(test, 3, "stack: 3 2 1 cold: non-resident:");
        test.put(4L, 40, 1L);
        test.put(5L, 50, 1L);
        this.verify(test, 4, "stack: 5 4 3 2 cold: 5 non-resident: 1");
        test.get(5L);
        test.get(2L);
        test.get(3L);
        test.get(4L);
        this.verify(test, 4, "stack: 4 3 2 5 cold: 2 non-resident: 1");
        this.assertEquals(50, (int)((Integer)test.remove(5L)));
        this.verify(test, 3, "stack: 4 3 2 cold: non-resident: 1");
        this.assertEquals(20, (int)((Integer)test.remove(2L)));
        this.assertFalse(test.containsKey(1L));
        this.assertEquals(10, (int)((Integer)test.remove(1L)));
        this.assertFalse(test.containsKey(1L));
        this.verify(test, 2, "stack: 4 3 cold: non-resident:");
        test.put(1L, 10, 1L);
        test.put(2L, 20, 1L);
        this.verify(test, 4, "stack: 2 1 4 3 cold: non-resident:");
        test.get(1L);
        test.get(3L);
        test.get(4L);
        this.verify(test, 4, "stack: 4 3 1 2 cold: non-resident:");
        this.assertEquals(10, (int)((Integer)test.remove(1L)));
        this.verify(test, 3, "stack: 4 3 2 cold: non-resident:");
        test.remove(2L);
        test.remove(3L);
        test.remove(4L);
        test.clear();
        this.verify(test, 0, "stack: cold: non-resident:");
        test.put(1L, 10, 1L);
        test.put(2L, 20, 1L);
        test.put(3L, 30, 1L);
        test.put(4L, 40, 1L);
        test.put(5L, 50, 1L);
        this.assertTrue(test.containsValue(50));
        this.verify(test, 4, "stack: 5 4 3 2 cold: 5 non-resident: 1");
        test.put(1L, 10, 1L);
        this.verify(test, 4, "stack: 1 5 4 3 cold: 2 non-resident: 5");
        this.assertTrue(test.containsValue(50));
        test.remove(2L);
        test.remove(3L);
        test.remove(4L);
        this.verify(test, 1, "stack: 1 cold: non-resident: 5");
        this.assertTrue(test.containsKey(1L));
        test.remove(1L);
        this.assertFalse(test.containsKey(1L));
        this.verify(test, 0, "stack: cold: non-resident: 5");
        this.assertFalse(test.containsKey(5L));
        this.assertTrue(test.isEmpty());
        test.clear();
        test.put(1L, 10, 1L);
        test.put(2L, 20, 1L);
        test.put(3L, 30, 1L);
        test.put(4L, 40, 1L);
        test.put(5L, 50, 1L);
        test.get(4L);
        test.get(3L);
        this.verify(test, 4, "stack: 3 4 5 2 cold: 5 non-resident: 1");
        test.put(6L, 60, 1L);
        this.verify(test, 4, "stack: 6 3 4 5 2 cold: 6 non-resident: 5 1");
        test.get(6L);
        this.verify(test, 4, "stack: 6 3 4 cold: 2 non-resident: 5 1");
    }

    private void testPruneStack() {
        CacheLongKeyLIRS<Integer> test = TestCacheLongKeyLIRS.createCache(5, 5);
        int i = 0;
        while (i < 7) {
            test.put(i, i * 10, 1L);
            ++i;
        }
        this.verify(test, 5, "stack: 6 5 4 3 2 1 cold: 6 non-resident: 5 0");
        test.get(4L);
        test.get(3L);
        test.get(2L);
        this.verify(test, 5, "stack: 2 3 4 6 5 1 cold: 6 non-resident: 5 0");
        test.remove(1L);
        this.verify(test, 4, "stack: 2 3 4 6 cold: non-resident: 5 0");
        test.put(0L, 0, 1L);
        test.put(1L, 10, 1L);
        this.verify(test, 5, "stack: 1 0 2 3 4 cold: 1 non-resident: 6 5");
    }

    private void testClear() {
        CacheLongKeyLIRS<Integer> test = TestCacheLongKeyLIRS.createCache(40, 4);
        int i = 0;
        while (i < 5) {
            test.put(i, 10 * i, 9L);
            ++i;
        }
        this.verify(test, 4, 9, "stack: 4 3 2 1 cold: 4 non-resident: 0");
        for (Map.Entry e : test.entrySet()) {
            this.assertTrue(e.getKey() >= 1L && e.getKey() <= 4L);
            this.assertTrue((Integer)e.getValue() >= 10 && (Integer)e.getValue() <= 40);
        }
        Iterator iterator = test.values().iterator();
        while (iterator.hasNext()) {
            int x = (Integer)((Object)iterator.next());
            this.assertTrue(x >= 10 && x <= 40);
        }
        for (long x : test.keySet()) {
            this.assertTrue(x >= 1L && x <= 4L);
        }
        this.assertEquals((long)(40 + 4 * MEMORY_OVERHEAD), test.getMaxMemory());
        this.assertEquals((long)(36 + 4 * MEMORY_OVERHEAD), test.getUsedMemory());
        this.assertEquals(4, test.size());
        this.assertEquals(3, test.sizeHot());
        this.assertEquals(1, test.sizeNonResident());
        this.assertFalse(test.isEmpty());
        long maxMemory = test.getMaxMemory();
        test.setMaxMemory(10L);
        this.assertEquals(10L, test.getMaxMemory());
        test.setMaxMemory(maxMemory);
        this.verify(test, 4, 9, "stack: 4 3 2 1 cold: 4 non-resident: 0");
        test.putAll(test.getMap());
        if (MEMORY_OVERHEAD < 7) {
            this.verify(test, 2, 16, "stack: 4 cold: 3 non-resident: 2 1 0");
        } else {
            this.verify(test, 3, 16, "stack: 4 3 cold: 2 non-resident: 1 0");
        }
        test.clear();
        this.verify(test, 0, 16, "stack: cold: non-resident:");
        this.assertEquals((long)(40 + 4 * MEMORY_OVERHEAD), test.getMaxMemory());
        this.assertEquals(0L, test.getUsedMemory());
        this.assertEquals(0, test.size());
        this.assertEquals(0, test.sizeHot());
        this.assertEquals(0, test.sizeNonResident());
        this.assertTrue(test.isEmpty());
    }

    private void testLimitHot() {
        CacheLongKeyLIRS<Integer> test = TestCacheLongKeyLIRS.createCache(1600, 100);
        int i = 0;
        while (i < 300) {
            test.put(i, 10 * i);
            ++i;
        }
        this.assertEquals(100, test.size());
        this.assertEquals(200, test.sizeNonResident());
        this.assertEquals(96, test.sizeHot());
    }

    private void testLimitNonResident() {
        CacheLongKeyLIRS<Integer> test = TestCacheLongKeyLIRS.createCache(4, 4);
        int i = 0;
        while (i < 20) {
            test.put(i, 10 * i, 1L);
            ++i;
        }
        this.verify(test, 4, "stack: 19 18 17 16 15 14 13 12 11 10 9 8 7 6 5 4 3 2 1 cold: 19 non-resident: 18 17 16 15 14 13 12 11 10 9 8 7 6 5 4 0");
    }

    private void testLimitMemory() {
        CacheLongKeyLIRS<Integer> test = TestCacheLongKeyLIRS.createCache(4, 4);
        int i = 0;
        while (i < 5) {
            test.put(i, 10 * i, 1L);
            ++i;
        }
        this.verify(test, 4, "stack: 4 3 2 1 cold: 4 non-resident: 0");
        this.assertTrue("" + test.getUsedMemory(), test.getUsedMemory() <= (long)(4 * (MEMORY_OVERHEAD + 1)));
        test.put(6L, 60, 3 + 2 * MEMORY_OVERHEAD);
        this.verify(test, 4, "stack: 6 4 3 cold: 6 non-resident: 2 1 4 0");
        this.assertTrue("" + test.getUsedMemory(), test.getUsedMemory() <= (long)(4 * (MEMORY_OVERHEAD + 1)));
        test.put(7L, 70, 3 + 2 * MEMORY_OVERHEAD);
        this.verify(test, 4, "stack: 7 6 4 3 cold: 7 non-resident: 6 2 1 4 0");
        this.assertTrue("" + test.getUsedMemory(), test.getUsedMemory() <= (long)(4 * (MEMORY_OVERHEAD + 1)));
        test.put(8L, 80, 4 + 3 * MEMORY_OVERHEAD);
        this.verify(test, 4, "stack: 8 cold: non-resident:");
        this.assertTrue("" + test.getUsedMemory(), test.getUsedMemory() <= (long)(4 * (MEMORY_OVERHEAD + 1)));
    }

    private void testScanResistance() {
        Integer x;
        boolean log = false;
        int size = 20;
        CacheLongKeyLIRS<Integer> test = TestCacheLongKeyLIRS.createCache((size / 2 + 2) * 16, size / 2 + 2);
        int i = 0;
        while (i < size) {
            test.put(-i, -i * 10);
            ++i;
        }
        this.verify(test, 0, null);
        i = 0;
        while (i < size / 2) {
            test.put(i, i * 10);
            test.get(i);
            if (log) {
                this.println("get " + i + " -> " + String.valueOf(test));
            }
            ++i;
        }
        this.verify(test, 0, null);
        i = 0;
        while (i < size) {
            x = (Integer)test.get(i);
            Integer y = (Integer)test.peek(i);
            if (i < size / 2) {
                this.assertNotNull("i: " + i, x);
                this.assertNotNull("i: " + i, y);
                this.assertEquals(i * 10, (int)x);
                this.assertEquals(i * 10, (int)y);
            } else {
                this.assertNull(x);
                this.assertNull(y);
                test.put(i, i * 10);
                this.assertEquals(i * 10, (int)((Integer)test.peek(i)));
            }
            if (log) {
                System.out.println("get " + i + " -> " + String.valueOf(test));
            }
            this.verify(test, 0, null);
            ++i;
        }
        i = 0;
        while (i < size) {
            x = (Integer)test.get(i);
            if (i < size / 2 || i == size - 1 || i == size - 2) {
                this.assertNotNull("i: " + i, x);
                this.assertEquals(i * 10, (int)x);
            }
            this.verify(test, 0, null);
            ++i;
        }
    }

    private void testRandomOperations() {
        boolean log = false;
        int size = 10;
        Random r = new Random(1L);
        int j = 0;
        while (j < 100) {
            CacheLongKeyLIRS<Integer> test = TestCacheLongKeyLIRS.createCache(size / 2 * 16, size / 2);
            HashMap<Integer, Integer> good = new HashMap<Integer, Integer>();
            int i = 0;
            while (i < 10000) {
                int key = r.nextInt(size);
                int value = r.nextInt();
                switch (r.nextInt(3)) {
                    case 0: {
                        if (log) {
                            System.out.println(i + " put " + key + " " + value);
                        }
                        good.put(key, value);
                        test.put(key, value);
                        break;
                    }
                    case 1: {
                        if (log) {
                            System.out.println(i + " get " + key);
                        }
                        Integer a = (Integer)good.get(key);
                        Integer b = (Integer)test.get(key);
                        if (a == null) {
                            this.assertNull(b);
                            break;
                        }
                        if (b == null) break;
                        this.assertEquals(a, b);
                        break;
                    }
                    case 2: {
                        if (log) {
                            System.out.println(i + " remove " + key);
                        }
                        good.remove(key);
                        test.remove(key);
                    }
                }
                if (log) {
                    System.out.println(" -> " + TestCacheLongKeyLIRS.toString(test));
                }
                ++i;
            }
            this.verify(test, 0, null);
            ++j;
        }
    }

    private static <V> String toString(CacheLongKeyLIRS<V> cache) {
        StringBuilder buff = new StringBuilder();
        buff.append("mem: " + cache.getUsedMemory());
        buff.append(" stack:");
        for (long k : cache.keys(false, false)) {
            buff.append(' ').append(k);
        }
        buff.append(" cold:");
        for (long k : cache.keys(true, false)) {
            buff.append(' ').append(k);
        }
        buff.append(" non-resident:");
        for (long k : cache.keys(true, true)) {
            buff.append(' ').append(k);
        }
        return buff.toString();
    }

    private <V> void verify(CacheLongKeyLIRS<V> cache, int expectedMemory, String expected) {
        this.verify(cache, expectedMemory, 1, expected);
    }

    private <V> void verify(CacheLongKeyLIRS<V> cache, int expectedMemory, int valueSize, String expected) {
        if (expected != null) {
            String got = TestCacheLongKeyLIRS.toString(cache);
            this.assertEquals("mem: " + expectedMemory * (valueSize + MEMORY_OVERHEAD) + " " + expected, got);
        }
        int mem = 0;
        for (long k : cache.keySet()) {
            mem = (int)((long)mem + cache.getMemory(k));
        }
        this.assertEquals((long)mem, cache.getUsedMemory());
        List<Long> stack = cache.keys(false, false);
        List<Long> cold = cache.keys(true, false);
        List<Long> nonResident = cache.keys(true, true);
        this.assertEquals(nonResident.size(), cache.sizeNonResident());
        HashSet<Long> hot = new HashSet<Long>(stack);
        hot.removeAll(cold);
        hot.removeAll(nonResident);
        this.assertEquals(hot.size(), cache.sizeHot());
        this.assertEquals(hot.size() + cold.size(), cache.size());
        if (stack.size() > 0) {
            long lastStack = stack.get(stack.size() - 1);
            this.assertTrue(hot.contains(lastStack));
        }
    }

    private static <V> CacheLongKeyLIRS<V> createCache(int maxSize, int elements) {
        CacheLongKeyLIRS.Config cc = new CacheLongKeyLIRS.Config();
        cc.maxMemory = maxSize + elements * MEMORY_OVERHEAD;
        cc.segmentCount = 1;
        cc.stackMoveDistance = 0;
        return new CacheLongKeyLIRS(cc);
    }
}

