/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.db.SpatialKey;
import org.h2.mvstore.rtree.MVRTreeMap;
import org.h2.mvstore.rtree.Spatial;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.store.TestMVStore;

public class TestMVRTree
extends TestMVStore {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() {
        this.testRemoveAll();
        this.testRandomInsert();
        this.testSpatialKey();
        this.testExample();
        this.testMany();
        this.testSimple();
        this.testRandom();
        this.testRandomFind();
    }

    private void testRemoveAll() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = new MVStore.Builder().fileName(fileName).pageSplitSize(100).open();){
            MVRTreeMap map = (MVRTreeMap)s.openMap("data", new MVRTreeMap.Builder());
            Random r = new Random(1L);
            int i = 0;
            while (i < 1000) {
                float x = r.nextFloat() * 50.0f;
                float y = r.nextFloat() * 50.0f;
                SpatialKey k = new SpatialKey((long)(i % 100), x, x + 2.0f, y, y + 1.0f);
                map.put(k, "i:" + i);
                ++i;
            }
            s.commit();
            map.clear();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testRandomInsert() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = new MVStore.Builder().fileName(fileName).pageSplitSize(100).open();){
            MVRTreeMap map = (MVRTreeMap)s.openMap("data", new MVRTreeMap.Builder());
            Random r = new Random(1L);
            int i = 0;
            while (i < 1000) {
                if (i % 100 == 0) {
                    r.setSeed(1L);
                }
                float x = r.nextFloat() * 50.0f;
                float y = r.nextFloat() * 50.0f;
                SpatialKey k = new SpatialKey((long)(i % 100), x, x + 2.0f, y, y + 1.0f);
                map.put(k, "i:" + i);
                if (i % 10 == 0) {
                    s.commit();
                }
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testSpatialKey() {
        SpatialKey a0 = new SpatialKey(0L, 1.0f, 2.0f, 3.0f, 4.0f);
        SpatialKey a1 = new SpatialKey(0L, 1.0f, 2.0f, 3.0f, 4.0f);
        SpatialKey b0 = new SpatialKey(1L, 1.0f, 2.0f, 3.0f, 4.0f);
        SpatialKey c0 = new SpatialKey(1L, 1.1f, 2.2f, 3.3f, 4.4f);
        this.assertEquals(0, ((Object)a0).hashCode());
        this.assertEquals(1, ((Object)b0).hashCode());
        this.assertTrue(((Object)a0).equals(a0));
        this.assertTrue(((Object)a0).equals(a1));
        this.assertFalse(((Object)a0).equals(b0));
        this.assertTrue(a0.equalsIgnoringId(b0));
        this.assertFalse(((Object)b0).equals(c0));
        this.assertFalse(b0.equalsIgnoringId(c0));
        this.assertEquals("0: (1.0/2.0, 3.0/4.0)", ((Object)a0).toString());
        this.assertEquals("1: (1.0/2.0, 3.0/4.0)", ((Object)b0).toString());
        this.assertEquals("1: (1.1/2.2, 3.3/4.4)", ((Object)c0).toString());
    }

    private void testExample() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = MVStore.open(null);){
            MVRTreeMap r = (MVRTreeMap)s.openMap("data", new MVRTreeMap.Builder());
            r.add(new SpatialKey(0L, -3.0f, -2.0f, 2.0f, 3.0f), "left");
            r.add(new SpatialKey(1L, 3.0f, 4.0f, 4.0f, 5.0f), "right");
            MVRTreeMap.RTreeCursor it = r.findIntersectingKeys(new SpatialKey(0L, 0.0f, 9.0f, 3.0f, 6.0f));
            while (it.hasNext()) {
                Spatial k = (Spatial)it.next();
                this.assertNotNull(k);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testMany() {
        SpatialKey k;
        float p;
        float y;
        float x;
        int i;
        Random rand;
        MVRTreeMap r;
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        int len = 1000;
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            s = TestMVRTree.openStore(fileName);
            try {
                r = (MVRTreeMap)s.openMap("data", new MVRTreeMap.Builder().dimensions(2).valueType((DataType)StringDataType.INSTANCE));
                rand = new Random(1L);
                i = 0;
                while (i < len) {
                    x = rand.nextFloat();
                    y = rand.nextFloat();
                    p = (float)((double)rand.nextFloat() * 1.0E-6);
                    k = new SpatialKey((long)i, x - p, x + p, y - p, y + p);
                    r.add(k, "" + i);
                    if (i > 0 && i % len / 10 == 0) {
                        s.commit();
                    }
                    if (i > 0 && i % 10000 == 0) {
                        TestMVRTree.render(r, this.getBaseDir() + "/test.png");
                    }
                    ++i;
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            s = TestMVRTree.openStore(fileName);
            try {
                r = (MVRTreeMap)s.openMap("data", new MVRTreeMap.Builder().dimensions(2).valueType((DataType)StringDataType.INSTANCE));
                rand = new Random(1L);
                i = 0;
                while (i < len) {
                    x = rand.nextFloat();
                    y = rand.nextFloat();
                    p = (float)((double)rand.nextFloat() * 1.0E-6);
                    k = new SpatialKey((long)i, x - p, x + p, y - p, y + p);
                    this.assertEquals("" + i, (String)r.get(k));
                    ++i;
                }
                this.assertEquals(len, r.size());
                int count = 0;
                for (Spatial k2 : r.keySet()) {
                    this.assertNotNull(r.get(k2));
                    ++count;
                }
                this.assertEquals(len, count);
                rand = new Random(1L);
                int i2 = 0;
                while (i2 < len) {
                    float x2 = rand.nextFloat();
                    float y2 = rand.nextFloat();
                    float p2 = (float)((double)rand.nextFloat() * 1.0E-6);
                    SpatialKey k3 = new SpatialKey((long)i2, x2 - p2, x2 + p2, y2 - p2, y2 + p2);
                    r.remove(k3);
                    ++i2;
                }
                this.assertEquals(0, r.size());
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testSimple() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = TestMVRTree.openStore(fileName);){
            MVRTreeMap r = (MVRTreeMap)s.openMap("data", new MVRTreeMap.Builder().dimensions(2).valueType((DataType)StringDataType.INSTANCE));
            TestMVRTree.add(r, "Bern", TestMVRTree.key(0, 46.57, 7.27, 124381));
            TestMVRTree.add(r, "Basel", TestMVRTree.key(1, 47.34, 7.36, 170903));
            TestMVRTree.add(r, "Zurich", TestMVRTree.key(2, 47.22, 8.33, 376008));
            TestMVRTree.add(r, "Lucerne", TestMVRTree.key(3, 47.03, 8.18, 77491));
            TestMVRTree.add(r, "Geneva", TestMVRTree.key(4, 46.12, 6.09, 191803));
            TestMVRTree.add(r, "Lausanne", TestMVRTree.key(5, 46.31, 6.38, 127821));
            TestMVRTree.add(r, "Winterthur", TestMVRTree.key(6, 47.3, 8.45, 102966));
            TestMVRTree.add(r, "St. Gallen", TestMVRTree.key(7, 47.25, 9.22, 73500));
            TestMVRTree.add(r, "Biel/Bienne", TestMVRTree.key(8, 47.08, 7.15, 51203));
            TestMVRTree.add(r, "Lugano", TestMVRTree.key(9, 46.0, 8.57, 54667));
            TestMVRTree.add(r, "Thun", TestMVRTree.key(10, 46.46, 7.38, 42623));
            TestMVRTree.add(r, "Bellinzona", TestMVRTree.key(11, 46.12, 9.01, 17373));
            TestMVRTree.add(r, "Chur", TestMVRTree.key(12, 46.51, 9.32, 33756));
            ArrayList<String> list = new ArrayList<String>(r.size());
            for (Spatial x : r.keySet()) {
                list.add((String)r.get(x));
            }
            Collections.sort(list);
            this.assertEquals("[Basel, Bellinzona, Bern, Biel/Bienne, Chur, Geneva, Lausanne, Lucerne, Lugano, St. Gallen, Thun, Winterthur, Zurich]", list.toString());
            list.clear();
            Spatial k = TestMVRTree.key(0, 47.34, 7.36, 0);
            MVRTreeMap.RTreeCursor it = r.findIntersectingKeys(k);
            while (it.hasNext()) {
                list.add((String)r.get(it.next()));
            }
            Collections.sort(list);
            this.assertEquals("[Basel]", list.toString());
            list.clear();
            k = TestMVRTree.key(0, 47.34, 7.36, 0);
            it = r.findContainedKeys(k);
            while (it.hasNext()) {
                list.add((String)r.get(it.next()));
            }
            this.assertEquals(0, list.size());
            k = TestMVRTree.key(0, 47.34, 7.36, 171000);
            it = r.findContainedKeys(k);
            while (it.hasNext()) {
                list.add((String)r.get(it.next()));
            }
            this.assertEquals("[Basel]", list.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void add(MVRTreeMap<String> r, String name, Spatial k) {
        r.put(k, name);
    }

    private static Spatial key(int id, double y, double x, int population) {
        float a = (float)((double)((int)x) + (x - (double)((int)x)) * 5.0 / 3.0);
        float b = 50.0f - (float)((double)((int)y) + (y - (double)((int)y)) * 5.0 / 3.0);
        float s = (float)Math.sqrt((double)population / 1.0E7);
        SpatialKey k = new SpatialKey((long)id, a - s, a + s, b - s, b + s);
        return k;
    }

    private static void render(MVRTreeMap<String> r, String fileName) {
        Object rect;
        int width = 1000;
        int height = 500;
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2d = (Graphics2D)img.getGraphics();
        g2d.setBackground(Color.WHITE);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, width, height);
        g2d.setComposite(AlphaComposite.SrcOver.derive(0.5f));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.BLACK);
        SpatialKey b = new SpatialKey(0L, Float.MAX_VALUE, Float.MIN_VALUE, Float.MAX_VALUE, Float.MIN_VALUE);
        for (Spatial x : r.keySet()) {
            b.setMin(0, Math.min(b.min(0), x.min(0)));
            b.setMin(1, Math.min(b.min(1), x.min(1)));
            b.setMax(0, Math.max(b.max(0), x.max(0)));
            b.setMax(1, Math.max(b.max(1), x.max(1)));
        }
        for (Spatial x : r.keySet()) {
            rect = TestMVRTree.scale(b, x, width, height);
            g2d.drawRect(rect[0], rect[1], (int)(rect[2] - rect[0]), (int)(rect[3] - rect[1]));
            String s = (String)r.get(x);
            g2d.drawChars(s.toCharArray(), 0, s.length(), (int)rect[0], (int)(rect[1] - 4));
        }
        g2d.setColor(Color.red);
        ArrayList<Spatial> list = new ArrayList<Spatial>();
        r.addNodeKeys(list, r.getRootPage());
        rect = list.iterator();
        while (rect.hasNext()) {
            Spatial x = (Spatial)rect.next();
            int[] rect2 = TestMVRTree.scale(b, x, width, height);
            g2d.drawRect(rect2[0], rect2[1], rect2[2] - rect2[0], rect2[3] - rect2[1]);
        }
        ImageWriter out = ImageIO.getImageWritersByFormatName("png").next();
        try {
            out.setOutput(new FileImageOutputStream(new File(fileName)));
            out.write(img);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int[] scale(Spatial b, Spatial x, int width, int height) {
        int[] rect = new int[]{(int)((double)(x.min(0) - b.min(0)) * ((double)width * 0.9) / (double)(b.max(0) - b.min(0)) + (double)width * 0.05), (int)((double)(x.min(1) - b.min(1)) * ((double)height * 0.9) / (double)(b.max(1) - b.min(1)) + (double)height * 0.05), (int)((double)(x.max(0) - b.min(0)) * ((double)width * 0.9) / (double)(b.max(0) - b.min(0)) + (double)width * 0.05), (int)((double)(x.max(1) - b.min(1)) * ((double)height * 0.9) / (double)(b.max(1) - b.min(1)) + (double)height * 0.05)};
        return rect;
    }

    private void testRandom() {
        this.testRandom(true);
        this.testRandom(false);
    }

    private void testRandomFind() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = TestMVRTree.openStore(null);){
            MVRTreeMap m = (MVRTreeMap)s.openMap("data", new MVRTreeMap.Builder());
            int max = 100;
            int x = 0;
            while (x < max) {
                int y = 0;
                while (y < max) {
                    int id = x * max + y;
                    SpatialKey k = new SpatialKey((long)id, x, x, y, y);
                    m.put(k, Integer.valueOf(id));
                    ++y;
                }
                ++x;
            }
            Random rand = new Random(1L);
            int operationCount = 1000;
            int i = 0;
            while (i < operationCount) {
                Spatial t;
                int x1 = rand.nextInt(max);
                int y1 = rand.nextInt(10);
                int x2 = rand.nextInt(10);
                int y2 = rand.nextInt(10);
                int intersecting = Math.max(0, x2 - x1 + 1) * Math.max(0, y2 - y1 + 1);
                int contained = Math.max(0, x2 - x1 - 1) * Math.max(0, y2 - y1 - 1);
                SpatialKey k = new SpatialKey(0L, x1, x2, y1, y2);
                MVRTreeMap.RTreeCursor it = m.findContainedKeys(k);
                int count = 0;
                while (it.hasNext()) {
                    t = (Spatial)it.next();
                    this.assertTrue(t.min(0) > (float)x1);
                    this.assertTrue(t.min(1) > (float)y1);
                    this.assertTrue(t.max(0) < (float)x2);
                    this.assertTrue(t.max(1) < (float)y2);
                    ++count;
                }
                this.assertEquals(contained, count);
                it = m.findIntersectingKeys(k);
                count = 0;
                while (it.hasNext()) {
                    t = (Spatial)it.next();
                    this.assertTrue(t.min(0) >= (float)x1);
                    this.assertTrue(t.min(1) >= (float)y1);
                    this.assertTrue(t.max(0) <= (float)x2);
                    this.assertTrue(t.max(1) <= (float)y2);
                    ++count;
                }
                this.assertEquals(intersecting, count);
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testRandom(boolean quadraticSplit) {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var4_5 = null;
        try (MVStore s = TestMVRTree.openStore(fileName);){
            MVRTreeMap m = (MVRTreeMap)s.openMap("data", new MVRTreeMap.Builder());
            m.setQuadraticSplit(quadraticSplit);
            HashMap<SpatialKey, CallSite> map = new HashMap<SpatialKey, CallSite>();
            Random rand = new Random(1L);
            int operationCount = 10000;
            int maxValue = 300;
            int i = 0;
            while (i < operationCount) {
                int key = rand.nextInt(maxValue);
                Random rk = new Random(key);
                float x = rk.nextFloat();
                float y = rk.nextFloat();
                float p = (float)((double)rk.nextFloat() * 1.0E-6);
                SpatialKey k = new SpatialKey((long)key, x - p, x + p, y - p, y + p);
                String v = "" + rand.nextInt();
                switch (rand.nextInt(5)) {
                    case 0: {
                        TestMVRTree.log(i + ": put " + String.valueOf(k) + " = " + v + " " + m.size());
                        m.put(k, v);
                        map.put(k, (CallSite)((Object)v));
                        break;
                    }
                    case 1: {
                        TestMVRTree.log(i + ": remove " + String.valueOf(k) + " " + m.size());
                        m.remove(k);
                        map.remove(k);
                        break;
                    }
                    case 2: {
                        String a;
                        Spatial n;
                        p = (float)((double)rk.nextFloat() * 0.01);
                        k = new SpatialKey((long)key, x - p, x + p, y - p, y + p);
                        MVRTreeMap.RTreeCursor it = m.findIntersectingKeys(k);
                        while (it.hasNext()) {
                            n = (Spatial)it.next();
                            a = (String)map.get(n);
                            this.assertNotNull(a);
                        }
                        break;
                    }
                    case 3: {
                        String a;
                        Spatial n;
                        p = (float)((double)rk.nextFloat() * 0.01);
                        k = new SpatialKey((long)key, x - p, x + p, y - p, y + p);
                        MVRTreeMap.RTreeCursor it = m.findContainedKeys(k);
                        while (it.hasNext()) {
                            n = (Spatial)it.next();
                            a = (String)map.get(n);
                            this.assertNotNull(a);
                        }
                        break;
                    }
                    default: {
                        String a = (String)map.get(k);
                        String b = (String)m.get(k);
                        this.assertTrue(Objects.equals(a, b));
                    }
                }
                this.assertEquals(map.size(), m.size());
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

