/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.util.Task;

public class TestMVStoreCachePerformance
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.test();
    }

    @Override
    public void test() throws Exception {
        this.testCache(1, "");
        this.testCache(1, "cache:");
        this.testCache(10, "");
        this.testCache(10, "cache:");
        this.testCache(100, "");
        this.testCache(100, "cache:");
    }

    private void testCache(int threadCount, String fileNamePrefix) {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        fileName = fileNamePrefix + fileName;
        FileUtils.delete(fileName);
        MVStore store = new MVStore.Builder().fileName(fileName).open();
        final MVMap<Integer, byte[]> map = store.openMap("test");
        final AtomicInteger counter = new AtomicInteger();
        byte[] data = new byte[8192];
        int count = 10000;
        int i = 0;
        while (i < 10000) {
            map.put(i, data);
            store.commit();
            int cfr_ignored_0 = i % 1000;
            ++i;
        }
        Task[] tasks = new Task[threadCount];
        int i2 = 0;
        while (i2 < threadCount) {
            tasks[i2] = new Task(){

                @Override
                public void call() throws Exception {
                    Random r = new Random();
                    do {
                        int id = r.nextInt(10000);
                        map.get(id);
                        counter.incrementAndGet();
                    } while (!this.stop);
                }
            };
            tasks[i2].execute();
            ++i2;
        }
        i2 = 0;
        while (i2 < 4) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i2;
        }
        Task[] taskArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            Task t = taskArray[n2];
            t.get();
            ++n2;
        }
        store.close();
        System.out.println(counter.get() / 10000 + " ops/ms; " + threadCount + " thread(s); " + fileNamePrefix);
    }
}

