/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.lang.invoke.CallSite;
import java.util.Random;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;

public class TestMVStoreStopCompact
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.config.big = true;
        test.test();
    }

    @Override
    public void test() throws Exception {
        int retentionTime = 10;
        while (retentionTime < 1000) {
            int timeout = 100;
            while (timeout <= 1000) {
                this.testStopCompact(retentionTime, timeout);
                timeout *= 10;
            }
            retentionTime *= 10;
        }
    }

    private void testStopCompact(int retentionTime, int timeout) throws InterruptedException {
        String fileName = this.getBaseDir() + "/testStopCompact.h3";
        FileUtils.createDirectories(this.getBaseDir());
        FileUtils.delete(fileName);
        MVStore.Builder builder = new MVStore.Builder().fileName(fileName);
        Throwable throwable = null;
        Object var6_7 = null;
        try (MVStore s = builder.open();){
            s.setRetentionTime(retentionTime);
            s.setVersionsToKeep(0);
            MVMap<Integer, CallSite> map = s.openMap("data");
            long start = System.currentTimeMillis();
            Random r = new Random(1L);
            int i = 0;
            while (i < 4000000) {
                long time = System.currentTimeMillis() - start;
                if (time > (long)timeout) break;
                int x = r.nextInt(10000000);
                map.put(x, (CallSite)((Object)("Hello World " + i * 10)));
                ++i;
            }
            s.setAutoCommitDelay(100);
            long oldWriteCount = s.getFileStore().getWriteCount();
            long totalWrites = 0L;
            int i2 = 0;
            while (i2 < 50) {
                Thread.sleep(200L);
                long newWriteCount = s.getFileStore().getWriteCount();
                long delta = newWriteCount - oldWriteCount;
                if (delta == 0L) break;
                totalWrites += delta;
                oldWriteCount = newWriteCount;
                ++i2;
            }
            this.assertTrue("writeCount diff: " + retentionTime + "/" + timeout + " " + totalWrites, totalWrites < 90L);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

