/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.util.Map;
import java.util.Random;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreTool;
import org.h2.mvstore.db.SpatialKey;
import org.h2.mvstore.rtree.MVRTreeMap;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;

public class TestMVStoreTool
extends TestBase {
    public static final String BIG_STRING_WITH_C = new String(new char[3000]).replace("\u0000", "c");
    public static final String BIG_STRING_WITH_H = new String(new char[3000]).replace("\u0000", "H");

    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.config.traceTest = true;
        test.config.big = true;
        test.testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testCompact();
        this.testDump();
        this.testRollback();
    }

    private void testCompact() {
        String fileName = this.getBaseDir() + "/testCompact.h3";
        String fileNameNew = fileName + ".new";
        String fileNameCompressed = fileNameNew + ".compress";
        FileUtils.createDirectories(this.getBaseDir());
        FileUtils.delete(fileName);
        MVStore s = new MVStore.Builder().pageSplitSize(1000).fileName(fileName).autoCommitDisabled().open();
        s.setRetentionTime(0);
        long start = System.currentTimeMillis();
        MVMap<Integer, CallSite> map = s.openMap("data");
        int size = this.config.big ? 2000000 : 20000;
        int i = 0;
        while (i < size) {
            map.put(i, (CallSite)((Object)("Hello World " + i * 10)));
            if (i % 10000 == 0) {
                s.commit();
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            map.remove(i);
            if (i % 10000 == 0) {
                s.commit();
            }
            i += 2;
        }
        i = 0;
        while (i < 20) {
            map = s.openMap("data" + i);
            int j = 0;
            while (j < i * i) {
                map.put(j, (CallSite)((Object)("Hello World " + j * 10)));
                ++j;
            }
            s.commit();
            ++i;
        }
        MVRTreeMap rTreeMap = (MVRTreeMap)s.openMap("rtree", new MVRTreeMap.Builder());
        Random r = new Random(1L);
        int i2 = 0;
        while (i2 < 10) {
            float x = r.nextFloat();
            float y = r.nextFloat();
            float width = r.nextFloat() / 10.0f;
            float height = r.nextFloat() / 10.0f;
            SpatialKey k = new SpatialKey((long)i2, x, x + width, y, y + height);
            rTreeMap.put(k, "Hello World " + i2 * 10);
            if (i2 % 3 == 0) {
                s.commit();
            }
            ++i2;
        }
        s.close();
        this.trace("Created in " + (System.currentTimeMillis() - start) + " ms.");
        start = System.currentTimeMillis();
        MVStoreTool.compact(fileName, fileNameNew, false);
        MVStoreTool.compact(fileName, fileNameCompressed, true);
        this.trace("Compacted in " + (System.currentTimeMillis() - start) + " ms.");
        long size1 = FileUtils.size(fileName);
        long size2 = FileUtils.size(fileNameNew);
        long size3 = FileUtils.size(fileNameCompressed);
        this.assertTrue("size1: " + size1 + " size2: " + size2 + " size3: " + size3, size2 < size1 && size3 < size2);
        start = System.currentTimeMillis();
        MVStoreTool.compact(fileNameNew, false);
        this.assertTrue(100L * Math.abs(size2 - FileUtils.size(fileNameNew)) / size2 < 1L);
        MVStoreTool.compact(fileNameCompressed, true);
        this.assertEquals(size3, FileUtils.size(fileNameCompressed));
        this.trace("Re-compacted in " + (System.currentTimeMillis() - start) + " ms.");
        start = System.currentTimeMillis();
        MVStore s1 = new MVStore.Builder().fileName(fileName).readOnly().open();
        MVStore s2 = new MVStore.Builder().fileName(fileNameNew).readOnly().open();
        MVStore s3 = new MVStore.Builder().fileName(fileNameCompressed).readOnly().open();
        this.assertEquals(s1, s2);
        this.assertEquals(s1, s3);
        s1.close();
        s2.close();
        s3.close();
        this.trace("Verified in " + (System.currentTimeMillis() - start) + " ms.");
    }

    private void assertEquals(MVStore a, MVStore b) {
        this.assertEquals(a.getMapNames().size(), b.getMapNames().size());
        for (String mapName : a.getMapNames()) {
            Object x;
            MVRTreeMap mb;
            MVRTreeMap ma;
            if (mapName.startsWith("rtree")) {
                ma = (MVRTreeMap)a.openMap(mapName, new MVRTreeMap.Builder());
                mb = (MVRTreeMap)b.openMap(mapName, new MVRTreeMap.Builder());
                this.assertEquals(ma.sizeAsLong(), mb.sizeAsLong());
                for (Map.Entry e : ma.entrySet()) {
                    x = mb.get(e.getKey());
                    this.assertEquals((String)e.getValue(), x.toString());
                }
                continue;
            }
            ma = a.openMap(mapName);
            mb = a.openMap(mapName);
            this.assertEquals(ma.sizeAsLong(), mb.sizeAsLong());
            for (Map.Entry e : ma.entrySet()) {
                x = mb.get(e.getKey());
                this.assertEquals(e.getValue().toString(), x.toString());
            }
        }
    }

    private void testDump() {
        String fileName = this.getBaseDir() + "/testDump.h3";
        FileUtils.createDirectories(this.getBaseDir());
        FileUtils.delete(fileName);
        MVStore s = new MVStore.Builder().pageSplitSize(1000).fileName(fileName).autoCommitDisabled().open();
        s.setRetentionTime(0);
        MVMap<Integer, String> map = s.openMap("data");
        int nbEntries = 20000;
        int i = 0;
        while (i < nbEntries) {
            map.put(i, i % 2 == 0 ? BIG_STRING_WITH_C : BIG_STRING_WITH_H);
            ++i;
        }
        s.commit();
        i = 0;
        while (i < nbEntries) {
            map.put(i, i % 2 == 0 ? BIG_STRING_WITH_H : BIG_STRING_WITH_C);
            ++i;
        }
        s.commit();
        s.close();
        StringWriter dumpWriter = new StringWriter();
        MVStoreTool.dump(fileName, dumpWriter, true);
        int nbFileHeaders = TestMVStoreTool.nbOfOccurrences(dumpWriter.toString(), "fileHeader");
        this.assertEquals("Exactly 2 file headers are expected in the dump", 2, nbFileHeaders);
    }

    private void testRollback() {
        String fileName = this.getBaseDir() + "/testDump.h4";
        FileUtils.createDirectories(this.getBaseDir());
        FileUtils.delete(fileName);
        MVStore s = new MVStore.Builder().pageSplitSize(1000).fileName(fileName).autoCommitDisabled().open();
        s.setRetentionTime(0);
        MVMap<Integer, String> map = s.openMap("data");
        int nbEntries = 20000;
        int i = 0;
        while (i < nbEntries) {
            map.put(i, i % 2 == 0 ? BIG_STRING_WITH_C : BIG_STRING_WITH_H);
            ++i;
        }
        s.commit();
        i = 0;
        while (i < nbEntries) {
            map.put(i, i % 2 == 0 ? BIG_STRING_WITH_H : BIG_STRING_WITH_C);
            ++i;
        }
        s.commit();
        s.close();
        StringWriter dumpWriter = new StringWriter();
        try {
            MVStoreTool.rollback(fileName, Long.MAX_VALUE, dumpWriter);
        }
        catch (NullPointerException ex) {
            this.fail("No NullPointerException expected");
        }
    }

    private static int nbOfOccurrences(String str, String pattern) {
        return str.split(pattern, -1).length - 1;
    }
}

