/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.channels.FileChannel;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.h2.engine.Database;
import org.h2.jdbc.JdbcConnection;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.Recover;
import org.h2.tools.Restore;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.Task;

public class TestMVTableEngine
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void test() throws Exception {
        this.testDataTypes();
    }

    private void testLobCopy() throws Exception {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection(this.getTestName());
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, data clob)");
        stat = conn.createStatement();
        stat.execute("insert into test(id, data) values(2, space(300))");
        stat.execute("insert into test(id, data) values(1, space(300))");
        stat.execute("alter table test add column x int");
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection(this.getTestName());
        }
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select data from test");
        while (rs.next()) {
            rs.getString(1);
        }
        conn.close();
    }

    private void testLobReuse() throws Exception {
        this.deleteDb(this.getTestName());
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn1 = this.getConnection(this.getTestName());){
            Statement stat = conn1.createStatement();
            stat.execute("create table test(id identity primary key, lob clob)");
            byte[] buffer = new byte[8192];
            int i = 0;
            while (i < 20) {
                Throwable throwable2 = null;
                Object var8_11 = null;
                try (Connection conn2 = this.getConnection(this.getTestName());){
                    stat = conn2.createStatement();
                    stat.execute("insert into test(lob) select space(1025) from system_range(1, 10)");
                    stat.execute("delete from test where random() > 0.5");
                    ResultSet rs = conn2.createStatement().executeQuery("select lob from test");
                    while (rs.next()) {
                        InputStream is = rs.getBinaryStream(1);
                        while (is.read(buffer) != -1) {
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                ++i;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void testShutdownDuringLobCreation() throws Exception {
        Statement stat;
        Connection conn;
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        Throwable throwable = null;
        Object var2_5 = null;
        try {
            conn = this.getConnection(this.getTestName());
            try {
                stat = conn.createStatement();
                stat.execute("create table test(data clob) as select space(10000)");
                final PreparedStatement prep = conn.prepareStatement("set @lob = ?");
                final AtomicBoolean end = new AtomicBoolean();
                Task t = new Task(){

                    @Override
                    public void call() throws Exception {
                        prep.setBinaryStream(1, new InputStream(){
                            int len;

                            @Override
                            public int read() throws IOException {
                                if (this.len++ < 0x400000) {
                                    return 0;
                                }
                                end.set(true);
                                while (!stop) {
                                    try {
                                        Thread.sleep(1L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                                return -1;
                            }
                        }, -1);
                    }
                };
                t.execute();
                while (!end.get()) {
                    Thread.sleep(1L);
                }
                stat.execute("checkpoint");
                stat.execute("shutdown immediately");
                Exception ex = t.getException();
                this.assertNotNull(ex);
                IOUtils.closeSilently(conn);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var2_5 = null;
        try {
            conn = this.getConnection(this.getTestName());
            try {
                stat = conn.createStatement();
                stat.execute("shutdown defrag");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var2_5 = null;
        try {
            conn = this.getConnection(this.getTestName());
            try {
                stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select * from information_schema.settings where setting_name = 'info.PAGE_COUNT'");
                rs.next();
                int pages = rs.getInt(2);
                this.assertTrue("p:" + pages, pages <= 7);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void testLobCreationThenShutdown() throws Exception {
        Statement stat;
        Connection conn;
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        Throwable throwable = null;
        Object var2_5 = null;
        try {
            conn = this.getConnection(this.getTestName());
            try {
                stat = conn.createStatement();
                stat.execute("create table test(id identity, data clob)");
                PreparedStatement prep = conn.prepareStatement("insert into test values(?, ?)");
                int i = 0;
                while (i < 9) {
                    prep.setInt(1, i);
                    int size = i * i * i * i * 1024;
                    prep.setCharacterStream(2, new StringReader(new String(new char[size])));
                    prep.execute();
                    ++i;
                }
                stat.execute("shutdown immediately");
                IOUtils.closeSilently(conn);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var2_5 = null;
        try {
            conn = this.getConnection(this.getTestName());
            try {
                stat = conn.createStatement();
                stat.execute("drop all objects");
                stat.execute("shutdown defrag");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var2_5 = null;
        try {
            conn = this.getConnection(this.getTestName());
            try {
                stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select * from information_schema.settings where setting_name = 'info.PAGE_COUNT'");
                rs.next();
                int pages = rs.getInt(2);
                this.assertTrue("p:" + pages, pages < 4);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void testManyTransactions() throws Exception {
        this.deleteDb(this.getTestName());
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(this.getTestName());){
            Statement stat = conn.createStatement();
            stat.execute("create table test()");
            conn.setAutoCommit(false);
            stat.execute("insert into test values()");
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (Connection conn2 = this.getConnection(this.getTestName());){
                Statement stat2 = conn2.createStatement();
                long i = 0L;
                while (i < 100000L) {
                    stat2.execute("insert into test values()");
                    ++i;
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void testAppendOnly() throws Exception {
        Statement stat;
        Connection conn;
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn2 = this.getConnection(this.getTestName());){
            Statement stat2 = conn2.createStatement();
            stat2.execute("set retention_time 0");
            int i = 0;
            while (i < 10) {
                stat2.execute("create table dummy" + i + " as select x, space(100) from system_range(1, 1000)");
                stat2.execute("checkpoint");
                ++i;
            }
            stat2.execute("create table test as select x from system_range(1, 1000)");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String fileName = this.getBaseDir() + "/" + this.getTestName() + ".mv.db";
        long fileSize = FileUtils.size(fileName);
        Throwable throwable3 = null;
        Object var5_12 = null;
        try {
            conn = this.getConnection(this.getTestName() + ";reuse_space=false");
            try {
                stat = conn.createStatement();
                stat.execute("set retention_time 0");
                int i = 0;
                while (i < 10) {
                    stat.execute("drop table dummy" + i);
                    stat.execute("checkpoint");
                    ++i;
                }
                stat.execute("alter table test alter column x rename to y");
                stat.execute("select y from test where 1 = 0");
                stat.execute("create table test2 as select x from system_range(1, 1000)");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
        throwable3 = null;
        var5_12 = null;
        try (FileChannel fc = FileUtils.open(fileName, "rw");){
            fc.truncate(fileSize);
        }
        catch (Throwable throwable5) {
            if (throwable3 == null) {
                throwable3 = throwable5;
            } else if (throwable3 != throwable5) {
                throwable3.addSuppressed(throwable5);
            }
            throw throwable3;
        }
        throwable3 = null;
        var5_12 = null;
        try {
            conn = this.getConnection(this.getTestName());
            try {
                stat = conn.createStatement();
                stat.execute("select * from dummy0 where 1 = 0");
                stat.execute("select * from dummy9 where 1 = 0");
                stat.execute("select x from test where 1 = 0");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable3 == null) {
                throwable3 = throwable6;
            } else if (throwable3 != throwable6) {
                throwable3.addSuppressed(throwable6);
            }
            throw throwable3;
        }
    }

    private void testNoRetentionTime() throws SQLException {
        this.deleteDb(this.getTestName());
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection(this.getTestName() + ";RETENTION_TIME=0;WRITE_DELAY=10");){
            Statement stat = conn.createStatement();
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (Connection conn2 = this.getConnection(this.getTestName());){
                Statement stat2 = conn2.createStatement();
                stat.execute("create alias sleep as $$void sleep(int ms) throws Exception { Thread.sleep(ms); }$$");
                stat.execute("create table test(id identity, name varchar) as select x, 'Init' from system_range(0, 1999)");
                int i = 0;
                while (i < 10) {
                    stat.execute("insert into test values(null, 'Hello')");
                    stat.execute("create table temp(id identity, name varchar) as select x, space(1000000) from system_range(0, 10)");
                    stat.execute("drop table temp");
                    ++i;
                }
                ResultSet rs = stat2.executeQuery("select *, sleep(1) from test order by id");
                int i2 = 0;
                while (i2 < 2010) {
                    this.assertTrue(rs.next());
                    this.assertEquals(i2, rs.getInt(1));
                    ++i2;
                }
                this.assertFalse(rs.next());
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void testOldAndNew() throws SQLException {
        Connection conn;
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        String urlOld = this.getURL(this.getTestName() + ";MV_STORE=FALSE", true);
        String urlNew = this.getURL(this.getTestName() + ";MV_STORE=TRUE", true);
        String url = this.getURL(this.getTestName(), true);
        Throwable throwable = null;
        Object var5_11 = null;
        try {
            conn = this.getConnection(urlOld);
            try {
                conn.createStatement().execute("create table test_old(id int)");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var5_11 = null;
        try {
            conn = this.getConnection(url);
            try {
                conn.createStatement().execute("select * from test_old");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var5_11 = null;
        try {
            conn = this.getConnection(urlNew);
            try {
                conn.createStatement().execute("create table test_new(id int)");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        throwable = null;
        var5_11 = null;
        try {
            conn = this.getConnection(url);
            try {
                conn.createStatement().execute("select * from test_new");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        throwable = null;
        var5_11 = null;
        try {
            conn = this.getConnection(urlOld);
            try {
                conn.createStatement().execute("select * from test_old");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        throwable = null;
        var5_11 = null;
        try {
            conn = this.getConnection(urlNew);
            try {
                conn.createStatement().execute("select * from test_new");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
            } else if (throwable != throwable7) {
                throwable.addSuppressed(throwable7);
            }
            throw throwable;
        }
    }

    private void testTemporaryTables() throws SQLException {
        int i;
        Statement stat;
        Connection conn;
        this.deleteDb(this.getTestName());
        Object url = this.getTestName() + ";MV_STORE=TRUE";
        url = this.getURL((String)url, true);
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            conn = this.getConnection((String)url);
            try {
                stat = conn.createStatement();
                stat.execute("set max_memory_rows 100");
                stat.execute("create table t1 as select x from system_range(1, 200)");
                stat.execute("create table t2 as select x from system_range(1, 200)");
                i = 0;
                while (i < 20) {
                    stat.execute("select count(*) from t1 where t1.x in (select t2.x from t2)");
                    ++i;
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            conn = this.getConnection((String)url);
            try {
                stat = conn.createStatement();
                i = 0;
                while (i < 20) {
                    stat.execute("create table a" + i + "(id int primary key)");
                    ResultSet rs = stat.executeQuery("select count(*) from a" + i);
                    rs.next();
                    this.assertEquals(0, rs.getInt(1));
                    ++i;
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testUniqueIndex() throws SQLException {
        this.deleteDb(this.getTestName());
        Object url = this.getTestName() + ";MV_STORE=TRUE";
        url = this.getURL((String)url, true);
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection conn = this.getConnection((String)url);){
            Statement stat = conn.createStatement();
            stat.execute("create table test as select x, 0 from system_range(1, 5000)");
            stat.execute("create unique index on test(x)");
            ResultSet rs = stat.executeQuery("select * from test where x=1");
            this.assertTrue(rs.next());
            this.assertFalse(rs.next());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testSecondaryIndex() throws SQLException {
        this.deleteDb(this.getTestName());
        Object url = this.getTestName() + ";MV_STORE=TRUE";
        url = this.getURL((String)url, true);
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection conn = this.getConnection((String)url);){
            Statement stat = conn.createStatement();
            stat.execute("create table test(id int)");
            int size = 8192;
            stat.execute("insert into test select mod(x * 111, " + size + ") from system_range(1, " + size + ")");
            stat.execute("create index on test(id)");
            ResultSet rs = stat.executeQuery("select count(*) from test inner join system_range(1, " + size + ") where id = mod(x * 111, " + size + ")");
            rs.next();
            this.assertEquals(size, rs.getInt(1));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testGarbageCollectionForLOB() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        Object url = this.getTestName() + ";MV_STORE=TRUE";
        url = this.getURL((String)url, true);
        Throwable throwable = null;
        Object var3_5 = null;
        try (Connection conn = this.getConnection((String)url);){
            Statement stat = conn.createStatement();
            stat.execute("create table test(id int, data blob)");
            stat.execute("insert into test select x, repeat('0', 10000) from system_range(1, 10)");
            stat.execute("drop table test");
            stat.execute("create table test2(id int, data blob)");
            PreparedStatement prep = conn.prepareStatement("insert into test2 values(?, ?)");
            prep.setInt(1, 1);
            this.assertThrows(90028, prep).setBinaryStream(1, TestMVTableEngine.createFailingStream(new IOException()));
            prep.setInt(1, 2);
            this.assertThrows(90028, prep).setBinaryStream(1, TestMVTableEngine.createFailingStream(new IllegalStateException()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try (MVStore s = MVStore.open(this.getBaseDir() + "/" + this.getTestName() + ".mv.db");){
            this.assertTrue(s.hasMap("lobData"));
            MVMap lobData = s.openMap("lobData");
            this.assertEquals(0L, lobData.sizeAsLong());
            this.assertTrue(s.hasMap("lobMap"));
            MVMap lobMap = s.openMap("lobMap");
            this.assertEquals(0L, lobMap.sizeAsLong());
            this.assertTrue(s.hasMap("lobRef"));
            MVMap lobRef = s.openMap("lobRef");
            this.assertEquals(0L, lobRef.sizeAsLong());
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testSpatial() throws SQLException {
        this.deleteDb(this.getTestName());
        Object url = this.getTestName() + ";MV_STORE=TRUE";
        url = this.getURL((String)url, true);
        Throwable throwable = null;
        Object var4_4 = null;
        try (Connection conn = this.getConnection((String)url);){
            Statement stat = conn.createStatement();
            stat.execute("call rand(1)");
            stat.execute("create table coordinates as select rand()*50 x, rand()*50 y from system_range(1, 5000)");
            stat.execute("create table test(id identity, data geometry)");
            stat.execute("create spatial index on test(data)");
            stat.execute("insert into test(data) select 'polygon(('||(1+x)||' '||(1+y)||', '||(2+x)||' '||(2+y)||', '||(3+x)||' '||(1+y)||', '||(1+x)||' '||(1+y)||'))' from coordinates;");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testCount() throws Exception {
        Statement stat;
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        Object url = this.getTestName() + ";MV_STORE=TRUE";
        url = this.getURL((String)url, true);
        Throwable throwable = null;
        Object var5_4 = null;
        try (Connection conn = this.getConnection((String)url);){
            stat = conn.createStatement();
            stat.execute("create table test(id int)");
            stat.execute("create table test2(id int)");
            stat.execute("insert into test select x from system_range(1, 10000)");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Throwable throwable3 = null;
        Object var7_9 = null;
        try (Connection conn2 = this.getConnection((String)url);){
            Statement stat2 = conn2.createStatement();
            ResultSet rs = stat2.executeQuery("explain analyze select count(*) from test");
            rs.next();
            String plan = rs.getString(1);
            this.assertTrue(plan, !plan.contains("reads:"));
            Throwable throwable4 = null;
            Object var10_15 = null;
            try (Connection conn = this.getConnection((String)url);){
                stat = conn.createStatement();
                conn.setAutoCommit(false);
                stat.execute("insert into test select x from system_range(1, 1000)");
                rs = stat.executeQuery("select count(*) from test");
                rs.next();
                this.assertEquals(11000, rs.getInt(1));
                rs = stat2.executeQuery("explain analyze select count(*) from test");
                rs.next();
                plan = rs.getString(1);
                this.assertTrue(plan, !plan.contains("reads:"));
                rs = stat2.executeQuery("select count(*) from test");
                rs.next();
                this.assertEquals(10000, rs.getInt(1));
                stat2.execute("set cache_size 1024");
                stat.execute("insert into test2 select x from system_range(1, 11000)");
                rs = stat2.executeQuery("explain analyze select count(*) from test");
                rs.next();
                plan = rs.getString(1);
                this.assertContains(plan, "reads:");
                rs = stat2.executeQuery("select count(*) from test");
                rs.next();
                this.assertEquals(10000, rs.getInt(1));
            }
            catch (Throwable throwable5) {
                if (throwable4 == null) {
                    throwable4 = throwable5;
                } else if (throwable4 != throwable5) {
                    throwable4.addSuppressed(throwable5);
                }
                throw throwable4;
            }
        }
        catch (Throwable throwable6) {
            if (throwable3 == null) {
                throwable3 = throwable6;
            } else if (throwable3 != throwable6) {
                throwable3.addSuppressed(throwable6);
            }
            throw throwable3;
        }
    }

    private void testMinMaxWithNull() throws Exception {
        this.deleteDb(this.getTestName());
        Object url = this.getTestName() + ";MV_STORE=TRUE";
        url = this.getURL((String)url, true);
        Throwable throwable = null;
        Object var5_4 = null;
        try (Connection conn = this.getConnection((String)url);){
            Statement stat = conn.createStatement();
            stat.execute("create table test(data int)");
            stat.execute("create index on test(data)");
            stat.execute("insert into test values(null), (2)");
            Throwable throwable2 = null;
            Object var8_10 = null;
            try (Connection conn2 = this.getConnection((String)url);){
                Statement stat2 = conn2.createStatement();
                conn.setAutoCommit(false);
                conn2.setAutoCommit(false);
                stat.execute("insert into test values(1)");
                ResultSet rs = stat.executeQuery("select min(data) from test");
                rs.next();
                this.assertEquals(1, rs.getInt(1));
                rs = stat2.executeQuery("select min(data) from test");
                rs.next();
                this.assertEquals(2, rs.getInt(1));
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void testTimeout() throws Exception {
        this.deleteDb(this.getTestName());
        Object url = this.getTestName() + ";MV_STORE=TRUE";
        url = this.getURL((String)url, true);
        Throwable throwable = null;
        Object var5_4 = null;
        try (Connection conn = this.getConnection((String)url);){
            Statement stat = conn.createStatement();
            stat.execute("create table test(id identity, name varchar)");
            Throwable throwable2 = null;
            Object var8_10 = null;
            try (Connection conn2 = this.getConnection((String)url);){
                Statement stat2 = conn2.createStatement();
                conn.setAutoCommit(false);
                conn2.setAutoCommit(false);
                stat.execute("insert into test values(1, 'Hello')");
                this.assertThrows(50200, stat2).execute("insert into test values(1, 'Hello')");
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void testExplainAnalyze() throws Exception {
        Statement stat;
        Connection conn;
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        Object url = this.getTestName() + ";MV_STORE=TRUE;WRITE_DELAY=0";
        url = this.getURL((String)url, true);
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            conn = this.getConnection((String)url);
            try {
                stat = conn.createStatement();
                stat.execute("create table test(id identity, name varchar) as select x, space(1000) from system_range(1, 1000)");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_5 = null;
        try {
            conn = this.getConnection((String)url);
            try {
                stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("explain analyze select * from test");
                rs.next();
                String plan = rs.getString(1);
                String readCount = plan.substring(plan.indexOf("reads: "));
                readCount = readCount.substring("reads: ".length(), readCount.indexOf(10));
                int rc = Integer.parseInt(readCount);
                this.assertTrue(plan, rc >= 60 && rc <= 80);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testTransactionLogEmptyAfterCommit() throws Exception {
        Throwable throwable;
        this.deleteDb(this.getTestName());
        Object url = this.getTestName() + ";MV_STORE=TRUE";
        url = this.getURL((String)url, true);
        try {
            Throwable throwable2 = null;
            throwable = null;
            try (Connection conn = this.getConnection((String)url);){
                Statement stat = conn.createStatement();
                stat.execute("create table test(id identity, name varchar)");
                stat.execute("set write_delay 0");
                conn.setAutoCommit(false);
                PreparedStatement prep = conn.prepareStatement("insert into test(name) values(space(10000))");
                int j = 0;
                while (j < 100) {
                    int i = 0;
                    while (i < 100) {
                        prep.execute();
                        ++i;
                    }
                    conn.commit();
                    ++j;
                }
                stat.execute("shutdown immediately");
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String file = this.getBaseDir() + "/" + this.getTestName() + ".mv.db";
        this.assertTrue(new File(file).exists());
        throwable = null;
        Object var5_8 = null;
        try (MVStore store = MVStore.open(file);){
            TransactionStore t = new TransactionStore(store);
            t.init();
            int openTransactions = t.getOpenTransactions().size();
            if (openTransactions != 0) {
                this.fail("transaction log was not empty");
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void testShrinkDatabaseFile() throws Exception {
        Statement stat;
        Connection conn;
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        String dbName = this.getTestName() + ";MV_STORE=TRUE;WRITE_DELAY=0";
        long maxSize = 0L;
        int retentionTime = 45000;
        int i = 0;
        while (i < 20) {
            conn = this.getConnection(dbName);
            stat = conn.createStatement();
            if (i == 10) {
                stat.execute("set retention_time 0");
                retentionTime = 0;
            }
            ResultSet rs = stat.executeQuery("select setting_value from information_schema.settings where setting_name='RETENTION_TIME'");
            this.assertTrue(rs.next());
            this.assertEquals(retentionTime, rs.getInt(1));
            stat.execute("create table test(id int primary key, data varchar)");
            stat.execute("insert into test select x, space(100) from system_range(1, 1000)");
            if (i < 10) {
                stat.execute("create table test" + i + "(id int primary key, data varchar) as select x, space(10) from system_range(1, 100)");
            }
            stat.execute("checkpoint");
            stat.execute("drop table test");
            stat.execute("checkpoint");
            stat.execute("shutdown immediately");
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String fileName = this.getBaseDir() + "/" + this.getTestName() + ".mv.db";
            long size = FileUtils.size(fileName);
            if (i < 10) {
                maxSize = (int)Math.max((double)size * 1.2, (double)maxSize);
            } else if (size > maxSize) {
                this.fail(i + " size: " + size + " max: " + maxSize);
            }
            ++i;
        }
        long sizeOld = FileUtils.size(this.getBaseDir() + "/" + this.getTestName() + ".mv.db");
        conn = this.getConnection(dbName);
        stat = conn.createStatement();
        stat.execute("shutdown compact");
        conn.close();
        long sizeNew = FileUtils.size(this.getBaseDir() + "/" + this.getTestName() + ".mv.db");
        this.assertTrue("new: " + sizeNew + " old: " + sizeOld, sizeNew < sizeOld);
    }

    private void testTwoPhaseCommit() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        Object url = this.getTestName() + ";MV_STORE=TRUE";
        url = this.getURL((String)url, true);
        Connection conn = this.getConnection((String)url);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("set write_delay 0");
        conn.setAutoCommit(false);
        stat.execute("insert into test values(1, 'Hello')");
        stat.execute("prepare commit test_tx");
        stat.execute("shutdown immediately");
        JdbcUtils.closeSilently(conn);
        conn = this.getConnection((String)url);
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select * from information_schema.in_doubt");
        this.assertTrue(rs.next());
        stat.execute("commit transaction test_tx");
        rs = stat.executeQuery("select * from test");
        this.assertTrue(rs.next());
        conn.close();
    }

    private void testRecover() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        Object url = this.getTestName() + ";MV_STORE=TRUE";
        url = this.getURL((String)url, true);
        Connection conn = this.getConnection((String)url);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("insert into test values(1, 'Hello')");
        stat.execute("create table test2(name varchar)");
        stat.execute("insert into test2 values('Hello World')");
        conn.close();
        Recover.execute(this.getBaseDir(), this.getTestName());
        this.deleteDb(this.getTestName());
        conn = this.getConnection((String)url);
        stat = conn.createStatement();
        stat.execute("runscript from '" + this.getBaseDir() + "/" + this.getTestName() + ".h2.sql'");
        ResultSet rs = stat.executeQuery("select * from test");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        rs = stat.executeQuery("select * from test2");
        this.assertTrue(rs.next());
        this.assertEquals("Hello World", rs.getString(1));
        conn.close();
    }

    private void testRollback() throws Exception {
        this.deleteDb(this.getTestName());
        String url = this.getTestName() + ";MV_STORE=TRUE";
        Connection conn = this.getConnection(url);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id identity)");
        conn.setAutoCommit(false);
        stat.execute("insert into test values(1)");
        stat.execute("delete from test");
        conn.rollback();
        conn.close();
    }

    private void testSeparateKey() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        String url = this.getTestName() + ";MV_STORE=TRUE";
        Connection conn = this.getConnection(url);
        Statement stat = conn.createStatement();
        stat.execute("create table a(id int)");
        stat.execute("insert into a values(1)");
        stat.execute("insert into a values(1)");
        stat.execute("create table test(id int not null) as select 100");
        stat.execute("create primary key on test(id)");
        ResultSet rs = stat.executeQuery("select * from test where id = 100");
        this.assertTrue(rs.next());
        conn.close();
        conn = this.getConnection(url);
        stat = conn.createStatement();
        rs = stat.executeQuery("select * from test where id = 100");
        this.assertTrue(rs.next());
        conn.close();
    }

    private void testRollbackAfterCrash() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        String url = this.getTestName() + ";MV_STORE=TRUE";
        String url2 = this.getTestName() + "2;MV_STORE=TRUE";
        Connection conn = this.getConnection(url);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int)");
        stat.execute("insert into test values(0)");
        stat.execute("set write_delay 0");
        conn.setAutoCommit(false);
        stat.execute("insert into test values(1)");
        stat.execute("shutdown immediately");
        JdbcUtils.closeSilently(conn);
        conn = this.getConnection(url);
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select row_count_estimate from information_schema.tables where table_name='TEST'");
        rs.next();
        this.assertEquals(1L, rs.getLong(1));
        stat.execute("drop table test");
        stat.execute("create table test(id int primary key, data clob)");
        stat.execute("insert into test values(1, space(10000))");
        conn.setAutoCommit(false);
        stat.execute("delete from test");
        stat.execute("checkpoint");
        stat.execute("shutdown immediately");
        JdbcUtils.closeSilently(conn);
        conn = this.getConnection(url);
        stat = conn.createStatement();
        rs = stat.executeQuery("select * from test");
        this.assertTrue(rs.next());
        stat.execute("drop all objects delete files");
        conn.close();
        conn = this.getConnection(url);
        stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("create index idx_name on test(name, id)");
        stat.execute("insert into test select x, x || space(200 * x) from system_range(1, 10)");
        conn.setAutoCommit(false);
        stat.execute("delete from test where id > 5");
        stat.execute("backup to '" + this.getBaseDir() + "/" + this.getTestName() + ".zip'");
        conn.rollback();
        Restore.execute(this.getBaseDir() + "/" + this.getTestName() + ".zip", this.getBaseDir(), this.getTestName() + "2");
        Connection conn2 = this.getConnection(url2);
        conn.close();
        conn2.close();
    }

    private void testReferentialIntegrity() throws Exception {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection(this.getTestName() + ";MV_STORE=TRUE");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int, parent int references test(id) on delete cascade)");
        stat.execute("insert into test values(0, 0)");
        stat.execute("delete from test");
        stat.execute("drop table test");
        stat.execute("create table parent(id int, name varchar)");
        stat.execute("create table child(id int, parentid int, foreign key(parentid) references parent(id))");
        stat.execute("insert into parent values(1, 'mary'), (2, 'john')");
        stat.execute("insert into child values(10, 1), (11, 1), (20, 2), (21, 2)");
        stat.execute("update parent set name = 'marc' where id = 1");
        stat.execute("merge into parent key(id) values(1, 'marcy')");
        stat.execute("drop table parent, child");
        stat.execute("create table test(id identity, parent bigint, foreign key(parent) references(id))");
        stat.execute("insert into test values(0, 0), (1, NULL), (2, 1), (3, 3), (4, 3)");
        stat.execute("drop table test");
        stat.execute("create table parent(id int)");
        stat.execute("create table child(pid int)");
        stat.execute("insert into parent values(1)");
        stat.execute("insert into child values(2)");
        this.assertThrows(23506, stat).execute("alter table child add constraint cp foreign key(pid) references parent(id)");
        stat.execute("update child set pid=1");
        stat.execute("drop table child, parent");
        stat.execute("create table parent(id int)");
        stat.execute("create table child(pid int)");
        stat.execute("insert into parent values(1)");
        stat.execute("insert into child values(2)");
        this.assertThrows(23506, stat).execute("alter table child add constraint cp foreign key(pid) references parent(id)");
        stat.execute("drop table child, parent");
        stat.execute("create table test(id identity, parent bigint, foreign key(parent) references(id))");
        stat.execute("insert into test values(0, 0), (1, NULL), (2, 1), (3, 3), (4, 3)");
        stat.execute("drop table test");
        stat.execute("create table parent(id int, x int)");
        stat.execute("insert into parent values(1, 2)");
        stat.execute("create table child(id int references parent(id)) as select 1");
        conn.close();
    }

    private void testWriteDelay() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection(this.getTestName() + ";MV_STORE=TRUE");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int)");
        stat.execute("set write_delay 0");
        stat.execute("insert into test values(1)");
        stat.execute("shutdown immediately");
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        conn = this.getConnection(this.getTestName() + ";MV_STORE=TRUE");
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select * from test");
        this.assertTrue(rs.next());
        conn.close();
    }

    private void testAutoCommit() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection(this.getTestName() + ";MV_STORE=TRUE");
        int i = 0;
        while (i < 2) {
            Statement stat = conn.createStatement();
            stat.execute("create table test(id int primary key, name varchar)");
            stat.execute("create index on test(name)");
            conn.setAutoCommit(false);
            stat.execute("insert into test values(1, 'Hello')");
            stat.execute("insert into test values(2, 'World')");
            ResultSet rs = stat.executeQuery("select count(*) from test");
            rs.next();
            this.assertEquals(2, rs.getInt(1));
            conn.rollback();
            rs = stat.executeQuery("select count(*) from test");
            rs.next();
            this.assertEquals(0, rs.getInt(1));
            stat.execute("insert into test values(1, 'Hello')");
            Savepoint sp = conn.setSavepoint();
            stat.execute("insert into test values(2, 'World')");
            conn.rollback(sp);
            rs = stat.executeQuery("select count(*) from test");
            rs.next();
            this.assertEquals(1, rs.getInt(1));
            stat.execute("drop table test");
            ++i;
        }
        conn.close();
    }

    private void testReopen() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection(this.getTestName() + ";MV_STORE=TRUE");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int, name varchar)");
        conn.close();
        conn = this.getConnection(this.getTestName() + ";MV_STORE=TRUE");
        stat = conn.createStatement();
        stat.execute("drop table test");
        conn.close();
    }

    private void testBlob() throws SQLException, IOException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        String dbName = this.getTestName() + ";MV_STORE=TRUE";
        Connection conn = this.getConnection(dbName);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int, name blob)");
        PreparedStatement prep = conn.prepareStatement("insert into test values(1, ?)");
        prep.setBinaryStream(1, new ByteArrayInputStream(new byte[129]));
        prep.execute();
        conn.close();
        conn = this.getConnection(dbName);
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select * from test");
        while (rs.next()) {
            InputStream in = rs.getBinaryStream(2);
            int len = 0;
            while (in.read() >= 0) {
                ++len;
            }
            this.assertEquals(129, len);
        }
        conn.close();
    }

    private void testEncryption() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        String dbName = this.getTestName() + ";MV_STORE=TRUE";
        String url = this.getURL(dbName + ";CIPHER=AES", true);
        String user = "sa";
        String password = "123 123";
        Connection conn = DriverManager.getConnection(url, user, password);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key)");
        conn.close();
        conn = DriverManager.getConnection(url, user, password);
        stat = conn.createStatement();
        stat.execute("select * from test");
        stat.execute("drop table test");
        conn.close();
    }

    private void testReadOnly() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        String dbName = this.getTestName() + ";MV_STORE=TRUE";
        Connection conn = this.getConnection(dbName);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int)");
        conn.close();
        FileUtils.setReadOnly(this.getBaseDir() + "/" + this.getTestName() + ".mv.db");
        conn = this.getConnection(dbName);
        Database db = (Database)((JdbcConnection)conn).getSession().getDataHandler();
        this.assertTrue(db.getStore().getMvStore().getFileStore().isReadOnly());
        conn.close();
    }

    private void testReuseDiskSpace() throws Exception {
        this.deleteDb(this.getTestName());
        String dbName = this.getTestName() + ";MV_STORE=TRUE;WRITE_DELAY=0;RETENTION_TIME=0";
        long maxSize = 0L;
        int i = 0;
        while (i < 20) {
            Connection conn = this.getConnection(dbName);
            Statement stat = conn.createStatement();
            stat.execute("create table test(id int primary key, data varchar)");
            stat.execute("insert into test select x, space(1000) from system_range(1, 1000)");
            stat.execute("drop table test");
            conn.close();
            long size = FileUtils.size(this.getBaseDir() + "/" + this.getTestName() + ".mv.db");
            if (i < 10) {
                maxSize = (int)Math.max((double)size * 1.1, (double)maxSize);
            } else if (size > maxSize) {
                this.fail(i + " size: " + size + " max: " + maxSize);
            }
            ++i;
        }
    }

    private void testDataTypes() throws Exception {
        this.deleteDb(this.getTestName());
        String dbName = this.getTestName() + ";MV_STORE=TRUE";
        Connection conn = this.getConnection(dbName);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, vc varchar,ch char(10),bo boolean,by tinyint,sm smallint,bi bigint,de decimal(5, 2),re real,do double,ti time,da date,ts timestamp,bin varbinary,uu uuid,bl blob,cl clob)");
        stat.execute("insert into test values(1000, '', '', null, 0, 0, 0, 9, 2, 3, '10:00:00', '2001-01-01', '2010-10-10 10:10:10', x'00', '01234567-89AB-CDEF-0123-456789ABCDEF', x'b1', 'clob')");
        stat.execute("insert into test values(1, 'vc', 'ch', true, 8, 16, 64, 123.00, 64.0, 32.0, '10:00:00', '2001-01-01', '2010-10-10 10:10:10', x'00', '01234567-89AB-CDEF-0123-456789ABCDEF', x'b1', 'clob')");
        stat.execute("insert into test values(-1, 'quite a long string \u1234 \u00ff', 'ch', false, -8, -16, -64, 0, 0, 0, '10:00:00', '2001-01-01', '2010-10-10 10:10:10', SECURE_RAND(100), RANDOM_UUID(), x'b1', 'clob')");
        stat.execute("insert into test values(-1000, space(1000), 'ch', false, -8, -16, -64, 1, 1, 1, '10:00:00', '2001-01-01', '2010-10-10 10:10:10', SECURE_RAND(100), RANDOM_UUID(), x'b1', 'clob')");
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection(dbName);
            stat = conn.createStatement();
        }
        ResultSet rs = stat.executeQuery("select * from test order by id desc");
        rs.next();
        this.assertEquals(1000, rs.getInt(1));
        this.assertEquals("", rs.getString(2));
        this.assertEquals("          ", rs.getString(3));
        this.assertFalse(rs.getBoolean(4));
        this.assertEquals(0, rs.getByte(5));
        this.assertEquals(0, rs.getShort(6));
        this.assertEquals(0L, rs.getLong(7));
        this.assertEquals("9.00", rs.getBigDecimal(8).toString());
        this.assertEquals(2.0, rs.getDouble(9));
        this.assertEquals(3.0, (double)rs.getFloat(10));
        this.assertEquals("10:00:00", rs.getString(11));
        this.assertEquals("2001-01-01", rs.getString(12));
        this.assertEquals("2010-10-10 10:10:10", rs.getString(13));
        this.assertEquals(1, rs.getBytes(14).length);
        this.assertEquals(UUID.fromString("01234567-89AB-CDEF-0123-456789ABCDEF"), rs.getObject(15));
        this.assertEquals(1, rs.getBytes(16).length);
        this.assertEquals("clob", rs.getString(17));
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("vc", rs.getString(2));
        this.assertEquals("ch        ", rs.getString(3));
        this.assertTrue(rs.getBoolean(4));
        this.assertEquals(8, rs.getByte(5));
        this.assertEquals(16, rs.getShort(6));
        this.assertEquals(64L, rs.getLong(7));
        this.assertEquals("123.00", rs.getBigDecimal(8).toString());
        this.assertEquals(64.0, rs.getDouble(9));
        this.assertEquals(32.0, (double)rs.getFloat(10));
        this.assertEquals("10:00:00", rs.getString(11));
        this.assertEquals("2001-01-01", rs.getString(12));
        this.assertEquals("2010-10-10 10:10:10", rs.getString(13));
        this.assertEquals(1, rs.getBytes(14).length);
        this.assertEquals(UUID.fromString("01234567-89AB-CDEF-0123-456789ABCDEF"), rs.getObject(15));
        this.assertEquals(1, rs.getBytes(16).length);
        this.assertEquals("clob", rs.getString(17));
        rs.next();
        this.assertEquals(-1, rs.getInt(1));
        this.assertEquals("quite a long string \u1234 \u00ff", rs.getString(2));
        this.assertEquals("ch        ", rs.getString(3));
        this.assertFalse(rs.getBoolean(4));
        this.assertEquals(-8, rs.getByte(5));
        this.assertEquals(-16, rs.getShort(6));
        this.assertEquals(-64L, rs.getLong(7));
        this.assertEquals("0.00", rs.getBigDecimal(8).toString());
        this.assertEquals(0.0, rs.getDouble(9));
        this.assertEquals(0.0, (double)rs.getFloat(10));
        this.assertEquals("10:00:00", rs.getString(11));
        this.assertEquals("2001-01-01", rs.getString(12));
        this.assertEquals("2010-10-10 10:10:10", rs.getString(13));
        this.assertEquals(100, rs.getBytes(14).length);
        this.assertEquals(2, rs.getObject(15, UUID.class).variant());
        this.assertEquals(1, rs.getBytes(16).length);
        this.assertEquals("clob", rs.getString(17));
        rs.next();
        this.assertEquals(-1000, rs.getInt(1));
        this.assertEquals(1000, rs.getString(2).length());
        this.assertEquals("ch        ", rs.getString(3));
        this.assertFalse(rs.getBoolean(4));
        this.assertEquals(-8, rs.getByte(5));
        this.assertEquals(-16, rs.getShort(6));
        this.assertEquals(-64L, rs.getLong(7));
        this.assertEquals("1.00", rs.getBigDecimal(8).toString());
        this.assertEquals(1.0, rs.getDouble(9));
        this.assertEquals(1.0, (double)rs.getFloat(10));
        this.assertEquals("10:00:00", rs.getString(11));
        this.assertEquals("2001-01-01", rs.getString(12));
        this.assertEquals("2010-10-10 10:10:10", rs.getString(13));
        this.assertEquals(100, rs.getBytes(14).length);
        this.assertEquals(2, rs.getObject(15, UUID.class).variant());
        this.assertEquals(1, rs.getBytes(16).length);
        this.assertEquals("clob", rs.getString(17));
        stat.execute("drop table test");
        stat.execute("create table test(id int, obj object, rs row(a int), arr1 int array, arr2 numeric(1000) array, ig varchar_ignorecase)");
        PreparedStatement prep = conn.prepareStatement("insert into test values(?, ?, ?, ?, ?, ?)");
        prep.setInt(1, 1);
        prep.setObject(2, new AssertionError());
        prep.setObject(3, stat.executeQuery("select 1 from dual"));
        prep.setObject(4, new Object[]{1, 2});
        prep.setObject(5, new Object[0]);
        prep.setObject(6, "test");
        prep.execute();
        prep.setInt(1, 1);
        prep.setObject(2, new AssertionError());
        prep.setObject(3, stat.executeQuery("select 1 from dual"));
        prep.setObject(4, new Object[0]);
        prep.setObject(5, new Object[]{new BigDecimal(new String(new char[1000]).replace('\u0000', '1'))});
        prep.setObject(6, "test");
        prep.execute();
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection(dbName);
            stat = conn.createStatement();
        }
        stat.execute("select * from test");
        rs = stat.executeQuery("script");
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        this.assertTrue(count < 10);
        stat.execute("drop table test");
        conn.close();
    }

    private void testSimple() throws Exception {
        this.deleteDb(this.getTestName());
        String dbName = this.getTestName() + ";MV_STORE=TRUE";
        Connection conn = this.getConnection(dbName);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("insert into test values(1, 'Hello'), (2, 'World')");
        ResultSet rs = stat.executeQuery("select *, _rowid_ from test");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertEquals(1, rs.getInt(3));
        stat.execute("update test set name = 'Hello' where id = 1");
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection(dbName);
            stat = conn.createStatement();
        }
        rs = stat.executeQuery("select * from test order by id");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("World", rs.getString(2));
        this.assertFalse(rs.next());
        stat.execute("create unique index idx_name on test(name)");
        rs = stat.executeQuery("select * from test where name = 'Hello' order by name");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
        this.assertThrows(23505, stat).execute("insert into test(id, name) values(10, 'Hello')");
        rs = stat.executeQuery("select min(id), max(id), min(name), max(name) from test");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals(2, rs.getInt(2));
        this.assertEquals("Hello", rs.getString(3));
        this.assertEquals("World", rs.getString(4));
        this.assertFalse(rs.next());
        stat.execute("delete from test where id = 2");
        rs = stat.executeQuery("select * from test order by id");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
        stat.execute("alter table test add column firstName varchar");
        rs = stat.executeQuery("select * from test where name = 'Hello'");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection(dbName);
            stat = conn.createStatement();
        }
        rs = stat.executeQuery("select * from test order by id");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
        stat.execute("truncate table test");
        rs = stat.executeQuery("select * from test order by id");
        this.assertFalse(rs.next());
        rs = stat.executeQuery("select count(*) from test");
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        stat.execute("insert into test(id) select x from system_range(1, 3000)");
        rs = stat.executeQuery("select count(*) from test");
        rs.next();
        this.assertEquals(3000, rs.getInt(1));
        this.assertThrows(23505, stat).execute("insert into test(id) values(1)");
        stat.execute("delete from test");
        stat.execute("insert into test(id, name) values(-1, 'Hello')");
        rs = stat.executeQuery("select count(*) from test where id = -1");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        rs = stat.executeQuery("select count(*) from test where name = 'Hello'");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        conn.close();
    }

    private void testReverseDeletePerformance() throws Exception {
        long direct = 0L;
        long reverse = 0L;
        int i = 0;
        while (i < 5) {
            reverse += this.testReverseDeletePerformance(true);
            direct += this.testReverseDeletePerformance(false);
            ++i;
        }
        this.assertTrue("direct: " + direct + ", reverse: " + reverse, 3L * Math.abs(reverse - direct) < 2L * (reverse + direct));
    }

    private long testReverseDeletePerformance(boolean reverse) throws Exception {
        this.deleteDb(this.getTestName());
        String dbName = this.getTestName() + ";MV_STORE=TRUE";
        Throwable throwable = null;
        Object var4_5 = null;
        try (Connection conn = this.getConnection(dbName);){
            Statement stat = conn.createStatement();
            stat.execute("CREATE TABLE test(id INT PRIMARY KEY, name VARCHAR) AS SELECT x, x || space(1024) || x FROM system_range(1, 1000)");
            conn.setAutoCommit(false);
            PreparedStatement prep = conn.prepareStatement("DELETE FROM test WHERE id = ?");
            long start = System.nanoTime();
            int i = 0;
            while (i < 1000) {
                prep.setInt(1, reverse ? 1000 - i : i);
                prep.execute();
                ++i;
            }
            long end = System.nanoTime();
            conn.commit();
            return TimeUnit.NANOSECONDS.toMillis(end - start);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

