/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestAll;
import org.h2.test.TestBase;

public class TestRandomMapOps
extends TestBase {
    private static final boolean LOG = false;
    private final Random r = new Random();
    private int op;

    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        TestAll config = test.config;
        config.big = true;
        test.println(config.toString());
        int i = 0;
        while (i < 10) {
            test.testFromMain();
            test.println("Done pass #" + i);
            ++i;
        }
    }

    @Override
    public void test() throws Exception {
        if (this.config.memory) {
            this.testMap(null);
        } else {
            String fileName = "memFS:" + this.getTestName();
            this.testMap(fileName);
        }
    }

    private void testMap(String fileName) {
        int size = this.getSize(500, 3000);
        long seed = 0L;
        int cnt = 0;
        while (cnt < 100) {
            try {
                try {
                    this.testOps(fileName, size, seed);
                }
                catch (AssertionError | Exception ex) {
                    this.println("seed:" + seed + " op:" + this.op + " " + String.valueOf(ex));
                    throw ex;
                }
            }
            finally {
                if (fileName != null) {
                    FileUtils.delete(fileName);
                }
            }
            seed = this.r.nextLong();
            ++cnt;
        }
    }

    private void testOps(String fileName, int loopCount, long seed) {
        this.r.setSeed(seed);
        this.op = 0;
        MVStore s = TestRandomMapOps.openStore(fileName);
        int keysPerPage = s.getKeysPerPage();
        int keyRange = 2000;
        MVMap<Integer, CallSite> m = s.openMap("data");
        TreeMap<Integer, CallSite> map = new TreeMap<Integer, CallSite>();
        int[] recentKeys = new int[2 * keysPerPage];
        while (this.op < loopCount) {
            String msg;
            int to;
            int k = this.r.nextInt(3 * keyRange / 2);
            if (k >= keyRange) {
                k = recentKeys[k % recentKeys.length];
            } else {
                recentKeys[this.op % recentKeys.length] = k;
            }
            String v = k + "_Value_" + this.op;
            int type = this.r.nextInt(15);
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    TestRandomMapOps.log(this.op, k, v, "m.put({0}, {1})");
                    m.put(k, (CallSite)((Object)v));
                    map.put(k, (CallSite)((Object)v));
                    break;
                }
                case 4: 
                case 5: {
                    TestRandomMapOps.log(this.op, k, v, "m.remove({0})");
                    m.remove(k);
                    map.remove(k);
                    break;
                }
                case 6: {
                    TestRandomMapOps.log(this.op, k, v, "s.compact(90, 1024)");
                    s.compact(90, 1024);
                    break;
                }
                case 7: {
                    if (this.op % 64 != 0) break;
                    TestRandomMapOps.log(this.op, k, v, "m.clear()");
                    m.clear();
                    map.clear();
                    break;
                }
                case 8: {
                    TestRandomMapOps.log(this.op, k, v, "s.commit()");
                    s.commit();
                    break;
                }
                case 9: {
                    if (fileName == null) break;
                    TestRandomMapOps.log(this.op, k, v, "s.commit()");
                    s.commit();
                    TestRandomMapOps.log(this.op, k, v, "s.close()");
                    s.close();
                    TestRandomMapOps.log(this.op, k, v, "s = openStore(fileName)");
                    s = TestRandomMapOps.openStore(fileName);
                    TestRandomMapOps.log(this.op, k, v, "m = s.openMap(\"data\")");
                    m = s.openMap("data");
                    break;
                }
                case 10: {
                    TestRandomMapOps.log(this.op, k, v, "s.commit()");
                    s.commit();
                    TestRandomMapOps.log(this.op, k, v, "s.compactFile(0)");
                    s.compactFile(0);
                    break;
                }
                case 11: {
                    int rangeSize = this.r.nextInt(2 * keysPerPage);
                    int step = this.r.nextBoolean() ? 1 : -1;
                    int i = 0;
                    while (i < rangeSize) {
                        TestRandomMapOps.log(this.op, k, v, "m.put({0}, {1})");
                        m.put(k, (CallSite)((Object)v));
                        map.put(k, (CallSite)((Object)v));
                        v = (k += step) + "_Value_" + this.op;
                        ++i;
                    }
                    break;
                }
                case 12: {
                    int rangeSize = this.r.nextInt(2 * keysPerPage);
                    int step = this.r.nextBoolean() ? 1 : -1;
                    int i = 0;
                    while (i < rangeSize) {
                        TestRandomMapOps.log(this.op, k, v, "m.remove({0})");
                        m.remove(k);
                        map.remove(k);
                        k += step;
                        ++i;
                    }
                    break;
                }
                default: {
                    TestRandomMapOps.log(this.op, k, v, "m.getKeyIndex({0})");
                    ArrayList keyList = new ArrayList(map.keySet());
                    int index = Collections.binarySearch(keyList, k, null);
                    int index2 = (int)m.getKeyIndex(k);
                    this.assertEquals(index, index2);
                    if (index < 0) break;
                    int k2 = (Integer)m.getKey(index);
                    this.assertEquals(k2, k);
                }
            }
            this.assertEquals((String)map.get(k), (String)m.get(k));
            this.assertEquals(map.ceilingKey(k), m.ceilingKey(k));
            this.assertEquals(map.floorKey(k), m.floorKey(k));
            this.assertEquals(map.higherKey(k), m.higherKey(k));
            this.assertEquals(map.lowerKey(k), m.lowerKey(k));
            this.assertEquals(map.isEmpty(), m.isEmpty());
            this.assertEquals(map.size(), m.size());
            if (!map.isEmpty()) {
                this.assertEquals((Integer)map.firstKey(), (Integer)m.firstKey());
                this.assertEquals((Integer)map.lastKey(), (Integer)m.lastKey());
            }
            int from = this.r.nextBoolean() ? this.r.nextInt(keyRange) : k + this.r.nextInt(2 * keysPerPage) - keysPerPage;
            int n = to = this.r.nextBoolean() ? this.r.nextInt(keyRange) : from + this.r.nextInt(2 * keysPerPage) - keysPerPage;
            if (from <= to) {
                msg = "(" + from + ", null)";
                Cursor cursor = m.cursor(from, null, false);
                Set entrySet = map.tailMap(from).entrySet();
                this.assertEquals(msg, entrySet, cursor);
                msg = "(null, " + from + ")";
                cursor = m.cursor(null, from, false);
                entrySet = map.headMap(from + 1).entrySet();
                this.assertEquals(msg, entrySet, cursor);
                msg = "(" + from + ", " + to + ")";
                cursor = m.cursor(from, to, false);
                entrySet = map.subMap(from, to + 1).entrySet();
                this.assertEquals(msg, entrySet, cursor);
            }
            if (from >= to) {
                msg = "rev (" + from + ", null)";
                Cursor cursor = m.cursor(from, null, true);
                Collection entrySet = TestRandomMapOps.reverse(map.headMap(from + 1).entrySet());
                this.assertEquals(msg, entrySet, cursor);
                msg = "rev (null, " + from + ")";
                cursor = m.cursor(null, from, true);
                entrySet = TestRandomMapOps.reverse(map.tailMap(from).entrySet());
                this.assertEquals(msg, entrySet, cursor);
                msg = "rev (" + from + ", " + to + ")";
                cursor = m.cursor(from, to, true);
                entrySet = TestRandomMapOps.reverse(map.subMap(to, from + 1).entrySet());
                this.assertEquals(msg, entrySet, cursor);
            }
            ++this.op;
        }
        s.close();
    }

    private static <K, V> Collection<Map.Entry<K, V>> reverse(Collection<Map.Entry<K, V>> entrySet) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(entrySet);
        Collections.reverse(list);
        entrySet = list;
        return entrySet;
    }

    private <K, V> void assertEquals(String msg, Iterable<Map.Entry<K, V>> entrySet, Cursor<K, V> cursor) {
        int cnt = 0;
        for (Map.Entry<K, V> entry : entrySet) {
            String message = msg + " " + cnt;
            this.assertTrue(message, cursor.hasNext());
            this.assertEquals(message, entry.getKey(), cursor.next());
            this.assertEquals(message, entry.getKey(), cursor.getKey());
            this.assertEquals(message, entry.getValue(), cursor.getValue());
            ++cnt;
        }
        this.assertFalse(msg, cursor.hasNext());
    }

    public void assertEquals(String message, Object expected, Object actual) {
        if (!Objects.equals(expected, actual)) {
            this.fail(message + " expected: " + String.valueOf(expected) + " actual: " + String.valueOf(actual));
        }
    }

    private static MVStore openStore(String fileName) {
        MVStore s = new MVStore.Builder().fileName(fileName).keysPerPage(7).autoCommitDisabled().open();
        s.setRetentionTime(1000);
        return s;
    }

    private static void log(int op, int k, String v, String msg) {
    }
}

