/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.util.ArrayList;
import java.util.Random;
import org.h2.bnf.Bnf;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleHead;

public class BnfRandom
implements BnfVisitor {
    private static final boolean SHOW_SYNTAX = false;
    private final Random random = new Random();
    private final ArrayList<RuleHead> statements = new ArrayList();
    private int level;
    private String sql;

    public BnfRandom() throws Exception {
        Bnf config = Bnf.getInstance(null);
        config.addAlias("procedure", "@func@");
        config.linkStatements();
        ArrayList<RuleHead> all = config.getStatements();
        int i = all.size() - 1;
        while (i >= 0) {
            RuleHead r = all.get(i);
            String topic = r.getTopic().toLowerCase();
            int weight = 0;
            if (topic.equals("select")) {
                weight = 10;
            } else if (topic.equals("create table")) {
                weight = 20;
            } else if (topic.equals("insert")) {
                weight = 5;
            } else if (topic.startsWith("update")) {
                weight = 3;
            } else if (topic.startsWith("delete")) {
                weight = 3;
            } else if (topic.startsWith("drop")) {
                weight = 2;
            }
            int j = 0;
            while (j < weight) {
                this.statements.add(r);
                ++j;
            }
            --i;
        }
    }

    public String getRandomSQL() {
        int sid = this.random.nextInt(this.statements.size());
        RuleHead r = this.statements.get(sid);
        this.level = 0;
        r.getRule().accept(this);
        this.sql = this.sql.trim();
        if (this.sql.length() > 0 && this.sql.indexOf("TRACE_LEVEL_") < 0 && this.sql.indexOf("COLLATION") < 0 && this.sql.indexOf("SCRIPT ") < 0 && this.sql.indexOf("CSVWRITE") < 0 && this.sql.indexOf("BACKUP") < 0 && this.sql.indexOf("DB_CLOSE_DELAY") < 0) {
            return this.sql;
        }
        return null;
    }

    @Override
    public void visitRuleElement(boolean keyword, String name, Rule link) {
        if (keyword) {
            this.sql = name.startsWith(";") ? "" : (name.length() > 1 ? " " + name + " " : name);
        } else if (link != null) {
            ++this.level;
            link.accept(this);
            --this.level;
        } else {
            throw new AssertionError((Object)name);
        }
    }

    @Override
    public void visitRuleFixed(int type) {
        this.sql = this.getRandomFixed(type);
    }

    private String getRandomFixed(int type) {
        Random r = this.random;
        switch (type) {
            case 0: {
                return 1800 + r.nextInt(200) + "-" + (1 + r.nextInt(12)) + "-" + (1 + r.nextInt(31));
            }
            case 1: {
                return r.nextInt(24) + "-" + r.nextInt(60) + "-" + r.nextInt(60);
            }
            case 2: {
                return "" + (r.nextInt(100000) + r.nextInt(10000));
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                StringBuilder buff = new StringBuilder();
                int len = r.nextBoolean() ? 1 : r.nextInt(5);
                int i = 0;
                while (i < len) {
                    buff.append((char)(65 + r.nextInt(2)));
                    ++i;
                }
                return buff.toString();
            }
            case 9: {
                return "0x";
            }
            case 10: {
                return "0b";
            }
            case 11: {
                return "0b";
            }
            case 12: {
                return "||";
            }
            case 13: {
                return "" + (char)(65 + r.nextInt(2));
            }
            case 14: {
                return "" + (char)(65 + r.nextInt(5));
            }
            case 15: {
                return "" + (char)(48 + r.nextInt(10));
            }
            case 16: {
                return "[";
            }
            case 17: {
                return "]";
            }
        }
        throw new AssertionError((Object)("type=" + type));
    }

    @Override
    public void visitRuleList(boolean or, ArrayList<Rule> list) {
        if (or) {
            this.visitOr(list);
            return;
        }
        StringBuilder buff = new StringBuilder();
        ++this.level;
        for (Rule r : list) {
            r.accept(this);
            buff.append(this.sql);
        }
        --this.level;
        this.sql = buff.toString();
    }

    @Override
    public void visitRuleOptional(Rule rule) {
        if (this.level > 10 ? this.random.nextInt(this.level) == 1 : this.random.nextInt(4) == 1) {
            ++this.level;
            rule.accept(this);
            --this.level;
            return;
        }
        this.sql = "";
    }

    @Override
    public void visitRuleOptional(ArrayList<Rule> list) {
        if (this.level > 10 ? this.random.nextInt(this.level) == 1 : this.random.nextInt(4) == 1) {
            ++this.level;
            this.visitOr(list);
            --this.level;
            return;
        }
        this.sql = "";
    }

    private void visitOr(ArrayList<Rule> list) throws AssertionError {
        if (this.level > 10) {
            if (this.level > 1000) {
                throw new AssertionError();
            }
            list.get(0).accept(this);
            return;
        }
        int idx = this.random.nextInt(list.size());
        ++this.level;
        list.get(idx).accept(this);
        --this.level;
    }

    @Override
    public void visitRuleRepeat(boolean comma, Rule rule) {
        rule.accept(this);
    }

    @Override
    public void visitRuleExtension(Rule rule, boolean compatibility) {
        rule.accept(this);
    }

    public void setSeed(int seed) {
        this.random.setSeed(seed);
    }

    public int getStatementCount() {
        return this.statements.size();
    }
}

