/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.h2.Driver;
import org.h2.store.FileLister;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.scripts.TestScript;
import org.h2.test.synth.sql.RandomGen;
import org.h2.tools.Backup;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Restore;
import org.h2.util.MathUtils;

public class TestCrashAPI
extends TestDb
implements Runnable {
    private static final boolean RECOVER_ALL = false;
    private static final Class<?>[] INTERFACES = new Class[]{Connection.class, PreparedStatement.class, Statement.class, ResultSet.class, ResultSetMetaData.class, Savepoint.class, ParameterMetaData.class, Clob.class, Blob.class, Array.class, CallableStatement.class};
    private static final String DIR = "synth";
    private final ArrayList<Object> objects = new ArrayList();
    private final HashMap<Class<?>, ArrayList<Method>> classMethods = new HashMap();
    private RandomGen random = new RandomGen();
    private ArrayList<String> statements;
    private int openCount;
    private long callCount;
    private volatile long maxWait = 60L;
    private volatile boolean stopped;
    private volatile boolean running;
    private Thread mainThread;

    public static void main(String ... a) throws Exception {
        System.setProperty("h2.delayWrongPasswordMin", "0");
        System.setProperty("h2.delayWrongPasswordMax", "0");
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void run() {
        while (--this.maxWait > 0L) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                ++this.maxWait;
            }
            if (this.maxWait <= 0L || this.maxWait > 10L) continue;
            this.println("stopping...");
            this.stopped = true;
        }
        if (this.maxWait == 0L && this.running) {
            this.objects.clear();
            if (this.running) {
                this.println("stopping (trying to interrupt)...");
                StackTraceElement[] stackTraceElementArray = this.mainThread.getStackTrace();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement e = stackTraceElementArray[n2];
                    System.out.println(e.toString());
                    ++n2;
                }
                this.mainThread.interrupt();
            }
        }
    }

    private static void recoverAll() {
        Driver.load();
        File[] files = new File("temp/backup").listFiles();
        Arrays.sort(files, Comparator.comparing(File::getName));
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().startsWith("db-")) {
                DeleteDbFiles.execute("data", null, true);
                try {
                    Restore.execute(f.getAbsolutePath(), "data", null);
                }
                catch (Exception e) {
                    System.out.println(f.getName() + " restore error " + String.valueOf(e));
                }
                ArrayList<String> dbFiles = FileLister.getDatabaseFiles("data", null, false);
                for (String name : dbFiles) {
                    if (!name.endsWith(".h2.db")) continue;
                    name = name.substring(0, name.length() - 6);
                    try {
                        DriverManager.getConnection("jdbc:h2:data/" + name, "sa", "").close();
                        System.out.println(f.getName() + " OK");
                    }
                    catch (SQLException e) {
                        System.out.println(f.getName() + " " + String.valueOf(e));
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean isEnabled() {
        return !this.config.networked;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void test() throws Exception {
        if (this.config.networked) {
            return;
        }
        TestScript script = new TestScript();
        this.statements = script.getAllStatements(this.config);
        this.initMethods();
        int len = this.getSize(2, 6);
        Thread t = new Thread(this);
        try {
            block7: {
                int i;
                block6: {
                    this.mainThread = Thread.currentThread();
                    t.start();
                    this.running = true;
                    i = 0;
                    if (!true) break block6;
                    if (i >= len) return;
                    if (this.stopped) break block7;
                }
                do {
                    int seed = MathUtils.randomInt(Integer.MAX_VALUE);
                    this.testCase(seed);
                    this.deleteDb();
                    ++i;
                    if (i >= len) return;
                } while (!this.stopped);
            }
            return;
        }
        finally {
            this.running = false;
            this.deleteDb();
            this.maxWait = -1L;
            t.join();
        }
    }

    private void deleteDb() {
        try {
            this.deleteDb(this.getBaseDir() + "/synth", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Connection getConnection(int seed, boolean delete) throws SQLException {
        ++this.openCount;
        if (delete) {
            this.deleteDb();
        }
        String add = ";MAX_QUERY_TIMEOUT=10000";
        String dbName = "crashApi" + seed;
        String url = this.getURL("synth/" + dbName, true) + add;
        Connection conn = null;
        String fileName = "temp/backup/db-" + uniqueId++ + ".zip";
        Backup.execute(fileName, this.getBaseDir() + "/synth", dbName, true);
        System.gc();
        try {
            conn = DriverManager.getConnection(url, "sa", this.getPassword(""));
            FileUtils.delete(fileName);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 28000) {
                FileUtils.delete(fileName);
            }
            throw e;
        }
        int len = this.random.getInt(50);
        int first = this.random.getInt(this.statements.size() - len);
        int end = first + len;
        Statement stat = conn.createStatement();
        stat.execute("SET LOCK_TIMEOUT 10");
        stat.execute("SET WRITE_DELAY 0");
        if (this.random.nextBoolean()) {
            if (this.random.nextBoolean()) {
                double g = this.random.nextGaussian();
                int size = (int)Math.abs(10000.0 * g * g);
                stat.execute("SET CACHE_SIZE " + size);
            } else {
                stat.execute("SET CACHE_SIZE 0");
            }
        }
        stat.execute("SCRIPT NOPASSWORDS NOSETTINGS");
        int i = first;
        while (i < end && i < this.statements.size() && !this.stopped) {
            try {
                stat.execute("SELECT * FROM TEST WHERE ID=1");
            }
            catch (Throwable t) {
                this.printIfBad(seed, -i, -1, t);
            }
            try {
                stat.execute("SELECT * FROM TEST WHERE ID=1 OR ID=1");
            }
            catch (Throwable t) {
                this.printIfBad(seed, -i, -1, t);
            }
            String sql = this.statements.get(i);
            try {
                stat.execute(sql);
            }
            catch (Throwable t) {
                this.printIfBad(seed, -i, -1, t);
            }
            ++i;
        }
        if (this.random.nextBoolean()) {
            try {
                conn.commit();
            }
            catch (Throwable t) {
                this.printIfBad(seed, 0, -1, t);
            }
        }
        return conn;
    }

    private void testCase(int seed) throws SQLException {
        this.printTime("seed: " + seed);
        this.callCount = 0L;
        this.openCount = 0;
        this.random = new RandomGen();
        this.random.setSeed(seed);
        Connection c1 = this.getConnection(seed, true);
        Connection conn = null;
        int i = 0;
        while (i < 2000 && !this.stopped) {
            if (this.objects.size() == 0) {
                try {
                    conn = this.getConnection(seed, false);
                }
                catch (SQLException e) {
                    if ("08004".equals(e.getSQLState())) {
                        try {
                            c1.createStatement().execute("SET PASSWORD ''");
                        }
                        catch (Throwable t) {
                            break;
                        }
                        try {
                            conn = this.getConnection(seed, false);
                        }
                        catch (Throwable t) {
                            this.printIfBad(seed, -i, -1, t);
                        }
                    }
                    if ("90098".equals(e.getSQLState())) break;
                    this.printIfBad(seed, -i, -1, e);
                }
                this.objects.add(conn);
            }
            int objectId = this.random.getInt(this.objects.size());
            if (this.random.getBoolean(1)) {
                this.objects.remove(objectId);
            } else {
                Object o;
                if (this.random.getInt(2000) == 0 && conn != null) {
                    TestCrashAPI.setPowerOffCount(conn, this.random.getInt(50));
                }
                if ((o = this.objects.get(objectId)) == null) {
                    this.objects.remove(objectId);
                } else {
                    Class<?> in = this.getJdbcInterface(o);
                    ArrayList<Method> methods = this.classMethods.get(in);
                    Method m = methods.get(this.random.getInt(methods.size()));
                    Object o2 = this.callRandom(seed, i, objectId, o, m);
                    if (o2 != null) {
                        this.objects.add(o2);
                    }
                }
            }
            ++i;
        }
        try {
            if (conn != null) {
                conn.close();
            }
            c1.close();
        }
        catch (Throwable t) {
            this.printIfBad(seed, -101010, -1, t);
            try {
                this.deleteDb();
            }
            catch (Throwable t2) {
                this.printIfBad(seed, -101010, -1, t2);
            }
        }
        this.objects.clear();
    }

    private void printError(int seed, int id, Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String s = writer.toString();
        TestBase.logError("new TestCrashAPI().init(test).testCase(" + seed + "); // Bug " + s.hashCode() + " id=" + id + " callCount=" + this.callCount + " openCount=" + this.openCount + " " + t.getMessage(), t);
        throw new RuntimeException(t);
    }

    private Object callRandom(int seed, int id, int objectId, Object o, Method m) {
        boolean isDefault = (m.getModifiers() & 0x409) == 1 && m.getDeclaringClass().isInterface();
        boolean allowNPE = isDefault || o instanceof Blob && "setBytes".equals(m.getName());
        Class<?>[] paramClasses = m.getParameterTypes();
        Object[] params = new Object[paramClasses.length];
        int i = 0;
        while (i < params.length) {
            params[i] = this.getRandomParam(paramClasses[i]);
            ++i;
        }
        Object result = null;
        try {
            ++this.callCount;
            result = m.invoke(o, params);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            TestBase.logError("error", e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            this.printIfBad(seed, id, objectId, t, allowNPE);
        }
        if (result == null) {
            return null;
        }
        Class<?> in = this.getJdbcInterface(result);
        if (in == null) {
            return null;
        }
        return result;
    }

    private void printIfBad(int seed, int id, int objectId, Throwable t) {
        this.printIfBad(seed, id, objectId, t, false);
    }

    private void printIfBad(int seed, int id, int objectId, Throwable t, boolean allowNPE) {
        if (!(t instanceof BatchUpdateException || t.getClass().getName().contains("SQLClientInfoException") || t instanceof UnsupportedOperationException || t instanceof SQLFeatureNotSupportedException)) {
            if (t instanceof SQLException) {
                SQLException s = (SQLException)t;
                int errorCode = s.getErrorCode();
                if (errorCode == 0) {
                    this.printError(seed, id, s);
                } else if (errorCode == 90007) {
                    if (objectId >= 0 && this.objects.size() > 0) {
                        this.objects.remove(objectId);
                    }
                } else if (errorCode == 50000) {
                    this.printError(seed, id, s);
                }
            } else if (!allowNPE || !(t instanceof NullPointerException)) {
                this.printError(seed, id, t);
            }
        }
    }

    private Object getRandomParam(Class<?> type) {
        if (type == Integer.TYPE) {
            return this.random.getRandomInt();
        }
        if (type == Byte.TYPE) {
            return (byte)this.random.getRandomInt();
        }
        if (type == Short.TYPE) {
            return (short)this.random.getRandomInt();
        }
        if (type == Long.TYPE) {
            return this.random.getRandomLong();
        }
        if (type == Float.TYPE) {
            return Float.valueOf((float)this.random.getRandomDouble());
        }
        if (type == Boolean.TYPE) {
            return this.random.nextBoolean();
        }
        if (type == Double.TYPE) {
            return this.random.getRandomDouble();
        }
        if (type == String.class) {
            if (this.random.getInt(10) == 0) {
                return null;
            }
            int randomId = this.random.getInt(this.statements.size());
            String sql = this.statements.get(randomId);
            if (this.random.getInt(10) == 0) {
                sql = this.random.modify(sql);
            }
            return sql;
        }
        if (type == int[].class) {
            return this.random.getIntArray();
        }
        if (type == Reader.class) {
            return null;
        }
        if (type == java.sql.Array.class) {
            return null;
        }
        if (type == byte[].class) {
            return this.random.getByteArray();
        }
        if (type == Map.class) {
            return null;
        }
        if (type == Object.class) {
            return null;
        }
        if (type == Date.class) {
            return this.random.randomDate();
        }
        if (type == Time.class) {
            return this.random.randomTime();
        }
        if (type == Timestamp.class) {
            return this.random.randomTimestamp();
        }
        if (type == InputStream.class) {
            return null;
        }
        if (type == String[].class) {
            return null;
        }
        if (type == Clob.class) {
            return null;
        }
        if (type == Blob.class) {
            return null;
        }
        if (type == Savepoint.class) {
            return null;
        }
        if (type == Calendar.class) {
            return new GregorianCalendar();
        }
        if (type == URL.class) {
            return null;
        }
        if (type == BigDecimal.class) {
            return new BigDecimal("" + this.random.getRandomDouble());
        }
        if (type == Ref.class) {
            return null;
        }
        return null;
    }

    private Class<?> getJdbcInterface(Object o) {
        Class<?>[] classArray = o.getClass().getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> in = classArray[n2];
            if (this.classMethods.get(in) != null) {
                return in;
            }
            ++n2;
        }
        return null;
    }

    private void initMethods() {
        Class<?>[] classArray = INTERFACES;
        int n = INTERFACES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inter = classArray[n2];
            ArrayList<Method> list = new ArrayList<Method>();
            Method[] methodArray = inter.getMethods();
            int n3 = methodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Method m = methodArray[n4];
                list.add(m);
                ++n4;
            }
            this.classMethods.put(inter, list);
            ++n2;
        }
    }
}

