/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.utils.FilePathUnstable;

public class TestDiskFull
extends TestDb {
    private FilePathUnstable fs;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.fs = FilePathUnstable.register();
        this.fs.setPartialWrites(true);
        try {
            this.test(Integer.MAX_VALUE);
            int max = Integer.MAX_VALUE - this.fs.getDiskFullCount() + 10;
            int i = 0;
            while (i < max) {
                this.test(i);
                ++i;
            }
        }
        finally {
            this.fs.setPartialWrites(false);
        }
    }

    private boolean test(int x) throws SQLException {
        boolean opened;
        Statement stat;
        Connection conn;
        Object url;
        block27: {
            this.deleteDb("memFS:", null);
            this.fs.setDiskFullCount(x, 0);
            url = "jdbc:h2:unstable:memFS:diskFull" + x + ";FILE_LOCK=NO;TRACE_LEVEL_FILE=0;WRITE_DELAY=10;LOCK_TIMEOUT=100;CACHE_SIZE=4096;MAX_COMPACT_TIME=10";
            url = this.getURL((String)url, true);
            conn = null;
            stat = null;
            opened = false;
            try {
                conn = DriverManager.getConnection((String)url);
                stat = conn.createStatement();
                opened = true;
                int j = 0;
                while (j < 5) {
                    stat.execute("create table test(id int primary key, name varchar)");
                    stat.execute("insert into test values(1, 'Hello')");
                    stat.execute("create index idx_name on test(name)");
                    stat.execute("insert into test values(2, 'World')");
                    stat.execute("update test set name='Hallo' where id=1");
                    stat.execute("delete from test where id=2");
                    stat.execute("checkpoint");
                    stat.execute("insert into test values(3, space(10000))");
                    stat.execute("update test set name='Hallo' where id=3");
                    stat.execute("drop table test");
                    ++j;
                }
                conn.close();
                conn = null;
                boolean bl = this.fs.getDiskFullCount() > 0;
                return bl;
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 42101) {
                    throw e;
                }
                if (stat == null) break block27;
                try {
                    this.fs.setDiskFullCount(0, 0);
                    stat.execute("create table if not exists test(id int primary key, name varchar)");
                    stat.execute("insert into test values(4, space(10000))");
                    stat.execute("update test set name='Hallo' where id=3");
                    conn.close();
                }
                catch (SQLException e2) {
                    if (e2.getErrorCode() != 90028 && e2.getErrorCode() != 90031 && e2.getErrorCode() != 90098 && e2.getErrorCode() != 90007) {
                        throw e2;
                    }
                }
            }
            finally {
                if (conn != null) {
                    try {
                        if (stat != null) {
                            stat.execute("shutdown immediately");
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.fs.setDiskFullCount(0, 0);
        try {
            conn = null;
            conn = DriverManager.getConnection((String)url);
        }
        catch (SQLException e) {
            if (!opened) {
                return false;
            }
            throw e;
        }
        stat = conn.createStatement();
        stat.execute("script to 'memFS:test.sql'");
        conn.close();
        this.deleteDb("memFS:", null);
        FileUtils.delete("memFS:test.sql");
        return false;
    }
}

