/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;
import org.h2.Driver;
import org.h2.test.TestAll;
import org.h2.test.TestBase;
import org.h2.test.synth.OutputCatcher;
import org.h2.test.utils.SelfDestructor;
import org.h2.tools.Backup;
import org.h2.tools.DeleteDbFiles;
import org.h2.util.StringUtils;

public abstract class TestHalt
extends TestBase {
    protected static final int OP_INSERT = 1;
    protected static final int OP_DELETE = 2;
    protected static final int OP_UPDATE = 4;
    protected static final int OP_SELECT = 8;
    protected static final int FLAG_NO_DELAY = 1;
    protected static final int FLAG_LOBS = 2;
    private static final String DATABASE_NAME = "halt";
    private static final String TRACE_FILE_NAME = "haltTrace.trace.db";
    protected int operations;
    protected int flags;
    protected int value;
    protected Connection conn;
    protected Random random = new Random();
    private final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("MM-dd HH:mm:ss");
    private int errorId;
    private int sequenceId;

    abstract void controllerInit() throws SQLException;

    abstract void controllerCheckAfterCrash() throws SQLException;

    abstract void controllerWaitAfterAppStart() throws Exception;

    abstract void processAppStart() throws SQLException;

    abstract void processAppRun() throws SQLException;

    @Override
    public void test() {
        int i = 0;
        while (true) {
            this.operations = 1 | i;
            this.flags = i >> 4;
            try {
                this.controllerTest();
            }
            catch (Throwable t) {
                System.out.println("Error: " + String.valueOf(t));
                t.printStackTrace();
            }
            ++i;
        }
    }

    Connection getConnection() throws SQLException {
        Driver.load();
        String url = "jdbc:h2:" + this.getBaseDir() + "/halt";
        return DriverManager.getConnection(url, "sa", "sa");
    }

    void processRunRandom() throws SQLException {
        this.connect();
        try {
            this.traceOperation("connected, operations:" + this.operations + " flags:" + this.flags + " value:" + this.value);
            this.processAppStart();
            System.out.println("READY");
            System.out.println("READY");
            System.out.println("READY");
            this.processAppRun();
            this.traceOperation("done");
        }
        catch (Exception e) {
            this.traceOperation("run", e);
        }
        this.disconnect();
    }

    private void connect() throws SQLException {
        try {
            this.traceOperation("connecting");
            this.conn = this.getConnection();
        }
        catch (SQLException e) {
            this.traceOperation("connect", e);
            e.printStackTrace();
            throw e;
        }
    }

    protected void traceOperation(String s) {
        this.traceOperation(s, null);
    }

    protected void traceOperation(String s, Exception e) {
        File f = new File(this.getBaseDir() + "/haltTrace.trace.db");
        f.getParentFile().mkdirs();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileWriter writer = new FileWriter(f, true);){
                PrintWriter w = new PrintWriter(writer);
                s = this.dateFormat.format(LocalDateTime.now()) + " : " + (String)s;
                w.println((String)s);
                if (e != null) {
                    e.printStackTrace(w);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    void controllerTest() throws Exception {
        this.traceOperation("delete database -----------------------------");
        DeleteDbFiles.execute(this.getBaseDir(), DATABASE_NAME, true);
        new File(this.getBaseDir() + "/haltTrace.trace.db").delete();
        this.connect();
        this.controllerInit();
        this.disconnect();
        int i = 0;
        while (i < 10) {
            block8: {
                this.traceOperation("backing up " + this.sequenceId);
                Backup.execute(this.getBaseDir() + "/haltSeq" + this.sequenceId + ".zip", this.getBaseDir(), null, true);
                ++this.sequenceId;
                int testValue = this.random.nextInt(1000);
                String selfDestruct = SelfDestructor.getPropertyString(60);
                String[] procDef = new String[]{TestHalt.getJVM(), selfDestruct, "-cp", this.getClassPath(), this.getClass().getName(), "" + this.operations, "" + this.flags, "" + testValue};
                this.traceOperation("start: " + StringUtils.arrayCombine(procDef, ' '));
                Process p = Runtime.getRuntime().exec(procDef);
                InputStream in = p.getInputStream();
                OutputCatcher catcher = new OutputCatcher(in);
                catcher.start();
                String s = catcher.readLine(300000L);
                if (s == null) {
                    throw new IOException("No reply from process, command: " + StringUtils.arrayCombine(procDef, ' '));
                }
                if (s.startsWith("READY")) {
                    this.traceOperation("got reply: " + s);
                }
                this.controllerWaitAfterAppStart();
                p.destroy();
                p.waitFor();
                try {
                    try {
                        this.traceOperation("backing up " + this.sequenceId);
                        Backup.execute(this.getBaseDir() + "/haltSeq" + this.sequenceId + ".zip", this.getBaseDir(), null, true);
                        this.connect();
                        this.controllerCheckAfterCrash();
                    }
                    catch (Exception e) {
                        File zip = new File(this.getBaseDir() + "/haltSeq" + this.sequenceId + ".zip");
                        File zipId = new File(this.getBaseDir() + "/haltSeq" + this.sequenceId + "-" + this.errorId + ".zip");
                        zip.renameTo(zipId);
                        this.printTime("ERROR: " + this.sequenceId + " " + this.errorId + " " + e.toString());
                        e.printStackTrace();
                        ++this.errorId;
                        ++this.sequenceId;
                        this.disconnect();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    ++this.sequenceId;
                    this.disconnect();
                    throw throwable;
                }
                ++this.sequenceId;
                this.disconnect();
            }
            ++i;
        }
    }

    protected void disconnect() {
        try {
            this.traceOperation("disconnect");
            this.conn.close();
        }
        catch (Exception e) {
            this.traceOperation("disconnect", e);
        }
    }

    protected String getRandomString(int len) {
        StringBuilder buff = new StringBuilder();
        int i = 0;
        while (i < len) {
            buff.append(97 + this.random.nextInt(20));
            ++i;
        }
        return buff.toString();
    }

    @Override
    public TestBase init(TestAll conf) throws Exception {
        super.init(conf);
        return this;
    }
}

